/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrgInfo;
import org.compiere.model.X_C_Order;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class OrderPOCreate
extends SvrProcess {
    private Timestamp p_DateOrdered_From;
    private Timestamp p_DateOrdered_To;
    private int p_C_BPartner_ID;
    private int p_Vendor_ID;
    private int p_C_Order_ID;
    private boolean p_IsDropShip = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("DateOrdered")) {
                this.p_DateOrdered_From = (Timestamp)para[i2].getParameter();
                this.p_DateOrdered_To = (Timestamp)para[i2].getParameter_To();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("Vendor_ID")) {
                this.p_Vendor_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("IsDropShip")) {
                this.p_IsDropShip = ((String)para[i2].getParameter()).equals("Y");
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.getTable_ID() == MOrder.Table_ID && this.getRecord_ID() > 0) {
            this.p_C_Order_ID = this.getRecord_ID();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        this.log.info("DateOrdered=" + this.p_DateOrdered_From + " - " + this.p_DateOrdered_To + " - C_BPartner_ID=" + this.p_C_BPartner_ID + " - Vendor_ID=" + this.p_Vendor_ID + " - IsDropShip=" + this.p_IsDropShip + " - C_Order_ID=" + this.p_C_Order_ID);
        if (this.p_C_Order_ID == 0 && this.p_DateOrdered_From == null && this.p_DateOrdered_To == null && this.p_C_BPartner_ID == 0 && this.p_Vendor_ID == 0) {
            throw new AdempiereUserError("You need to restrict selection");
        }
        String sql = "SELECT * FROM C_Order o WHERE o.IsSOTrx='Y' AND NOT EXISTS (SELECT * FROM C_OrderLine ol WHERE o.C_Order_ID=ol.C_Order_ID AND ol.Link_OrderLine_ID IS NOT NULL)";
        if (this.p_C_Order_ID != 0) {
            sql = sql + " AND o.C_Order_ID=?";
        } else {
            if (this.p_C_BPartner_ID != 0) {
                sql = sql + " AND o.C_BPartner_ID=?";
            }
            if (this.p_Vendor_ID != 0) {
                sql = sql + " AND EXISTS (SELECT * FROM C_OrderLine ol INNER JOIN M_Product_PO po ON (ol.M_Product_ID=po.M_Product_ID) WHERE o.C_Order_ID=ol.C_Order_ID AND po.C_BPartner_ID=?)";
            }
            if (this.p_DateOrdered_From != null && this.p_DateOrdered_To != null) {
                sql = sql + "AND TRUNC(o.DateOrdered) BETWEEN ? AND ?";
            } else if (this.p_DateOrdered_From != null && this.p_DateOrdered_To == null) {
                sql = sql + "AND TRUNC(o.DateOrdered) >= ?";
            } else if (this.p_DateOrdered_From == null && this.p_DateOrdered_To != null) {
                sql = sql + "AND TRUNC(o.DateOrdered) <= ?";
            }
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int counter = 0;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            if (this.p_C_Order_ID != 0) {
                pstmt.setInt(1, this.p_C_Order_ID);
            } else {
                int index = 1;
                if (this.p_C_BPartner_ID != 0) {
                    pstmt.setInt(index++, this.p_C_BPartner_ID);
                }
                if (this.p_Vendor_ID != 0) {
                    pstmt.setInt(index++, this.p_Vendor_ID);
                }
                if (this.p_DateOrdered_From != null && this.p_DateOrdered_To != null) {
                    pstmt.setTimestamp(index++, this.p_DateOrdered_From);
                    pstmt.setTimestamp(index++, this.p_DateOrdered_To);
                } else if (this.p_DateOrdered_From != null && this.p_DateOrdered_To == null) {
                    pstmt.setTimestamp(index++, this.p_DateOrdered_From);
                } else if (this.p_DateOrdered_From == null && this.p_DateOrdered_To != null) {
                    pstmt.setTimestamp(index++, this.p_DateOrdered_To);
                }
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                counter += this.createPOFromSO(new MOrder(this.getCtx(), rs, this.get_TrxName()));
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (counter == 0) {
            this.log.fine(sql);
        }
        return "@Created@ " + counter;
    }

    private int createPOFromSO(MOrder so) throws Exception {
        this.log.info(so.toString());
        MOrderLine[] soLines = so.getLines(true, null);
        if (soLines == null || soLines.length == 0) {
            this.log.warning("No Lines - " + so);
            return 0;
        }
        int counter = 0;
        String sql = "SELECT MIN(po.C_BPartner_ID), po.M_Product_ID FROM M_Product_PO po INNER JOIN C_OrderLine ol ON (po.M_Product_ID=ol.M_Product_ID) WHERE ol.C_Order_ID=? AND po.IsCurrentVendor='Y' " + (this.p_Vendor_ID > 0 ? " AND po.C_BPartner_ID=? " : "") + "GROUP BY po.M_Product_ID " + "ORDER BY 1";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        X_C_Order po = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, so.getC_Order_ID());
            if (this.p_Vendor_ID != 0) {
                pstmt.setInt(2, this.p_Vendor_ID);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_BPartner_ID = rs.getInt(1);
                if (po == null || po.getBill_BPartner_ID() != C_BPartner_ID) {
                    po = this.createPOForVendor(rs.getInt(1), so);
                    this.addLog(0, null, null, po.getDocumentNo());
                    ++counter;
                }
                int M_Product_ID = rs.getInt(2);
                for (int i2 = 0; i2 < soLines.length; ++i2) {
                    if (soLines[i2].getM_Product_ID() != M_Product_ID) continue;
                    MOrderLine poLine = new MOrderLine((MOrder)po);
                    poLine.setLink_OrderLine_ID(soLines[i2].getC_OrderLine_ID());
                    poLine.setM_Product_ID(soLines[i2].getM_Product_ID());
                    poLine.setC_Charge_ID(soLines[i2].getC_Charge_ID());
                    poLine.setM_AttributeSetInstance_ID(soLines[i2].getM_AttributeSetInstance_ID());
                    poLine.setC_UOM_ID(soLines[i2].getC_UOM_ID());
                    poLine.setQtyEntered(soLines[i2].getQtyEntered());
                    poLine.setQtyOrdered(soLines[i2].getQtyOrdered());
                    poLine.setDescription(soLines[i2].getDescription());
                    poLine.setDatePromised(soLines[i2].getDatePromised());
                    poLine.setPrice();
                    poLine.saveEx();
                    soLines[i2].setLink_OrderLine_ID(poLine.getC_OrderLine_ID());
                    soLines[i2].saveEx();
                }
            }
        }
        catch (Exception e) {
            try {
                this.log.log(Level.SEVERE, sql, e);
                throw e;
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (counter == 1 && po != null) {
            so.setLink_Order_ID(po.getC_Order_ID());
            so.saveEx();
        }
        return counter;
    }

    public MOrder createPOForVendor(int C_BPartner_ID, MOrder so) {
        MOrder po = new MOrder(this.getCtx(), 0, this.get_TrxName());
        po.setClientOrg(so.getAD_Client_ID(), so.getAD_Org_ID());
        po.setLink_Order_ID(so.getC_Order_ID());
        po.setIsSOTrx(false);
        po.setC_DocTypeTarget_ID();
        po.setDescription(so.getDescription());
        po.setPOReference(so.getDocumentNo());
        po.setPriorityRule(so.getPriorityRule());
        po.setSalesRep_ID(so.getSalesRep_ID());
        po.setM_Warehouse_ID(so.getM_Warehouse_ID());
        MBPartner vendor = new MBPartner(this.getCtx(), C_BPartner_ID, this.get_TrxName());
        po.setBPartner(vendor);
        if (this.p_IsDropShip) {
            po.setIsDropShip(this.p_IsDropShip);
            if (so.isDropShip() && so.getDropShip_BPartner_ID() != 0) {
                po.setDropShip_BPartner_ID(so.getDropShip_BPartner_ID());
                po.setDropShip_Location_ID(so.getDropShip_Location_ID());
                po.setDropShip_User_ID(so.getDropShip_User_ID());
            } else {
                po.setDropShip_BPartner_ID(so.getC_BPartner_ID());
                po.setDropShip_Location_ID(so.getC_BPartner_Location_ID());
                po.setDropShip_User_ID(so.getAD_User_ID());
            }
            MOrgInfo orginfo = MOrgInfo.get(this.getCtx(), po.getAD_Org_ID(), this.get_TrxName());
            if (orginfo.getDropShip_Warehouse_ID() != 0) {
                po.setM_Warehouse_ID(orginfo.getDropShip_Warehouse_ID());
            } else {
                this.log.log(Level.SEVERE, "Must specify drop ship warehouse in org info.");
            }
        }
        po.setC_Activity_ID(so.getC_Activity_ID());
        po.setC_Campaign_ID(so.getC_Campaign_ID());
        po.setC_Project_ID(so.getC_Project_ID());
        po.setUser1_ID(so.getUser1_ID());
        po.setUser2_ID(so.getUser2_ID());
        po.saveEx();
        return po;
    }
}

