/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;

public class InOutCreateInvoice
extends SvrProcess {
    private int p_M_InOut_ID = 0;
    private int p_M_PriceList_ID = 0;
    private String p_InvoiceDocumentNo = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_PriceList_ID")) {
                    this.p_M_PriceList_ID = para[i].getParameterAsInt();
                } else if (name.equals("InvoiceDocumentNo")) {
                    this.p_InvoiceDocumentNo = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.p_M_InOut_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_InOut_ID=" + this.p_M_InOut_ID + ", M_PriceList_ID=" + this.p_M_PriceList_ID + ", InvoiceDocumentNo=" + this.p_InvoiceDocumentNo);
        if (this.p_M_InOut_ID == 0) {
            throw new IllegalArgumentException("No Shipment");
        }
        MInOut ship = new MInOut(this.getCtx(), this.p_M_InOut_ID, null);
        if (ship.get_ID() == 0) {
            throw new IllegalArgumentException("Shipment not found");
        }
        if (!"CO".equals(ship.getDocStatus()) && !"CL".equals(ship.getDocStatus())) {
            throw new IllegalArgumentException("Shipment not completed");
        }
        if (ship.getC_Order_ID() == 0) {
            throw new IllegalArgumentException("No Order");
        }
        String m_sql = "select count(c_invoiceline_id) from c_invoiceline cil inner join m_inoutline mil on (cil.m_inoutline_id = mil.m_inoutline_id) inner join c_invoice ci on (cil.c_invoice_id = ci.c_invoice_id)where ci.docstatus <> 'VO' and mil.m_inout_id =?";
        int invoicecount = DB.getSQLValue(this.get_TrxName(), m_sql, this.p_M_InOut_ID);
        if (invoicecount > 0) {
            throw new IllegalArgumentException("Invoice already exists");
        }
        MOrder order = new MOrder(this.getCtx(), ship.getC_Order_ID(), this.get_TrxName());
        MInvoice invoice = new MInvoice(ship, null);
        invoice.setM_PriceList_ID(order.getM_PriceList_ID());
        if (this.p_InvoiceDocumentNo != null && this.p_InvoiceDocumentNo.length() > 0) {
            invoice.setDocumentNo(this.p_InvoiceDocumentNo);
        }
        if (!invoice.save()) {
            throw new IllegalArgumentException("Cannot save Invoice");
        }
        MInOutLine[] shipLines = ship.getLines(false);
        int i = 0;
        while (i < shipLines.length) {
            MInOutLine sLine = shipLines[i];
            if (sLine.getC_OrderLine_ID() == 0) {
                throw new IllegalArgumentException("Una de las lineas no se relaciona con una Orden");
            }
            I_C_OrderLine oline = sLine.getC_OrderLine();
            MInvoiceLine line = new MInvoiceLine(invoice);
            line.setShipLine(sLine);
            line.setOrderLine((MOrderLine)oline);
            if (sLine.sameOrderLineUOM()) {
                line.setQtyEntered(sLine.getQtyEntered());
            } else {
                line.setQtyEntered(sLine.getMovementQty());
            }
            line.setQtyInvoiced(sLine.getMovementQty());
            line.setPriceActual(oline.getPriceActual());
            line.setPriceEntered(oline.getPriceEntered());
            if (!line.save()) {
                throw new IllegalArgumentException("Cannot save Invoice Line");
            }
            ++i;
        }
        return invoice.getDocumentNo();
    }
}

