/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MCost;
import org.compiere.model.MInventory;
import org.compiere.model.MInventoryLine;
import org.compiere.model.MProduct;
import org.compiere.model.X_I_Inventory;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class ImportInventory
extends SvrProcess {
    private int p_AD_Client_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_M_Locator_ID = 0;
    private Timestamp p_MovementDate = null;
    private boolean p_DeleteOldImported = false;
    private boolean p_UpdateCosting = false;
    private int p_C_AcctSchema_ID = 0;
    MAcctSchema acctSchema = null;
    private int p_M_CostType_ID = 0;
    private int p_M_CostElement_ID = 0;
    private int p_AD_OrgTrx_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Client_ID")) {
                    this.p_AD_Client_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_Locator_ID")) {
                    this.p_M_Locator_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("MovementDate")) {
                    this.p_MovementDate = (Timestamp)para[i].getParameter();
                } else if (name.equals("DeleteOldImported")) {
                    this.p_DeleteOldImported = "Y".equals(para[i].getParameter());
                } else if (name.equals("IsUpdateCosting")) {
                    this.p_UpdateCosting = "Y".equals(para[i].getParameter());
                } else if (name.equals("C_AcctSchema_ID")) {
                    this.p_C_AcctSchema_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_CostType_ID")) {
                    this.p_M_CostType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("M_CostElement_ID")) {
                    this.p_M_CostElement_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("AD_OrgTrx_ID")) {
                    this.p_AD_OrgTrx_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_Locator_ID=" + this.p_M_Locator_ID + ",MovementDate=" + this.p_MovementDate);
        if (this.p_UpdateCosting) {
            if (this.p_C_AcctSchema_ID <= 0) {
                throw new IllegalArgumentException("Accounting Schema required!");
            }
            if (this.p_M_CostType_ID <= 0) {
                throw new IllegalArgumentException("Cost Type required!");
            }
            if (this.p_M_CostElement_ID <= 0) {
                throw new IllegalArgumentException("Cost Element required!");
            }
            if (this.p_AD_OrgTrx_ID < 0) {
                throw new IllegalArgumentException("AD_OrgTrx required!");
            }
            this.acctSchema = MAcctSchema.get(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName());
        }
        StringBuffer sql = null;
        int no = 0;
        String clientCheck = " AND AD_Client_ID=" + this.p_AD_Client_ID;
        if (this.p_DeleteOldImported) {
            sql = new StringBuffer("DELETE I_Inventory WHERE I_IsImported='Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Delete Old Imported=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.p_AD_Client_ID).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append(this.p_AD_Org_ID).append("),");
        if (this.p_MovementDate != null) {
            sql.append(" MovementDate = COALESCE (MovementDate,").append(DB.TO_DATE(this.p_MovementDate)).append("),");
        }
        sql.append(" IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', M_Warehouse_ID = NULL, I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.info("Reset=" + no);
        sql = new StringBuffer("UPDATE I_Inventory o SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE o.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("Invalid Org=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l WHERE i.LocatorValue=l.Value AND i.AD_Client_ID=l.AD_Client_ID) WHERE M_Locator_ID IS NULL AND LocatorValue IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Locator from Value =" + no);
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator l WHERE i.X=l.X AND i.Y=l.Y AND i.Z=l.Z AND i.AD_Client_ID=l.AD_Client_ID) WHERE M_Locator_ID IS NULL AND X IS NOT NULL AND Y IS NOT NULL AND Z IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Locator from X,Y,Z =" + no);
        if (this.p_M_Locator_ID != 0) {
            sql = new StringBuffer("UPDATE I_Inventory SET M_Locator_ID = ").append(this.p_M_Locator_ID).append(" WHERE M_Locator_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
            no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("Set Locator from Parameter=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Location, ' WHERE M_Locator_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No Location=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Warehouse_ID=(SELECT M_Warehouse_ID FROM M_Locator l WHERE i.M_Locator_ID=l.M_Locator_ID) WHERE M_Locator_ID IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Warehouse from Locator =" + no);
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Warehouse, ' WHERE M_Warehouse_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("No Warehouse=" + no);
        }
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE i.Value=p.Value AND i.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND Value IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Product from Value=" + no);
        sql = new StringBuffer("UPDATE I_Inventory i SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product p WHERE i.UPC=p.UPC AND i.AD_Client_ID=p.AD_Client_ID) WHERE M_Product_ID IS NULL AND UPC IS NOT NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.log.fine("Set Product from UPC=" + no);
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Product, ' WHERE M_Product_ID IS NULL AND I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.warning("No Product=" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=No Qty Count, ' WHERE QtyCount IS NULL AND I_IsImported<>'Y'").append(clientCheck)).toString(), this.get_TrxName())) != 0) {
            this.log.warning("No QtyCount=" + no);
        }
        this.commitEx();
        MInventory inventory = null;
        int noInsert = 0;
        int noInsertLine = 0;
        sql = new StringBuffer("SELECT * FROM I_Inventory WHERE I_IsImported='N'").append(clientCheck).append(" ORDER BY M_Warehouse_ID, TRUNC(MovementDate), I_Inventory_ID");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            int x_M_Warehouse_ID = -1;
            Timestamp x_MovementDate = null;
            while (rs.next()) {
                MProduct product;
                X_I_Inventory imp = new X_I_Inventory(this.getCtx(), rs, this.get_TrxName());
                Timestamp MovementDate = TimeUtil.getDay(imp.getMovementDate());
                if (inventory == null || imp.getM_Warehouse_ID() != x_M_Warehouse_ID || !MovementDate.equals(x_MovementDate)) {
                    inventory = new MInventory(this.getCtx(), 0, this.get_TrxName());
                    inventory.setClientOrg(imp.getAD_Client_ID(), imp.getAD_Org_ID());
                    inventory.setDescription("I " + imp.getM_Warehouse_ID() + " " + MovementDate);
                    inventory.setM_Warehouse_ID(imp.getM_Warehouse_ID());
                    inventory.setMovementDate(MovementDate);
                    if (!inventory.save()) {
                        this.log.log(Level.SEVERE, "Inventory not saved");
                        break;
                    }
                    x_M_Warehouse_ID = imp.getM_Warehouse_ID();
                    x_MovementDate = MovementDate;
                    ++noInsert;
                }
                int M_AttributeSetInstance_ID = 0;
                if ((imp.getLot() != null || imp.getSerNo() != null) && (product = MProduct.get(this.getCtx(), imp.getM_Product_ID())).isInstanceAttribute()) {
                    MAttributeSet mas = product.getAttributeSet();
                    MAttributeSetInstance masi = new MAttributeSetInstance(this.getCtx(), 0, mas.getM_AttributeSet_ID(), this.get_TrxName());
                    if (mas.isLot() && imp.getLot() != null) {
                        masi.setLot(imp.getLot(), imp.getM_Product_ID());
                    }
                    if (mas.isSerNo() && imp.getSerNo() != null) {
                        masi.setSerNo(imp.getSerNo());
                    }
                    masi.setDescription();
                    masi.save();
                    M_AttributeSetInstance_ID = masi.getM_AttributeSetInstance_ID();
                }
                MInventoryLine line = new MInventoryLine(inventory, imp.getM_Locator_ID(), imp.getM_Product_ID(), M_AttributeSetInstance_ID, imp.getQtyBook(), imp.getQtyCount());
                if (imp.get_ColumnIndex("Tratamiento") >= 0) {
                    MAttributeSetInstance att = new MAttributeSetInstance(this.getCtx(), 0, 1000000, this.get_TrxName());
                    att.save();
                    if (imp.get_ValueAsInt("Ancho") > 0) {
                        MAttributeInstance at1 = new MAttributeInstance(this.getCtx(), 1000009, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Ancho"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Ancho")), this.get_TrxName());
                        at1.save();
                    }
                    if (imp.get_ValueAsInt("Certificacion") > 0) {
                        MAttributeInstance at2 = new MAttributeInstance(this.getCtx(), 1000000, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Certificacion"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Certificacion")), this.get_TrxName());
                        at2.save();
                    }
                    if (imp.get_ValueAsInt("DescEstado") > 0) {
                        MAttributeInstance at3 = new MAttributeInstance(this.getCtx(), 1000007, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("DescEstado"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("DescEstado")), this.get_TrxName());
                        at3.save();
                    }
                    if (imp.get_ValueAsInt("Estado") > 0) {
                        MAttributeInstance at4 = new MAttributeInstance(this.getCtx(), 1000002, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Estado"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Estado")), this.get_TrxName());
                        at4.save();
                    }
                    if (imp.get_ValueAsInt("Humedad") > 0) {
                        MAttributeInstance at5 = new MAttributeInstance(this.getCtx(), 1000006, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Humedad"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Humedad")), this.get_TrxName());
                        at5.save();
                    }
                    if (imp.get_ValueAsInt("Largo") > 0) {
                        MAttributeInstance at6 = new MAttributeInstance(this.getCtx(), 1000001, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Largo"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Largo")), this.get_TrxName());
                        at6.save();
                    }
                    if (imp.get_ValueAsInt("Proveedor") > 0) {
                        MAttributeInstance at7 = new MAttributeInstance(this.getCtx(), 1000005, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Proveedor"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Proveedor")), this.get_TrxName());
                        at7.save();
                    }
                    if (imp.get_ValueAsInt("Terminacion") > 0) {
                        MAttributeInstance at8 = new MAttributeInstance(this.getCtx(), 1000004, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Terminacion"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Terminacion")), this.get_TrxName());
                        at8.save();
                    }
                    if (imp.get_ValueAsInt("TerminacionLargo") > 0) {
                        MAttributeInstance at9 = new MAttributeInstance(this.getCtx(), 1000008, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("TerminacionLargo"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("TerminacionLargo")), this.get_TrxName());
                        at9.save();
                    }
                    if (imp.get_ValueAsInt("Tratamiento") > 0) {
                        MAttributeInstance at10 = new MAttributeInstance(this.getCtx(), 1000003, att.getM_AttributeSetInstance_ID(), imp.get_ValueAsInt("Tratamiento"), DB.getSQLValueString(this.get_TrxName(), "select name from m_attributevalue where m_attributevalue_id =?", imp.get_ValueAsInt("Tratamiento")), this.get_TrxName());
                        at10.save();
                    }
                    line.setM_AttributeSetInstance_ID(att.getM_AttributeSetInstance_ID());
                }
                if (!line.save()) continue;
                imp.setI_IsImported(true);
                imp.setM_Inventory_ID(line.getM_Inventory_ID());
                imp.setM_InventoryLine_ID(line.getM_InventoryLine_ID());
                imp.setProcessed(true);
                if (!imp.save()) continue;
                ++noInsertLine;
                if (!this.p_UpdateCosting) continue;
                MCost cost = MCost.get(MProduct.get(this.getCtx(), imp.getM_Product_ID()), 0, this.acctSchema, this.p_AD_OrgTrx_ID, this.p_M_CostElement_ID, this.get_TrxName());
                cost.setCurrentCostPrice(imp.getCurrentCostPrice());
                if (cost.save()) continue;
                this.log.log(Level.SEVERE, "Cost not saved!");
                break;
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        sql = new StringBuffer("UPDATE I_Inventory SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(clientCheck);
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), "@Errors@");
        this.addLog(0, null, new BigDecimal(noInsert), "@M_Inventory_ID@: @Inserted@");
        this.addLog(0, null, new BigDecimal(noInsertLine), "@M_InventoryLine_ID@: @Inserted@");
        return "";
    }
}

