/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.X_C_BankMatch;
import org.compiere.model.X_I_BankMatch;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ImportCartola
extends SvrProcess {
    private int m_AD_Org_ID = 0;
    private int m_BankAccount_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_Org_ID")) {
                    this.m_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else if (name.equals("C_BankAccount_ID")) {
                    this.m_BankAccount_ID = ((BigDecimal)para[i].getParameter()).intValue();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        StringBuffer sql = null;
        int no = 0;
        sql = new StringBuffer("Delete From I_bankMatch i WHERE (i.SerialNo IS NULL OR i.Amt = 0 OR i.description like '%SALDO%') AND i.I_IsImported<>'Y'");
        no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        if (no != 0) {
            this.log.info("Deleted =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("Update I_bankMatch  Set  ErrorMsg = ''  Where I_IsImported<>'Y'")).toString(), this.get_TrxName())) != 0) {
            this.log.info("updated msg =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_bankMatch i SET C_BankAccount_ID=(  SELECT C_BankAccount_ID  FROM C_BankAccount a, C_Bank b  WHERE b.IsOwnBank='Y'  AND a.AD_Client_ID=i.AD_Client_ID  AND a.C_Bank_ID=b.C_Bank_ID  AND a.AccountNoFile=i.BankAccountNo ), ErrorMsg=''  WHERE i.C_BankAccount_ID IS NULL AND i.I_IsImported<>'Y' OR i.I_IsImported IS NULL")).toString(), this.get_TrxName())) != 0) {
            this.log.info("Bank Account found =" + no);
        }
        if ((no = DB.executeUpdate((sql = new StringBuffer("UPDATE I_bankMatch i SET ErrorMsg='NO Bank Account' WHERE i.C_BankAccount_ID IS NULL AND i.I_IsImported<>'Y' OR i.I_IsImported IS NULL")).toString(), this.get_TrxName())) != 0) {
            this.log.info("Bank Account notfound =" + no);
        }
        this.log.config("**chequeo de folio**");
        sql = new StringBuffer("SELECT * FROM I_bankMatch i  WHERE i.I_isImported='N' and i.C_BankAccount_ID>0 and (ErrorMsg = '' or ErrorMsg is null) ");
        sql.append(" And i.createdby=" + Env.getAD_User_ID(this.getCtx()));
        if (this.m_BankAccount_ID > 0) {
            sql.append(" And i.C_BankAccount_ID=" + this.m_BankAccount_ID);
        }
        sql.append(" Order by i.C_BankAccount_ID");
        CPreparedStatement pstmt = null;
        no = 0;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                X_I_BankMatch ibank = new X_I_BankMatch(Env.getCtx(), rs, this.get_TrxName());
                int Payment_ID = this.getPayment(ibank.getAmt(), ibank.getSigno(), ibank.getDescription(), ibank.getC_BankAccount_ID(), ibank.getSerialNo());
                X_C_BankMatch cbank = new X_C_BankMatch(Env.getCtx(), 0, this.get_TrxName());
                if (Payment_ID > 0) {
                    cbank.setC_Payment_ID(Payment_ID);
                    ibank.setC_Payment_ID(Payment_ID);
                    cbank.setIsMatched(true);
                    ibank.setIsMatched(true);
                }
                cbank.setAD_Org_ID(ibank.getAD_Org_ID());
                cbank.setAmt(ibank.getAmt());
                cbank.setBankAccountNo(ibank.getBankAccountNo());
                cbank.setC_BankAccount_ID(ibank.getC_BankAccount_ID());
                cbank.setCodSucursal(ibank.getCodSucursal());
                cbank.setCodTransaction(ibank.getCodTransaction());
                cbank.setDescription(ibank.getDescription());
                cbank.setDocumentDate(ibank.getDocumentDate());
                cbank.setFolio(ibank.getFolio());
                cbank.setSerialNo(ibank.getSerialNo());
                cbank.setSigno(ibank.getSigno());
                cbank.setStatementDate(ibank.getStatementDate());
                cbank.set_ValueOfColumn("SaldoInicial", ibank.get_Value("SaldoInicial"));
                cbank.save();
                ibank.setI_IsImported(true);
                ibank.setProcessed(true);
                ibank.save();
                ++no;
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
            if (no > 1) {
                sql = new StringBuffer("Delete from I_bankMatch i where i.I_isImported='Y' and i.Createdby=" + Env.getAD_User_ID(this.getCtx()));
                no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage());
        }
        this.commitEx();
        return String.valueOf(no) + " Movimientos Importados";
    }

    private int getPayment(BigDecimal amt, String signo, String Descripcion, int Account_ID, String SerialNo) {
        String sql = "select p.C_Payment_ID from C_Payment p where p.DocStatus IN ('CO','CL') and p.isReconciled='N' and p.PayAmt=? and p.isreceipt=? and p.C_BankAccount_ID=? And Not Exists (select * from I_bankMatch c where c.C_Payment_ID = p.C_Payment_ID)  And (CheckNo = '" + SerialNo + "' OR CreditCardNumber = '" + SerialNo + "' OR AccountNo = '" + SerialNo + "')";
        if (Descripcion.toUpperCase().indexOf("CHEQUE") > -1) {
            sql = String.valueOf(sql) + " and TenderType='K' ";
        }
        return DB.getSQLValue(this.get_TrxName(), sql, amt, signo.equals("A") ? "Y" : "N", Account_ID);
    }

    private BigDecimal getSaldoAnterior(int C_BankAccount_ID, int folio) {
        int maxFolio = DB.getSQLValue(this.get_TrxName(), "Select max(folio) from c_bankMatch where C_BankAccount_ID=" + C_BankAccount_ID);
        if (maxFolio <= 0 || maxFolio == folio) {
            return new BigDecimal(0.0);
        }
        CPreparedStatement pstmt = null;
        String sql = "select saldoinicial,amt,signo from c_bankmatch where folio=" + maxFolio;
        BigDecimal saldo = new BigDecimal("0.0");
        int no = 0;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (no == 0) {
                    saldo = rs.getBigDecimal(1);
                }
                if (rs.getString(3).trim().equals("A")) {
                    saldo = saldo.add(rs.getBigDecimal(2));
                }
                if (rs.getString(3).trim().equals("C")) {
                    saldo = saldo.subtract(rs.getBigDecimal(2));
                }
                ++no;
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage());
        }
        return saldo;
    }

    private void actualizaSaldoInicial() {
        StringBuffer sql = new StringBuffer("Select i.* from I_bankMatch i Inner join C_BankAccount ba on (i.C_BankAccount_ID=ba.C_BankAccount_ID) Inner join C_Bank b on (ba.C_Bank_ID = b.C_Bank_ID)where i.I_isImported='N' and i.C_BankAccount_ID>0 and (ErrorMsg = '' or ErrorMsg is null) and upper(b.name) like '%CHILE%' and i.codsucursal<>'OK'  and i.createdby=" + Env.getAD_User_ID(this.getCtx()) + " order by i.folio");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            BigDecimal saldo = new BigDecimal("0.0");
            long folio = 0L;
            int Account_ID = 0;
            while (rs.next()) {
                if (folio != rs.getLong("folio")) {
                    if (folio != 0L) {
                        DB.executeUpdate("update I_bankMatch set saldoinicial =" + saldo.longValue() + ", codsucursal='OK' where folio=" + folio + " and I_isImported='N' and C_BankAccount_ID=" + Account_ID, this.get_TrxName());
                    }
                    folio = rs.getLong("folio");
                    Account_ID = rs.getInt("C_BankAccount_ID");
                    saldo = rs.getBigDecimal("saldoinicial");
                }
                if (rs.getString("signo").trim().toUpperCase().equals("A")) {
                    saldo = saldo.subtract(rs.getBigDecimal("amt"));
                }
                if (!rs.getString("signo").trim().toUpperCase().equals("C")) continue;
                saldo = saldo.add(rs.getBigDecimal("amt"));
            }
            if (folio != 0L) {
                DB.executeUpdate("update I_bankMatch set saldoinicial =" + saldo.longValue() + ", codsucursal='OK' where folio=" + folio + " and I_isImported='N' and C_BankAccount_ID=" + Account_ID, this.get_TrxName());
            }
            rs.close();
            pstmt.close();
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage());
        }
    }
}

