/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class CostUpdate
extends SvrProcess {
    private int p_M_Product_Category_ID = 0;
    private String p_SetFutureCostTo = null;
    private String p_SetStandardCostTo = null;
    private int p_M_PriceList_Version_ID = 0;
    private static final String TO_AveragePO = "A";
    private static final String TO_AverageInvoiceHistory = "DI";
    private static final String TO_AveragePOHistory = "DP";
    private static final String TO_FiFo = "F";
    private static final String TO_AverageInvoice = "I";
    private static final String TO_LiFo = "L";
    private static final String TO_PriceListLimit = "LL";
    private static final String TO_StandardCost = "S";
    private static final String TO_FutureStandardCost = "f";
    private static final String TO_LastInvoicePrice = "i";
    private static final String TO_LastPOPrice = "p";
    private static final String TO_OldStandardCost = "x";
    private MCostElement m_ce = null;
    private MAcctSchema[] m_ass = null;
    private HashMap<String, MCostElement> m_ces = new HashMap();

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("M_Product_Category_ID")) {
                this.p_M_Product_Category_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("SetFutureCostTo")) {
                this.p_SetFutureCostTo = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("SetStandardCostTo")) {
                this.p_SetStandardCostTo = (String)para[i2].getParameter();
                continue;
            }
            if (name.equals("M_PriceList_Version_ID")) {
                this.p_M_PriceList_Version_ID = para[i2].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_Product_Category_ID=" + this.p_M_Product_Category_ID + ", Future=" + this.p_SetFutureCostTo + ", Standard=" + this.p_SetStandardCostTo + "; M_PriceList_Version_ID=" + this.p_M_PriceList_Version_ID);
        if (this.p_SetFutureCostTo == null) {
            this.p_SetFutureCostTo = "";
        }
        if (this.p_SetStandardCostTo == null) {
            this.p_SetStandardCostTo = "";
        }
        if (this.p_SetFutureCostTo.length() == 0 && this.p_SetStandardCostTo.length() == 0) {
            return "-";
        }
        if (this.p_M_PriceList_Version_ID == 0 && (this.p_SetFutureCostTo.equals(TO_PriceListLimit) || this.p_SetStandardCostTo.equals(TO_PriceListLimit))) {
            throw new AdempiereUserError("@FillMandatory@  @M_PriceList_Version_ID@");
        }
        if (!this.isValid(this.p_SetFutureCostTo)) {
            throw new AdempiereUserError("@NotFound@ @M_CostElement_ID@ (Future) " + this.p_SetFutureCostTo);
        }
        if (!this.isValid(this.p_SetStandardCostTo)) {
            throw new AdempiereUserError("@NotFound@ @M_CostElement_ID@ (Standard) " + this.p_SetStandardCostTo);
        }
        MClient client = MClient.get(this.getCtx());
        this.m_ce = MCostElement.getMaterialCostElement(client, TO_StandardCost);
        if (this.m_ce.get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@ @M_CostElement_ID@ (StdCost)");
        }
        this.log.config(this.m_ce.toString());
        this.m_ass = MAcctSchema.getClientAcctSchema(this.getCtx(), client.getAD_Client_ID());
        for (int i2 = 0; i2 < this.m_ass.length; ++i2) {
            this.createNew(this.m_ass[i2]);
        }
        this.commitEx();
        int counter = this.update();
        return "#" + counter;
    }

    private boolean isValid(String to) {
        if (this.p_SetFutureCostTo.length() == 0) {
            return true;
        }
        String toTarget = to;
        if (to.equals(TO_AverageInvoiceHistory)) {
            to = TO_AverageInvoice;
        }
        if (to.equals(TO_AveragePOHistory)) {
            to = TO_AveragePO;
        }
        if (to.equals(TO_FutureStandardCost)) {
            to = TO_StandardCost;
        }
        if (to.equals(TO_AverageInvoice) || to.equals(TO_AveragePO) || to.equals(TO_FiFo) || to.equals(TO_LiFo) || to.equals(TO_StandardCost)) {
            MCostElement ce = this.getCostElement(this.p_SetFutureCostTo);
            return ce != null;
        }
        return true;
    }

    private void createNew(MAcctSchema as) {
        if (!as.getCostingLevel().equals("C")) {
            String txt = "Costing Level prevents creating new Costing records for " + as.getName();
            this.log.warning(txt);
            this.addLog(0, null, null, txt);
            return;
        }
        String sql = "SELECT * FROM M_Product p WHERE NOT EXISTS (SELECT * FROM M_Cost c WHERE c.M_Product_ID=p.M_Product_ID AND c.M_CostType_ID=? AND c.C_AcctSchema_ID=? AND c.M_CostElement_ID=? AND c.M_AttributeSetInstance_ID=0) AND AD_Client_ID=?";
        if (this.p_M_Product_Category_ID != 0) {
            sql = sql + " AND M_Product_Category_ID=?";
        }
        int counter = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, as.getM_CostType_ID());
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            pstmt.setInt(3, this.m_ce.getM_CostElement_ID());
            pstmt.setInt(4, as.getAD_Client_ID());
            if (this.p_M_Product_Category_ID != 0) {
                pstmt.setInt(5, this.p_M_Product_Category_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (!this.createNew(new MProduct(this.getCtx(), rs, null), as)) continue;
                ++counter;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info("#" + counter);
        this.addLog(0, null, new BigDecimal(counter), "Created for " + as.getName());
    }

    private boolean createNew(MProduct product, MAcctSchema as) {
        MCost cost = MCost.get(product, 0, as, 0, this.m_ce.getM_CostElement_ID());
        if (cost.is_new()) {
            return cost.save();
        }
        return false;
    }

    private int update() {
        int counter = 0;
        String sql = "SELECT * FROM M_Cost c WHERE M_CostElement_ID=?";
        if (this.p_M_Product_Category_ID != 0) {
            sql = sql + " AND EXISTS (SELECT * FROM M_Product p WHERE c.M_Product_ID=p.M_Product_ID AND p.M_Product_Category_ID=?)";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_ce.getM_CostElement_ID());
            if (this.p_M_Product_Category_ID != 0) {
                pstmt.setInt(2, this.p_M_Product_Category_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MCost cost = new MCost(this.getCtx(), rs, this.get_TrxName());
                for (int i2 = 0; i2 < this.m_ass.length; ++i2) {
                    if (this.m_ass[i2].getC_AcctSchema_ID() != cost.getC_AcctSchema_ID() || this.m_ass[i2].getM_CostType_ID() != cost.getM_CostType_ID() || !this.update(cost)) continue;
                    ++counter;
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info("#" + counter);
        this.addLog(0, null, new BigDecimal(counter), "@Updated@");
        return counter;
    }

    private boolean update(MCost cost) throws Exception {
        boolean updated = false;
        if (this.p_SetFutureCostTo.equals(this.p_SetStandardCostTo)) {
            BigDecimal costs = this.getCosts(cost, this.p_SetFutureCostTo);
            if (costs != null && costs.signum() != 0) {
                cost.setFutureCostPrice(costs);
                cost.setCurrentCostPrice(costs);
                updated = true;
            }
        } else {
            BigDecimal costs;
            if (this.p_SetStandardCostTo.length() > 0 && (costs = this.getCosts(cost, this.p_SetStandardCostTo)) != null && costs.signum() != 0) {
                cost.setCurrentCostPrice(costs);
                updated = true;
            }
            if (this.p_SetFutureCostTo.length() > 0 && (costs = this.getCosts(cost, this.p_SetFutureCostTo)) != null && costs.signum() != 0) {
                cost.setFutureCostPrice(costs);
                updated = true;
            }
        }
        if (updated) {
            updated = cost.save();
        }
        return updated;
    }

    private BigDecimal getCosts(MCost cost, String to) throws Exception {
        BigDecimal retValue = null;
        if (to.equals(TO_AverageInvoice)) {
            MCostElement ce = this.getCostElement(TO_AverageInvoice);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: I");
            }
            MCost xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_AverageInvoiceHistory)) {
            MCostElement ce = this.getCostElement(TO_AverageInvoice);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: I");
            }
            MCost xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID());
            if (xCost != null) {
                retValue = xCost.getHistoryAverage();
            }
        } else if (to.equals(TO_AveragePO)) {
            MCostElement ce = this.getCostElement(TO_AveragePO);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: A");
            }
            MCost xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_AveragePOHistory)) {
            MCostElement ce = this.getCostElement(TO_AveragePO);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: A");
            }
            MCost xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID());
            if (xCost != null) {
                retValue = xCost.getHistoryAverage();
            }
        } else if (to.equals(TO_FiFo)) {
            MCostElement ce = this.getCostElement(TO_FiFo);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: F");
            }
            MCost xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_FutureStandardCost)) {
            retValue = cost.getFutureCostPrice();
        } else if (to.equals(TO_LastInvoicePrice)) {
            MCost xCost;
            MCostElement ce = this.getCostElement(TO_LastInvoicePrice);
            if (ce != null && (xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID())) != null) {
                retValue = xCost.getCurrentCostPrice();
            }
            if (retValue == null) {
                MProduct product = MProduct.get(this.getCtx(), cost.getM_Product_ID());
                MAcctSchema as = MAcctSchema.get(this.getCtx(), cost.getC_AcctSchema_ID());
                retValue = MCost.getLastInvoicePrice(product, cost.getM_AttributeSetInstance_ID(), cost.getAD_Org_ID(), as.getC_Currency_ID());
            }
        } else if (to.equals(TO_LastPOPrice)) {
            MCost xCost;
            MCostElement ce = this.getCostElement(TO_LastPOPrice);
            if (ce != null && (xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID())) != null) {
                retValue = xCost.getCurrentCostPrice();
            }
            if (retValue == null) {
                MProduct product = MProduct.get(this.getCtx(), cost.getM_Product_ID());
                MAcctSchema as = MAcctSchema.get(this.getCtx(), cost.getC_AcctSchema_ID());
                retValue = MCost.getLastPOPrice(product, cost.getM_AttributeSetInstance_ID(), cost.getAD_Org_ID(), as.getC_Currency_ID());
            }
        } else if (to.equals(TO_LiFo)) {
            MCostElement ce = this.getCostElement(TO_LiFo);
            if (ce == null) {
                throw new AdempiereSystemError("CostElement not found: L");
            }
            MCost xCost = MCost.get(this.getCtx(), cost.getAD_Client_ID(), cost.getAD_Org_ID(), cost.getM_Product_ID(), cost.getM_CostType_ID(), cost.getC_AcctSchema_ID(), ce.getM_CostElement_ID(), cost.getM_AttributeSetInstance_ID());
            if (xCost != null) {
                retValue = xCost.getCurrentCostPrice();
            }
        } else if (to.equals(TO_OldStandardCost)) {
            retValue = this.getOldCurrentCostPrice(cost);
        } else if (to.equals(TO_PriceListLimit)) {
            retValue = this.getPrice(cost);
        } else if (to.equals(TO_StandardCost)) {
            retValue = cost.getCurrentCostPrice();
        }
        return retValue;
    }

    private MCostElement getCostElement(String CostingMethod) {
        MCostElement ce = this.m_ces.get(CostingMethod);
        if (ce == null) {
            ce = MCostElement.getMaterialCostElement(this.getCtx(), CostingMethod);
            this.m_ces.put(CostingMethod, ce);
        }
        return ce;
    }

    private BigDecimal getOldCurrentCostPrice(MCost cost) {
        BigDecimal retValue = null;
        String sql = "SELECT CostStandard, CurrentCostPrice FROM M_Product_Costing WHERE M_Product_ID=? AND C_AcctSchema_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, cost.getM_Product_ID());
            pstmt.setInt(2, cost.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next() && ((retValue = rs.getBigDecimal(1)) == null || retValue.signum() == 0)) {
                retValue = rs.getBigDecimal(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    private BigDecimal getPrice(MCost cost) {
        BigDecimal retValue = null;
        String sql = "SELECT PriceLimit FROM M_ProductPrice WHERE M_Product_ID=? AND M_PriceList_Version_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, cost.getM_Product_ID());
            pstmt.setInt(2, this.p_M_PriceList_Version_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }
}

