/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MProduct;
import org.compiere.model.OFBProductCost;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CostResetTo
extends SvrProcess {
    private int p_M_Product_ID = 0;
    private int p_M_Product_Category_ID = 0;
    private int p_AD_Org_ID = 0;
    private boolean p_UpdateQty;
    private boolean p_FromPO = false;
    private int p_WareHouse_ID = 0;
    private BigDecimal p_Margen = Env.ZERO;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_ID")) {
                    this.p_M_Product_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_Category_ID")) {
                    this.p_M_Product_Category_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("M_Warehouse_ID")) {
                    this.p_WareHouse_ID = para[i].getParameterAsInt();
                } else if (name.equals("UpdateQty")) {
                    this.p_UpdateQty = para[i].getParameterAsBoolean();
                } else if (name.equals("FromPO")) {
                    this.p_FromPO = para[i].getParameterAsBoolean();
                } else if (name.equals("Margen")) {
                    this.p_Margen = (BigDecimal)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("M_Product_ID=" + this.p_M_Product_ID);
        if (this.p_M_Product_ID == 0 && this.p_M_Product_Category_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @M_Product_ID@ = " + this.p_M_Product_ID);
        }
        if (this.p_UpdateQty && this.p_WareHouse_ID == 0) {
            throw new AdempiereUserError("Para Actualizar la Cantidad se Requiere Un Warehouse");
        }
        if (this.p_Margen.signum() == 0) {
            throw new AdempiereUserError("El Margen Debe ser al Menos 1");
        }
        if (this.p_M_Product_ID > 0) {
            MProduct product = MProduct.get(this.getCtx(), this.p_M_Product_ID);
            if (product.get_ID() != this.p_M_Product_ID) {
                throw new AdempiereUserError("@NotFound@: @M_Product_ID@ = " + this.p_M_Product_ID);
            }
            if (this.p_FromPO) {
                OFBProductCost.resetCostToPO(this.p_M_Product_ID, this.p_Margen, this.p_AD_Org_ID, this.p_UpdateQty, this.p_WareHouse_ID, this.get_TrxName(), this.getCtx());
            } else {
                OFBProductCost.resetCostToInvoice(this.p_M_Product_ID, this.p_Margen, this.p_AD_Org_ID, this.p_UpdateQty, this.p_WareHouse_ID, this.get_TrxName(), this.getCtx());
            }
            this.commitEx();
            return "@OK@";
        }
        if (this.p_M_Product_Category_ID > 0) {
            String sql = "SELECT p.M_Product_ID FROM M_Product p Inner Join M_CostDetail d on (p.M_Product_ID=d.M_product_ID) WHERE p.M_Product_Category_ID=? AND p.isactive='Y' ";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.p_M_Product_Category_ID);
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    if (this.p_FromPO) {
                        OFBProductCost.resetCostToPO(rs.getInt(1), this.p_Margen, this.p_AD_Org_ID, this.p_UpdateQty, this.p_WareHouse_ID, this.get_TrxName(), this.getCtx());
                        continue;
                    }
                    OFBProductCost.resetCostToInvoice(rs.getInt(1), this.p_Margen, this.p_AD_Org_ID, this.p_UpdateQty, this.p_WareHouse_ID, this.get_TrxName(), this.getCtx());
                }
                rs.close();
                pstmt.close();
                pstmt = null;
                this.commitEx();
                return "@OK@";
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return "@Error@";
    }
}

