/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CopyRole
extends SvrProcess {
    private int m_AD_Role_ID_From = 0;
    private int m_AD_Role_ID_To = 0;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("AD_Role_ID") && i2 == 0) {
                this.m_AD_Role_ID_From = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Role_ID") && i2 == 1) {
                this.m_AD_Role_ID_To = para[i2].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Client_ID")) {
                this.m_AD_Client_ID = para[i2].getParameterAsInt();
                continue;
            }
            if (!name.equals("AD_Org_ID")) continue;
            this.m_AD_Org_ID = para[i2].getParameterAsInt();
        }
    }

    @Override
    protected String doIt() throws Exception {
        String[] tables = new String[]{"AD_Window_Access", "AD_Process_Access", "AD_Form_Access", "AD_Workflow_Access", "AD_Task_Access", "AD_Document_Action_Access", "AD_Role_Included"};
        String[] keycolumns = new String[]{"AD_Window_ID", "AD_Process_ID", "AD_Form_ID", "AD_Workflow_ID", "AD_Task_ID", "C_DocType_ID, AD_Ref_List_ID", "Included_Role_ID"};
        int action = 0;
        for (int i2 = 0; i2 < tables.length; ++i2) {
            String table2 = tables[i2];
            String keycolumn = keycolumns[i2];
            String sql = "DELETE FROM " + table2 + " WHERE AD_Role_ID = " + this.m_AD_Role_ID_To;
            int no = DB.executeUpdateEx(sql, this.get_TrxName());
            this.addLog(action++, null, BigDecimal.valueOf(no), "Old records deleted from " + table2);
            boolean column_IsReadWrite = !table2.equals("AD_Document_Action_Access") && !table2.equals("AD_Role_Included");
            boolean column_SeqNo = table2.equals("AD_Role_Included");
            sql = "INSERT INTO " + table2 + " (AD_Client_ID, AD_Org_ID, Created, CreatedBy, Updated, UpdatedBy, " + "AD_Role_ID, " + keycolumn + ", isActive";
            if (column_SeqNo) {
                sql = sql + ", SeqNo ";
            }
            sql = column_IsReadWrite ? sql + ", isReadWrite) " : sql + ") ";
            sql = sql + "SELECT " + this.m_AD_Client_ID + ", " + this.m_AD_Org_ID + ", getdate(), " + Env.getAD_User_ID(Env.getCtx()) + ", getdate(), " + Env.getAD_User_ID(Env.getCtx()) + ", " + this.m_AD_Role_ID_To + ", " + keycolumn + ", IsActive ";
            if (column_SeqNo) {
                sql = sql + ", SeqNo ";
            }
            if (column_IsReadWrite) {
                sql = sql + ", isReadWrite ";
            }
            sql = sql + "FROM " + table2 + " WHERE AD_Role_ID = " + this.m_AD_Role_ID_From;
            no = DB.executeUpdateEx(sql, this.get_TrxName());
            this.addLog(action++, null, new BigDecimal(no), "New records inserted into " + table2);
        }
        return "Role copied";
    }
}

