/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class CopyOrder
extends SvrProcess {
    private int p_C_Order_ID = 0;
    private int p_C_DocType_ID = 0;
    private Timestamp p_DateDoc = null;
    private boolean p_IsCloseDocument = false;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i2 = 0; i2 < para.length; ++i2) {
            String name = para[i2].getParameterName();
            if (para[i2].getParameter() == null) continue;
            if (name.equals("C_Order_ID")) {
                this.p_C_Order_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = ((BigDecimal)para[i2].getParameter()).intValue();
                continue;
            }
            if (name.equals("DateDoc")) {
                this.p_DateDoc = (Timestamp)para[i2].getParameter();
                continue;
            }
            if (name.equals("IsCloseDocument")) {
                this.p_IsCloseDocument = "Y".equals(para[i2].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_Order_ID=" + this.p_C_Order_ID + ", C_DocType_ID=" + this.p_C_DocType_ID + ", CloseDocument=" + this.p_IsCloseDocument);
        if (this.p_C_Order_ID == 0) {
            throw new IllegalArgumentException("No Order");
        }
        MDocType dt = MDocType.get(this.getCtx(), this.p_C_DocType_ID);
        if (dt.get_ID() == 0) {
            throw new IllegalArgumentException("No DocType");
        }
        if (this.p_DateDoc == null) {
            this.p_DateDoc = new Timestamp(System.currentTimeMillis());
        }
        MOrder from = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
        MOrder newOrder = MOrder.copyFrom(from, this.p_DateDoc, dt.getC_DocType_ID(), dt.isSOTrx(), false, true, this.get_TrxName());
        newOrder.setC_DocTypeTarget_ID(this.p_C_DocType_ID);
        boolean OK = newOrder.save();
        if (!OK) {
            throw new IllegalStateException("Could not create new Order");
        }
        if (this.p_IsCloseDocument) {
            MOrder original = new MOrder(this.getCtx(), this.p_C_Order_ID, this.get_TrxName());
            original.setDocAction("CO");
            original.processIt("CO");
            original.save();
            original.setDocAction("CL");
            original.processIt("CL");
            original.save();
        }
        return dt.getName() + ": " + newOrder.getDocumentNo();
    }
}

