/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MOrder;
import org.compiere.model.PO;
import org.compiere.pos.PosPanel;
import org.compiere.pos.PosSubPanel;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class SubLines
extends PosSubPanel
implements ActionListener {
    private static final long serialVersionUID = -1536223059244074580L;
    private MiniTable m_table;
    private String m_sql;
    private static CLogger log = CLogger.getCLogger(SubLines.class);
    private CButton f_up;
    private CButton f_delete;
    private CButton f_down;
    private VNumber f_net;
    private VNumber f_tax;
    private VNumber f_total;
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_OrderLine_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Line"), "Line", Integer.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Qty"), "QtyOrdered", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_UOM_ID"), "UOMSymbol", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceBruto"), "round(PriceActual*1.19)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "LineTotalAmt"), "round(LineNetAmt*1.19)", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "PriceActual"), "PriceActual", BigDecimal.class), new ColumnInfo(Msg.translate(Env.getCtx(), "LineNetAmt"), "LineNetAmt", BigDecimal.class)};
    private static String s_sqlFrom = "C_Order_LineTax_v";
    private static String s_sqlWhere = "C_Order_ID=? AND LineNetAmt<>0";

    public SubLines(PosPanel posPanel) {
        super(posPanel);
    }

    @Override
    public void init() {
        TitledBorder border = new TitledBorder(Msg.translate(Env.getCtx(), "C_OrderLine_ID"));
        this.setBorder(border);
        this.setLayout(new BorderLayout(5, 5));
        this.m_table = new MiniTable();
        CScrollPane scroll = new CScrollPane(this.m_table);
        this.m_sql = String.valueOf(this.m_table.prepareTable(s_layout, s_sqlFrom, s_sqlWhere, false, "C_Order_LineTax_v")) + " ORDER BY Line";
        this.m_table.setRowSelectionAllowed(true);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setMultiSelection(false);
        scroll.setPreferredSize(new Dimension(100, 120));
        this.add((Component)scroll, "Center");
        CPanel right = new CPanel();
        this.add((Component)right, "East");
        right.setLayout(new BoxLayout(right, 1));
        right.add(Box.createGlue());
        this.f_up = this.createButtonAction("Previous", KeyStroke.getKeyStroke(38, 0));
        right.add(this.f_up);
        right.add(Box.createGlue());
        this.f_delete = this.createButtonAction("Delete", KeyStroke.getKeyStroke(127, 1));
        right.add(this.f_delete);
        right.add(Box.createGlue());
        this.f_down = this.createButtonAction("Next", KeyStroke.getKeyStroke(40, 0));
        right.add(this.f_down);
        right.add(Box.createGlue());
        FlowLayout summaryLayout = new FlowLayout(3, 2, 0);
        CPanel summary = new CPanel(summaryLayout);
        this.add((Component)summary, "South");
        CLabel lNet = new CLabel(Msg.translate(Env.getCtx(), "TotalLines"));
        summary.add(lNet);
        this.f_net = new VNumber("TotalLines", false, true, false, 12, "TotalLines");
        this.f_net.setColumns(11, 22);
        lNet.setLabelFor(this.f_net);
        summary.add(this.f_net);
        this.f_net.setValue(Env.ZERO);
        CLabel lTax = new CLabel(Msg.translate(Env.getCtx(), "TaxAmt"));
        summary.add(lTax);
        this.f_tax = new VNumber("TaxAmt", false, true, false, 12, "TaxAmt");
        this.f_tax.setColumns(6, 22);
        lTax.setLabelFor(this.f_tax);
        summary.add(this.f_tax);
        this.f_tax.setValue(Env.ZERO);
        CLabel lTotal = new CLabel(Msg.translate(Env.getCtx(), "GrandTotal"));
        summary.add(lTotal);
        this.f_total = new VNumber("GrandTotal", false, true, false, 12, "GrandTotal");
        this.f_total.setColumns(11, 22);
        lTotal.setLabelFor(this.f_total);
        summary.add(this.f_total);
        this.f_total.setValue(Env.ZERO);
        this.f_delete.setReadWrite(true);
    }

    @Override
    public GridBagConstraints getGridBagConstraints() {
        GridBagConstraints gbc = super.getGridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.7;
        gbc.weighty = 0.7;
        return gbc;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int row;
        int rows;
        String action = e.getActionCommand();
        if (action == null || action.length() == 0) {
            return;
        }
        log.info("PosSubAllLines - actionPerformed: " + action);
        if ("Previous".equalsIgnoreCase(e.getActionCommand())) {
            int rows2 = this.m_table.getRowCount();
            if (rows2 == 0) {
                return;
            }
            int row2 = this.m_table.getSelectedRow();
            if (--row2 < 0) {
                row2 = 0;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row2, row2);
            return;
        }
        if ("Next".equalsIgnoreCase(e.getActionCommand())) {
            int rows3 = this.m_table.getRowCount();
            if (rows3 == 0) {
                return;
            }
            int row3 = this.m_table.getSelectedRow();
            if (++row3 >= rows3) {
                row3 = rows3 - 1;
            }
            this.m_table.getSelectionModel().setSelectionInterval(row3, row3);
            return;
        }
        if (action.equals("Delete") && (rows = this.m_table.getRowCount()) != 0 && (row = this.m_table.getSelectedRow()) != -1) {
            this.p_posPanel.f_curLine.deleteLine(row);
        }
        this.p_posPanel.updateInfo();
    }

    public void updateTable(MOrder order) {
        block7: {
            int C_Order_ID = 0;
            if (order != null) {
                C_Order_ID = order.getC_Order_ID();
            }
            if (C_Order_ID == 0) {
                this.m_table.loadTable(new PO[0]);
                this.setSums(null);
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(this.m_sql, null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    this.m_table.loadTable(rs);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, this.m_sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.setSums(order);
    }

    private void setSums(MOrder order) {
        int noLines = this.m_table.getRowCount();
        this.p_posPanel.f_status.setStatusDB(noLines);
        if (order == null || noLines == 0) {
            this.f_net.setValue(Env.ZERO);
            this.f_total.setValue(Env.ZERO);
            this.f_tax.setValue(Env.ZERO);
        } else {
            this.p_posPanel.f_curLine.setOrder(order.getC_Order_ID());
            MOrder retValue = this.p_posPanel.f_curLine.getOrder();
            this.f_net.setValue(retValue.getTotalLines());
            this.f_total.setValue(retValue.getGrandTotal());
            this.f_tax.setValue(retValue.getGrandTotal().subtract(retValue.getTotalLines()));
        }
    }
}

