/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.pos;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.compiere.apps.ADialog;
import org.compiere.apps.form.FormFrame;
import org.compiere.model.MPOS;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.pos.CashSubFunctions;
import org.compiere.pos.PosPanel;
import org.compiere.pos.QueryBPartner;
import org.compiere.pos.QueryProduct;
import org.compiere.pos.QueryTicket;
import org.compiere.pos.SubBPartner;
import org.compiere.pos.SubCheckout;
import org.compiere.pos.SubCurrentLine;
import org.compiere.pos.SubFunctionKeys;
import org.compiere.pos.SubLines;
import org.compiere.pos.SubProduct;
import org.compiere.pos.SubSalesRep;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PosPanelWH
extends PosPanel {
    private CLogger log = CLogger.getCLogger(this.getClass());
    private Properties m_ctx = Env.getCtx();
    private Timestamp m_today = Env.getContextAsDate(this.m_ctx, "#Date");

    @Override
    public void init(int WindowNo, FormFrame frame) {
        frame.setMaximize(true);
        this.setm_SalesRep_ID(Env.getAD_User_ID(Env.getCtx()));
        this.log.info("init - SalesRep_ID=" + this.getm_SalesRep_ID());
        this.setm_WindowNo(WindowNo);
        this.setm_frame(frame);
        try {
            if (!this.dynInit()) {
                this.dispose();
                frame.dispose();
                return;
            }
            frame.getContentPane().add((Component)this, "Center");
            frame.getContentPane().add((Component)this.f_status, "South");
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "init", e);
        }
        this.log.config("PosPanel.init - " + this.getPreferredSize());
        this.getm_focusMgr().start();
    }

    private boolean dynInit() {
        if (!this.setMPOS()) {
            return false;
        }
        this.f_bpartner = new SubBPartner(this);
        this.add((Component)this.f_bpartner, this.f_bpartner.getGridBagConstraints());
        this.f_salesRep = new SubSalesRep(this);
        this.add((Component)this.f_salesRep, this.f_salesRep.getGridBagConstraints());
        this.f_curLine = new SubCurrentLine(this);
        this.add((Component)this.f_curLine, this.f_curLine.getGridBagConstraints());
        this.f_product = new SubProduct(this);
        this.add((Component)this.f_product, this.f_product.getGridBagConstraints());
        this.f_lines = new SubLines(this);
        this.add((Component)this.f_lines, this.f_lines.getGridBagConstraints());
        this.f_functionKeys = new SubFunctionKeys(this);
        this.add((Component)this.f_functionKeys, this.f_functionKeys.getGridBagConstraints());
        this.f_checkout = new SubCheckout(this);
        this.add((Component)this.f_checkout, this.f_checkout.getGridBagConstraints());
        this.f_queryProduct = new QueryProduct(this);
        this.add((Component)this.f_queryProduct, this.f_queryProduct.getGridBagConstraints());
        this.f_queryBPartner = new QueryBPartner(this);
        this.add((Component)this.f_queryBPartner, this.f_queryBPartner.getGridBagConstraints());
        this.f_queryTicket = new QueryTicket(this);
        this.add((Component)this.f_queryTicket, this.f_queryTicket.getGridBagConstraints());
        this.f_cashfunctions = new CashSubFunctions(this);
        this.add((Component)this.f_cashfunctions, this.f_cashfunctions.getGridBagConstraints());
        CPanel content = (CPanel)this.f_functionKeys.getComponent(0);
        content.getComponentCount();
        MPOSKeyLayout fKeys = MPOSKeyLayout.get(Env.getCtx(), this.p_pos.getC_POSKeyLayout_ID());
        MPOSKey[] m_keys = fKeys.getKeys(false);
        int i = 0;
        while (i < m_keys.length && i < 12) {
            CButton source = (CButton)content.getComponent(i);
            String myaction = "F" + (i + 1);
            source.getInputMap(2).put(KeyStroke.getKeyStroke(myaction), myaction);
            source.getActionMap().put(myaction, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CButton source = (CButton)e.getSource();
                    System.out.println("Activated: " + source.getText() + ":" + source.getActionCommand());
                    int C_POSKey_ID = Integer.parseInt(source.getActionCommand());
                    MPOSKey key = new MPOSKey(Env.getCtx(), C_POSKey_ID, null);
                    PosPanelWH.this.f_product.setM_Product_ID(key.getM_Product_ID());
                    PosPanelWH.this.f_product.setPrice();
                    PosPanelWH.this.f_curLine.setQty(key.getQty());
                    PosPanelWH.this.f_curLine.saveLine();
                    PosPanelWH.this.updateInfo();
                }
            });
            ++i;
        }
        this.newOrder();
        return true;
    }

    private boolean setMPOS() {
        MPOS[] poss = null;
        poss = this.getPOSs(0);
        if (poss.length == 0) {
            ADialog.error(this.getWindowNo(), this.getm_frame(), "NoPOSForUser");
            return false;
        }
        if (poss.length == 1) {
            this.p_pos = poss[0];
            return true;
        }
        Object[] SelectionPos = new Object[poss.length];
        int x = 0;
        while (x < poss.length) {
            SelectionPos[x] = poss[x].getDisplayName();
            ++x;
        }
        String msg = Msg.getMsg(Env.getCtx(), "SelectPOS");
        String title = Env.getHeader(Env.getCtx(), this.getWindowNo());
        Object selection = JOptionPane.showInputDialog(this.getm_frame(), msg, title, 3, null, SelectionPos, SelectionPos[0]);
        if (selection != null) {
            this.p_pos = poss[0].getPosbyDisplay((String)selection);
            return true;
        }
        return false;
    }

    private MPOS[] getPOSs(int SalesRep_ID) {
        ArrayList<MPOS> list = new ArrayList<MPOS>();
        String sql = "SELECT p.* FROM C_POS p Inner join C_DocType d on (p.c_doctype_id=d.c_doctype_id) WHERE p.SalesRep_ID=? and d.docsubtypeso='WP'";
        if (SalesRep_ID == 0) {
            sql = "SELECT p.* FROM C_POS p Inner join C_DocType d on (p.c_doctype_id=d.c_doctype_id) WHERE p.AD_Client_ID=? and d.docsubtypeso='WP'";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            if (SalesRep_ID != 0) {
                pstmt.setInt(1, this.getm_SalesRep_ID());
            } else {
                pstmt.setInt(1, Env.getAD_Client_ID(Env.getCtx()));
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MPOS(Env.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MPOS[] retValue = new MPOS[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    @Override
    public void newOrder() {
        this.log.info("PosPabel.newOrder");
        this.f_bpartner.setC_BPartner_ID(0);
        this.f_curLine.newOrder();
        this.f_curLine.newLine();
        this.f_product.f_name.requestFocus();
        this.updateInfo();
    }
}

