/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MPriceList;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MRole;
import org.compiere.model.X_RV_WarehousePrice;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MWarehousePrice
extends X_RV_WarehousePrice {
    private static final long serialVersionUID = -4902324773162437140L;
    private static CLogger s_log = CLogger.getCLogger(MWarehousePrice.class);

    public static MWarehousePrice[] find(Properties ctx, int M_PriceList_Version_ID, int M_Warehouse_ID, String Value, String Name, String UPC, String SKU, String trxName) {
        StringBuffer sql = new StringBuffer("SELECT * FROM RV_WarehousePrice WHERE M_PriceList_Version_ID=? AND M_Warehouse_ID=?");
        StringBuffer sb = new StringBuffer();
        if ((Value = MWarehousePrice.getFindParameter(Value)) != null) {
            sb.append("UPPER(Value) LIKE ?");
        }
        if ((Name = MWarehousePrice.getFindParameter(Name)) != null) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPPER(Name) LIKE ?");
        }
        if (UPC != null && UPC.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPC=?");
        }
        if (SKU != null && SKU.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("SKU=?");
        }
        if (sb.length() > 0) {
            sql.append(" AND (").append(sb).append(")");
        }
        sql.append(" ORDER BY Value");
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), "RV_WarehousePrice", false, false);
        s_log.fine("find - M_PriceList_Version_ID=" + M_PriceList_Version_ID + ", M_Warehouse_ID=" + M_Warehouse_ID + " - " + finalSQL);
        ArrayList<MWarehousePrice> list = new ArrayList<MWarehousePrice>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(finalSQL, trxName);
            int index = 1;
            pstmt.setInt(index++, M_PriceList_Version_ID);
            pstmt.setInt(index++, M_Warehouse_ID);
            if (Value != null) {
                pstmt.setString(index++, Value);
            }
            if (Name != null) {
                pstmt.setString(index++, Name);
            }
            if (UPC != null && UPC.length() > 0) {
                pstmt.setString(index++, UPC);
            }
            if (SKU != null && SKU.length() > 0) {
                pstmt.setString(index++, SKU);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MWarehousePrice(ctx, rs, trxName));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, finalSQL, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.fine("find - #" + list.size());
        MWarehousePrice[] retValue = new MWarehousePrice[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MWarehousePrice[] find(MBPartner bPartner, boolean IsSOTrx, Timestamp valid, int M_Warehouse_ID, String Value, String Name, String UPC, String SKU, String trxName) {
        int M_PriceList_ID = IsSOTrx ? bPartner.getM_PriceList_ID() : bPartner.getPO_PriceList_ID();
        MPriceList pl = null;
        pl = M_PriceList_ID == 0 ? MPriceList.getDefault(bPartner.getCtx(), IsSOTrx) : MPriceList.get(bPartner.getCtx(), M_PriceList_ID, trxName);
        if (pl == null) {
            s_log.severe("No PriceList found");
            return null;
        }
        MPriceListVersion plv = pl.getPriceListVersion(valid);
        if (plv == null) {
            s_log.severe("No PriceListVersion found for M_PriceList_ID=" + pl.getM_PriceList_ID());
            return null;
        }
        return MWarehousePrice.find(bPartner.getCtx(), plv.getM_PriceList_Version_ID(), M_Warehouse_ID, Value, Name, UPC, SKU, trxName);
    }

    public static MWarehousePrice get(MProduct product, int M_PriceList_Version_ID, int M_Warehouse_ID, String trxName) {
        MWarehousePrice retValue = null;
        String sql = "SELECT * FROM RV_WarehousePrice WHERE M_Product_ID=? AND M_PriceList_Version_ID=? AND M_Warehouse_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, product.getM_Product_ID());
            pstmt.setInt(2, M_PriceList_Version_ID);
            pstmt.setInt(3, M_Warehouse_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MWarehousePrice(product.getCtx(), rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public MWarehousePrice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean isAvailable() {
        return this.getQtyAvailable().signum() == 1;
    }

    public static MWarehousePrice[] findTax(Properties ctx, int M_PriceList_Version_ID, int M_Warehouse_ID, String Value, String Name, String UPC, String SKU, String trxName) {
        StringBuffer sql = new StringBuffer("SELECT * FROM RV_WarehousePrice WHERE M_PriceList_Version_ID=? AND M_Warehouse_ID=?");
        StringBuffer sb = new StringBuffer();
        if ((Value = MWarehousePrice.getFindParameter(Value)) != null) {
            sb.append("UPPER(Value) LIKE ?");
        }
        if ((Name = MWarehousePrice.getFindParameter(Name)) != null) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPPER(Name) LIKE ?");
        }
        if (UPC != null && UPC.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("UPC=?");
        }
        if (SKU != null && SKU.length() > 0) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append("SKU=?");
        }
        if (sb.length() > 0) {
            sql.append(" AND (").append(sb).append(")");
        }
        sql.append(" ORDER BY Value");
        String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), "RV_WarehousePrice", false, false);
        s_log.fine("find - M_PriceList_Version_ID=" + M_PriceList_Version_ID + ", M_Warehouse_ID=" + M_Warehouse_ID + " - " + finalSQL);
        ArrayList<MWarehousePrice> list = new ArrayList<MWarehousePrice>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(finalSQL, trxName);
            int index = 1;
            pstmt.setInt(index++, M_PriceList_Version_ID);
            pstmt.setInt(index++, M_Warehouse_ID);
            if (Value != null) {
                pstmt.setString(index++, Value);
            }
            if (Name != null) {
                pstmt.setString(index++, Name);
            }
            if (UPC != null && UPC.length() > 0) {
                pstmt.setString(index++, UPC);
            }
            if (SKU != null && SKU.length() > 0) {
                pstmt.setString(index++, SKU);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MWarehousePrice WarehousePrice = new MWarehousePrice(ctx, rs, trxName);
                WarehousePrice.setPriceList(WarehousePrice.getPriceList().multiply(new BigDecimal("1.19")));
                WarehousePrice.setPriceStd(WarehousePrice.getPriceStd().multiply(new BigDecimal("1.19")));
                list.add(WarehousePrice);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, finalSQL, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        s_log.fine("find - #" + list.size());
        MWarehousePrice[] retValue = new MWarehousePrice[list.size()];
        list.toArray(retValue);
        return retValue;
    }
}

