/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Color;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.sql.RowSet;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.compiere.model.MClient;
import org.compiere.model.MRole;
import org.compiere.model.MTreeNode;
import org.compiere.model.MTree_Base;
import org.compiere.print.MPrintColor;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MTree
extends MTree_Base {
    private static final long serialVersionUID = -6412057411585787707L;
    private boolean m_editable = false;
    private MTreeNode m_root = null;
    private ArrayList<MTreeNode> m_buffer = new ArrayList();
    private RowSet m_nodeRowSet;
    private boolean m_clientTree = true;
    private HashMap<Integer, ArrayList<Integer>> m_nodeIdMap;
    private static CLogger s_log = CLogger.getCLogger(MTree.class);

    public MTree(Properties ctx, int AD_Tree_ID, String trxName) {
        super(ctx, AD_Tree_ID, trxName);
    }

    public MTree(Properties ctx, int AD_Tree_ID, boolean editable, boolean clientTree, String trxName) {
        this(ctx, AD_Tree_ID, editable, clientTree, false, trxName);
    }

    public MTree(Properties ctx, int AD_Tree_ID, boolean editable, boolean clientTree, boolean allNodes, String trxName) {
        this(ctx, AD_Tree_ID, trxName);
        this.m_editable = editable;
        int AD_User_ID = allNodes ? -1 : Env.getContextAsInt(ctx, "AD_User_ID");
        this.m_clientTree = clientTree;
        this.log.info("AD_Tree_ID=" + AD_Tree_ID + ", AD_User_ID=" + AD_User_ID + ", Editable=" + editable + ", OnClient=" + clientTree);
        this.loadNodes(AD_User_ID);
    }

    public static int getDefaultAD_Tree_ID(int AD_Client_ID, String keyColumnName) {
        s_log.config(keyColumnName);
        if (keyColumnName == null || keyColumnName.length() == 0) {
            return 0;
        }
        String TreeType = null;
        if (keyColumnName.equals("AD_Menu_ID")) {
            TreeType = "MM";
        } else if (keyColumnName.equals("C_ElementValue_ID")) {
            TreeType = "EV";
        } else if (keyColumnName.equals("M_Product_ID")) {
            TreeType = "PR";
        } else if (keyColumnName.equals("C_BPartner_ID")) {
            TreeType = "BP";
        } else if (keyColumnName.equals("AD_Org_ID")) {
            TreeType = "OO";
        } else if (keyColumnName.equals("C_Project_ID")) {
            TreeType = "PJ";
        } else if (keyColumnName.equals("M_ProductCategory_ID")) {
            TreeType = "PC";
        } else if (keyColumnName.equals("M_BOM_ID")) {
            TreeType = "BB";
        } else if (keyColumnName.equals("C_SalesRegion_ID")) {
            TreeType = "SR";
        } else if (keyColumnName.equals("C_Campaign_ID")) {
            TreeType = "MC";
        } else if (keyColumnName.equals("C_Activity_ID")) {
            TreeType = "AY";
        } else if (keyColumnName.equals("CM_CStage_ID")) {
            TreeType = "CS";
        } else if (keyColumnName.equals("CM_Container_ID")) {
            TreeType = "CC";
        } else if (keyColumnName.equals("CM_Media_ID")) {
            TreeType = "CM";
        } else if (keyColumnName.equals("CM_Template_ID")) {
            TreeType = "CT";
        } else {
            s_log.log(Level.SEVERE, "Could not map " + keyColumnName);
            return 0;
        }
        int AD_Tree_ID = 0;
        String sql = "SELECT AD_Tree_ID, Name FROM AD_Tree WHERE AD_Client_ID=? AND TreeType=? AND IsActive='Y' AND IsAllNodes='Y' ORDER BY IsDefault DESC, AD_Tree_ID";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Client_ID);
            pstmt.setString(2, TreeType);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                AD_Tree_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        return AD_Tree_ID;
    }

    private void loadNodes(int AD_User_ID) {
        StringBuffer sql = new StringBuffer("SELECT tn.Node_ID,tn.Parent_ID,tn.SeqNo,tb.IsActive FROM ").append(this.getNodeTableName()).append(" tn LEFT OUTER JOIN AD_TreeBar tb ON (tn.AD_Tree_ID=tb.AD_Tree_ID AND tn.Node_ID=tb.Node_ID " + (AD_User_ID != -1 ? " AND tb.AD_User_ID=? " : "") + ") " + "WHERE tn.AD_Tree_ID=?");
        if (!this.m_editable) {
            sql.append(" AND tn.IsActive='Y'");
        }
        sql.append(" ORDER BY COALESCE(tn.Parent_ID, -1), tn.SeqNo");
        this.log.finest(sql.toString());
        try {
            this.getNodeDetails();
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
            int idx = 1;
            if (AD_User_ID != -1) {
                pstmt.setInt(idx++, AD_User_ID);
            }
            pstmt.setInt(idx++, this.getAD_Tree_ID());
            ResultSet rs = pstmt.executeQuery();
            this.m_root = new MTreeNode(0, 0, this.getName(), this.getDescription(), 0, true, null, false, null);
            while (rs.next()) {
                boolean onBar;
                int node_ID = rs.getInt(1);
                int parent_ID = rs.getInt(2);
                int seqNo = rs.getInt(3);
                boolean bl = onBar = rs.getString(4) != null;
                if (node_ID == 0 && parent_ID == 0) continue;
                this.addToTree(node_ID, parent_ID, seqNo, onBar);
            }
            rs.close();
            pstmt.close();
            this.m_nodeRowSet = null;
            this.m_nodeIdMap = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
            this.m_nodeRowSet = null;
            this.m_nodeIdMap = null;
        }
        if (this.m_buffer.size() != 0) {
            this.log.finest("clearing buffer - Adding to: " + this.m_root);
            for (int i2 = 0; i2 < this.m_buffer.size(); ++i2) {
                MTreeNode node = this.m_buffer.get(i2);
                MTreeNode parent = this.m_root.findNode(node.getParent_ID());
                if (parent == null || !parent.getAllowsChildren()) continue;
                parent.add(node);
                int sizeBeforeCheckBuffer = this.m_buffer.size();
                this.checkBuffer(node);
                if (sizeBeforeCheckBuffer == this.m_buffer.size()) {
                    this.m_buffer.remove(i2);
                }
                i2 = -1;
            }
        }
        if (this.m_buffer.size() != 0) {
            this.log.severe("Nodes w/o parent - adding to root - " + this.m_buffer);
            for (int i3 = 0; i3 < this.m_buffer.size(); ++i3) {
                MTreeNode node = this.m_buffer.get(i3);
                this.m_root.add(node);
                int sizeBeforeCheckBuffer = this.m_buffer.size();
                this.checkBuffer(node);
                if (sizeBeforeCheckBuffer == this.m_buffer.size()) {
                    this.m_buffer.remove(i3);
                }
                i3 = -1;
            }
            if (this.m_buffer.size() != 0) {
                this.log.severe("Still nodes in Buffer - " + this.m_buffer);
            }
        }
        if (!this.m_editable && this.m_root.getChildCount() > 0) {
            this.trimTree();
        }
        if (CLogMgt.isLevelFinest() || this.m_root.getChildCount() == 0) {
            this.log.fine("ChildCount=" + this.m_root.getChildCount());
        }
    }

    private void addToTree(int node_ID, int parent_ID, int seqNo, boolean onBar) {
        MTreeNode child = this.getNodeDetail(node_ID, parent_ID, seqNo, onBar);
        if (child == null) {
            return;
        }
        DefaultMutableTreeNode parent = null;
        if (this.m_root != null) {
            parent = this.m_root.findNode(parent_ID);
        }
        if (parent != null && parent.getAllowsChildren()) {
            parent.add(child);
            if (this.m_buffer.size() > 0) {
                this.checkBuffer(child);
            }
        } else {
            this.m_buffer.add(child);
        }
    }

    private void checkBuffer(MTreeNode newNode) {
        if (!newNode.isSummary() || !newNode.getAllowsChildren()) {
            return;
        }
        for (int i2 = 0; i2 < this.m_buffer.size(); ++i2) {
            MTreeNode node = this.m_buffer.get(i2);
            if (node.getParent_ID() != newNode.getNode_ID()) continue;
            try {
                newNode.add(node);
            }
            catch (Exception e) {
                this.log.severe("Adding " + node.getName() + " to " + newNode.getName() + ": " + e.getMessage());
            }
            this.m_buffer.remove(i2);
            --i2;
        }
    }

    private void getNodeDetails() {
        StringBuffer sqlNode = new StringBuffer();
        String sourceTable = "t";
        String fromClause = this.getSourceTableName(false);
        String columnNameX = this.getSourceTableName(true);
        String color = this.getActionColorName();
        if (this.getTreeType().equals("MM")) {
            boolean hasWhere;
            boolean base = Env.isBaseLanguage(this.p_ctx, "AD_Menu");
            sourceTable = "m";
            if (base) {
                sqlNode.append("SELECT m.AD_Menu_ID, m.Name,m.Description,m.IsSummary,m.Action, m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_Workbench_ID FROM AD_Menu m");
            } else {
                sqlNode.append("SELECT m.AD_Menu_ID,  t.Name,t.Description,m.IsSummary,m.Action, m.AD_Window_ID, m.AD_Process_ID, m.AD_Form_ID, m.AD_Workflow_ID, m.AD_Task_ID, m.AD_Workbench_ID FROM AD_Menu m, AD_Menu_Trl t");
            }
            if (!base) {
                sqlNode.append(" WHERE m.AD_Menu_ID=t.AD_Menu_ID AND t.AD_Language='").append(Env.getAD_Language(this.p_ctx)).append("'");
            }
            if (!this.m_editable) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ").append("m.IsActive='Y' ");
            }
            if (!MClient.get(this.getCtx()).isUseBetaFunctions()) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ");
                sqlNode.append("(m.AD_Window_ID IS NULL OR EXISTS (SELECT * FROM AD_Window w WHERE m.AD_Window_ID=w.AD_Window_ID AND w.IsBetaFunctionality='N'))").append(" AND (m.AD_Process_ID IS NULL OR EXISTS (SELECT * FROM AD_Process p WHERE m.AD_Process_ID=p.AD_Process_ID AND p.IsBetaFunctionality='N'))").append(" AND (m.AD_Workflow_ID IS NULL OR EXISTS (SELECT * FROM AD_Workflow wf WHERE m.AD_Workflow_ID=wf.AD_Workflow_ID AND wf.IsBetaFunctionality='N'))").append(" AND (m.AD_Form_ID IS NULL OR EXISTS (SELECT * FROM AD_Form f WHERE m.AD_Form_ID=f.AD_Form_ID AND f.IsBetaFunctionality='N'))");
            }
            if (!this.m_editable) {
                hasWhere = sqlNode.indexOf(" WHERE ") != -1;
                sqlNode.append(hasWhere ? " AND " : " WHERE ");
                sqlNode.append("(m.AD_Form_ID IS NULL OR EXISTS (SELECT * FROM AD_Form f WHERE m.AD_Form_ID=f.AD_Form_ID AND ");
                if (this.m_clientTree) {
                    sqlNode.append("f.Classname");
                } else {
                    sqlNode.append("f.JSPURL");
                }
                sqlNode.append(" IS NOT NULL))");
            }
        } else {
            if (columnNameX == null) {
                throw new IllegalArgumentException("Unknown TreeType=" + this.getTreeType());
            }
            sqlNode.append("SELECT t.").append(columnNameX).append("_ID,t.Name,t.Description,t.IsSummary,").append(color).append(" FROM ").append(fromClause);
            if (!this.m_editable) {
                sqlNode.append(" WHERE t.IsActive='Y'");
            }
        }
        String sql = sqlNode.toString();
        if (!this.m_editable) {
            sql = MRole.getDefault(this.getCtx(), false).addAccessSQL(sql, sourceTable, true, this.m_editable);
        }
        this.log.fine(sql);
        this.m_nodeRowSet = DB.getRowSet(sql);
        this.m_nodeIdMap = new HashMap(50);
        try {
            this.m_nodeRowSet.beforeFirst();
            int i2 = 0;
            while (this.m_nodeRowSet.next()) {
                ++i2;
                int node = this.m_nodeRowSet.getInt(1);
                Integer nodeId = node;
                ArrayList<Integer> list = this.m_nodeIdMap.get(nodeId);
                if (list == null) {
                    list = new ArrayList(5);
                    this.m_nodeIdMap.put(nodeId, list);
                }
                list.add(i2);
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
        }
    }

    private MTreeNode getNodeDetail(int node_ID, int parent_ID, int seqNo, boolean onBar) {
        MTreeNode retValue = null;
        try {
            ArrayList<Integer> nodeList = this.m_nodeIdMap.get(node_ID);
            int size = nodeList != null ? nodeList.size() : 0;
            int i2 = 0;
            while (i2 < size) {
                MPrintColor printColor;
                Integer nodeId = nodeList.get(i2);
                ++i2;
                this.m_nodeRowSet.absolute(nodeId);
                int node = this.m_nodeRowSet.getInt(1);
                if (node_ID != node) continue;
                int index = 2;
                String name = this.m_nodeRowSet.getString(index++);
                String description = this.m_nodeRowSet.getString(index++);
                boolean isSummary = "Y".equals(this.m_nodeRowSet.getString(index++));
                String actionColor = this.m_nodeRowSet.getString(index++);
                if (this.getTreeType().equals("MM") && !isSummary) {
                    int AD_Window_ID = this.m_nodeRowSet.getInt(index++);
                    int AD_Process_ID = this.m_nodeRowSet.getInt(index++);
                    int AD_Form_ID = this.m_nodeRowSet.getInt(index++);
                    int AD_Workflow_ID = this.m_nodeRowSet.getInt(index++);
                    int AD_Task_ID = this.m_nodeRowSet.getInt(index++);
                    int AD_Workbench_ID = this.m_nodeRowSet.getInt(index++);
                    MRole role = MRole.getDefault(this.getCtx(), false);
                    Boolean access = null;
                    if ("W".equals(actionColor)) {
                        access = role.getWindowAccess(AD_Window_ID);
                    } else if ("P".equals(actionColor) || "R".equals(actionColor)) {
                        access = role.getProcessAccess(AD_Process_ID);
                    } else if ("X".equals(actionColor)) {
                        access = role.getFormAccess(AD_Form_ID);
                    } else if ("F".equals(actionColor)) {
                        access = role.getWorkflowAccess(AD_Workflow_ID);
                    } else if ("T".equals(actionColor)) {
                        access = role.getTaskAccess(AD_Task_ID);
                    }
                    if (access == null && !this.m_editable) continue;
                    retValue = new MTreeNode(node_ID, seqNo, name, description, parent_ID, isSummary, actionColor, onBar, null);
                    continue;
                }
                Color color = null;
                if (actionColor != null && !this.getTreeType().equals("MM") && (printColor = MPrintColor.get(this.getCtx(), actionColor)) != null) {
                    color = printColor.getColor();
                }
                retValue = new MTreeNode(node_ID, seqNo, name, description, parent_ID, isSummary, null, onBar, color);
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "", e);
        }
        return retValue;
    }

    public void trimTree() {
        boolean needsTrim;
        boolean bl = needsTrim = this.m_root != null;
        while (needsTrim) {
            needsTrim = false;
            Enumeration<TreeNode> en = this.m_root.preorderEnumeration();
            while (this.m_root.getChildCount() > 0 && en.hasMoreElements()) {
                MTreeNode nd = (MTreeNode)en.nextElement();
                if (!nd.isSummary() || nd.getChildCount() != 0) continue;
                nd.removeFromParent();
                needsTrim = true;
            }
        }
    }

    private void dumpTree() {
        Enumeration<TreeNode> en = this.m_root.preorderEnumeration();
        int count = 0;
        while (en.hasMoreElements()) {
            StringBuffer sb = new StringBuffer();
            MTreeNode nd = (MTreeNode)en.nextElement();
            for (int i2 = 0; i2 < nd.getLevel(); ++i2) {
                sb.append(" ");
            }
            sb.append("ID=").append(nd.getNode_ID()).append(", SeqNo=").append(nd.getSeqNo()).append(" ").append(nd.getName());
            System.out.println(sb.toString());
            ++count;
        }
        System.out.println("Count=" + count);
    }

    public MTreeNode getRoot() {
        return this.m_root;
    }

    public boolean isMenu() {
        return "MM".equals(this.getTreeType());
    }

    public boolean isProduct() {
        return "PR".equals(this.getTreeType());
    }

    public boolean isBPartner() {
        return "BP".equals(this.getTreeType());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTree[");
        sb.append("AD_Tree_ID=").append(this.getAD_Tree_ID()).append(", Name=").append(this.getName());
        sb.append("]");
        return sb.toString();
    }
}

