/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.GenericPO;
import org.compiere.model.MColumn;
import org.compiere.model.MEntityType;
import org.compiere.model.MSequence;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Table;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MTable
extends X_AD_Table {
    private static final long serialVersionUID = -2367316254623142732L;
    private static CCache<Integer, MTable> s_cache = new CCache("AD_Table", 20);
    private static CCache<String, Class<?>> s_classCache = new CCache("PO_Class", 20);
    private static CLogger s_log = CLogger.getCLogger(MTable.class);
    private static final String[] s_packages = new String[]{"org.compiere.model", "org.compiere.wf", "org.compiere.print", "org.compiere.impexp", "compiere.model", "adempiere.model", "org.adempiere.model"};
    private static final String[] s_special = new String[]{"AD_Element", "org.compiere.model.M_Element", "AD_Registration", "org.compiere.model.M_Registration", "AD_Tree", "org.compiere.model.MTree_Base", "R_Category", "org.compiere.model.MRequestCategory", "GL_Category", "org.compiere.model.MGLCategory", "K_Category", "org.compiere.model.MKCategory", "C_ValidCombination", "org.compiere.model.MAccount", "C_Phase", "org.compiere.model.MProjectTypePhase", "C_Task", "org.compiere.model.MProjectTypeTask"};
    private MColumn[] m_columns = null;

    public static MTable get(Properties ctx, int AD_Table_ID) {
        Integer key = new Integer(AD_Table_ID);
        MTable retValue = s_cache.get(key);
        if (retValue != null && retValue.getCtx() == ctx) {
            return retValue;
        }
        retValue = new MTable(ctx, AD_Table_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static MTable get(Properties ctx, String tableName) {
        MTable retValue2;
        if (tableName == null) {
            return null;
        }
        for (MTable retValue2 : s_cache.values()) {
            if (!tableName.equalsIgnoreCase(retValue2.getTableName()) || retValue2.getCtx() != ctx) continue;
            return retValue2;
        }
        retValue2 = null;
        String sql = "SELECT * FROM AD_Table WHERE UPPER(TableName)=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, tableName.toUpperCase());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue2 = new MTable(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (retValue2 != null) {
            Integer key = new Integer(retValue2.getAD_Table_ID());
            s_cache.put(key, retValue2);
        }
        return retValue2;
    }

    public static String getTableName(Properties ctx, int AD_Table_ID) {
        return MTable.get(ctx, AD_Table_ID).getTableName();
    }

    public static Class<?> getClass(String tableName) {
        String className;
        int index;
        MEntityType et;
        String etmodelpackage;
        if (tableName == null || tableName.endsWith("_Trl")) {
            return null;
        }
        Class<?> cache = s_classCache.get(tableName);
        if (cache != null) {
            if (cache.equals(Object.class)) {
                return null;
            }
            return cache;
        }
        MTable table2 = MTable.get(Env.getCtx(), tableName);
        String entityType = table2.getEntityType();
        if (tableName.startsWith("I_")) {
            Class<?> clazz;
            MEntityType et2 = MEntityType.get(Env.getCtx(), entityType);
            String etmodelpackage2 = et2.getModelPackage();
            if (etmodelpackage2 == null || "D".equals(entityType)) {
                etmodelpackage2 = "org.compiere.model";
            }
            if ((clazz = MTable.getPOclass(etmodelpackage2 + ".X_" + tableName)) != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            s_log.warning("No class for table: " + tableName);
            return null;
        }
        for (int i2 = 0; i2 < s_special.length; ++i2) {
            if (!s_special[i2++].equals(tableName)) continue;
            Class<?> clazz = MTable.getPOclass(s_special[i2]);
            if (clazz == null) break;
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        if (!"D".equals(entityType) && (etmodelpackage = (et = MEntityType.get(Env.getCtx(), entityType)).getModelPackage()) != null) {
            Class<?> clazz = null;
            clazz = MTable.getPOclass(etmodelpackage + ".M" + Util.replace(tableName, "_", ""));
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            clazz = MTable.getPOclass(etmodelpackage + ".X_" + tableName);
            if (clazz != null) {
                s_classCache.put(tableName, clazz);
                return clazz;
            }
            s_log.warning("No class for table with it entity: " + tableName);
        }
        if ((index = (className = tableName).indexOf(95)) > 0 && index < 3) {
            className = className.substring(index + 1);
        }
        className = Util.replace(className, "_", "");
        for (int i3 = 0; i3 < s_packages.length; ++i3) {
            StringBuffer name = new StringBuffer(s_packages[i3]).append(".M").append(className);
            Class<?> clazz = MTable.getPOclass(name.toString());
            if (clazz == null) continue;
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        Class<?> clazz = MTable.getPOclass("adempiere.model.X_" + tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        clazz = MTable.getPOclass("compiere.model.X_" + tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        clazz = MTable.getPOclass("org.compiere.model.X_" + tableName);
        if (clazz != null) {
            s_classCache.put(tableName, clazz);
            return clazz;
        }
        s_classCache.put(tableName, Object.class);
        return null;
    }

    private static Class<?> getPOclass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            for (Class<?> superClazz = clazz.getSuperclass(); superClazz != null; superClazz = superClazz.getSuperclass()) {
                if (superClazz != PO.class) continue;
                s_log.fine("Use: " + className);
                return clazz;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        s_log.finest("Not found: " + className);
        return null;
    }

    public MTable(Properties ctx, int AD_Table_ID, String trxName) {
        super(ctx, AD_Table_ID, trxName);
        if (AD_Table_ID == 0) {
            this.setAccessLevel("4");
            this.setEntityType("U");
            this.setIsChangeLog(false);
            this.setIsDeleteable(false);
            this.setIsHighVolume(false);
            this.setIsSecurityEnabled(false);
            this.setIsView(false);
            this.setReplicationType("L");
        }
    }

    public MTable(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn[] getColumns(boolean requery) {
        if (this.m_columns != null && !requery) {
            return this.m_columns;
        }
        String sql = "SELECT * FROM AD_Column WHERE AD_Table_ID=? ORDER BY ColumnName";
        ArrayList<MColumn> list = new ArrayList<MColumn>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getAD_Table_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MColumn(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_columns = new MColumn[list.size()];
        list.toArray(this.m_columns);
        return this.m_columns;
    }

    public MColumn getColumn(String columnName) {
        if (columnName == null || columnName.length() == 0) {
            return null;
        }
        this.getColumns(false);
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            if (!columnName.equalsIgnoreCase(this.m_columns[i2].getColumnName())) continue;
            return this.m_columns[i2];
        }
        return null;
    }

    public boolean isSingleKey() {
        String[] keys = this.getKeyColumns();
        return keys.length == 1;
    }

    public String[] getKeyColumns() {
        this.getColumns(false);
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            MColumn column = this.m_columns[i2];
            if (column.isKey()) {
                return new String[]{column.getColumnName()};
            }
            if (!column.isParent()) continue;
            list.add(column.getColumnName());
        }
        String[] retValue = new String[list.size()];
        retValue = list.toArray(retValue);
        return retValue;
    }

    public PO getPO(int Record_ID, String trxName) {
        String tableName = this.getTableName();
        if (Record_ID != 0 && !this.isSingleKey()) {
            this.log.log(Level.WARNING, "(id) - Multi-Key " + tableName);
            return null;
        }
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.INFO, "Using GenericPO for " + tableName);
            GenericPO po = new GenericPO(tableName, this.getCtx(), (int)new Integer(Record_ID), trxName);
            return po;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getDeclaredConstructor(Properties.class, Integer.TYPE, String.class);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                if (msg == null) {
                    msg = e.toString();
                }
                this.log.warning("No transaction Constructor for " + clazz + " (" + msg + ")");
            }
            PO po = (PO)constructor.newInstance(this.getCtx(), new Integer(Record_ID), trxName);
            if (po != null && po.get_ID() != Record_ID && Record_ID > 0) {
                return null;
            }
            return po;
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, t);
                errorLogged = true;
                if (t instanceof Exception) {
                    this.log.saveError("Error", (Exception)e.getCause());
                } else {
                    this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
                }
            } else {
                this.log.log(Level.SEVERE, "(id) - Table=" + tableName + ",Class=" + clazz, e);
                errorLogged = true;
                this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            }
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(id) - Not found - Table=" + tableName + ", Record_ID=" + Record_ID);
            }
            return null;
        }
    }

    public PO getPO(ResultSet rs, String trxName) {
        String tableName = this.getTableName();
        Class<?> clazz = MTable.getClass(tableName);
        if (clazz == null) {
            this.log.log(Level.INFO, "Using GenericPO for " + tableName);
            GenericPO po = new GenericPO(tableName, this.getCtx(), rs, trxName);
            return po;
        }
        boolean errorLogged = false;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(Properties.class, ResultSet.class, String.class);
            PO po = (PO)constructor.newInstance(this.getCtx(), rs, trxName);
            return po;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "(rs) - Table=" + tableName + ",Class=" + clazz, e);
            errorLogged = true;
            this.log.saveError("Error", "Table=" + tableName + ",Class=" + clazz);
            if (!errorLogged) {
                this.log.log(Level.SEVERE, "(rs) - Not found - Table=" + tableName);
            }
            return null;
        }
    }

    public PO getPO(String whereClause, String trxName) {
        return this.getPO(whereClause, null, trxName);
    }

    public PO getPO(String whereClause, Object[] params, String trxName) {
        if (whereClause == null || whereClause.length() == 0) {
            return null;
        }
        PO po = null;
        POInfo info = POInfo.getPOInfo(this.getCtx(), this.getAD_Table_ID(), trxName);
        if (info == null) {
            return null;
        }
        StringBuffer sqlBuffer = info.buildSelect();
        sqlBuffer.append(" WHERE ").append(whereClause);
        String sql = sqlBuffer.toString();
        CPreparedStatement pstmt = null;
        try {
            ResultSet rs;
            pstmt = DB.prepareStatement(sql, trxName);
            if (params != null && params.length > 0) {
                for (int i2 = 0; i2 < params.length; ++i2) {
                    pstmt.setObject(i2 + 1, params[i2]);
                }
            }
            if ((rs = pstmt.executeQuery()).next()) {
                po = this.getPO(rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
            this.log.saveError("Error", e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return po;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.isView() && this.isDeleteable()) {
            this.setIsDeleteable(false);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (seq == null || seq.get_ID() == 0) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            }
        } else {
            MSequence seq = MSequence.get(this.getCtx(), this.getTableName(), this.get_TrxName());
            if (seq == null || seq.get_ID() == 0) {
                MSequence.createTableSequence(this.getCtx(), this.getTableName(), this.get_TrxName());
            } else if (!seq.getName().equals(this.getTableName())) {
                seq.setName(this.getTableName());
                seq.save();
            }
        }
        return success;
    }

    public String getSQLCreate() {
        StringBuffer sb = new StringBuffer("CREATE TABLE ").append(this.getTableName()).append(" (");
        boolean hasPK = false;
        boolean hasParents = false;
        StringBuffer constraints = new StringBuffer();
        this.getColumns(true);
        for (int i2 = 0; i2 < this.m_columns.length; ++i2) {
            String constraint;
            MColumn column = this.m_columns[i2];
            String colSQL = column.getSQLDDL();
            if (colSQL == null) continue;
            if (i2 > 0) {
                sb.append(", ");
            }
            sb.append(column.getSQLDDL());
            if (column.isKey()) {
                hasPK = true;
            }
            if (column.isParent()) {
                hasParents = true;
            }
            if ((constraint = column.getConstraint(this.getTableName())) == null || constraint.length() <= 0) continue;
            constraints.append(", ").append(constraint);
        }
        if (!hasPK && hasParents) {
            StringBuffer cols = new StringBuffer();
            for (int i3 = 0; i3 < this.m_columns.length; ++i3) {
                MColumn column = this.m_columns[i3];
                if (!column.isParent()) continue;
                if (cols.length() > 0) {
                    cols.append(", ");
                }
                cols.append(column.getColumnName());
            }
            sb.append(", CONSTRAINT ").append(this.getTableName()).append("_Key PRIMARY KEY (").append(cols).append(")");
        }
        sb.append(constraints).append(")");
        return sb.toString();
    }

    public static int getTable_ID(String tableName) {
        int retValue = 0;
        String SQL = "SELECT AD_Table_ID FROM AD_Table WHERE tablename = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setString(1, tableName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, SQL, e);
            retValue = -1;
        }
        return retValue;
    }

    public Query createQuery(String whereClause, String trxName) {
        return new Query(this.getCtx(), this, whereClause, trxName);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MTable[");
        sb.append(this.get_ID()).append("-").append(this.getTableName()).append("]");
        return sb.toString();
    }
}

