/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.Adempiere;
import org.compiere.model.MChangeLog;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_Session;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.TimeUtil;

public class MSession
extends X_AD_Session {
    private static final long serialVersionUID = 480745219310430126L;
    private static CCache<Integer, MSession> s_sessions = Ini.isClient() ? new CCache("AD_Session_ID", 1, 0) : new CCache("AD_Session_ID", 30, 0);
    private boolean m_webStoreSession = false;

    public static MSession get(Properties ctx, boolean createNew) {
        int AD_Session_ID = Env.getContextAsInt(ctx, "#AD_Session_ID");
        MSession session = null;
        if (AD_Session_ID > 0) {
            session = s_sessions.get(new Integer(AD_Session_ID));
        }
        if (session == null && AD_Session_ID > 0) {
            session = new MSession(ctx, AD_Session_ID, null);
            if (session.get_ID() != AD_Session_ID) {
                Env.setContext(ctx, "#AD_Session_ID", AD_Session_ID);
            }
            s_sessions.put(AD_Session_ID, session);
        }
        if (session == null && createNew) {
            session = new MSession(ctx, null);
            session.save();
            AD_Session_ID = session.getAD_Session_ID();
            Env.setContext(ctx, "#AD_Session_ID", AD_Session_ID);
            s_sessions.put(new Integer(AD_Session_ID), session);
        }
        return session;
    }

    public static MSession get(Properties ctx, String Remote_Addr, String Remote_Host, String WebSession) {
        int AD_Session_ID = Env.getContextAsInt(ctx, "#AD_Session_ID");
        MSession session = null;
        if (AD_Session_ID > 0) {
            session = s_sessions.get(new Integer(AD_Session_ID));
        }
        if (session == null) {
            session = new MSession(ctx, Remote_Addr, Remote_Host, WebSession, null);
            session.save();
            AD_Session_ID = session.getAD_Session_ID();
            Env.setContext(ctx, "#AD_Session_ID", AD_Session_ID);
            s_sessions.put(new Integer(AD_Session_ID), session);
        }
        return session;
    }

    public MSession(Properties ctx, int AD_Session_ID, String trxName) {
        super(ctx, AD_Session_ID, trxName);
        if (AD_Session_ID == 0) {
            this.setProcessed(false);
        }
    }

    public MSession(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSession(Properties ctx, String Remote_Addr, String Remote_Host, String WebSession, String trxName) {
        this(ctx, 0, trxName);
        if (Remote_Addr != null) {
            this.setRemote_Addr(Remote_Addr);
        }
        if (Remote_Host != null) {
            this.setRemote_Host(Remote_Host);
        }
        if (WebSession != null) {
            this.setWebSession(WebSession);
        }
        this.setDescription(Adempiere.MAIN_VERSION + "_" + Adempiere.DATE_VERSION + " " + Adempiere.getImplementationVersion());
        this.setAD_Role_ID(Env.getContextAsInt(ctx, "#AD_Role_ID"));
        this.setLoginDate(Env.getContextAsDate(ctx, "#Date"));
    }

    public MSession(Properties ctx, String trxName) {
        this(ctx, 0, trxName);
        try {
            InetAddress lh = InetAddress.getLocalHost();
            this.setRemote_Addr(lh.getHostAddress());
            this.setRemote_Host(lh.getHostName());
            this.setDescription(Adempiere.MAIN_VERSION + "_" + Adempiere.DATE_VERSION + " " + Adempiere.getImplementationVersion());
            this.setAD_Role_ID(Env.getContextAsInt(ctx, "#AD_Role_ID"));
            this.setLoginDate(Env.getContextAsDate(ctx, "#Date"));
        }
        catch (UnknownHostException e) {
            this.log.log(Level.SEVERE, "No Local Host", e);
        }
    }

    public boolean isWebStoreSession() {
        return this.m_webStoreSession;
    }

    public void setWebStoreSession(boolean webStoreSession) {
        this.m_webStoreSession = webStoreSession;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MSession[").append(this.getAD_Session_ID()).append(",AD_User_ID=").append(this.getCreatedBy()).append(",").append(this.getCreated()).append(",Remote=").append(this.getRemote_Addr());
        String s = this.getRemote_Host();
        if (s != null && s.length() > 0) {
            sb.append(",").append(s);
        }
        if (this.m_webStoreSession) {
            sb.append(",WebStoreSession");
        }
        sb.append("]");
        return sb.toString();
    }

    public void logout() {
        this.setProcessed(true);
        this.save();
        s_sessions.remove(new Integer(this.getAD_Session_ID()));
        this.log.info(TimeUtil.formatElapsed(this.getCreated(), this.getUpdated()));
    }

    public MChangeLog changeLog(String TrxName, int AD_ChangeLog_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue) {
        return this.changeLog(TrxName, AD_ChangeLog_ID, AD_Table_ID, AD_Column_ID, Record_ID, AD_Client_ID, AD_Org_ID, OldValue, NewValue, null);
    }

    public MChangeLog changeLog(String TrxName, int AD_ChangeLog_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue, String event) {
        if (OldValue == null && NewValue == null) {
            return null;
        }
        if (OldValue != null && NewValue != null && OldValue.equals(NewValue)) {
            return null;
        }
        MRole role = MRole.getDefault(this.getCtx(), false);
        if (!(this.m_webStoreSession || MChangeLog.isLogged(AD_Table_ID) || role != null && role.isChangeLog())) {
            return null;
        }
        this.log.finest("AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID + ": " + OldValue + " -> " + NewValue);
        try {
            MChangeLog cl = new MChangeLog(this.getCtx(), AD_ChangeLog_ID, TrxName, this.getAD_Session_ID(), AD_Table_ID, AD_Column_ID, Record_ID, AD_Client_ID, AD_Org_ID, OldValue, NewValue, event);
            if (cl.save()) {
                return cl;
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID, e);
            return null;
        }
        this.log.log(Level.SEVERE, "AD_ChangeLog_ID=" + AD_ChangeLog_ID + ", AD_Session_ID=" + this.getAD_Session_ID() + ", AD_Table_ID=" + AD_Table_ID + ", AD_Column_ID=" + AD_Column_ID);
        return null;
    }
}

