/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MPaymentRequest;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MPaymentRequestLine
extends X_C_PaymentRequestLine {
    public MPaymentRequestLine(Properties ctx, int C_InvoiceLine_ID, String trxName) {
        super(ctx, C_InvoiceLine_ID, trxName);
        if (C_InvoiceLine_ID == 0) {
            this.setAmt(Env.ZERO);
        }
    }

    public MPaymentRequestLine(MPaymentRequest paymentRequest) {
        this(paymentRequest.getCtx(), 0, paymentRequest.get_TrxName());
        if (paymentRequest.get_ID() == 0) {
            throw new IllegalArgumentException("Header not saved");
        }
        this.setClientOrg(paymentRequest.getAD_Client_ID(), paymentRequest.getAD_Org_ID());
        this.setC_PaymentRequest_ID(paymentRequest.getC_PaymentRequest_ID());
    }

    public MPaymentRequestLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPaymentRequestLine[").append(this.get_ID()).append(",").append(",Amt=").append(this.getAmt()).append(",C_Invoice_ID=").append(this.getC_Invoice_ID()).append(",GL_JournalLine_ID=").append(this.getGL_JournalLine_ID()).append(",C_InvoicePaySchedule_ID=").append(this.getC_InvoicePaySchedule_ID()).append("]");
        return sb.toString();
    }

    public String getDescriptionText() {
        return super.getDescription();
    }

    @Override
    public BigDecimal getAmt() {
        return super.getAmt();
    }

    @Override
    public int getC_Invoice_ID() {
        return super.getC_Invoice_ID();
    }

    @Override
    public int getGL_JournalLine_ID() {
        return super.getGL_JournalLine_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        BigDecimal total = DB.getSQLValueBD(this.get_TrxName(), "select sum(amt) from C_PaymentRequestLine where isactive='Y' and C_PaymentRequest_ID=" + this.getC_PaymentRequest_ID(), new Object[0]);
        X_C_PaymentRequest hr = new X_C_PaymentRequest(this.getCtx(), this.getC_PaymentRequest_ID(), this.get_TrxName());
        hr.setPayAmt(total == null ? Env.ZERO : total);
        hr.save();
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        return true;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        return true;
    }
}

