/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MJournalLine;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MPayment;
import org.compiere.model.MProject;
import org.compiere.model.MRefList;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_C_PaymentRequest;
import org.compiere.model.X_C_PaymentRequestLine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class MPaymentRequest
extends X_C_PaymentRequest
implements DocAction {
    private String m_errorMessage = null;
    public static String REVERSE_INDICATOR = "^";
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MPaymentRequest[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        String whereClause = "C_BPartner_ID=?";
        List<MPaymentRequest> list = new Query(ctx, "C_Payment", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).list();
        MPaymentRequest[] retValue = new MPaymentRequest[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MPaymentRequest(Properties ctx, int C_Payment_ID, String trxName) {
        super(ctx, C_Payment_ID, trxName);
        if (C_Payment_ID == 0) {
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setProcessed(false);
            this.setProcessing(false);
            this.setPayAmt(Env.ZERO);
            this.setDateTrx(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(this.getDateTrx());
            this.setTenderType("K");
        }
    }

    public MPaymentRequest(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setErrorMessage(String errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }

    @Override
    public void setPayAmt(BigDecimal PayAmt) {
        super.setPayAmt(PayAmt == null ? Env.ZERO : PayAmt);
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPaySelectionCheck.deleteGeneratedDraft(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName())) {
            this.m_processMsg = "Could not delete draft generated payment selection lines";
            return "IN";
        }
        if (this.getPayAmt().signum() == 0) {
            this.m_processMsg = "PayAmt=0";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (this.getLines().length == 0 && !this.getRequestType().equals("R")) {
            return "No Lines";
        }
        if (this.getC_BankAccount_ID() <= 0) {
            return "No Account Bank";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.generatePayment();
        X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = this.getLines();
        int n = x_C_PaymentRequestLineArray.length;
        int n2 = 0;
        while (n2 < n) {
            X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n2];
            line.setProcessed(true);
            line.save();
            ++n2;
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        MPayment pay = new MPayment(Env.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if (pay.getDocStatus().equals("CO") || pay.getDocStatus().equals("IP")) {
            this.m_processMsg = "Payment Processed ID:" + pay.get_ID();
            this.setDocAction("--");
            return false;
        }
        pay.deleteEx(true, this.get_TrxName());
        this.setC_Payment_ID(0);
        this.save();
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            this.addDescription(String.valueOf(Msg.getMsg(this.getCtx(), "Voided")) + " (" + this.getPayAmt() + ")");
            this.setPayAmt(Env.ZERO);
        }
        if (this.getRequestType().equals("R")) {
            MProject pj = new MProject(this.getCtx(), this.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
            pj.setProjectBalanceAmt(pj.getProjectBalanceAmt().subtract(this.getPayAmt()));
            pj.save();
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        if (!this.reverseCorrectIt()) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        return this.m_processMsg == null;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPayment[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",PayAmt=").append(this.getPayAmt());
        return sb.toString();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    public String generatePayment() {
        String ret = "";
        if (this.getRequestType().equals("I") || this.getRequestType().equals("R")) {
            MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
            pay.setIsReceipt(false);
            pay.setAD_Org_ID(this.getAD_Org_ID());
            pay.setC_BPartner_ID(this.getC_BPartner_ID());
            pay.setC_BankAccount_ID(this.getC_BankAccount_ID());
            pay.setDateTrx(this.getDateTrx());
            pay.setDateAcct(this.getDateAcct());
            pay.setC_Currency_ID(this.getC_Currency_ID());
            pay.setTenderType(this.getTenderType());
            if (this.getTenderType().equals("K")) {
                pay.setCheckNo(this.getCheckNo());
            }
            if (this.getRequestType().equals("I")) {
                pay.setC_Currency_ID(this.getC_Currency_ID());
            }
            if (this.getC_Charge_ID() > 0) {
                pay.setC_Charge_ID(this.getC_Charge_ID());
            }
            pay.setPayAmt(this.getPayAmt());
            pay.set_CustomColumn("C_PaymentRequest_ID", this.getC_PaymentRequest_ID());
            pay.save();
            this.log.config("Payment ID :" + pay.getC_Payment_ID());
            this.setC_Payment_ID(pay.getC_Payment_ID());
            this.setProcessed(true);
            this.save();
            this.log.config("pr saved");
            if (this.getRequestType().equals("I")) {
                X_C_PaymentRequestLine[] lines;
                MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, this.getDateTrx(), this.getC_Currency_ID(), "Payment Request", this.get_TrxName());
                alloc.setAD_Org_ID(this.getAD_Org_ID());
                if (!alloc.save()) {
                    this.log.log(Level.SEVERE, "Allocation not created");
                    return "Allocation not created";
                }
                X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines = this.getLines();
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n2];
                    if (line.getC_Invoice_ID() > 0) {
                        MAllocationLine aLine = new MAllocationLine(alloc, line.getAmt().negate(), Env.ZERO, Env.ZERO, Env.ZERO);
                        aLine.setC_Invoice_ID(line.getC_Invoice_ID());
                        aLine.setC_Payment_ID(pay.getC_Payment_ID());
                        if (!aLine.save()) {
                            this.log.log(Level.SEVERE, "Allocation Line not written ");
                        }
                    }
                    ++n2;
                }
            }
            if (this.getRequestType().equals("R")) {
                MProject pj = new MProject(this.getCtx(), this.get_ValueAsInt("C_Project_ID"), this.get_TrxName());
                pj.setProjectBalanceAmt(pj.getProjectBalanceAmt().add(this.getPayAmt()));
                pj.save();
            }
            ret = "Pago Generado :" + pay.getDocumentNo();
        } else {
            X_C_PaymentRequestLine[] lines;
            int count = 0;
            X_C_PaymentRequestLine[] x_C_PaymentRequestLineArray = lines = this.getLines();
            int n = lines.length;
            int n3 = 0;
            while (n3 < n) {
                X_C_PaymentRequestLine line = x_C_PaymentRequestLineArray[n3];
                MJournalLine gline = new MJournalLine(this.getCtx(), line.getGL_JournalLine_ID(), this.get_TrxName());
                MPayment pay = new MPayment(Env.getCtx(), 0, this.get_TrxName());
                pay.setIsReceipt(false);
                pay.setAD_Org_ID(this.getAD_Org_ID());
                pay.setC_BPartner_ID(gline.get_ValueAsInt("C_BPartner_ID"));
                pay.setC_BankAccount_ID(this.getC_BankAccount_ID());
                pay.setDateTrx(this.getDateTrx());
                pay.setDateAcct(this.getDateAcct());
                pay.setC_Currency_ID(this.getC_Currency_ID());
                pay.setTenderType(this.getTenderType());
                pay.setDescription(gline.getDescription());
                if (this.getTenderType().equals("K")) {
                    pay.setCheckNo(this.getCheckNo());
                }
                if (this.getRequestType().equals("I")) {
                    pay.setC_Currency_ID(this.getC_Currency_ID());
                }
                if (this.getC_Charge_ID() > 0) {
                    pay.setC_Charge_ID(this.getC_Charge_ID());
                }
                pay.setPayAmt(line.getAmt());
                pay.set_CustomColumn("C_PaymentRequest_ID", this.getC_PaymentRequest_ID());
                pay.save();
                ++count;
                line.set_ValueOfColumn("C_Payment_ID", (Object)pay.getC_Payment_ID());
                line.save();
                ++n3;
            }
            ret = "Pagos Generados :" + count;
        }
        return ret;
    }

    @Override
    public boolean approveIt() {
        return false;
    }

    @Override
    public boolean rejectIt() {
        return false;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public String getSummary() {
        return null;
    }

    @Override
    public String getDocumentInfo() {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }
}

