/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.X_U_POSTerminal;
import org.compiere.util.CCache;

public class MPOSTerminal
extends X_U_POSTerminal {
    private static final long serialVersionUID = 6972567212871993024L;
    private static CCache<Integer, MPOSTerminal> s_cache = new CCache("U_POSTerminal", 10, 60);

    public MPOSTerminal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPOSTerminal(Properties ctx, int U_POSTerminal_ID, String trxName) {
        super(ctx, U_POSTerminal_ID, trxName);
    }

    public static MPOSTerminal get(Properties ctx, int U_POSTerminal_ID) {
        Integer key = new Integer(U_POSTerminal_ID);
        MPOSTerminal retValue = s_cache.get(key);
        if (retValue == null) {
            retValue = new MPOSTerminal(ctx, U_POSTerminal_ID, null);
            if (retValue.get_ID() <= 0) {
                return null;
            }
            s_cache.put(key, retValue);
        }
        MPOSTerminal.checkLock(retValue);
        return retValue;
    }

    @Override
    protected void loadComplete(boolean success) {
        if (success) {
            MPOSTerminal.checkLock(this);
        }
    }

    public static void checkLock(MPOSTerminal terminal) {
        if (terminal.isLocked()) {
            long timeToUnlock;
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            if (terminal.getUnlockingTime() != null && currentTime.after(terminal.getUnlockingTime())) {
                terminal.setLocked(false);
            }
            if (terminal.getLastLockTime() != null && terminal.getLockTime() > 0 && currentTime.after(new Timestamp(timeToUnlock = terminal.getLastLockTime().getTime() + (long)(terminal.getLockTime() * 60 * 1000)))) {
                terminal.setLocked(false);
            }
            terminal.save();
        }
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.is_ValueChanged("Locked") && this.isLocked()) {
            this.setLastLockTime(new Timestamp(System.currentTimeMillis()));
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success = super.afterSave(newRecord, success)) {
            s_cache.remove(new Integer(this.get_ID()));
        }
        return success;
    }
}

