/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.net.ftp.FTPClient;
import org.compiere.model.MImage;
import org.compiere.model.MMedia;
import org.compiere.model.MWebProject;
import org.compiere.model.Query;
import org.compiere.model.X_CM_Media_Server;
import org.compiere.util.CLogger;

public class MMediaServer
extends X_CM_Media_Server {
    private static final long serialVersionUID = 1065424104545571149L;
    private static CLogger s_log = CLogger.getCLogger(MMediaServer.class);

    public static MMediaServer[] getMediaServer(MWebProject project) {
        String whereClause = "CM_WebProject_ID=?";
        List<MMediaServer> list = new Query(project.getCtx(), "CM_Media_Server", "CM_WebProject_ID=?", project.get_TrxName()).setParameters(project.getCM_WebProject_ID()).setOrderBy("CM_Media_Server_ID").list();
        MMediaServer[] retValue = new MMediaServer[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MMediaServer(Properties ctx, int CM_Media_Server_ID, String trxName) {
        super(ctx, CM_Media_Server_ID, trxName);
    }

    public MMediaServer(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public boolean deploy(MMedia[] media) {
        if (this.getIP_Address().equals("127.0.0.1") || this.getName().equals("localhost")) {
            this.log.warning("You have not defined your own server, we will not really deploy to localhost!");
            return true;
        }
        FTPClient ftp = new FTPClient();
        try {
            ftp.connect(this.getIP_Address());
            if (!ftp.login(this.getUserName(), this.getPassword())) {
                this.log.warning("Could NOT connect to " + this.getIP_Address() + " as " + this.getUserName());
                return false;
            }
            this.log.info("Connected to " + this.getIP_Address() + " as " + this.getUserName());
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Could NOT connect to " + this.getIP_Address() + " as " + this.getUserName(), e);
            return false;
        }
        boolean success = true;
        String cmd = null;
        try {
            cmd = "cwd";
            ftp.changeWorkingDirectory(this.getFolder());
            cmd = "list";
            String[] fileNames = ftp.listNames();
            this.log.log(Level.FINE, "Number of files in " + this.getFolder() + ": " + fileNames.length);
            cmd = "bin";
            ftp.setFileType(2);
            for (int i2 = 0; i2 < media.length; ++i2) {
                if (media[i2].isSummary()) continue;
                this.log.log(Level.INFO, " Deploying Media Item:" + media[i2].get_ID() + media[i2].getExtension());
                MImage thisImage = media[i2].getImage();
                byte[] buffer = thisImage.getData();
                ByteArrayInputStream is = new ByteArrayInputStream(buffer);
                String fileName = media[i2].get_ID() + media[i2].getExtension();
                cmd = "put " + fileName;
                ftp.storeFile(fileName, (InputStream)is);
                is.close();
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, cmd, e);
            success = false;
        }
        try {
            cmd = "logout";
            ftp.logout();
            cmd = "disconnect";
            ftp.disconnect();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, cmd, e);
        }
        ftp = null;
        return success;
    }
}

