/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MInOutLine;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_M_InOutLineMA;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.model.OFBForward;

public class MInOutLineMA
extends X_M_InOutLineMA {
    private static final long serialVersionUID = -3229418883339488380L;

    public static MInOutLineMA[] get(Properties ctx, int M_InOutLine_ID, String trxName) {
        Query query = MTable.get(ctx, "M_InOutLineMA").createQuery("M_InOutLine_ID=?", trxName);
        query.setParameters(M_InOutLine_ID);
        List<MInOutLineMA> list = query.list();
        MInOutLineMA[] retValue = new MInOutLineMA[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static int deleteInOutMA(int M_InOut_ID, String trxName) {
        String sql = "DELETE FROM M_InOutLineMA ma WHERE EXISTS (SELECT * FROM M_InOutLine l WHERE l.M_InOutLine_ID=ma.M_InOutLine_ID AND M_InOut_ID=" + M_InOut_ID + ")";
        return DB.executeUpdate(sql, trxName);
    }

    public static int deleteInOutLineMA(int M_InOutLine_ID, String trxName) {
        String sql = "DELETE FROM M_InOutLineMA ma WHERE ma.M_InOutLine_ID=?";
        return DB.executeUpdate(sql, M_InOutLine_ID, trxName);
    }

    public MInOutLineMA(Properties ctx, int M_InOutLineMA_ID, String trxName) {
        super(ctx, M_InOutLineMA_ID, trxName);
        if (M_InOutLineMA_ID != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MInOutLineMA(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInOutLineMA(MInOutLine parent, int M_AttributeSetInstance_ID, BigDecimal MovementQty) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setM_InOutLine_ID(parent.getM_InOutLine_ID());
        this.setM_AttributeSetInstance_ID(M_AttributeSetInstance_ID);
        this.setMovementQty(MovementQty);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInOutLineMA[");
        sb.append("M_InOutLine_ID=").append(this.getM_InOutLine_ID()).append(",M_AttributeSetInstance_ID=").append(this.getM_AttributeSetInstance_ID()).append(", Qty=").append(this.getMovementQty()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getM_InOutLine().getReversalLine_ID() > 0) {
            return true;
        }
        if (this.getM_InOutLine().getM_InOut().getC_Order_ID() > 0 && this.getM_InOutLine().getM_InOut().getC_Order().getDeliveryRule().equals("F")) {
            return true;
        }
        BigDecimal qtyHand = DB.getSQLValueBD(this.get_TrxName(), "Select SUM(QtyonHand) from M_Storage where M_Product_ID=?and M_Locator_ID=? and M_AttributeSetInstance_ID=?", this.getM_InOutLine().getM_Product_ID(), this.getM_InOutLine().getM_Locator_ID(), this.getM_AttributeSetInstance_ID());
        if (!(OFBForward.ValidatorStockBlumos(Env.getAD_Client_ID(this.getCtx())) || qtyHand != null && qtyHand.compareTo(this.getMovementQty()) >= 0)) {
            this.log.saveError("Cantidad", "Stock Insuficiente Producto " + this.getM_InOutLine().getM_Product().getValue() + ":" + (qtyHand == null ? Env.ZERO : qtyHand));
            return false;
        }
        if (newRecord) {
            BigDecimal qtyFound = DB.getSQLValueBD(this.get_TrxName(), "Select SUM(MovementQty) from M_InOutLineMA where M_InOutLine_ID=?", this.getM_InOutLine_ID());
            if (qtyFound == null) {
                qtyFound = new BigDecimal("0.0");
            }
            qtyFound = qtyFound.add(this.getMovementQty());
            if (this.getM_InOutLine().getMovementQty().signum() > 0) {
                if (qtyFound.compareTo(this.getM_InOutLine().getMovementQty()) > 0) {
                    this.log.saveError("Cantidad", "El detalle de picking supera la linea de Entrega :" + qtyFound);
                    return false;
                }
            } else if (this.getM_InOutLine().getMovementQty().signum() < 0 && qtyFound.compareTo(this.getM_InOutLine().getMovementQty()) < 0) {
                this.log.saveError("Cantidad", "El detalle de picking supera la linea de Entrega :" + qtyFound);
                return false;
            }
        }
        return true;
    }
}

