/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.compiere.model.X_AD_Image;
import org.compiere.util.CCache;
import org.compiere.util.Ini;

public class MImage
extends X_AD_Image {
    private static final long serialVersionUID = -7361463683427300715L;
    private static CCache<Integer, MImage> s_cache = new CCache("AD_Image", 20);
    private Image m_image = null;
    private Icon m_icon = null;

    public static MImage get(Properties ctx, int AD_Image_ID) {
        if (AD_Image_ID == 0) {
            return new MImage(ctx, AD_Image_ID, null);
        }
        Integer key = new Integer(AD_Image_ID);
        MImage retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MImage(ctx, AD_Image_ID, null);
        if (retValue.get_ID() != 0 && Ini.isClient()) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MImage(Properties ctx, int AD_Image_ID, String trxName) {
        super(ctx, AD_Image_ID, trxName);
        if (AD_Image_ID < 1) {
            this.setName("-");
        }
    }

    public MImage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public Image getImage() {
        if (this.m_image != null) {
            return this.m_image;
        }
        byte[] data = this.getBinaryData();
        if (data != null && data.length > 0) {
            try {
                Toolkit tk = Toolkit.getDefaultToolkit();
                this.m_image = tk.createImage(data);
                return this.m_image;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
                return null;
            }
        }
        URL url = this.getURL();
        if (url == null) {
            return null;
        }
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.m_image = tk.getImage(url);
            return this.m_image;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "(URL)", e);
            return null;
        }
    }

    public Icon getIcon() {
        if (this.m_icon != null) {
            return this.m_icon;
        }
        byte[] data = this.getBinaryData();
        if (data != null && data.length > 0) {
            try {
                this.m_icon = new ImageIcon(data, this.getName());
                return this.m_icon;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
                return null;
            }
        }
        URL url = this.getURL();
        if (url == null) {
            return null;
        }
        try {
            this.m_icon = new ImageIcon(url, this.getName());
            return this.m_icon;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "(URL)", e);
            return null;
        }
    }

    private URL getURL() {
        String str = this.getImageURL();
        if (str == null || str.length() == 0) {
            return null;
        }
        URL url = null;
        try {
            url = str.indexOf("://") != -1 ? new URL(str) : this.getClass().getResource(str);
            if (url == null) {
                this.log.warning("Not found: " + str);
            }
        }
        catch (Exception e) {
            this.log.warning("Not found: " + str + " - " + e.getMessage());
        }
        return url;
    }

    @Override
    public void setImageURL(String ImageURL) {
        this.m_image = null;
        this.m_icon = null;
        super.setImageURL(ImageURL);
    }

    @Override
    public void setBinaryData(byte[] BinaryData) {
        this.m_image = null;
        this.m_icon = null;
        super.setBinaryData(BinaryData);
    }

    public byte[] getData() {
        byte[] data = super.getBinaryData();
        if (data != null) {
            return data;
        }
        String str = this.getImageURL();
        if (str == null || str.length() == 0) {
            this.log.config("No Image URL");
            return null;
        }
        URL url = this.getURL();
        if (url == null) {
            this.log.config("No URL");
            return null;
        }
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            InputStream is = conn.getInputStream();
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int length = -1;
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            is.close();
            data = os.toByteArray();
            os.close();
        }
        catch (Exception e) {
            this.log.config(e.toString());
        }
        return data;
    }

    @Override
    public String toString() {
        return "MImage[ID=" + this.get_ID() + ",Name=" + this.getName() + "]";
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        return true;
    }
}

