/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.X_AD_Column;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MColumn
extends X_AD_Column {
    private static final long serialVersionUID = 2954312267794622096L;
    private static CCache<Integer, MColumn> s_cache = new CCache("AD_Column", 20);
    private static CLogger s_log = CLogger.getCLogger(MColumn.class);

    public static MColumn get(Properties ctx, int AD_Column_ID) {
        Integer key = new Integer(AD_Column_ID);
        MColumn retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MColumn(ctx, AD_Column_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public static String getColumnName(Properties ctx, int AD_Column_ID) {
        MColumn col = MColumn.get(ctx, AD_Column_ID);
        if (col.get_ID() == 0) {
            return null;
        }
        return col.getColumnName();
    }

    public MColumn(Properties ctx, int AD_Column_ID, String trxName) {
        super(ctx, AD_Column_ID, trxName);
        if (AD_Column_ID == 0) {
            this.setIsAlwaysUpdateable(false);
            this.setIsEncrypted(false);
            this.setIsIdentifier(false);
            this.setIsKey(false);
            this.setIsMandatory(false);
            this.setIsParent(false);
            this.setIsSelectionColumn(false);
            this.setIsTranslated(false);
            this.setIsUpdateable(true);
            this.setVersion(Env.ZERO);
        }
    }

    public MColumn(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MColumn(MTable parent) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setAD_Table_ID(parent.getAD_Table_ID());
        this.setEntityType(parent.getEntityType());
    }

    public boolean isStandardColumn() {
        String columnName = this.getColumnName();
        return columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || columnName.equals("IsActive") || columnName.startsWith("Created") || columnName.startsWith("Updated");
    }

    public boolean isVirtualColumn() {
        String s = this.getColumnSQL();
        return s != null && s.length() > 0;
    }

    public boolean isEncrypted() {
        String s = this.getIsEncrypted();
        return "Y".equals(s);
    }

    public void setIsEncrypted(boolean IsEncrypted) {
        this.setIsEncrypted(IsEncrypted ? "Y" : "N");
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int cnt;
        int displayType = this.getAD_Reference_ID();
        if (DisplayType.isLOB(displayType)) {
            if (this.getFieldLength() != 0) {
                this.setFieldLength(0);
            }
        } else if (this.getFieldLength() == 0) {
            if (DisplayType.isID(displayType)) {
                this.setFieldLength(10);
            } else if (DisplayType.isNumeric(displayType)) {
                this.setFieldLength(14);
            } else if (DisplayType.isDate(displayType)) {
                this.setFieldLength(7);
            } else {
                this.log.saveError("FillMandatory", Msg.getElement(this.getCtx(), "FieldLength"));
                return false;
            }
        }
        if (this.isIdentifier() && (cnt = DB.getSQLValue(this.get_TrxName(), "SELECT COUNT(*) FROM AD_Column WHERE AD_Table_ID=? AND AD_Column_ID!=? AND IsIdentifier='Y' AND SeqNo=?", this.getAD_Table_ID(), this.getAD_Column_ID(), this.getSeqNo())) > 0) {
            this.log.saveError("SaveErrorNotUnique", Msg.getElement(this.getCtx(), "SeqNo"));
            return false;
        }
        if (this.isVirtualColumn()) {
            if (this.isMandatory()) {
                this.setIsMandatory(false);
            }
            if (this.isUpdateable()) {
                this.setIsUpdateable(false);
            }
        }
        if (this.isParent() || this.isKey()) {
            this.setIsUpdateable(false);
        }
        if (this.isAlwaysUpdateable() && !this.isUpdateable()) {
            this.setIsAlwaysUpdateable(false);
        }
        if (this.isEncrypted()) {
            int dt = this.getAD_Reference_ID();
            if (this.isKey() || this.isParent() || this.isStandardColumn() || this.isVirtualColumn() || this.isIdentifier() || this.isTranslated() || DisplayType.isLookup(dt) || DisplayType.isLOB(dt) || "DocumentNo".equalsIgnoreCase(this.getColumnName()) || "Value".equalsIgnoreCase(this.getColumnName()) || "Name".equalsIgnoreCase(this.getColumnName())) {
                this.log.warning("Encryption not sensible - " + this.getColumnName());
                this.setIsEncrypted(false);
            }
        }
        if ((newRecord || this.is_ValueChanged("AD_Element_ID")) && this.getAD_Element_ID() != 0) {
            M_Element element = new M_Element(this.getCtx(), this.getAD_Element_ID(), this.get_TrxName());
            this.setColumnName(element.getColumnName());
            this.setName(element.getName());
            this.setDescription(element.getDescription());
            this.setHelp(element.getHelp());
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!newRecord && (this.is_ValueChanged("Name") || this.is_ValueChanged("Description") || this.is_ValueChanged("Help"))) {
            StringBuffer sql = new StringBuffer("UPDATE AD_Field SET Name=").append(DB.TO_STRING(this.getName())).append(", Description=").append(DB.TO_STRING(this.getDescription())).append(", Help=").append(DB.TO_STRING(this.getHelp())).append(" WHERE AD_Column_ID=").append(this.get_ID()).append(" AND IsCentrallyMaintained='Y'");
            int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
            this.log.fine("afterSave - Fields updated #" + no);
        }
        return success;
    }

    public String getSQLAdd(MTable table2) {
        StringBuffer sql = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(this.getSQLDDL());
        String constraint = this.getConstraint(table2.getTableName());
        if (constraint != null && constraint.length() > 0) {
            sql.append("; ").append("ALTER TABLE ").append(table2.getTableName()).append(" ADD ").append(constraint);
        }
        return sql.toString();
    }

    public String getSQLDDL() {
        if (this.isVirtualColumn()) {
            return null;
        }
        StringBuffer sql = new StringBuffer(this.getColumnName()).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sql.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!this.isMandatory()) {
                sql.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        if (this.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(this.getColumnName()).append(" IN ('Y','N'))");
        }
        if (this.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    public String getSQLModify(MTable table2, boolean setNullOption) {
        StringBuffer sql = new StringBuffer();
        StringBuffer sqlBase = new StringBuffer("ALTER TABLE ").append(table2.getTableName()).append(" MODIFY ").append(this.getColumnName());
        StringBuffer sqlDefault = new StringBuffer(sqlBase).append(" ").append(this.getSQLDataType());
        String defaultValue = this.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID(this.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText(this.getAD_Reference_ID()) || this.getAD_Reference_ID() == 17 || this.getAD_Reference_ID() == 20 || this.getColumnName().equals("EntityType") || this.getColumnName().equals("AD_Language") || this.getAD_Reference_ID() == 28 && !this.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING(defaultValue);
            }
            sqlDefault.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!this.isMandatory()) {
                sqlDefault.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        sql.append(sqlDefault);
        if (this.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            StringBuffer sqlSet = new StringBuffer("UPDATE ").append(table2.getTableName()).append(" SET ").append(this.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(this.getColumnName()).append(" IS NULL");
            sql.append("; ").append(sqlSet);
        }
        if (setNullOption) {
            StringBuffer sqlNull = new StringBuffer(sqlBase);
            if (this.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append(sqlNull);
        }
        return sql.toString();
    }

    public String getSQLDataType() {
        String columnName = this.getColumnName();
        int dt = this.getAD_Reference_ID();
        return DisplayType.getSQLDataType(dt, columnName, this.getFieldLength());
    }

    public String getConstraint(String tableName) {
        if (this.isKey()) {
            String constraintName = tableName.length() > 26 ? tableName.substring(0, 26) + "_Key" : tableName + "_Key";
            return "CONSTRAINT " + constraintName + " PRIMARY KEY (" + this.getColumnName() + ")";
        }
        return "";
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MColumn[");
        sb.append(this.get_ID()).append("-").append(this.getColumnName()).append("]");
        return sb.toString();
    }

    public static int getColumn_ID(String TableName, String columnName) {
        int m_table_id = MTable.getTable_ID(TableName);
        if (m_table_id == 0) {
            return 0;
        }
        int retValue = 0;
        String SQL = "SELECT AD_Column_ID FROM AD_Column WHERE AD_Table_ID = ?  AND columnname = ?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, m_table_id);
            pstmt.setString(2, columnName);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, SQL, e);
            retValue = -1;
        }
        return retValue;
    }

    public static int getTable_ID(Properties ctx, int AD_Column_ID, String trxName) {
        String sqlStmt = "SELECT AD_Table_ID FROM AD_Column WHERE AD_Column_ID=?";
        return DB.getSQLValue(trxName, sqlStmt, AD_Column_ID);
    }
}

