/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.model.X_C_Cash;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.ofb.model.OFBForward;

public class MCash
extends X_C_Cash
implements DocAction {
    private static final long serialVersionUID = -1221144207418749593L;
    private static CLogger s_log = CLogger.getCLogger(MCash.class);
    private MCashLine[] m_lines = null;
    private MCashBook m_book = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MCash get(Properties ctx, int AD_Org_ID, Timestamp dateAcct, int C_Currency_ID, String trxName) {
        String whereClause = "C_Cash.AD_Org_ID=? And Trunc(C_Cash.StatementDate)=to_date('" + TimeUtil.getDay(dateAcct).toString().substring(0, 10) + "','yyyy-mm-dd')" + " AND C_Cash.Processed='N'" + " AND EXISTS (SELECT * FROM C_CashBook cb " + "WHERE C_Cash.C_CashBook_ID=cb.C_CashBook_ID AND cb.AD_Org_ID=C_Cash.AD_Org_ID" + " AND cb.C_Currency_ID=?)";
        MCash retValue = (MCash)new Query(ctx, "C_Cash", whereClause, trxName).setParameters(AD_Org_ID, C_Currency_ID).first();
        if (retValue != null) {
            return retValue;
        }
        MCashBook cb = MCashBook.get(ctx, AD_Org_ID, C_Currency_ID);
        if (cb == null) {
            s_log.warning("No CashBook for AD_Org_ID=" + AD_Org_ID + ", C_Currency_ID=" + C_Currency_ID);
            return null;
        }
        retValue = new MCash(cb, dateAcct);
        retValue.save(trxName);
        return retValue;
    }

    public static MCash get(Properties ctx, int C_CashBook_ID, Timestamp dateAcct, String trxName) {
        String whereClause = "C_CashBook_ID=? And Trunc(StatementDate)=to_date('" + TimeUtil.getDay(dateAcct).toString().substring(0, 10) + "','yyyy-mm-dd')" + " AND Processed='N'";
        MCash retValue = (MCash)new Query(ctx, "C_Cash", whereClause, trxName).setParameters(C_CashBook_ID).first();
        if (retValue != null) {
            return retValue;
        }
        MCashBook cb = new MCashBook(ctx, C_CashBook_ID, trxName);
        if (cb.get_ID() == 0) {
            s_log.warning("Not found C_CashBook_ID=" + C_CashBook_ID);
            return null;
        }
        retValue = new MCash(cb, dateAcct);
        retValue.saveEx(trxName);
        return retValue;
    }

    public MCash(Properties ctx, int C_Cash_ID, String trxName) {
        super(ctx, C_Cash_ID, trxName);
        if (C_Cash_ID == 0) {
            this.setBeginningBalance(Env.ZERO);
            this.setEndingBalance(Env.ZERO);
            this.setStatementDifference(Env.ZERO);
            this.setDocAction("CO");
            this.setDocStatus("DR");
            Timestamp today = TimeUtil.getDay(System.currentTimeMillis());
            this.setStatementDate(today);
            this.setDateAcct(today);
            String name = String.valueOf(DisplayType.getDateFormat(15).format(today)) + " " + MOrg.get(ctx, this.getAD_Org_ID()).getValue();
            this.setName(name);
            this.setIsApproved(false);
            this.setPosted(false);
            this.setProcessed(false);
        }
    }

    public MCash(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MCash(MCashBook cb, Timestamp today) {
        this(cb.getCtx(), 0, cb.get_TrxName());
        this.setClientOrg(cb);
        this.setC_CashBook_ID(cb.getC_CashBook_ID());
        if (today != null) {
            this.setStatementDate(today);
            this.setDateAcct(today);
            String name = String.valueOf(DisplayType.getDateFormat(15).format(today)) + " " + cb.getName();
            this.setName(name);
        }
        this.m_book = cb;
    }

    public MCashLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MCash.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "C_Cash_ID=?";
        List<MCashLine> list = new Query(this.getCtx(), "C_CashLine", "C_Cash_ID=?", this.get_TrxName()).setParameters(this.getC_Cash_ID()).setOrderBy("Line").setOnlyActiveRecords(true).list();
        this.m_lines = list.toArray(new MCashLine[list.size()]);
        return this.m_lines;
    }

    public MCashBook getCashBook() {
        if (this.m_book == null) {
            this.m_book = MCashBook.get(this.getCtx(), this.getC_CashBook_ID());
        }
        return this.m_book;
    }

    @Override
    public String getDocumentNo() {
        return this.getName();
    }

    @Override
    public String getDocumentInfo() {
        return String.valueOf(Msg.getElement(this.getCtx(), "C_Cash_ID")) + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(String.valueOf(this.get_TableName()) + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int count;
        if (this.getDocStatus().equals("DR") && (count = DB.getSQLValue(this.get_TrxName(), "select count(1) from C_Cash where DocStatus IN ('DR','IP') and C_CashBook_ID=" + this.getC_CashBook_ID() + " and C_Cash_ID!=" + this.getC_Cash_ID())) > 0) {
            this.log.saveError("Error", "Ya existe otra caja en borrador o en proceso por favor compl\u00e9tela antes de crear una nueva");
            this.m_processMsg = "Ya existe otra caja en borrador por favor compl\u00e9tela antes de crear una nueva";
            return false;
        }
        Calendar calCalendario = Calendar.getInstance();
        calCalendario.setTimeInMillis(this.getDateAcct().getTime());
        Timestamp tmsFecha = new Timestamp(calCalendario.getTimeInMillis());
        MCash oldCash = MCash.getDuplicate(this.getCtx(), this.getAD_Org_ID(), tmsFecha, this.getC_CashBook_ID(), this.get_TrxName(), this.getC_Cash_ID());
        if (OFBForward.UseOnlyCashForBBalance()) {
            oldCash = MCash.getDuplicate(this.getCtx(), this.getC_CashBook_ID(), this.get_TrxName(), this.getC_Cash_ID());
        }
        if (oldCash == null) {
            this.setBeginningBalance(Env.ZERO);
        } else {
            this.setBeginningBalance(oldCash.getEndingBalance());
        }
        if (newRecord) {
            this.setStatementDifference(Env.ZERO);
        }
        this.setEndingBalance(this.getBeginningBalance().add(this.getStatementDifference()));
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info(this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info(this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), "CMC", this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        MCashLine[] lines = this.getLines(false);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal difference = Env.ZERO;
        int C_Currency_ID = this.getC_Currency_ID();
        int i = 0;
        while (i < lines.length) {
            MCashLine line = lines[i];
            if (line.isActive()) {
                if (C_Currency_ID == line.getC_Currency_ID()) {
                    difference = difference.add(line.getAmount());
                } else {
                    BigDecimal amt = MConversionRate.convert(this.getCtx(), line.getAmount(), line.getC_Currency_ID(), C_Currency_ID, this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID());
                    if (amt == null) {
                        this.m_processMsg = "No Conversion Rate found - @C_CashLine_ID@= " + line.getLine();
                        return "IN";
                    }
                    difference = difference.add(amt);
                }
            }
            ++i;
        }
        this.setStatementDifference(difference);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        MCashLine[] lines = this.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MCashLine line = lines[i];
            if ("I".equals(line.getCashType())) {
                MInvoice invoice = line.getInvoice();
                if (!"VO".equals(invoice.getDocStatus()) || line.getAmount().signum() != 0) {
                    if (!("CO".equals(invoice.getDocStatus()) || "CL".equals(invoice.getDocStatus()) || "RE".equals(invoice.getDocStatus()) || "VO".equals(invoice.getDocStatus()))) {
                        this.m_processMsg = "@Line@ " + line.getLine() + ": @InvoiceCreateDocNotCompleted@";
                        return "IN";
                    }
                    String name = String.valueOf(Msg.translate(this.getCtx(), "C_Cash_ID")) + ": " + this.getName() + " - " + Msg.translate(this.getCtx(), "Line") + " " + line.getLine();
                    MAllocationHdr hdr = new MAllocationHdr(this.getCtx(), false, this.getDateAcct(), line.getC_Currency_ID(), name, this.get_TrxName());
                    hdr.setAD_Org_ID(this.getAD_Org_ID());
                    if (!hdr.save()) {
                        this.m_processMsg = CLogger.retrieveErrorString("Could not create Allocation Hdr");
                        return "IN";
                    }
                    MAllocationLine aLine = new MAllocationLine(hdr, line.getAmount(), line.getDiscountAmt(), line.getWriteOffAmt(), Env.ZERO);
                    aLine.setC_Invoice_ID(line.getC_Invoice_ID());
                    aLine.setC_CashLine_ID(line.getC_CashLine_ID());
                    if (!aLine.save()) {
                        this.m_processMsg = CLogger.retrieveErrorString("Could not create Allocation Line");
                        return "IN";
                    }
                    if (!hdr.processIt("CO")) {
                        this.m_processMsg = CLogger.retrieveErrorString("Could not process Allocation");
                        return "IN";
                    }
                    if (!hdr.save()) {
                        this.m_processMsg = CLogger.retrieveErrorString("Could not save Allocation");
                        return "IN";
                    }
                }
            } else if ("T".equals(line.getCashType()) && line.getC_Payment_ID() <= 0) {
                MPayment pay = new MPayment(this.getCtx(), 0, this.get_TrxName());
                pay.setAD_Org_ID(this.getAD_Org_ID());
                String documentNo = this.getName();
                pay.setDocumentNo(documentNo);
                pay.setR_PnRef(documentNo);
                pay.set_ValueNoCheck("TrxType", "X");
                pay.setC_CashBook_ID(this.getC_CashBook_ID());
                pay.setC_BankAccount_ID(line.getC_BankAccount_ID());
                pay.setC_DocType_ID(true);
                pay.setDateTrx(this.getStatementDate());
                pay.setDateAcct(this.getDateAcct());
                pay.setAmount(line.getC_Currency_ID(), line.getAmount().negate());
                pay.setDescription(line.getDescription());
                pay.setDocStatus("CL");
                pay.setDocAction("--");
                pay.setPosted(true);
                pay.setIsAllocated(true);
                pay.setProcessed(true);
                if (line.getAmount().compareTo(Env.ZERO) > 0) {
                    pay.setC_DocType_ID(false);
                } else {
                    pay.setC_DocType_ID(true);
                }
                pay.setC_BPartner_ID(line.get_ValueAsInt("C_BPartner_ID"));
                pay.setTenderType(line.get_ValueAsString("TenderType"));
                if (line.get_ValueAsString("TenderType").equals("K")) {
                    pay.setCheckNo(line.get_ValueAsString("DocumentNo"));
                } else {
                    pay.setDocumentNo(line.get_ValueAsString("DocumentNo"));
                    pay.setR_PnRef(line.get_ValueAsString("DocumentNo"));
                }
                pay.setAmount(line.getC_Currency_ID(), line.getAmount().abs());
                if (!pay.save()) {
                    this.m_processMsg = CLogger.retrieveErrorString("Could not create Payment");
                    return "IN";
                }
                line.setC_Payment_ID(pay.getC_Payment_ID());
                if (!line.save()) {
                    this.m_processMsg = "Could not update Cash Line";
                    return "IN";
                }
            }
            ++i;
        }
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean retValue = this.reverseIt();
        if (retValue) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
            if (this.m_processMsg != null) {
                return false;
            }
            this.setDocAction("--");
        }
        return retValue;
    }

    private boolean reverseIt() {
        MCashLine[] cashlines;
        MAllocationHdr[] allocations;
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (!MPeriod.isOpen(this.getCtx(), this.getDateAcct(), "CMC", this.getAD_Org_ID())) {
            throw new IllegalStateException("@PeriodClosed@");
        }
        MAllocationHdr[] mAllocationHdrArray = allocations = MAllocationHdr.getOfCash(this.getCtx(), this.getC_Cash_ID(), this.get_TrxName());
        int n = allocations.length;
        int n2 = 0;
        while (n2 < n) {
            MAllocationHdr allocation = mAllocationHdrArray[n2];
            allocation.reverseCorrectIt();
            if (!allocation.save()) {
                throw new IllegalStateException("Cannot reverse allocations");
            }
            ++n2;
        }
        MCashLine[] mCashLineArray = cashlines = this.getLines(true);
        int n3 = cashlines.length;
        n = 0;
        while (n < n3) {
            MCashLine cashline = mCashLineArray[n];
            BigDecimal oldAmount = cashline.getAmount();
            BigDecimal oldDiscount = cashline.getDiscountAmt();
            BigDecimal oldWriteOff = cashline.getWriteOffAmt();
            cashline.setAmount(Env.ZERO);
            cashline.setDiscountAmt(Env.ZERO);
            cashline.setWriteOffAmt(Env.ZERO);
            cashline.addDescription(String.valueOf(Msg.getMsg(this.getCtx(), "Voided")) + " (Amount=" + oldAmount + ", Discount=" + oldDiscount + ", WriteOff=" + oldWriteOff + ", )");
            if ("T".equals(cashline.getCashType())) {
                if (cashline.getC_Payment_ID() == 0) {
                    throw new IllegalStateException("Cannot reverse payment");
                }
                MPayment payment = new MPayment(this.getCtx(), cashline.getC_Payment_ID(), this.get_TrxName());
                if (payment.getC_BankStatementLine2_ID() < 1) {
                    payment.reverseCorrectIt();
                    payment.saveEx();
                } else {
                    throw new IllegalStateException("Pago Tiene un Estado de Cuentas Bancario Asociado");
                }
            }
            cashline.saveEx();
            ++n;
        }
        this.setName(String.valueOf(this.getName()) + "^");
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setDocStatus("RE");
        this.setProcessed(true);
        this.setPosted(true);
        this.setDocAction("--");
        this.saveEx();
        MFactAcct.deleteEx(Table_ID, this.getC_Cash_ID(), this.get_TrxName());
        return true;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(String.valueOf(desc) + " | " + description);
        }
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        boolean retValue = this.reverseIt();
        if (retValue) {
            this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
            if (this.m_processMsg != null) {
                return false;
            }
        }
        return retValue;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(false);
        if (this.reverseCorrectIt()) {
            return true;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        String sql = "UPDATE C_CashLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Cash_ID=" + this.getC_Cash_ID();
        int noLine = DB.executeUpdate(sql, this.get_TrxName());
        this.m_lines = null;
        this.log.fine(String.valueOf(processed) + " - Lines=" + noLine);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MCash[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(", Balance=").append(this.getBeginningBalance()).append("->").append(this.getEndingBalance()).append("]");
        return sb.toString();
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(": ").append(Msg.translate(this.getCtx(), "BeginningBalance")).append("=").append(this.getBeginningBalance()).append(",").append(Msg.translate(this.getCtx(), "EndingBalance")).append("=").append(this.getEndingBalance()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getStatementDifference();
    }

    @Override
    public int getC_Currency_ID() {
        return this.getCashBook().getC_Currency_ID();
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    public static MCash getDefault(Properties ctx, int AD_Client_ID, int C_CashBook_ID, String trxName) {
        MCash retValue = null;
        String sql = "SELECT * FROM C_Cash c WHERE c.AD_Client_ID=? And c.C_CashBook_ID=" + C_CashBook_ID + " AND c.Processed='N' ";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCash(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MCash getDuplicate(Properties ctx, int AD_Org_ID, Timestamp dateAcct, int CashBook_ID, String trxName, int C_Cash_ID) {
        MCash retValue = null;
        String sql = "SELECT * FROM C_Cash c WHERE c.AD_Org_ID=? AND TRUNC(c.StatementDate)<=? AND c.C_CashBook_ID=? AND c.DocStatus IN ('DR','CO') AND c.C_CASH_ID!=" + C_Cash_ID + " Order BY c.StatementDate Desc,c.created Desc";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, AD_Org_ID);
            pstmt.setTimestamp(2, TimeUtil.getDay(dateAcct));
            pstmt.setInt(3, CashBook_ID);
            ResultSet rs = pstmt.executeQuery();
            retValue = rs.next() ? new MCash(ctx, rs, trxName) : MCash.getDuplicate(ctx, dateAcct, CashBook_ID, trxName, C_Cash_ID);
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MCash getDuplicate(Properties ctx, Timestamp dateAcct, int CashBook_ID, String trxName, int C_Cash_ID) {
        MCash retValue = null;
        String sql = "SELECT * FROM C_Cash c WHERE TRUNC(c.StatementDate)<=? AND c.C_CashBook_ID=? AND c.DocStatus IN ('DR','CO') AND c.C_CASH_ID!=" + C_Cash_ID + " Order BY c.StatementDate Desc,c.created Desc";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setTimestamp(1, TimeUtil.getDay(dateAcct));
            pstmt.setInt(2, CashBook_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCash(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MCash getDuplicate(Properties ctx, int CashBook_ID, String trxName, int C_Cash_ID) {
        MCash retValue = null;
        String sql = "SELECT * FROM C_Cash c WHERE c.C_CashBook_ID=? AND c.DocStatus IN ('DR','CO') AND c.C_CASH_ID!=" + C_Cash_ID + " Order BY c.documentNo desc, c.StatementDate Desc,c.created Desc";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, trxName);
            pstmt.setInt(1, CashBook_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MCash(ctx, rs, trxName);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }
}

