/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAttribute;
import org.compiere.model.MColumn;
import org.compiere.model.Query;
import org.compiere.model.X_M_AttributeSet;
import org.compiere.model.X_M_AttributeSetExclude;
import org.compiere.model.X_M_LotCtlExclude;
import org.compiere.model.X_M_SerNoCtlExclude;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MAttributeSet
extends X_M_AttributeSet {
    private static final long serialVersionUID = -2703536167929259405L;
    private static CCache<Integer, MAttributeSet> s_cache = new CCache("M_AttributeSet", 20);
    private MAttribute[] m_instanceAttributes = null;
    private MAttribute[] m_productAttributes = null;
    private X_M_AttributeSetExclude[] m_excludes = null;
    private X_M_LotCtlExclude[] m_excludeLots = null;
    private X_M_SerNoCtlExclude[] m_excludeSerNos = null;

    public static MAttributeSet get(Properties ctx, int M_AttributeSet_ID) {
        Integer key = new Integer(M_AttributeSet_ID);
        MAttributeSet retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MAttributeSet(ctx, M_AttributeSet_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MAttributeSet(Properties ctx, int M_AttributeSet_ID, String trxName) {
        super(ctx, M_AttributeSet_ID, trxName);
        if (M_AttributeSet_ID == 0) {
            this.setIsGuaranteeDate(false);
            this.setIsGuaranteeDateMandatory(false);
            this.setIsLot(false);
            this.setIsLotMandatory(false);
            this.setIsSerNo(false);
            this.setIsSerNoMandatory(false);
            this.setIsInstanceAttribute(false);
            this.setMandatoryType("N");
        }
    }

    public MAttributeSet(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MAttribute[] getMAttributes(boolean instanceAttributes) {
        block9: {
            if ((this.m_instanceAttributes != null || !instanceAttributes) && (this.m_productAttributes != null || instanceAttributes)) break block9;
            String sql = "SELECT mau.M_Attribute_ID FROM M_AttributeUse mau INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) WHERE mau.IsActive='Y' AND ma.IsActive='Y' AND mau.M_AttributeSet_ID=? AND ma.IsInstanceAttribute=? ORDER BY mau.SeqNo";
            ArrayList<MAttribute> list = new ArrayList<MAttribute>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                pstmt.setInt(1, this.getM_AttributeSet_ID());
                pstmt.setString(2, instanceAttributes ? "Y" : "N");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    MAttribute ma = new MAttribute(this.getCtx(), rs.getInt(1), this.get_TrxName());
                    list.add(ma);
                }
            }
            catch (SQLException ex) {
                try {
                    throw new DBException(ex, sql);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (instanceAttributes) {
                this.m_instanceAttributes = new MAttribute[list.size()];
                list.toArray(this.m_instanceAttributes);
            } else {
                this.m_productAttributes = new MAttribute[list.size()];
                list.toArray(this.m_productAttributes);
            }
        }
        if (instanceAttributes && this.isInstanceAttribute() != this.m_instanceAttributes.length > 0) {
            this.setIsInstanceAttribute(this.m_instanceAttributes.length > 0);
        }
        if (instanceAttributes) {
            return this.m_instanceAttributes;
        }
        return this.m_productAttributes;
    }

    public boolean isMandatory() {
        return !"N".equals(this.getMandatoryType()) || this.isLotMandatory() || this.isSerNoMandatory() || this.isGuaranteeDateMandatory();
    }

    public boolean isMandatoryAlways() {
        return "Y".equals(this.getMandatoryType());
    }

    public boolean isMandatoryShipping() {
        return "S".equals(this.getMandatoryType());
    }

    public boolean excludeEntry(int AD_Column_ID, boolean isSOTrx) {
        if (this.m_excludes == null) {
            String whereClause = "M_AttributeSet_ID=?";
            List<X_M_AttributeSetExclude> list = new Query(this.getCtx(), "M_AttributeSetExclude", "M_AttributeSet_ID=?", null).setParameters(this.get_ID()).setOnlyActiveRecords(true).list();
            this.m_excludes = new X_M_AttributeSetExclude[list.size()];
            list.toArray(this.m_excludes);
        }
        if (this.m_excludes != null && this.m_excludes.length > 0) {
            MColumn column = MColumn.get(this.getCtx(), AD_Column_ID);
            for (int i2 = 0; i2 < this.m_excludes.length; ++i2) {
                if (this.m_excludes[i2].getAD_Table_ID() != column.getAD_Table_ID() || this.m_excludes[i2].isSOTrx() != isSOTrx) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExcludeLot(int AD_Column_ID, boolean isSOTrx) {
        if (this.getM_LotCtl_ID() == 0) {
            return true;
        }
        if (this.m_excludeLots == null) {
            String whereClause = "M_LotCtl_ID=?";
            List<X_M_LotCtlExclude> list = new Query(this.getCtx(), "M_LotCtlExclude", "M_LotCtl_ID=?", null).setParameters(this.getM_LotCtl_ID()).setOnlyActiveRecords(true).list();
            this.m_excludeLots = new X_M_LotCtlExclude[list.size()];
            list.toArray(this.m_excludeLots);
        }
        if (this.m_excludeLots != null && this.m_excludeLots.length > 0) {
            MColumn column = MColumn.get(this.getCtx(), AD_Column_ID);
            for (int i2 = 0; i2 < this.m_excludeLots.length; ++i2) {
                if (this.m_excludeLots[i2].getAD_Table_ID() != column.getAD_Table_ID() || this.m_excludeLots[i2].isSOTrx() != isSOTrx) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExcludeSerNo(int AD_Column_ID, boolean isSOTrx) {
        if (this.getM_SerNoCtl_ID() == 0) {
            return true;
        }
        if (this.m_excludeSerNos == null) {
            String whereClause = "M_SerNoCtl_ID=?";
            List<X_M_SerNoCtlExclude> list = new Query(this.getCtx(), "M_SerNoCtlExclude", "M_SerNoCtl_ID=?", null).setParameters(this.getM_SerNoCtl_ID()).setOnlyActiveRecords(true).list();
            this.m_excludeSerNos = new X_M_SerNoCtlExclude[list.size()];
            list.toArray(this.m_excludeSerNos);
        }
        if (this.m_excludeSerNos != null && this.m_excludeSerNos.length > 0) {
            MColumn column = MColumn.get(this.getCtx(), AD_Column_ID);
            for (int i2 = 0; i2 < this.m_excludeSerNos.length; ++i2) {
                if (this.m_excludeSerNos[i2].getAD_Table_ID() != column.getAD_Table_ID() || this.m_excludeSerNos[i2].isSOTrx() != isSOTrx) continue;
                return true;
            }
        }
        return false;
    }

    public String getLotCharStart() {
        String s = super.getLotCharSOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "\u00ab";
    }

    public String getLotCharEnd() {
        String s = super.getLotCharEOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "\u00bb";
    }

    public String getSerNoCharStart() {
        String s = super.getSerNoCharSOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "#";
    }

    public String getSerNoCharEnd() {
        String s = super.getSerNoCharEOverwrite();
        if (s != null && s.length() == 1 && !s.equals(" ")) {
            return s;
        }
        return "";
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (!this.isInstanceAttribute() && (this.isSerNo() || this.isLot() || this.isGuaranteeDate())) {
            this.setIsInstanceAttribute(true);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        String sql;
        int no;
        if (!this.isInstanceAttribute() && (no = DB.executeUpdate(sql = "UPDATE M_AttributeSet mas SET IsInstanceAttribute='Y' WHERE M_AttributeSet_ID=" + this.getM_AttributeSet_ID() + " AND IsInstanceAttribute='N'" + " AND (IsSerNo='Y' OR IsLot='Y' OR IsGuaranteeDate='Y'" + " OR EXISTS (SELECT * FROM M_AttributeUse mau" + " INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) " + "WHERE mau.M_AttributeSet_ID=mas.M_AttributeSet_ID" + " AND mau.IsActive='Y' AND ma.IsActive='Y'" + " AND ma.IsInstanceAttribute='Y')" + ")", this.get_TrxName())) != 0) {
            this.log.warning("Set Instance Attribute");
            this.setIsInstanceAttribute(true);
        }
        if (this.isInstanceAttribute() && !this.isSerNo() && !this.isLot() && !this.isGuaranteeDate() && (no = DB.executeUpdate(sql = "UPDATE M_AttributeSet mas SET IsInstanceAttribute='N' WHERE M_AttributeSet_ID=" + this.getM_AttributeSet_ID() + " AND IsInstanceAttribute='Y'" + "\tAND IsSerNo='N' AND IsLot='N' AND IsGuaranteeDate='N'" + " AND NOT EXISTS (SELECT * FROM M_AttributeUse mau" + " INNER JOIN M_Attribute ma ON (mau.M_Attribute_ID=ma.M_Attribute_ID) " + "WHERE mau.M_AttributeSet_ID=mas.M_AttributeSet_ID" + " AND mau.IsActive='Y' AND ma.IsActive='Y'" + " AND ma.IsInstanceAttribute='Y')", this.get_TrxName())) != 0) {
            this.log.warning("Reset Instance Attribute");
            this.setIsInstanceAttribute(false);
        }
        return success;
    }
}

