/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.grid.ed.Calendar;
import org.compiere.grid.ed.MDocDate;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VOvrCaret;
import org.compiere.grid.ed.ValuePreference;
import org.compiere.model.GridField;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;

public class VDate
extends JComponent
implements VEditor,
ActionListener,
KeyListener,
FocusListener {
    private static final long serialVersionUID = -9090302458969544529L;
    private String m_columnName;
    protected int m_displayType = 15;
    private String m_title;
    private boolean m_setting;
    private String m_oldText;
    private String m_initialText;
    private SimpleDateFormat m_format;
    private boolean m_readWrite;
    private boolean m_mandatory;
    private CTextField m_text = new CTextField(12);
    private CButton m_button = new CButton();
    JPopupMenu popupMenu = new JPopupMenu();
    private GridField m_mField = null;
    private static CLogger log = CLogger.getCLogger(VDate.class);

    public VDate() {
        this(15);
    }

    public VDate(int displayType) {
        this("Date", false, false, true, displayType, "Date");
    }

    public VDate(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, int displayType, String title) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.m_title = title;
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setFocusable(false);
        this.setPreferredSize(this.m_text.getPreferredSize());
        int height = this.m_text.getPreferredSize().height;
        this.setMinimumSize(new Dimension(30, height));
        VDate_mouseAdapter mouse = new VDate_mouseAdapter(this);
        this.m_text.addMouseListener(mouse);
        this.m_text.setBorder(null);
        this.m_text.setHorizontalAlignment(11);
        if (this.m_displayType == 15) {
            this.m_text.addFocusListener(this);
            this.m_text.addKeyListener(this);
            this.m_text.setCaret(new VOvrCaret());
        } else if (this.m_displayType == 16) {
            this.m_text.setColumns(20);
        }
        this.setMandatory(mandatory);
        this.add((Component)this.m_text, "Center");
        if (displayType == 16 || displayType == 24) {
            this.m_displayType = displayType;
        }
        this.setFormat();
        this.m_button.setIcon(Env.getImageIcon("Calendar10.gif"));
        this.m_button.setMargin(new Insets(0, 0, 0, 0));
        this.m_button.setPreferredSize(new Dimension(height, height));
        this.m_button.addActionListener(this);
        this.m_button.setFocusable(false);
        this.add((Component)this.m_button, "East");
        this.setPreferredSize(this.getPreferredSize());
        if (isReadOnly || !isUpdateable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
    }

    @Override
    public void dispose() {
        this.m_text = null;
        this.m_button = null;
        this.m_mField = null;
    }

    protected void setDocument(Document doc) {
        this.m_text.setDocument(doc);
    }

    @Override
    public void setReadWrite(boolean value) {
        this.m_readWrite = value;
        if (this.m_displayType == 15) {
            this.m_text.setReadWrite(value);
        } else {
            this.m_text.setEditable(false);
            this.m_text.setFocusable(false);
            this.setBackground(false);
        }
        if (this.m_button.isVisible() != value) {
            this.m_button.setVisible(value);
        }
        if (this.m_button.isEnabled() != value) {
            this.m_button.setEnabled(value);
        }
    }

    @Override
    public boolean isReadWrite() {
        return this.m_readWrite;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
        this.m_text.setMandatory(mandatory);
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.m_text.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.m_readWrite) {
            this.m_text.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.m_mandatory) {
            this.m_text.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.m_text.setBackground(AdempierePLAF.getFieldBackground_Normal());
        }
    }

    @Override
    public void setForeground(Color fg) {
        this.m_text.setForeground(fg);
    }

    public void setFormat() {
        this.m_format = DisplayType.getDateFormat(this.m_displayType);
        if (this.m_displayType == 15) {
            this.m_text.setDocument(new MDocDate(this.m_displayType, this.m_format, this.m_text, this.m_title));
        }
    }

    @Override
    public void requestFocus() {
        this.m_text.requestFocus();
    }

    @Override
    public void setValue(Object value) {
        log.finest("Value=" + value);
        this.m_oldText = "";
        if (value != null) {
            if (value instanceof Date) {
                this.m_oldText = this.m_format.format(value);
            } else {
                String strValue = value.toString();
                try {
                    Date date = DisplayType.getDateFormat_JDBC().parse(strValue);
                    this.m_oldText = this.m_format.format(date);
                }
                catch (ParseException pe0) {
                    try {
                        Date date = this.m_format.parse(strValue);
                        this.m_oldText = this.m_format.format(date);
                    }
                    catch (ParseException pe1) {
                        log.log(Level.SEVERE, "setValue - " + pe1.getMessage());
                        this.m_oldText = "";
                    }
                }
            }
        }
        if (this.m_setting) {
            return;
        }
        this.m_text.setText(this.m_oldText);
        this.m_initialText = this.m_oldText;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public Timestamp getTimestamp() {
        if (this.m_text == null) {
            return null;
        }
        String value = this.m_text.getText();
        if (value == null || value.length() == 0) {
            return null;
        }
        Timestamp ts = null;
        try {
            Date date = this.m_format.parse(value);
            ts = new Timestamp(date.getTime());
        }
        catch (ParseException pe) {
            log.fine(pe.getMessage());
        }
        return ts;
    }

    @Override
    public Object getValue() {
        return this.getTimestamp();
    }

    @Override
    public String getDisplay() {
        return this.m_text.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ValuePreference")) {
            if (MRole.getDefault().isShowPreference()) {
                ValuePreference.start(this.m_mField, this.getValue(), this.getDisplay());
            }
            return;
        }
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        if (e.getSource() == this.m_button) {
            this.m_button.setEnabled(false);
            this.setValue(VDate.startCalendar(this, this.getTimestamp(), this.m_format, this.m_displayType, this.m_title));
            try {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, this.getValue());
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.m_button.setEnabled(true);
            this.m_text.requestFocus();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        log.finest("Key=" + e.getKeyCode() + " - " + e.getKeyChar() + " -> " + this.m_text.getText());
        if (e.getKeyCode() == 27) {
            this.m_text.setText(this.m_initialText);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.m_setting = true;
        try {
            Timestamp ts = this.getTimestamp();
            if (ts == null) {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, null);
            } else {
                this.fireVetoableChange(this.m_columnName, this.m_oldText, ts);
            }
        }
        catch (PropertyVetoException pve) {
            // empty catch block
        }
        this.m_setting = false;
        if (e.isTemporary()) {
            return;
        }
        if (this.m_text == null || this.m_text.getText() == null) {
            return;
        }
        Object value = this.getValue();
        if (value == null && this.isMandatory()) {
            Timestamp ts = VDate.startCalendar(this, this.getTimestamp(), this.m_format, this.m_displayType, this.m_title);
            if (ts != null) {
                this.setValue(ts);
            } else {
                this.setValue(this.m_oldText);
            }
        } else {
            this.setValue(value);
        }
    }

    public static Timestamp startCalendar(Container jc, Timestamp value, SimpleDateFormat format, int displayType, String title) {
        log.config("Date=" + value);
        JFrame frame = Env.getFrame(jc);
        Calendar cal = new Calendar((Frame)frame, title, value, displayType);
        AEnv.showCenterWindow(frame, cal);
        Timestamp result = cal.getTimestamp();
        log.config("Result=" + result);
        if (result == null) {
            result = value;
        } else if (result.compareTo(new Timestamp(-1L)) == 0) {
            result = null;
        }
        cal = null;
        return result;
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null && MRole.getDefault().isShowPreference()) {
            ValuePreference.addMenu(this, this.popupMenu);
        }
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_text.setEnabled(enabled);
        this.m_button.setEnabled(enabled);
        if (enabled) {
            this.m_button.setReadWrite(this.m_readWrite);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    class VDate_mouseAdapter
    extends MouseAdapter {
        private VDate adaptee;

        VDate_mouseAdapter(VDate adaptee) {
            this.adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

