/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.grid.ed.AutoCompletion;
import org.compiere.grid.ed.MinuteModel;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class Calendar
extends CDialog
implements ActionListener,
MouseListener,
ChangeListener,
KeyListener {
    private static final long serialVersionUID = -1547404617639717922L;
    private int m_displayType;
    private GregorianCalendar m_calendar;
    private boolean m_hasAM_PM = false;
    private CButton[] m_days;
    private CButton m_today;
    private int m_firstDay;
    private int m_currentDay;
    private int m_currentMonth;
    private int m_currentYear;
    private int m_current24Hour = 0;
    private int m_currentMinute = 0;
    private boolean m_setting = true;
    private boolean m_abort = true;
    private boolean m_cancel = false;
    private boolean m_clear = false;
    private long m_lastClick = System.currentTimeMillis();
    private int m_lastDay = -1;
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    private static CLogger log = CLogger.getCLogger(Calendar.class);
    private CPanel mainPanel = new CPanel();
    private CPanel monthPanel = new CPanel();
    private CComboBox cMonth = new CComboBox();
    private JSpinner cYear = new JSpinner(new SpinnerNumberModel(2000, 1900, 2100, 1));
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel dayPanel = new CPanel();
    private GridLayout dayLayout = new GridLayout();
    private GridBagLayout monthLayout = new GridBagLayout();
    private CButton bNext = new CButton();
    private CButton bBack = new CButton();
    private CPanel timePanel = new CPanel();
    private CComboBox fHour = new CComboBox(this.getHours());
    private CLabel lTimeSep = new CLabel();
    private JSpinner fMinute = new JSpinner(new MinuteModel(5));
    private JCheckBox cbPM = new JCheckBox();
    private JLabel lTZ = new JLabel();
    private CButton bOK = new CButton();
    private GridBagLayout timeLayout = new GridBagLayout();
    private boolean userTime = true;

    public Calendar(Frame frame) {
        this(frame, Msg.getMsg(Env.getCtx(), "Calendar"), null, 15);
    }

    public Calendar(Frame frame, String title, Timestamp startTS, int displayType) {
        super(frame, title, true);
        log.info(startTS == null ? "null" : startTS.toString() + " - DT=" + displayType);
        this.m_displayType = displayType;
        try {
            this.jbInit();
            this.setDefaultCloseOperation(2);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Calendar", ex);
        }
        this.loadData(startTS);
    }

    private void jbInit() throws Exception {
        this.addKeyListener(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainLayout.setHgap(2);
        this.mainLayout.setVgap(2);
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 2));
        this.getContentPane().add(this.mainPanel);
        this.monthPanel.setLayout(this.monthLayout);
        this.monthPanel.add((Component)this.bBack, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.monthPanel.add((Component)this.cYear, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 14, 2, new Insets(0, 5, 0, 0), 0, 0));
        this.monthPanel.add((Component)this.bNext, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.monthPanel.add((Component)this.cMonth, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.monthPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        this.mainPanel.add((Component)this.monthPanel, "North");
        this.cMonth.addActionListener(this);
        this.cYear.addChangeListener(this);
        this.bBack.setIcon(Env.getImageIcon("Parent16.gif"));
        this.bBack.setMargin(new Insets(0, 0, 0, 0));
        this.bBack.addActionListener(this);
        this.bNext.setIcon(Env.getImageIcon("Detail16.gif"));
        this.bNext.setMargin(new Insets(0, 0, 0, 0));
        this.bNext.addActionListener(this);
        this.dayPanel.setLayout(this.dayLayout);
        this.dayLayout.setColumns(7);
        this.dayLayout.setHgap(2);
        this.dayLayout.setRows(7);
        this.dayLayout.setVgap(2);
        this.dayPanel.setBackground(Color.white);
        this.dayPanel.setOpaque(true);
        this.mainPanel.add((Component)this.dayPanel, "Center");
        this.timePanel.setLayout(this.timeLayout);
        this.lTimeSep.setText(" : ");
        this.timePanel.add((Component)this.fHour, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(0, 6, 0, 0), 0, 0));
        this.timePanel.add((Component)this.lTimeSep, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.timePanel.add((Component)this.fMinute, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.timePanel.add((Component)this.cbPM, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.timePanel.add((Component)this.lTZ, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.timePanel.add((Component)this.bOK, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 6, 0, 2), 0, 0));
        this.mainPanel.add((Component)this.timePanel, "South");
        this.fHour.addKeyListener(this);
        ((JSpinner.DefaultEditor)this.fMinute.getEditor()).getTextField().addKeyListener(this);
        this.fMinute.addChangeListener(this);
        this.cbPM.addActionListener(this);
        this.cbPM.addKeyListener(this);
        this.bOK.setIcon(Env.getImageIcon("Ok16.gif"));
        this.bOK.setMargin(new Insets(0, 1, 0, 1));
        this.bOK.addActionListener(this);
        AutoCompletion.enable(this.fHour);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 200) {
            if (this.m_displayType == 24) {
                this.fHour.requestFocus();
            } else if (this.m_today != null) {
                this.m_today.requestFocus();
            }
        }
    }

    private void loadData(Timestamp startTS) {
        int i;
        this.m_calendar = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        if (startTS == null) {
            this.m_calendar.setTimeInMillis(System.currentTimeMillis());
        } else {
            this.m_calendar.setTime(startTS);
        }
        if (this.m_displayType == 24) {
            this.m_calendar.set(1970, 1, 1);
        }
        this.m_firstDay = this.m_calendar.getFirstDayOfWeek();
        Locale loc = Language.getLoginLanguage().getLocale();
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        SimpleDateFormat formatTime = (SimpleDateFormat)DateFormat.getTimeInstance(3, loc);
        boolean bl = this.m_hasAM_PM = formatTime.toPattern().indexOf(97) != -1;
        if (this.m_hasAM_PM) {
            this.cbPM.setText(formatTime.getDateFormatSymbols().getAmPmStrings()[1]);
        } else {
            this.cbPM.setVisible(false);
        }
        this.m_currentYear = this.m_calendar.get(1);
        this.cYear.setEditor(new JSpinner.NumberEditor(this.cYear, "0000"));
        this.cYear.setValue(new Integer(this.m_currentYear));
        String[] months = formatDate.getDateFormatSymbols().getMonths();
        for (int i2 = 0; i2 < months.length; ++i2) {
            KeyNamePair p2 = new KeyNamePair(i2 + 1, months[i2]);
            if (months[i2].equals("")) continue;
            this.cMonth.addItem(p2);
        }
        this.m_currentMonth = this.m_calendar.get(2) + 1;
        this.cMonth.setSelectedIndex(this.m_currentMonth - 1);
        String[] days = formatDate.getDateFormatSymbols().getShortWeekdays();
        for (i = this.m_firstDay; i < 7 + this.m_firstDay; ++i) {
            int index = i > 7 ? i - 7 : i;
            this.dayPanel.add((Component)this.createWeekday(days[index]), null);
        }
        this.m_days = new CButton[42];
        this.m_currentDay = this.m_calendar.get(5);
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                int index = i * 7 + j;
                this.m_days[index] = this.createDay();
                this.dayPanel.add((Component)this.m_days[index], null);
            }
        }
        this.m_days[this.m_days.length - 1].setBackground(Color.green);
        this.m_days[this.m_days.length - 1].setText("*");
        this.m_days[this.m_days.length - 1].setToolTipText(Msg.getMsg(Env.getCtx(), "Today"));
        this.m_days[this.m_days.length - 2].setBackground(Color.red);
        this.m_days[this.m_days.length - 2].setText("x");
        this.m_days[this.m_days.length - 2].setToolTipText(Msg.getMsg(Env.getCtx(), "Cancel"));
        this.m_days[this.m_days.length - 3].setBackground(Color.yellow);
        this.m_days[this.m_days.length - 3].setText("c");
        this.m_days[this.m_days.length - 3].setToolTipText(Msg.getMsg(Env.getCtx(), "Clear"));
        this.m_current24Hour = this.m_calendar.get(11);
        this.m_currentMinute = this.m_calendar.get(12);
        this.timePanel.setVisible(this.m_displayType == 16 || this.m_displayType == 24);
        this.monthPanel.setVisible(this.m_displayType != 24);
        this.dayPanel.setVisible(this.m_displayType != 24);
        this.m_setting = false;
        this.setCalendar();
        this.userTime = false;
    }

    private JLabel createWeekday(String title) {
        JLabel label = new JLabel(title);
        label.setHorizontalAlignment(0);
        label.setHorizontalTextPosition(0);
        label.setRequestFocusEnabled(false);
        label.setBackground(AdempierePLAF.getPrimary1());
        label.setForeground(Color.white);
        label.setOpaque(true);
        return label;
    }

    private CButton createDay() {
        CButton button = new CButton();
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setHorizontalTextPosition(0);
        button.setMargin(ZERO_INSETS);
        button.addActionListener(this);
        button.addMouseListener(this);
        button.addKeyListener(this);
        button.setFocusPainted(false);
        button.putClientProperty("Plastic.is3D", Boolean.FALSE);
        return button;
    }

    private Object[] getHours() {
        Locale loc = Language.getLoginLanguage().getLocale();
        SimpleDateFormat formatTime = (SimpleDateFormat)DateFormat.getTimeInstance(3, loc);
        this.m_hasAM_PM = formatTime.toPattern().indexOf(97) != -1;
        Object[] retValue = new Object[this.m_hasAM_PM ? 12 : 24];
        if (this.m_hasAM_PM) {
            int i;
            retValue[0] = "12";
            for (i = 1; i < 10; ++i) {
                retValue[i] = " " + String.valueOf(i);
            }
            for (i = 10; i < 12; ++i) {
                retValue[i] = String.valueOf(i);
            }
        } else {
            int i;
            for (i = 0; i < 10; ++i) {
                retValue[i] = "0" + String.valueOf(i);
            }
            for (i = 10; i < 24; ++i) {
                retValue[i] = String.valueOf(i);
            }
        }
        return retValue;
    }

    private void setCalendar() {
        if (this.m_setting) {
            return;
        }
        this.m_setting = true;
        this.cMonth.setSelectedIndex(this.m_currentMonth - 1);
        this.cYear.setValue(new Integer(this.m_currentYear));
        this.m_setting = false;
        this.m_calendar.set(this.m_currentYear, this.m_currentMonth - 1, 1);
        int dayOne = this.m_calendar.get(7);
        int lastDate = this.m_calendar.getActualMaximum(5);
        if ((dayOne -= this.m_firstDay) < 0) {
            dayOne += 7;
        }
        lastDate += dayOne - 1;
        int curDay = 1;
        for (int i = 0; i < this.m_days.length - 3; ++i) {
            if (i >= dayOne && i <= lastDate) {
                if (this.m_currentDay == curDay) {
                    this.m_days[i].setBackground(Color.blue);
                    this.m_days[i].setForeground(Color.yellow);
                    this.m_today = this.m_days[i];
                    this.m_today.requestFocus();
                } else {
                    this.m_days[i].setBackground(Color.white);
                    this.m_days[i].setForeground(Color.black);
                }
                this.m_days[i].setText(String.valueOf(curDay++));
                this.m_days[i].setReadWrite(true);
                continue;
            }
            this.m_days[i].setText("");
            this.m_days[i].setReadWrite(false);
            this.m_days[i].setBackground(AdempierePLAF.getFieldBackground_Inactive());
        }
        if (!this.userTime) {
            this.m_current24Hour = 0;
            this.m_currentMinute = 0;
        }
        boolean pm = this.m_current24Hour > 11;
        int index = this.m_current24Hour;
        if (pm && this.m_hasAM_PM) {
            index -= 12;
        }
        if (index < 0 || index >= this.fHour.getItemCount()) {
            index = 0;
        }
        this.fHour.setSelectedIndex(index);
        int m = this.m_currentMinute;
        this.fMinute.setValue(new Integer(m));
        this.cbPM.setSelected(pm);
        TimeZone tz = this.m_calendar.getTimeZone();
        this.lTZ.setText(tz.getDisplayName(tz.inDaylightTime(this.m_calendar.getTime()), 0));
        this.m_calendar.set(this.m_currentYear, this.m_currentMonth - 1, this.m_currentDay, this.m_current24Hour, this.m_currentMinute, 0);
        this.m_calendar.set(14, 0);
    }

    private void setTime() {
        Integer ii;
        int h = this.fHour.getSelectedIndex();
        if (h != this.m_current24Hour) {
            this.userTime = true;
        }
        this.m_current24Hour = h;
        if (this.m_hasAM_PM && this.cbPM.isSelected()) {
            this.m_current24Hour += 12;
        }
        if (this.m_current24Hour < 0 || this.m_current24Hour > 23) {
            this.m_current24Hour = 0;
        }
        if (this.m_currentMinute != (ii = (Integer)this.fMinute.getValue())) {
            this.userTime = true;
        }
        this.m_currentMinute = ii;
        if (this.m_currentMinute < 0 || this.m_currentMinute > 59) {
            this.m_currentMinute = 0;
        }
    }

    public Timestamp getTimestamp() {
        this.m_calendar.set(this.m_currentYear, this.m_currentMonth - 1, this.m_currentDay, this.m_current24Hour, this.m_currentMinute, 0);
        this.m_calendar.set(14, 0);
        if (this.m_abort || this.m_cancel) {
            if (this.m_clear) {
                return new Timestamp(-1L);
            }
            return null;
        }
        long time = this.m_calendar.getTimeInMillis();
        if (this.m_displayType == 15) {
            time = new Date(time).getTime();
        } else if (this.m_displayType == 24) {
            time = new Time(time).getTime();
        }
        return new Timestamp(time);
    }

    public boolean isCancel() {
        return this.m_cancel;
    }

    public boolean isClear() {
        return this.m_clear;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_setting) {
            return;
        }
        this.setTime();
        if (e.getSource() == this.bOK) {
            this.m_abort = false;
            this.dispose();
            return;
        }
        if (e.getSource() == this.bBack) {
            if (--this.m_currentMonth < 1) {
                this.m_currentMonth = 12;
                --this.m_currentYear;
            }
            this.m_lastDay = -1;
        } else if (e.getSource() == this.bNext) {
            if (++this.m_currentMonth > 12) {
                this.m_currentMonth = 1;
                ++this.m_currentYear;
            }
            this.m_lastDay = -1;
        } else if (e.getSource() instanceof JButton) {
            JButton b = (JButton)e.getSource();
            String text = b.getText();
            if (text.equals("*")) {
                this.m_calendar.setTime(new Timestamp(System.currentTimeMillis()));
                this.m_currentDay = this.m_calendar.get(5);
                this.m_currentMonth = this.m_calendar.get(2) + 1;
                this.m_currentYear = this.m_calendar.get(1);
                this.m_current24Hour = this.m_calendar.get(11);
                this.m_currentMinute = this.m_calendar.get(12);
            } else {
                if (text.equals("x")) {
                    this.m_cancel = true;
                    this.dispose();
                    return;
                }
                if (text.equals("c")) {
                    this.m_clear = true;
                    this.dispose();
                    return;
                }
                if (text.length() > 0) {
                    this.m_currentDay = Integer.parseInt(text);
                    long currentClick = System.currentTimeMillis();
                    if (this.m_currentDay == this.m_lastDay && currentClick - this.m_lastClick < 1000L) {
                        this.m_abort = false;
                        this.dispose();
                        return;
                    }
                    this.m_lastClick = currentClick;
                    this.m_lastDay = this.m_currentDay;
                }
            }
        } else if (e.getSource() == this.cbPM) {
            this.setTime();
            this.m_lastDay = -1;
        } else {
            this.m_currentMonth = this.cMonth.getSelectedIndex() + 1;
            this.m_lastDay = -1;
        }
        this.setCalendar();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.m_setting) {
            return;
        }
        if (e.getSource() == this.fMinute) {
            this.setTime();
            return;
        }
        this.m_currentYear = (Integer)this.cYear.getValue();
        this.m_lastDay = -1;
        this.setCalendar();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.m_abort = false;
            this.dispose();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getKeyCode() == 34) {
                if (++this.m_currentMonth > 12) {
                    this.m_currentMonth = 1;
                    ++this.m_currentYear;
                }
                this.setCalendar();
                return;
            }
            if (e.getKeyCode() == 33) {
                if (--this.m_currentMonth < 1) {
                    this.m_currentMonth = 12;
                    --this.m_currentYear;
                }
                this.setCalendar();
                return;
            }
            int offset = 0;
            if (e.getKeyCode() == 39) {
                offset = 1;
            } else if (e.getKeyCode() == 37) {
                offset = -1;
            } else if (e.getKeyCode() == 38) {
                offset = -7;
            } else if (e.getKeyCode() == 40) {
                offset = 7;
            }
            if (offset != 0) {
                System.out.println(this.m_calendar.getTime() + "  offset=" + offset);
                this.m_calendar.add(6, offset);
                System.out.println(this.m_calendar.getTime());
                this.m_currentDay = this.m_calendar.get(5);
                this.m_currentMonth = this.m_calendar.get(2) + 1;
                this.m_currentYear = this.m_calendar.get(1);
                this.setCalendar();
                return;
            }
            this.actionPerformed(new ActionEvent(e.getSource(), 1001, ""));
        }
        if (e.getKeyCode() == 10) {
            this.m_abort = false;
            this.setTime();
            this.dispose();
            return;
        }
        if (e.getKeyCode() == 27) {
            this.m_cancel = true;
            this.dispose();
            return;
        }
        this.setTime();
        this.m_lastDay = -1;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }
}

