/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import org.compiere.swing.CComboBox;
import org.compiere.util.Util;

public class AutoCompletion
extends PlainDocument {
    private static final long serialVersionUID = 1449135613844313889L;
    CComboBox comboBox;
    ComboBoxModel model;
    JTextComponent editor;
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    private boolean m_strictMode = true;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;

    public AutoCompletion(final CComboBox comboBox) {
        this.comboBox = comboBox;
        this.model = comboBox.getModel();
        comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutoCompletion.this.selecting) {
                    AutoCompletion.this.highlightCompletedText(0);
                }
            }
        });
        comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("editor")) {
                    AutoCompletion.this.configureEditor((ComboBoxEditor)e.getNewValue());
                }
                if (e.getPropertyName().equals("model")) {
                    AutoCompletion.this.model = (ComboBoxModel)e.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyChar() == '\uffff') {
                    return;
                }
                if (e.getKeyCode() == 27) {
                    return;
                }
                if (comboBox.isDisplayable()) {
                    comboBox.setPopupVisible(true);
                }
                if (!AutoCompletion.this.m_strictMode) {
                    return;
                }
                AutoCompletion.this.hitBackspace = false;
                switch (e.getKeyCode()) {
                    case 8: {
                        AutoCompletion.this.hitBackspace = true;
                        AutoCompletion.this.hitBackspaceOnSelection = AutoCompletion.this.editor.getSelectionStart() != AutoCompletion.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        e.consume();
                        UIManager.getLookAndFeel().provideErrorFeedback(comboBox);
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletion.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (AutoCompletion.this.hidePopupOnFocusLoss) {
                    comboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(comboBox.getEditor());
        Object selected = comboBox.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        this.highlightCompletedText(0);
    }

    public static void enable(CComboBox comboBox) {
        AutoCompletion.enable(comboBox, true);
    }

    public static void enable(CComboBox comboBox, boolean strictMode) {
        comboBox.setEditable(true);
        AutoCompletion ac = new AutoCompletion(comboBox);
        ac.setStrictMode(strictMode);
    }

    void configureEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (newEditor != null) {
            this.editor = (JTextComponent)newEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (offs > 0) {
                if (this.hitBackspaceOnSelection) {
                    --offs;
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.comboBox);
            }
            this.highlightCompletedText(offs);
        } else {
            super.remove(offs, len);
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(offs, str, a2);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        if (item != null) {
            this.setSelectedItem(item);
        } else if (this.m_strictMode) {
            if (offs == 0) {
                this.setSelectedItem(null);
            } else {
                item = this.comboBox.getSelectedItem();
            }
            offs -= str.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.comboBox);
        } else {
            return;
        }
        if (item != null) {
            this.setText(item.toString());
        } else {
            this.setText("");
        }
        this.highlightCompletedText(offs + str.length());
    }

    public void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.getLength());
        if (this.getLength() < start) {
            start = this.getLength();
        }
        this.editor.moveCaretPosition(start);
    }

    private void setSelectedItem(Object item) {
        this.selecting = true;
        this.model.setSelectedItem(item);
        this.selecting = false;
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.model.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
            return selectedItem;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.model.getElementAt(i);
            if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
            return currentItem;
        }
        return null;
    }

    public void setStrictMode(boolean mode) {
        this.m_strictMode = mode;
    }

    protected boolean startsWithIgnoreCase(String str1, String str2) {
        String s1 = Util.stripDiacritics(str1.toUpperCase()).replaceAll("^\\s+", "");
        String s2 = Util.stripDiacritics(str2.toUpperCase()).replaceAll("^\\s+", "");
        return s1.startsWith(s2);
    }
}

