/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.compiere.apps.ADialog;
import org.compiere.apps.APanel;
import org.compiere.grid.APanelTab;
import org.compiere.model.MRole;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;

public class VSortTab
extends CPanel
implements APanelTab {
    private static final long serialVersionUID = -2133358506913610514L;
    static CLogger log = CLogger.getCLogger(VSortTab.class);
    private int m_WindowNo;
    private int m_AD_Table_ID;
    private String m_TableName = null;
    private String m_ColumnSortName = null;
    private String m_ColumnYesNoName = null;
    private String m_KeyColumnName = null;
    private String m_IdentifierSql = null;
    private boolean m_IdentifierTranslated = false;
    private String m_ParentColumnName = null;
    private APanel m_aPanel = null;
    private GridBagLayout mainLayout = new GridBagLayout();
    private CLabel noLabel = new CLabel();
    private CLabel yesLabel = new CLabel();
    private CButton bAdd = new CButton();
    private CButton bRemove = new CButton();
    private CButton bUp = new CButton();
    private CButton bDown = new CButton();
    DefaultListModel noModel = new DefaultListModel(){
        private static final long serialVersionUID = 2171680655634744697L;

        public void addElement(Object obj) {
            Object[] elements = this.toArray();
            Arrays.sort(elements);
            int index = Arrays.binarySearch(elements, obj);
            if (index < 0) {
                index = -1 * index - 1;
            }
            if (index > elements.length) {
                super.addElement(obj);
            } else {
                super.add(index, obj);
            }
        }

        public void add(int index, Object obj) {
            this.addElement(obj);
        }
    };
    DefaultListModel yesModel = new DefaultListModel();
    DefaultListCellRenderer listRenderer = new DefaultListCellRenderer(){
        private static final long serialVersionUID = -101524191283634472L;

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof ListItem && !((ListItem)value).isUpdateable()) {
                Font f = c.getFont();
                c.setFont(f.deriveFont(f.getStyle() | 2));
                c.setFocusable(false);
            }
            return c;
        }
    };
    JList noList = new JList(this.noModel);
    JList yesList = new JList(this.yesModel);
    private JScrollPane noPane = new JScrollPane(this.noList);
    private JScrollPane yesPane = new JScrollPane(this.yesList);

    public VSortTab(int WindowNo, int AD_Table_ID, int AD_ColumnSortOrder_ID, int AD_ColumnSortYesNo_ID) {
        log.config("SortOrder=" + AD_ColumnSortOrder_ID + ", SortYesNo=" + AD_ColumnSortYesNo_ID);
        this.m_WindowNo = WindowNo;
        try {
            this.jbInit();
            this.dynInit(AD_Table_ID, AD_ColumnSortOrder_ID, AD_ColumnSortYesNo_ID);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dynInit(int AD_Table_ID, int AD_ColumnSortOrder_ID, int AD_ColumnSortYesNo_ID) {
        boolean trl;
        this.m_AD_Table_ID = AD_Table_ID;
        int identifiersCount = 0;
        StringBuffer identifierSql = new StringBuffer();
        String sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, e.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated FROM AD_Table t, AD_Column c, AD_Element e WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=? OR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=e.AD_Element_ID";
        boolean bl = trl = !Env.isBaseLanguage(Env.getCtx(), "AD_Element");
        if (trl) {
            sql = "SELECT t.TableName, c.AD_Column_ID, c.ColumnName, et.Name,c.IsParent, c.IsKey, c.IsIdentifier, c.IsTranslated FROM AD_Table t, AD_Column c, AD_Element_Trl et WHERE t.AD_Table_ID=? AND t.AD_Table_ID=c.AD_Table_ID AND (c.AD_Column_ID=? OR AD_Column_ID=?\tOR c.IsParent='Y' OR c.IsKey='Y' OR c.IsIdentifier='Y') AND c.AD_Element_ID=et.AD_Element_ID AND et.AD_Language=?";
        }
        sql = sql + " ORDER BY c.SeqNo";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_Table_ID);
            pstmt.setInt(2, AD_ColumnSortOrder_ID);
            pstmt.setInt(3, AD_ColumnSortYesNo_ID);
            if (trl) {
                pstmt.setString(4, Env.getAD_Language(Env.getCtx()));
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.m_TableName = rs.getString(1);
                if (AD_ColumnSortOrder_ID == rs.getInt(2)) {
                    log.fine("Sort=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_ColumnSortName = rs.getString(3);
                    this.yesLabel.setText(rs.getString(4));
                    continue;
                }
                if (AD_ColumnSortYesNo_ID == rs.getInt(2)) {
                    log.fine("YesNo=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_ColumnYesNoName = rs.getString(3);
                    continue;
                }
                if (rs.getString(5).equals("Y")) {
                    log.fine("Parent=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_ParentColumnName = rs.getString(3);
                    continue;
                }
                if (rs.getString(6).equals("Y")) {
                    log.fine("Key=" + rs.getString(1) + "." + rs.getString(3));
                    this.m_KeyColumnName = rs.getString(3);
                    continue;
                }
                if (rs.getString(7).equals("Y")) {
                    boolean isTranslated;
                    log.fine("Identifier=" + rs.getString(1) + "." + rs.getString(3));
                    boolean bl2 = isTranslated = trl && "Y".equals(rs.getString(8));
                    if (identifierSql.length() > 0) {
                        identifierSql.append(",");
                    }
                    identifierSql.append(isTranslated ? "tt." : "t.").append(rs.getString(3));
                    ++identifiersCount;
                    if (!isTranslated) continue;
                    this.m_IdentifierTranslated = true;
                    continue;
                }
                log.fine("??NotUsed??=" + rs.getString(1) + "." + rs.getString(3));
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_IdentifierSql = identifiersCount == 0 ? "NULL" : (identifiersCount == 1 ? identifierSql.toString() : identifierSql.insert(0, "COALESCE(").append(")").toString());
        this.noLabel.setText(Msg.getMsg(Env.getCtx(), "Available"));
        log.fine(this.m_ColumnSortName);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.noLabel.setText("No");
        this.yesLabel.setText("Yes");
        for (MouseMotionListener mml : this.noList.getMouseMotionListeners()) {
            this.noList.removeMouseMotionListener(mml);
        }
        for (MouseMotionListener mml : this.yesList.getMouseMotionListeners()) {
            this.yesList.removeMouseMotionListener(mml);
        }
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                Point p2;
                JList list;
                int index;
                if (me.getClickCount() > 1 && (index = (list = (JList)me.getComponent()).locationToIndex(p2 = me.getPoint())) > -1 && list.getCellBounds(index, index).contains(p2)) {
                    VSortTab.this.migrateValueAcrossLists(me);
                }
            }
        };
        this.yesList.addMouseListener(mouseListener);
        this.noList.addMouseListener(mouseListener);
        this.yesList.setCellRenderer(this.listRenderer);
        this.noList.setCellRenderer(this.listRenderer);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VSortTab.this.migrateValueAcrossLists(ae);
            }
        };
        this.bAdd.setIcon(Env.getImageIcon("Detail24.gif"));
        this.bAdd.setMargin(new Insets(2, 2, 2, 2));
        this.bAdd.addActionListener(actionListener);
        this.bRemove.setIcon(Env.getImageIcon("Parent24.gif"));
        this.bRemove.setMargin(new Insets(2, 2, 2, 2));
        this.bRemove.addActionListener(actionListener);
        DragListener crossListMouseListener = new DragListener();
        this.yesList.addMouseListener(crossListMouseListener);
        this.yesList.addMouseMotionListener(crossListMouseListener);
        this.noList.addMouseListener(crossListMouseListener);
        this.noList.addMouseMotionListener(crossListMouseListener);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                VSortTab.this.migrateValueWithinYesList(ae);
            }
        };
        this.bUp.setIcon(Env.getImageIcon("Previous24.gif"));
        this.bUp.setMargin(new Insets(2, 2, 2, 2));
        this.bUp.addActionListener(actionListener);
        this.bDown.setIcon(Env.getImageIcon("Next24.gif"));
        this.bDown.setMargin(new Insets(2, 2, 2, 2));
        this.bDown.addActionListener(actionListener);
        MouseMotionAdapter yesListMouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent me) {
                Point p2;
                JList list = (JList)me.getComponent();
                int index = list.locationToIndex(p2 = me.getPoint());
                if (index > -1 && list.getCellBounds(index, index).contains(p2)) {
                    VSortTab.this.migrateValueWithinYesList(me);
                }
            }
        };
        this.yesList.addMouseMotionListener(yesListMouseMotionListener);
        this.yesPane.setPreferredSize(new Dimension(200, 300));
        this.yesList.setSelectionMode(2);
        this.noPane.setPreferredSize(new Dimension(200, 300));
        this.noList.setSelectionMode(2);
        this.add((Component)this.noLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.yesLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bDown, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.noPane, new GridBagConstraints(0, 1, 1, 3, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.yesPane, new GridBagConstraints(2, 1, 1, 3, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bUp, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add((Component)this.bRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 4), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData() {
        this.yesModel.removeAllElements();
        this.noModel.removeAllElements();
        boolean isReadWrite = true;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.").append(this.m_KeyColumnName).append(",").append(this.m_IdentifierSql).append(",t.").append(this.m_ColumnSortName).append(", t.AD_Client_ID, t.AD_Org_ID");
        if (this.m_ColumnYesNoName != null) {
            sql.append(",t.").append(this.m_ColumnYesNoName);
        }
        sql.append(" FROM ").append(this.m_TableName).append(" t");
        if (this.m_IdentifierTranslated) {
            sql.append(", ").append(this.m_TableName).append("_Trl tt");
        }
        if (this.m_ParentColumnName != null) {
            sql.append(" WHERE t.").append(this.m_ParentColumnName).append("=?");
        } else {
            sql.append(" WHERE 1=?");
        }
        if (this.m_IdentifierTranslated) {
            sql.append(" AND t.").append(this.m_KeyColumnName).append("=tt.").append(this.m_KeyColumnName).append(" AND tt.AD_Language=?");
        }
        sql.append(" ORDER BY ");
        if (this.m_ColumnYesNoName != null) {
            sql.append("6 DESC,");
        }
        sql.append("3,2");
        int ID = 0;
        if (this.m_ParentColumnName != null) {
            ID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, this.m_ParentColumnName);
            log.fine(sql.toString() + " - ID=" + ID);
        } else {
            ID = 1;
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, ID);
            if (this.m_IdentifierTranslated) {
                pstmt.setString(2, Env.getAD_Language(Env.getCtx()));
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int key = rs.getInt(1);
                String name = rs.getString(2);
                int seq = rs.getInt(3);
                boolean isYes = seq != 0;
                int AD_Client_ID = rs.getInt(4);
                int AD_Org_ID = rs.getInt(5);
                if (this.m_ColumnYesNoName != null) {
                    isYes = rs.getString(6).equals("Y");
                }
                ListItem pp = new ListItem(key, name, seq, isYes, AD_Client_ID, AD_Org_ID);
                if (isYes) {
                    this.yesModel.addElement(pp);
                } else {
                    this.noModel.addElement(pp);
                }
                if (!isYes || pp.isUpdateable()) continue;
                isReadWrite = false;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.setIsChanged(false);
        this.bAdd.setEnabled(isReadWrite);
        this.bRemove.setEnabled(isReadWrite);
        this.bUp.setEnabled(isReadWrite);
        this.bDown.setEnabled(isReadWrite);
        this.yesList.setEnabled(isReadWrite);
        this.noList.setEnabled(isReadWrite);
    }

    private void setIsChanged(boolean value) {
        if (this.m_aPanel != null) {
            this.m_aPanel.aSave.setEnabled(value);
            this.m_aPanel.aIgnore.setEnabled(value);
        }
    }

    void migrateValueAcrossLists(AWTEvent event) {
        Object source = event.getSource();
        Object[] selObjects = source == this.bAdd || source == this.noList ? this.noList.getSelectedValues() : this.yesList.getSelectedValues();
        for (int i = 0; i < selObjects.length; ++i) {
            ListItem selObject = (ListItem)selObjects[i];
            if (selObject == null || !selObject.isUpdateable()) continue;
            DefaultListModel lmFrom = source == this.bAdd || source == this.noList ? this.noModel : this.yesModel;
            DefaultListModel lmTo = lmFrom == this.yesModel ? this.noModel : this.yesModel;
            lmFrom.removeElement(selObject);
            lmTo.addElement(selObject);
            JList list = source == this.bAdd || source == this.noList ? this.yesList : this.noList;
            list.setSelectedValue(selObject, true);
            this.setIsChanged(true);
        }
    }

    void migrateValueWithinYesList(AWTEvent event) {
        Object[] selObjects = this.yesList.getSelectedValues();
        if (selObjects == null) {
            return;
        }
        int length = selObjects.length;
        if (length == 0) {
            return;
        }
        int[] indices = this.yesList.getSelectedIndices();
        boolean change = false;
        Object source = event.getSource();
        if (source == this.bUp) {
            for (int i = 0; i < length; ++i) {
                ListItem selObject = (ListItem)selObjects[i];
                int index = indices[i];
                if (index == 0) break;
                ListItem newObject = (ListItem)this.yesModel.getElementAt(index - 1);
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt(newObject, index);
                    this.yesModel.setElementAt(selObject, index - 1);
                    indices[i] = index - 1;
                    change = true;
                    continue;
                }
                break;
            }
        } else if (source == this.bDown) {
            for (int i = length - 1; i >= 0; --i) {
                ListItem selObject = (ListItem)selObjects[i];
                int index = indices[i];
                if (index >= this.yesModel.size() - 1) break;
                ListItem newObject = (ListItem)this.yesModel.getElementAt(index + 1);
                if (selObject.isUpdateable() && newObject.isUpdateable()) {
                    this.yesModel.setElementAt(newObject, index);
                    this.yesModel.setElementAt(selObject, index + 1);
                    this.yesList.setSelectedIndex(index + 1);
                    indices[i] = index + 1;
                    change = true;
                    continue;
                }
                break;
            }
        } else if (source != this.yesList) {
            log.severe("Unknown source: " + source);
        }
        if (change) {
            this.yesList.setSelectedIndices(indices);
            this.setIsChanged(true);
        }
    }

    @Override
    public void registerAPanel(APanel panel) {
        this.m_aPanel = panel;
    }

    @Override
    public void saveData() {
        if (!this.m_aPanel.aSave.isEnabled()) {
            return;
        }
        log.fine("");
        boolean ok = true;
        StringBuffer info = new StringBuffer();
        StringBuffer sql = null;
        for (int i = 0; i < this.noModel.getSize(); ++i) {
            ListItem pp = (ListItem)this.noModel.getElementAt(i);
            if (!pp.isUpdateable() || pp.getSortNo() == 0 && (this.m_ColumnYesNoName == null || !pp.isYes())) continue;
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.m_TableName).append(" SET ").append(this.m_ColumnSortName).append("=0");
            if (this.m_ColumnYesNoName != null) {
                sql.append(",").append(this.m_ColumnYesNoName).append("='N'");
            }
            sql.append(" WHERE ").append(this.m_KeyColumnName).append("=").append(pp.getKey());
            if (DB.executeUpdate(sql.toString(), null) == 1) {
                pp.setSortNo(0);
                pp.setIsYes(false);
                continue;
            }
            ok = false;
            if (info.length() > 0) {
                info.append(", ");
            }
            info.append(pp.getName());
            log.log(Level.SEVERE, "NoModel - Not updated: " + this.m_KeyColumnName + "=" + pp.getKey());
        }
        int index = 0;
        for (int i = 0; i < this.yesModel.getSize(); ++i) {
            ListItem pp = (ListItem)this.yesModel.getElementAt(i);
            if (!pp.isUpdateable() || pp.getSortNo() == (index += 10) && (this.m_ColumnYesNoName == null || pp.isYes())) continue;
            sql = new StringBuffer();
            sql.append("UPDATE ").append(this.m_TableName).append(" SET ").append(this.m_ColumnSortName).append("=").append(index);
            if (this.m_ColumnYesNoName != null) {
                sql.append(",").append(this.m_ColumnYesNoName).append("='Y'");
            }
            sql.append(" WHERE ").append(this.m_KeyColumnName).append("=").append(pp.getKey());
            if (DB.executeUpdate(sql.toString(), null) == 1) {
                pp.setSortNo(index);
                pp.setIsYes(true);
                continue;
            }
            ok = false;
            if (info.length() > 0) {
                info.append(", ");
            }
            info.append(pp.getName());
            log.log(Level.SEVERE, "YesModel - Not updated: " + this.m_KeyColumnName + "=" + pp.getKey());
        }
        if (ok) {
            this.setIsChanged(false);
        } else {
            ADialog.error(this.m_WindowNo, null, "SaveError", info.toString());
        }
    }

    @Override
    public void unregisterPanel() {
        this.saveData();
        this.m_aPanel = null;
    }

    private class DragListener
    extends MouseInputAdapter {
        private String cursorName = "/org/compiere/images/DragCursor32.gif";
        private JList startList = null;
        private DefaultListModel startModel = null;
        private Object selObject = null;
        private boolean moved = false;
        private Cursor customCursor;

        public DragListener() {
            URL url = VSortTab.class.getResource(this.cursorName);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(url);
            this.customCursor = toolkit.createCustomCursor(image, new Point(0, 0), "Howdy");
        }

        @Override
        public void mousePressed(MouseEvent me) {
            Point p2;
            JList list = (JList)me.getComponent();
            int index = list.locationToIndex(p2 = me.getPoint());
            if (index > -1 && list.getCellBounds(index, index).contains(p2)) {
                this.startList = list;
                this.startModel = list == VSortTab.this.noList ? VSortTab.this.noModel : VSortTab.this.yesModel;
                this.selObject = list.getModel().getElementAt(index);
            }
            if (list == VSortTab.this.noList) {
                VSortTab.this.yesList.clearSelection();
            } else {
                VSortTab.this.noList.clearSelection();
            }
            this.moved = false;
        }

        @Override
        public void mouseDragged(MouseEvent me) {
            if (this.selObject == null || !((ListItem)this.selObject).isUpdateable()) {
                this.moved = false;
                return;
            }
            this.moved = true;
            if (VSortTab.this.getCursor() != this.customCursor) {
                VSortTab.this.setCursor(this.customCursor);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (this.startModel != null && this.moved) {
                int index;
                Point p2 = me.getPoint();
                JList endList = VSortTab.this.yesList;
                DefaultListModel endModel = VSortTab.this.yesModel;
                if (me.getComponent() == VSortTab.this.yesList) {
                    if (!VSortTab.this.yesList.contains(p2)) {
                        endList = VSortTab.this.noList;
                        endModel = VSortTab.this.noModel;
                    }
                } else {
                    if (VSortTab.this.noList.contains(p2)) {
                        VSortTab.this.setCursor(Cursor.getDefaultCursor());
                        this.moved = false;
                        return;
                    }
                    p2 = SwingUtilities.convertPoint(VSortTab.this.noList, p2, VSortTab.this.yesList);
                }
                if ((index = endList.locationToIndex(p2)) > -1) {
                    this.startModel.removeElement(this.selObject);
                    endModel.add(index, this.selObject);
                    this.startList.clearSelection();
                    endList.clearSelection();
                    endList.setSelectedValue(this.selObject, true);
                    VSortTab.this.setIsChanged(true);
                }
            }
            this.startList = null;
            this.startModel = null;
            this.selObject = null;
            this.moved = false;
            VSortTab.this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class ListItem
    extends NamePair {
        private static final long serialVersionUID = 5399675004361331697L;
        private int m_key;
        private int m_AD_Client_ID;
        private int m_AD_Org_ID;
        private int m_sortNo;
        private boolean m_isYes;
        private boolean m_updateable;

        public ListItem(int key, String name, int sortNo, boolean isYes, int AD_Client_ID, int AD_Org_ID) {
            super(name);
            this.m_key = key;
            this.m_AD_Client_ID = AD_Client_ID;
            this.m_AD_Org_ID = AD_Org_ID;
            this.m_sortNo = sortNo;
            this.m_isYes = isYes;
            this.m_updateable = MRole.getDefault().canUpdate(this.m_AD_Client_ID, this.m_AD_Org_ID, VSortTab.this.m_AD_Table_ID, this.m_key, false);
        }

        public int getKey() {
            return this.m_key;
        }

        public void setSortNo(int sortNo) {
            this.m_sortNo = sortNo;
        }

        public int getSortNo() {
            return this.m_sortNo;
        }

        public void setIsYes(boolean value) {
            this.m_isYes = value;
        }

        public boolean isYes() {
            return this.m_isYes;
        }

        public int getAD_Client_ID() {
            return this.m_AD_Client_ID;
        }

        public int getAD_Org_ID() {
            return this.m_AD_Org_ID;
        }

        public boolean isUpdateable() {
            return this.m_updateable;
        }

        @Override
        public String getID() {
            return this.m_key != -1 ? String.valueOf(this.m_key) : null;
        }

        public int hashCode() {
            return this.m_key;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof ListItem) {
                ListItem li = (ListItem)obj;
                return li.getKey() == this.m_key && li.getName() != null && li.getName().equals(this.getName()) && li.getAD_Client_ID() == this.m_AD_Client_ID && li.getAD_Org_ID() == this.m_AD_Org_ID;
            }
            return false;
        }

        @Override
        public String toString() {
            String s = super.toString();
            if (s == null || s.trim().length() == 0) {
                s = "<" + this.getKey() + ">";
            }
            return s;
        }
    }
}

