/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.CreateFromInvoice;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.GridTab;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VCreateFromInvoiceUI
extends CreateFromInvoice
implements ActionListener,
VetoableChangeListener {
    private static final long serialVersionUID = 1L;
    private VCreateFromDialog dialog;
    private String docBaseType;
    int C_BPartner_ID = 0;
    private String valuePTK = "";
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private JLabel bPartnerLabel = new JLabel();
    private VLookup bPartnerField;
    private JLabel orderLabel = new JLabel();
    private JComboBox orderField = new JComboBox();
    private JLabel shipmentLabel = new JLabel();
    private JComboBox shipmentField = new JComboBox();
    private JLabel rmaLabel = new JLabel();
    private JComboBox rmaField = new JComboBox();
    private JCheckBox getPayments = new JCheckBox();
    private CLabel dateFromLabel = new CLabel(Msg.translate(Env.getCtx(), "Fecha Vencimiento"));
    protected VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    protected VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private CLabel bankListLabel = new CLabel("Banco");
    protected JComboBox bankListField = new JComboBox();
    private CLabel payTypeLabel = new CLabel("Tipo Pago");
    protected JComboBox payTypeField = new JComboBox();
    private CLabel NPaymentLabel = new CLabel("N\u00c2\u00b0 Documento");
    protected JTextField NPaymentField = new JTextField();
    private CLabel amtFromLabel = new CLabel("Cantidad");
    protected VNumber amtFromField = new VNumber();
    private CLabel amtToLabel = new CLabel("-");
    protected VNumber amtToField = new VNumber();
    private CLabel dateFromLabelAcct = new CLabel(Msg.translate(Env.getCtx(), "DateAcct"));
    protected VDate dateFromFieldAcct = new VDate("DateFromAcct", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFromAcct"));
    private CLabel dateToLabelAcct = new CLabel("-");
    protected VDate dateToFieldAcct = new VDate("DateToAcct", false, false, true, 15, Msg.translate(Env.getCtx(), "DateToAcct"));
    private JLabel docNoLabel = new JLabel();
    private VLookup docNoField;
    private CLabel REmployeeLabel = new CLabel("Rut Trabajador");
    protected JTextField REmployeeField = new JTextField();
    private CLabel NEmployeeLabel = new CLabel("Solo Nombre");
    protected JTextField NEmployeeField = new JTextField();
    private boolean m_actionActive = false;

    public VCreateFromInvoiceUI(GridTab mTab) {
        super(mTab);
        this.log.info(this.getGridTab().toString());
        Integer docTypeId = (Integer)this.getGridTab().getValue("C_DocTypeTarget_ID");
        MDocType docType = MDocType.get(Env.getCtx(), docTypeId);
        this.docBaseType = docType.getDocBaseType();
        if (this.docBaseType.equals("FAT")) {
            this.wType = 1;
        } else if (this.docBaseType.equals("PTK")) {
            this.wType = 2;
            this.valuePTK = "BA";
            try {
                this.valuePTK = docType.get_ValueAsString("ptkType");
            }
            catch (Exception e) {
                this.valuePTK = "BA";
                this.log.log(Level.SEVERE, "No se pudo setear variable ptkType", e);
            }
            if (this.valuePTK == null || this.valuePTK == "" || this.valuePTK == " ") {
                this.valuePTK = "BA";
            }
        } else {
            this.wType = this.docBaseType.equals("CDC") ? 3 : (this.docBaseType.equals("VDC") ? 4 : (this.docBaseType.equals("PRV") && docType.getName().toLowerCase().contains("nota") ? 6 : (this.docBaseType.equals("PRV") ? 5 : 0)));
        }
        if (this.wType == 2) {
            this.getPay = true;
        }
        this.dialog = new VCreateFromDialog(this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow(Env.getWindow(this.p_WindowNo), this.dialog);
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        CButton refreshButton = ConfirmPanel.createRefreshButton(false);
        refreshButton.setMargin(new Insets(1, 10, 0, 10));
        refreshButton.setDefaultCapable(true);
        refreshButton.addActionListener(this);
        this.dialog.getConfirmPanel().addButton(refreshButton);
        this.dialog.getRootPane().setDefaultButton(refreshButton);
        this.dialog.setTitle(this.getTitle());
        Integer docTypeId = (Integer)this.getGridTab().getValue("C_DocTypeTarget_ID");
        MDocType docType = MDocType.get(Env.getCtx(), docTypeId);
        if (!"APC".equals(docType.getDocBaseType())) {
            this.rmaLabel.setVisible(false);
            this.rmaField.setVisible(false);
        }
        this.initBPartner(true);
        this.bPartnerField.addVetoableChangeListener(this);
        if (this.wType == 5 || this.wType == 6) {
            this.docNoField.addVetoableChangeListener(this);
        }
        Timestamp date = Env.getContextAsDate(Env.getCtx(), this.p_WindowNo, "DateInvoiced");
        this.dateToField.setValue(date);
        this.dateToFieldAcct.setValue(date);
        if (this.wType == 2) {
            this.getPayments.setSelected(true);
            this.bankListLabel.setVisible(true);
            this.bankListField.setVisible(true);
            this.payTypeLabel.setVisible(true);
            this.payTypeField.setVisible(true);
            this.NPaymentLabel.setVisible(true);
            this.NPaymentField.setVisible(true);
            this.amtFromLabel.setVisible(true);
            this.amtFromField.setVisible(true);
            this.amtToLabel.setVisible(true);
            this.amtToField.setVisible(true);
            this.dateFromLabelAcct.setVisible(true);
            this.dateFromFieldAcct.setVisible(true);
            this.dateToLabelAcct.setVisible(true);
            this.dateToFieldAcct.setVisible(true);
        } else {
            this.bankListLabel.setVisible(false);
            this.bankListField.setVisible(false);
            this.payTypeLabel.setVisible(false);
            this.payTypeField.setVisible(false);
            this.NPaymentLabel.setVisible(false);
            this.NPaymentField.setVisible(false);
            this.amtFromLabel.setVisible(false);
            this.amtFromField.setVisible(false);
            this.amtToLabel.setVisible(false);
            this.amtToField.setVisible(false);
            this.dateFromLabelAcct.setVisible(false);
            this.dateFromFieldAcct.setVisible(false);
            this.dateToLabelAcct.setVisible(false);
            this.dateToFieldAcct.setVisible(false);
        }
        return true;
    }

    private void jbInit() throws Exception {
        this.bPartnerLabel.setText(Msg.getElement(Env.getCtx(), "C_BPartner_ID"));
        this.orderLabel.setText(Msg.getElement(Env.getCtx(), "C_Order_ID", false));
        this.shipmentLabel.setText(Msg.getElement(Env.getCtx(), "M_InOut_ID", false));
        this.rmaLabel.setText(Msg.translate(Env.getCtx(), "M_RMA_ID"));
        this.getPayments.setText("Traer Pagos");
        this.dateFromLabel.setLabelFor(this.dateFromField);
        this.dateFromField.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.dateToLabel.setLabelFor(this.dateToField);
        this.dateToField.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.dateFromLabelAcct.setLabelFor(this.dateFromFieldAcct);
        this.dateFromFieldAcct.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.dateToLabelAcct.setLabelFor(this.dateToField);
        this.dateToFieldAcct.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.getPayments.addActionListener(this);
        if (this.wType == 5) {
            this.docNoLabel.setText("Pre-Factura");
        } else if (this.wType == 6) {
            this.docNoLabel.setText("Solicitud");
        }
        int Reference_IDBL = DB.getSQLValue(null, "Select AD_Reference_ID from AD_Reference where upper(name)='BANCOS'");
        String sqlValuesBank = "SELECT name FROM AD_Ref_List WHERE AD_Reference_ID = " + Reference_IDBL;
        String sqlPayType = "select rlt.name from AD_Ref_List rl inner join AD_Ref_List_Trl rlt on (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID) where AD_Reference_ID = 214 AND rlt.ad_language = 'es_CL' AND rl.IsActive = 'Y'";
        this.bankListField.addItem(" ");
        this.payTypeField.addItem(" ");
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sqlValuesBank, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.bankListField.addItem(rs.getString(1));
            }
            CPreparedStatement pstmt2 = DB.prepareStatement(sqlPayType, null);
            ResultSet rs2 = pstmt2.executeQuery();
            while (rs2.next()) {
                this.payTypeField.addItem(rs2.getString(1));
            }
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sqlValuesBank.toString(), e);
        }
        this.amtFromField.setValue(0);
        this.amtToField.setValue(0);
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout(new BorderLayout());
        CPanel parameterStdPanel = new CPanel(new GridBagLayout());
        parameterPanel.add((Component)parameterStdPanel, "Center");
        parameterStdPanel.add((Component)this.bPartnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bPartnerField != null) {
            parameterStdPanel.add((Component)this.bPartnerField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        if (this.wType == 0) {
            parameterStdPanel.add((Component)this.orderLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.orderField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.shipmentLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.shipmentField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.rmaLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.rmaField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        if (this.wType != 0 && this.wType != 5 && this.wType != 6) {
            parameterStdPanel.add((Component)this.getPayments, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        if (this.wType != 0 && this.wType != 5 && this.wType != 6) {
            parameterStdPanel.add((Component)this.dateFromLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateFromField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateToLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateToField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.bankListLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.bankListField, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.payTypeLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.payTypeField, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.NPaymentLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.NPaymentField, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateFromLabelAcct, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateFromFieldAcct, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateToLabelAcct, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateToFieldAcct, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.amtFromLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.amtFromField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.amtToLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.amtToField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        if (this.wType == 5 || this.wType == 6) {
            parameterStdPanel.add((Component)this.docNoLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.docNoField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateFromLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateFromField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateToLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.dateToField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.REmployeeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.REmployeeField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.NEmployeeLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
            parameterStdPanel.add((Component)this.NEmployeeField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.log.config("Action=" + e.getActionCommand());
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        this.log.config("Action=" + e.getActionCommand());
        if (e.getSource().equals(this.orderField)) {
            KeyNamePair pp = (KeyNamePair)this.orderField.getSelectedItem();
            int C_Order_ID = 0;
            if (pp != null) {
                C_Order_ID = pp.getKey();
            }
            this.rmaField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadOrder(C_Order_ID, true);
        } else if (e.getSource().equals(this.shipmentField)) {
            KeyNamePair pp = (KeyNamePair)this.shipmentField.getSelectedItem();
            int M_InOut_ID = 0;
            if (pp != null) {
                M_InOut_ID = pp.getKey();
            }
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.loadShipment(M_InOut_ID);
        } else if (e.getSource().equals(this.rmaField)) {
            KeyNamePair pp = (KeyNamePair)this.rmaField.getSelectedItem();
            int M_RMA_ID = 0;
            if (pp != null) {
                M_RMA_ID = pp.getKey();
            }
            this.orderField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadRMA(M_RMA_ID);
        } else if (e.getSource().equals(this.getPayments)) {
            if (this.getPayments.isSelected()) {
                this.getPay = true;
                this.bankListLabel.setVisible(true);
                this.bankListField.setVisible(true);
                this.payTypeLabel.setVisible(true);
                this.payTypeField.setVisible(true);
                this.NPaymentLabel.setVisible(true);
                this.NPaymentField.setVisible(true);
                this.amtFromLabel.setVisible(true);
                this.amtFromField.setVisible(true);
                this.amtToLabel.setVisible(true);
                this.amtToField.setVisible(true);
                this.dateFromLabelAcct.setVisible(true);
                this.dateFromFieldAcct.setVisible(true);
                this.dateToLabelAcct.setVisible(true);
                this.dateToFieldAcct.setVisible(true);
            } else {
                this.getPay = false;
                this.bankListLabel.setVisible(false);
                this.bankListField.setVisible(false);
                this.payTypeLabel.setVisible(false);
                this.payTypeField.setVisible(false);
                this.NPaymentLabel.setVisible(false);
                this.NPaymentField.setVisible(false);
                this.amtFromLabel.setVisible(false);
                this.amtFromField.setVisible(false);
                this.amtToLabel.setVisible(false);
                this.amtToField.setVisible(false);
                this.dateFromLabelAcct.setVisible(false);
                this.dateFromFieldAcct.setVisible(false);
                this.dateToLabelAcct.setVisible(false);
                this.dateToFieldAcct.setVisible(false);
            }
            this.initOFBDetails(this.C_BPartner_ID);
        }
        if (e.getActionCommand().equals("Refresh")) {
            Cursor.getPredefinedCursor(3);
            if (this.wType == 5 || this.wType == 6) {
                this.initOFBDetailsForMutual(this.C_BPartner_ID);
            } else {
                this.initOFBDetails(this.C_BPartner_ID);
            }
            this.dialog.tableChanged(null);
            Cursor.getPredefinedCursor(0);
        }
        this.m_actionActive = false;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.C_BPartner_ID = (Integer)e.getNewValue();
            if (this.wType == 0) {
                this.initBPOrderDetails(this.C_BPartner_ID, true);
            }
            if (this.wType == 5 || this.wType == 6) {
                this.initOFBDetailsForMutual(this.C_BPartner_ID);
            } else {
                this.initOFBDetails(this.C_BPartner_ID);
            }
        }
        this.dialog.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
        this.bPartnerField = new VLookup("C_BPartner_ID", true, false, true, lookup);
        int C_BPartner_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID");
        this.bPartnerField.setValue(new Integer(C_BPartner_ID));
        int Ref_Invoice_ID = 0;
        int Ref_InvoiceRequest_ID = 0;
        if (this.wType == 5) {
            AD_Column_ID = 10788;
            MLookup lookup2 = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
            this.docNoField = new VLookup("Ref_Invoice_ID", true, false, true, lookup2);
            Ref_Invoice_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "Ref_Invoice_ID");
            this.docNoField.setValue(new Integer(Ref_Invoice_ID));
        } else if (this.wType == 6) {
            AD_Column_ID = DB.isPostgreSQL() ? 1001943 : 1001776;
            MLookup lookup2 = MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, AD_Column_ID, 30);
            this.docNoField = new VLookup("Ref_InvoiceRequest_ID", true, false, true, lookup2);
            Ref_InvoiceRequest_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "Ref_InvoiceRequest_ID");
            this.docNoField.setValue(new Integer(Ref_InvoiceRequest_ID));
        }
        if (this.wType == 0) {
            this.initBPOrderDetails(C_BPartner_ID, forInvoice);
        } else if (this.wType == 5 || this.wType == 6) {
            this.initOFBDetailsForMutual(C_BPartner_ID);
        } else {
            this.initOFBDetails(C_BPartner_ID);
        }
    }

    protected void initBPOrderDetails(int C_BPartner_ID, boolean forInvoice) {
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener(this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadOrderData(C_BPartner_ID, forInvoice, false);
        for (KeyNamePair knp : list) {
            this.orderField.addItem(knp);
        }
        this.orderField.setSelectedIndex(0);
        this.orderField.addActionListener(this);
        this.dialog.pack();
        this.initBPDetails(C_BPartner_ID);
    }

    public void initBPDetails(int C_BPartner_ID) {
        this.initBPShipmentDetails(C_BPartner_ID);
        this.initBPRMADetails(C_BPartner_ID);
    }

    private void initBPShipmentDetails(int C_BPartner_ID) {
        this.log.config("C_BPartner_ID: " + C_BPartner_ID);
        this.shipmentField.removeActionListener(this);
        this.shipmentField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.shipmentField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadShipmentData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.shipmentField.addItem(knp);
        }
        this.shipmentField.setSelectedIndex(0);
        this.shipmentField.addActionListener(this);
    }

    private void initBPRMADetails(int C_BPartner_ID) {
        this.rmaField.removeActionListener(this);
        this.rmaField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.rmaField.addItem(pp);
        ArrayList<KeyNamePair> list = this.loadRMAData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.rmaField.addItem(knp);
        }
        this.rmaField.setSelectedIndex(0);
        this.rmaField.addActionListener(this);
    }

    protected void loadOrder(int C_Order_ID, boolean forInvoice) {
        this.loadTableOIS(this.getOrderData(C_Order_ID, forInvoice));
    }

    protected void loadRMA(int M_RMA_ID) {
        this.loadTableOIS(this.getRMAData(M_RMA_ID));
    }

    protected void loadShipment(int M_InOut_ID) {
        this.loadTableOIS(this.getShipmentData(M_InOut_ID));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    @Override
    public void showWindow() {
        this.dialog.setVisible(true);
    }

    @Override
    public void closeWindow() {
        this.dialog.dispose();
    }

    protected void initOFBDetails(int C_BPartner_ID) {
        Timestamp to;
        Timestamp from;
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        boolean PutInFactoring = "Y".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "PutInFactoring"));
        int C_Currency_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_Currency_ID");
        int Reference_ID = DB.getSQLValue(null, "Select AD_Reference_ID from AD_Reference where upper(name)='BANCOS'");
        this.extinguir = "Y".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "Extinguir"));
        boolean IsSOTrx = "Y".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "IsSOTrx"));
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer();
        if (!this.getPay) {
            sql.append("SELECT p.DateInvoiced,p.C_invoice_ID,p.DocumentNo,p.C_Currency_ID, ");
            sql.append("invoiceOpen(p.C_Invoice_ID,p.C_InvoicePaySchedule_ID),");
            sql.append(" bp.Name,org.name as OrgName, doc.name as Tipo, COALESCE(pter.name,pter2.name) as pterName ");
            sql.append(" FROM C_Invoice_v p");
            sql.append(" INNER JOIN AD_Org org ON (p.AD_Org_ID=org.AD_Org_ID)");
            sql.append(" INNER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) ");
            sql.append(" Inner Join C_DocType doc ON (P.C_DocType_ID=doc.C_DocType_ID) ");
            sql.append(" LEFT Join C_PaymentTerm pter ON (P.C_PaymentTerm2_ID=pter.C_PaymentTerm_ID) ");
            sql.append(" LEFT Join C_PaymentTerm pter2 ON (P.C_PaymentTerm_ID=pter2.C_PaymentTerm_ID) ");
            sql.append(" WHERE p.Processed='Y' AND p.DocStatus IN ('CO','CL')  and p.AD_Client_ID=" + Env.getAD_Client_ID(Env.getCtx()));
            sql.append(" And p.C_Currency_ID=" + C_Currency_ID);
            if (this.wType == 1) {
                if (!PutInFactoring) {
                    sql.append(" AND p.ISFACTORING='Y' And p.Extinta='N'");
                } else {
                    sql.append(" AND p.ISFACTORING='N' and p.ispaid='N' ");
                }
            }
            if (this.wType == 3) {
                sql.append(" and doc.IsSOTrx='Y' AND doc.docbasetype IN ('ARI','ARC','CDC','PTK')  AND p.ispaid <> 'Y' ");
            }
            if (this.wType == 4) {
                sql.append(" and doc.IsSOTrx='N' AND doc.docbasetype IN ('API','APC') ");
            }
            if (C_BPartner_ID > 0) {
                sql.append(" AND p.C_Bpartner_ID=" + C_BPartner_ID);
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(p.DateInvoiced) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(p.DateInvoiced) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(p.DateInvoiced) BETWEEN ? AND ?");
                }
            }
        } else {
            sql.append("SELECT p.DateTrx,p.C_Payment_ID,p.DocumentNo, p.C_Currency_ID,c.ISO_Code, p.PayAmt,");
            sql.append("currencyConvert(p.PayAmt,p.C_Currency_ID,ba.C_Currency_ID,?,null,p.AD_Client_ID,p.AD_Org_ID),");
            if (Reference_ID > 0) {
                if (DB.isOracle()) {
                    sql.append(" bp.value||'-'||bp.name as Name,p.dateacct,(SELECT NAME FROM AD_Ref_List_Trl arlt WHERE AD_Ref_List_ID=l2.AD_Ref_List_ID AND AD_Language='es_CL') as Tender ,l.name, COALESCE(p.checkno,n'') as checkno ");
                } else {
                    sql.append(" bp.value||'-'||bp.name as Name,p.dateacct,(SELECT NAME FROM AD_Ref_List_Trl arlt WHERE AD_Ref_List_ID=l2.AD_Ref_List_ID AND AD_Language='es_CL') as Tender ,l.name, COALESCE(p.checkno,'') as checkno ");
                }
            } else if (DB.isOracle()) {
                sql.append(" bp.value||'-'||bp.name as Name,p.dateacct,(SELECT NAME FROM AD_Ref_List_Trl arlt WHERE AD_Ref_List_ID=l2.AD_Ref_List_ID AND AD_Language='es_CL') as Tender, COALESCE(p.checkno,n'') as checkno ");
            } else {
                sql.append(" bp.value||'-'||bp.name as Name,p.dateacct,(SELECT NAME FROM AD_Ref_List_Trl arlt WHERE AD_Ref_List_ID=l2.AD_Ref_List_ID AND AD_Language='es_CL') as Tender, COALESCE(p.checkno,'') as checkno ");
            }
            sql.append("FROM C_BankAccount ba");
            sql.append(" INNER JOIN C_Payment_v p ON (p.C_BankAccount_ID=ba.C_BankAccount_ID)");
            sql.append(" INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)");
            sql.append(" LEFT OUTER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID) ");
            if (Reference_ID > 0) {
                sql.append(" LEFT OUTER JOIN AD_Ref_List l ON (p.Banco=l.value and l.AD_Reference_ID=" + Reference_ID + ") ");
            }
            sql.append(" LEFT OUTER JOIN AD_Ref_List l2 ON (p.TenderType=l2.value and l2.AD_Reference_ID=214) ");
            if (this.wType == 3) {
                sql.append("WHERE p.Processed='Y' AND p.TenderType IN ('L','K','I','P','Z','A','C','D','T','V','X') ");
            } else {
                sql.append("WHERE p.Processed='Y' AND p.TenderType IN ('L','K','I','P','Z') ");
            }
            sql.append(" AND p.DocStatus IN ('CO','CL') AND p.PayAmt<>0");
            sql.append(" AND p.AD_Client_ID=" + Env.getAD_Client_ID(Env.getCtx()) + " AND p.C_Currency_ID=" + C_Currency_ID);
            if (this.wType == 2) {
                if (this.valuePTK.compareToIgnoreCase("NB") == 0) {
                    sql.append(" AND p.isreceipt='" + (IsSOTrx ? "Y" : "N") + "' AND p.IsProtested='N'" + " AND p.IsReconciled='N' " + " AND (custodio = 'A' OR custodio is null)");
                } else if (this.valuePTK.compareToIgnoreCase("BA") == 0) {
                    sql.append(" AND p.isreceipt='" + (IsSOTrx ? "Y" : "N") + "' AND p.IsProtested='N'" + " AND p.TenderType IN ('K','P','Z') AND " + " (p.IsReconciled='Y' OR (p.IsReconciled='N' AND custodio IN ('B','D')))");
                } else {
                    sql.append(" AND p.isreceipt='" + (IsSOTrx ? "Y" : "N") + "' AND p.IsProtested='N'" + " AND ( (p.TenderType IN ('K','P','Z') and p.IsReconciled='Y') OR " + "(p.TenderType NOT IN ('K','P') and p.IsReconciled='N') OR " + "(custodio = 'D')  ) ");
                }
            }
            if (this.wType == 1) {
                sql.append(" AND p.isreceipt='Y' AND p.IsProtested='N' AND p.IsReconciled='N' ");
            }
            if (!PutInFactoring && this.wType == 1) {
                sql.append(" AND p.Custodio='F' ");
            }
            if (PutInFactoring && this.wType == 1) {
                sql.append(" AND (p.Custodio is null OR p.Custodio IN ('A')) ");
            }
            if (this.wType == 3) {
                sql.append(" and p.isreceipt='Y' AND p.IsReconciled='N' AND p.IsProtested='N'");
                sql.append(" AND (p.Custodio is null OR p.Custodio IN ('A')) ");
            }
            if (this.wType == 4) {
                sql.append(" and p.isreceipt='N' AND p.IsReconciled='N' AND p.IsProtested='N'");
            }
            if (C_BPartner_ID > 0) {
                sql.append(" AND p.C_Bpartner_ID = " + C_BPartner_ID);
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                from = (Timestamp)this.dateFromField.getValue();
                to = (Timestamp)this.dateToField.getValue();
                if (from == null && to != null) {
                    sql.append(" AND TRUNC(p.DateTrx) <= ?");
                } else if (from != null && to == null) {
                    sql.append(" AND TRUNC(p.DateTrx) >= ?");
                } else if (from != null && to != null) {
                    sql.append(" AND TRUNC(p.DateTrx) BETWEEN ? AND ?");
                }
            }
            if (this.getPay && (this.dateFromFieldAcct.getValue() != null || this.dateToFieldAcct.getValue() != null)) {
                Timestamp fromAcct = (Timestamp)this.dateFromFieldAcct.getValue();
                Timestamp toAcct = (Timestamp)this.dateToFieldAcct.getValue();
                if (fromAcct == null && toAcct != null) {
                    sql.append(" AND TRUNC(p.DateAcct) <= ?");
                } else if (fromAcct != null && toAcct == null) {
                    sql.append(" AND TRUNC(p.DateAcct) >= ?");
                } else if (fromAcct != null && toAcct != null) {
                    sql.append(" AND TRUNC(p.DateAcct) BETWEEN ? AND ?");
                }
            }
            if (this.bankListField.getSelectedItem() != null && this.bankListField.getSelectedItem() != "" && this.bankListField.getSelectedItem() != " ") {
                sql.append(" AND l.name like '" + this.bankListField.getSelectedItem().toString() + "'");
            }
            if (this.payTypeField.getSelectedItem() != null && this.payTypeField.getSelectedItem() != "" && this.payTypeField.getSelectedItem() != " ") {
                String sqlValPayType = "select MAX(rl.value) from AD_Ref_List rl inner join AD_Ref_List_Trl rlt on (rl.AD_Ref_List_ID = rlt.AD_Ref_List_ID) where AD_Reference_ID = 214 AND rlt.ad_language = 'es_CL' AND rl.IsActive = 'Y'AND rlt.name like '" + this.payTypeField.getSelectedItem().toString() + "'";
                String valpayType = DB.getSQLValueString(null, sqlValPayType, new Object[0]);
                sql.append(" AND l2.value like '" + valpayType + "'");
            }
            if (this.NPaymentField.getText() != null && this.NPaymentField.getText() != "" && this.NPaymentField.getText() != " ") {
                sql.append(" AND p.DocumentNo like '%" + this.NPaymentField.getText() + "%'");
            }
            BigDecimal amtFrom = (BigDecimal)this.amtFromField.getValue();
            BigDecimal amtTo = (BigDecimal)this.amtToField.getValue();
            if (amtFrom == null) {
                amtFrom = Env.ZERO;
            }
            if (amtTo == null) {
                amtTo = Env.ZERO;
            }
            if (amtFrom.compareTo(Env.ZERO) > 0) {
                sql.append(" AND p.payAmt > " + amtFrom);
            }
            if (amtTo.compareTo(Env.ZERO) > 0) {
                sql.append(" AND p.payAmt < " + amtTo);
            }
        }
        this.log.config("**" + sql.toString());
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        try {
            int index = 1;
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            if (this.getPay) {
                pstmt.setTimestamp(index++, ts);
            }
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                Timestamp from2 = (Timestamp)this.dateFromField.getValue();
                Timestamp to2 = (Timestamp)this.dateToField.getValue();
                this.log.fine("Date From=" + from2 + ", To=" + to2);
                if (from2 == null && to2 != null) {
                    pstmt.setTimestamp(index++, to2);
                } else if (from2 != null && to2 == null) {
                    pstmt.setTimestamp(index++, from2);
                } else if (from2 != null && to2 != null) {
                    pstmt.setTimestamp(index++, from2);
                    pstmt.setTimestamp(index++, to2);
                }
            }
            if (this.getPay && (this.dateFromFieldAcct.getValue() != null || this.dateToFieldAcct.getValue() != null)) {
                Timestamp fromAcct = (Timestamp)this.dateFromFieldAcct.getValue();
                Timestamp toAcct = (Timestamp)this.dateToFieldAcct.getValue();
                if (fromAcct == null && toAcct != null) {
                    pstmt.setTimestamp(index++, toAcct);
                } else if (fromAcct != null && toAcct == null) {
                    pstmt.setTimestamp(index++, fromAcct);
                } else if (fromAcct != null && toAcct != null) {
                    pstmt.setTimestamp(index++, fromAcct);
                    pstmt.setTimestamp(index++, toAcct);
                }
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp;
                Vector<Object> line = new Vector<Object>(10);
                if (!this.getPay) {
                    line.add(new Boolean(false));
                    line.add(rs.getString(3));
                    pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                    line.add(pp);
                    line.add(rs.getBigDecimal(5));
                    line.add(rs.getTimestamp(1));
                    line.add(rs.getString(6));
                    line.add(rs.getString(7));
                    line.add(rs.getString(8));
                    line.add(rs.getString(9));
                } else {
                    line.add(new Boolean(false));
                    line.add(rs.getTimestamp(1));
                    pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                    line.add(pp);
                    if (Reference_ID > 0) {
                        line.add(rs.getString(12));
                    } else {
                        line.add(rs.getString(11));
                    }
                    pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                    line.add(pp);
                    line.add(rs.getBigDecimal(6));
                    line.add(rs.getBigDecimal(7));
                    line.add(rs.getString(8));
                    line.add(rs.getString(10));
                    if (Reference_ID > 0) {
                        line.add(rs.getString(11));
                    }
                    line.add(rs.getTimestamp(9));
                }
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        Vector<String> columnNames = new Vector<String>(10);
        if (!this.getPay) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
            columnNames.add(Msg.getElement(Env.getCtx(), "DocumentNo"));
            columnNames.add(Msg.getElement(Env.getCtx(), "C_Invoice_ID"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
            columnNames.add(Msg.translate(Env.getCtx(), "Date"));
            columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
            columnNames.add(Msg.translate(Env.getCtx(), "AD_Org_ID"));
            columnNames.add("Tipo");
            columnNames.add("Termino de Pago");
        } else {
            columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
            columnNames.add(Msg.translate(Env.getCtx(), "Date"));
            columnNames.add(Msg.getElement(Env.getCtx(), "C_Payment_ID"));
            columnNames.add(Msg.translate(Env.getCtx(), "N\u00c2\u00b0 Cheque"));
            columnNames.add(Msg.translate(Env.getCtx(), "C_Currency_ID"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
            columnNames.add(Msg.translate(Env.getCtx(), "ConvertedAmount"));
            columnNames.add(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
            columnNames.add(Msg.translate(Env.getCtx(), "TenderType"));
            if (Reference_ID > 0) {
                columnNames.add(Msg.translate(Env.getCtx(), "Banco"));
            }
            columnNames.add(Msg.translate(Env.getCtx(), "DateAcct"));
        }
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        if (!this.getPay) {
            this.dialog.getMiniTable().setColumnClass(0, Boolean.class, false);
            this.dialog.getMiniTable().setColumnClass(1, String.class, true);
            this.dialog.getMiniTable().setColumnClass(2, String.class, true);
            this.dialog.getMiniTable().setColumnClass(3, BigDecimal.class, true);
            this.dialog.getMiniTable().setColumnClass(4, Timestamp.class, true);
            this.dialog.getMiniTable().setColumnClass(5, String.class, true);
            this.dialog.getMiniTable().setColumnClass(6, String.class, true);
            this.dialog.getMiniTable().setColumnClass(7, String.class, true);
            this.dialog.getMiniTable().setColumnClass(8, String.class, true);
        } else {
            this.dialog.getMiniTable().setColumnClass(0, Boolean.class, false);
            this.dialog.getMiniTable().setColumnClass(1, Timestamp.class, true);
            this.dialog.getMiniTable().setColumnClass(2, String.class, true);
            if (Reference_ID > 0) {
                this.dialog.getMiniTable().setColumnClass(3, String.class, true);
                this.dialog.getMiniTable().setColumnClass(4, String.class, true);
                this.dialog.getMiniTable().setColumnClass(5, BigDecimal.class, true);
                this.dialog.getMiniTable().setColumnClass(6, BigDecimal.class, true);
                this.dialog.getMiniTable().setColumnClass(7, String.class, true);
                this.dialog.getMiniTable().setColumnClass(8, String.class, true);
                this.dialog.getMiniTable().setColumnClass(9, String.class, true);
                this.dialog.getMiniTable().setColumnClass(10, Timestamp.class, true);
            } else {
                this.dialog.getMiniTable().setColumnClass(3, String.class, true);
                this.dialog.getMiniTable().setColumnClass(4, String.class, true);
                this.dialog.getMiniTable().setColumnClass(5, BigDecimal.class, true);
                this.dialog.getMiniTable().setColumnClass(6, BigDecimal.class, true);
                this.dialog.getMiniTable().setColumnClass(7, String.class, true);
                this.dialog.getMiniTable().setColumnClass(8, String.class, true);
                this.dialog.getMiniTable().setColumnClass(9, Timestamp.class, true);
            }
        }
    }

    protected void initOFBDetailsForMutual(int C_BPartner_ID) {
        this.log.config("C_BPartner_ID=" + C_BPartner_ID);
        int C_Currency_ID = Env.getContextAsInt(Env.getCtx(), this.p_WindowNo, "C_Currency_ID");
        Vector data = new Vector();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT p.DateInvoiced,pl.C_invoiceLine_ID,pl.line, ");
        sql.append(" p.DocumentNo, p.C_Currency_ID, ");
        sql.append(" bp.Name,org.name as OrgName,doc.name,pl.m_product_id,pro.name, ");
        sql.append(" pl.C_Charge_id,cc.name,pl.linetotalamt,p.Ref_Invoice_ID,p.Ref_InvoiceRequest_ID, ");
        sql.append(" (select value from m_attributeinstance ai where m_attributesetinstance_ID = pl.m_attributesetinstance_ID ");
        sql.append(" AND m_attribute_id = 1000009) as rut_trabajador ,");
        sql.append(" (select value from m_attributeinstance ai ");
        sql.append(" where m_attributesetinstance_ID = pl.m_attributesetinstance_ID AND m_attribute_id = 1000010) ||' '|| ");
        sql.append("(select value from m_attributeinstance ai ");
        sql.append(" where m_attributesetinstance_ID = pl.m_attributesetinstance_ID AND m_attribute_id = 1000011) ||' '|| ");
        sql.append("(select value from m_attributeinstance ai ");
        sql.append(" where m_attributesetinstance_ID = pl.m_attributesetinstance_ID AND m_attribute_id = 1000012) as nombre_trabajador ");
        sql.append(" FROM C_Invoice p");
        sql.append(" INNER JOIN C_InvoiceLine pl ON (p.C_Invoice_ID = pl.C_Invoice_ID)");
        sql.append(" INNER JOIN AD_Org org ON (p.AD_Org_ID=org.AD_Org_ID)");
        sql.append(" INNER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID)");
        sql.append(" Inner Join C_DocType doc ON (P.C_DocType_ID=doc.C_DocType_ID)");
        sql.append(" LEFT JOIN M_Product pro ON (pl.M_Product_ID = pro.M_Product_ID)");
        sql.append(" LEFT JOIN C_Charge cc ON (pl.C_Charge_ID = cc.C_Charge_ID)");
        sql.append(" WHERE p.Processed='Y' AND p.DocStatus IN ('CO','CL')  and p.AD_Client_ID =" + Env.getAD_Client_ID(Env.getCtx()));
        sql.append(" AND IsUseMutualSP = 'N' And p.C_Currency_ID=" + C_Currency_ID);
        if (C_BPartner_ID > 0) {
            sql.append(" AND p.C_Bpartner_ID=" + C_BPartner_ID);
        }
        if (this.docNoField != null) {
            sql.append(" AND p.C_Invoice_ID=" + this.docNoField.getValue());
        }
        if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
            Timestamp from = (Timestamp)this.dateFromField.getValue();
            Timestamp to = (Timestamp)this.dateToField.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(p.DateInvoiced) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(p.DateInvoiced) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(p.DateInvoiced) BETWEEN ? AND ?");
            }
        }
        if (this.REmployeeField.getText() != null && this.REmployeeField.getText().trim() != "" && this.REmployeeField.getText().trim() != " " && this.REmployeeField.getText().length() > 0) {
            sql.append(" AND (select value from m_attributeinstance ai where m_attributesetinstance_ID = pl.m_attributesetinstance_ID  AND m_attribute_id = 1000009) like '%" + this.REmployeeField.getText() + "%'");
        }
        if (this.NEmployeeField.getText() != null && this.NEmployeeField.getText().trim() != "" && this.NEmployeeField.getText().trim() != " " && this.NEmployeeField.getText().length() > 0) {
            sql.append(" AND (select value from m_attributeinstance ai where m_attributesetinstance_ID = pl.m_attributesetinstance_ID  AND m_attribute_id = 1000010) like '%" + this.NEmployeeField.getText() + "%'");
        }
        sql.append(" ORDER BY bp.C_BPartner_ID, p.DocumentNo ");
        this.log.config("**" + sql.toString());
        try {
            int index = 1;
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            if (this.dateFromField.getValue() != null || this.dateToField.getValue() != null) {
                Timestamp from = (Timestamp)this.dateFromField.getValue();
                Timestamp to = (Timestamp)this.dateToField.getValue();
                this.log.fine("Date From=" + from + ", To=" + to);
                if (from == null && to != null) {
                    pstmt.setTimestamp(index++, to);
                } else if (from != null && to == null) {
                    pstmt.setTimestamp(index++, from);
                } else if (from != null && to != null) {
                    pstmt.setTimestamp(index++, from);
                    pstmt.setTimestamp(index++, to);
                }
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(10);
                line.add(new Boolean(false));
                line.add(rs.getString(4));
                line.add(rs.getString(6));
                line.add(rs.getString(16));
                line.add(rs.getString(17));
                KeyNamePair pprod = new KeyNamePair(rs.getInt(9), rs.getString(10));
                line.add(pprod);
                KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                line.add(pp);
                line.add(rs.getString(7));
                line.add(rs.getBigDecimal(13));
                line.add(rs.getTimestamp(1));
                line.add(rs.getString(8));
                KeyNamePair pch = new KeyNamePair(rs.getInt(11), rs.getString(12));
                line.add(pch);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.getElement(Env.getCtx(), "DocumentNo"));
        columnNames.add("Cliente");
        columnNames.add("Rut Empleado");
        columnNames.add("Empleado");
        columnNames.add(Msg.translate(Env.getCtx(), "Ex\u00c3\u00a1men"));
        columnNames.add(Msg.translate(Env.getCtx(), "Line"));
        columnNames.add(Msg.translate(Env.getCtx(), "Centro de Atenci\u00c3\u00b3n"));
        columnNames.add(Msg.translate(Env.getCtx(), "Total"));
        columnNames.add(Msg.translate(Env.getCtx(), "DateDoc"));
        columnNames.add(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Cargo"));
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, columnNames);
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.dialog.getMiniTable().setColumnClass(0, Boolean.class, false);
        this.dialog.getMiniTable().setColumnClass(1, String.class, true);
        this.dialog.getMiniTable().setColumnClass(2, String.class, true);
        this.dialog.getMiniTable().setColumnClass(3, String.class, true);
        this.dialog.getMiniTable().setColumnClass(4, String.class, true);
        this.dialog.getMiniTable().setColumnClass(5, String.class, true);
        this.dialog.getMiniTable().setColumnClass(6, String.class, true);
        this.dialog.getMiniTable().setColumnClass(7, String.class, true);
        this.dialog.getMiniTable().setColumnClass(8, BigDecimal.class, true);
        this.dialog.getMiniTable().setColumnClass(9, Timestamp.class, true);
        this.dialog.getMiniTable().setColumnClass(9, String.class, true);
        this.dialog.getMiniTable().setColumnClass(9, String.class, true);
    }
}

