/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRequisitionLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class CreateFromOrder
extends CreateFrom {
    public CreateFromOrder(GridTab mTab) {
        super(mTab);
        this.log.info(mTab.toString());
    }

    @Override
    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement(Env.getCtx(), "C_Invoice_ID", false)) + " .. " + Msg.translate(Env.getCtx(), "CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block13: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX='N' AND r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND NOT EXISTS (SELECT * FROM C_Invoice inv WHERE inv.M_RMA_ID=r.M_RMA_ID AND inv.DocStatus IN ('CO', 'CL'))";
            CPreparedStatement pstmt = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), e);
                    if (pstmt == null) break block13;
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception ex) {
                        this.log.severe("Could not close prepared statement");
                    }
                }
            }
        }
        return list;
    }

    @Override
    public void info() {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, BigDecimal.class, true);
        miniTable.setColumnClass(9, BigDecimal.class, true);
        miniTable.setColumnClass(10, Integer.class, true);
        miniTable.setColumnClass(11, Integer.class, true);
        miniTable.autoSize();
    }

    @Override
    public boolean save(IMiniTable miniTable, String trxName) {
        this.log.config("");
        int Order_ID = (Integer)this.getGridTab().getValue("C_Order_ID");
        MOrder newOrder = new MOrder(Env.getCtx(), Order_ID, null);
        this.log.config("**doctype " + newOrder.getC_DocTypeTarget_ID());
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                boolean OK;
                MOrderLine line = new MOrderLine(newOrder);
                KeyNamePair product_id = (KeyNamePair)miniTable.getValueAt(i, 5);
                if (product_id.getKey() > 0) {
                    line.setProduct(new MProduct(Env.getCtx(), product_id.getKey(), null));
                }
                BigDecimal valor = (BigDecimal)miniTable.getValueAt(i, 9);
                this.log.config("valor:" + valor);
                line.setPrice();
                line.setPrice(valor);
                KeyNamePair charge_id = (KeyNamePair)miniTable.getValueAt(i, 6);
                if (charge_id.getKey() > 0) {
                    line.setC_Charge_ID(charge_id.getKey());
                }
                line.setQtyOrdered((BigDecimal)miniTable.getValueAt(i, 8));
                line.setQtyEntered((BigDecimal)miniTable.getValueAt(i, 8));
                Integer subproject = (Integer)miniTable.getValueAt(i, 11);
                line.set_ValueOfColumn("C_SubProjectOFB_ID", (Object)subproject);
                Integer requiline = (Integer)miniTable.getValueAt(i, 10);
                line.set_ValueOfColumn("M_RequisitionLine_ID", (Object)requiline);
                line.setDescription((String)miniTable.getValueAt(i, 7));
                line.setAD_Org_ID(new MRequisitionLine(Env.getCtx(), requiline, null).getAD_Org_ID());
                MRequisitionLine rLine = new MRequisitionLine(Env.getCtx(), requiline, null);
                if (!rLine.get_ValueAsString("Help").equals("")) {
                    line.set_CustomColumn("Help", rLine.get_ValueAsString("Help"));
                }
                if (OK = line.save()) {
                    DB.executeUpdate("update M_RequisitionLine set C_ORDERLINE_ID=" + line.getC_OrderLine_ID() + " where M_RequisitionLine_ID=" + (Integer)miniTable.getValueAt(i, 10));
                }
            }
            ++i;
        }
        return true;
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.getElement(Env.getCtx(), "DateRequired"));
        columnNames.add("Usuario");
        columnNames.add("NoSolicitud");
        columnNames.add("Proyecto/OT");
        columnNames.add(Msg.translate(Env.getCtx(), "ProductName"));
        columnNames.add("Cargo");
        columnNames.add(Msg.translate(Env.getCtx(), "Description"));
        columnNames.add(Msg.translate(Env.getCtx(), "Quantity"));
        columnNames.add(Msg.translate(Env.getCtx(), "Price"));
        columnNames.add("Control");
        columnNames.add("Seguimiento");
        return columnNames;
    }
}

