/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.grid.ICreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MRMA;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.ofb.model.OFBForward;

public abstract class CreateFrom
implements ICreateFrom {
    protected CLogger log = CLogger.getCLogger(this.getClass());
    protected MOrder p_order = null;
    protected MRMA m_rma = null;
    private GridTab gridTab;
    private String title;
    private boolean initOK = false;
    String IsSOTrx;

    public CreateFrom(GridTab gridTab) {
        this.gridTab = gridTab;
        this.IsSOTrx = gridTab.get_ValueAsString("IsSOTrx");
    }

    public abstract boolean dynInit() throws Exception;

    public abstract void info();

    public abstract boolean save(IMiniTable var1, String var2);

    @Override
    public boolean isInitOK() {
        return this.initOK;
    }

    public void setInitOK(boolean initOK) {
        this.initOK = initOK;
    }

    protected ArrayList<KeyNamePair> loadOrderData(int C_BPartner_ID, boolean forInvoice, boolean sameWarehouseOnly) {
        ArrayList<KeyNamePair> list;
        block10: {
            list = new ArrayList<KeyNamePair>();
            StringBuffer display = new StringBuffer("o.DocumentNo||' - ' ||").append(DB.TO_CHAR("o.DateOrdered", 15, Env.getAD_Language(Env.getCtx()))).append("||' - '||").append(DB.TO_CHAR("o.GrandTotal", 12, Env.getAD_Language(Env.getCtx())));
            String extraWhere = "";
            if (this.isRangeActive()) {
                extraWhere = " and ol.CanReceipt='Y'";
            }
            String column = "ol.QtyDelivered";
            if (forInvoice) {
                column = "ol.QtyInvoiced";
            }
            StringBuffer sql = new StringBuffer("SELECT o.C_Order_ID,").append(display).append(" FROM C_Order o WHERE o.C_BPartner_ID=? AND o.IsSOTrx='" + this.IsSOTrx + "' AND o.DocStatus IN ('CL','CO')" + " AND o.C_Order_ID IN " + "(SELECT ol.C_Order_ID FROM C_OrderLine ol" + " WHERE ol.QtyOrdered - ").append(column).append(" != 0 " + extraWhere + ") ");
            if (sameWarehouseOnly) {
                sql = sql.append(" AND o.M_Warehouse_ID=? ");
            }
            sql = sql.append(" and o.AD_Org_ID=" + this.getAD_Org_ID());
            sql = sql.append("ORDER BY o.DateOrdered");
            this.log.fine(sql.toString());
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_BPartner_ID);
                    if (sameWarehouseOnly) {
                        pstmt.setInt(2, this.getM_Warehouse_ID());
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice) {
        Vector<Vector<Object>> data;
        block18: {
            this.log.config("C_Order_ID=" + C_Order_ID);
            this.p_order = new MOrder(Env.getCtx(), C_Order_ID, null);
            data = new Vector<Vector<Object>>();
            StringBuffer sql = new StringBuffer("SELECT ");
            if (forInvoice) {
                sql.append("l.QtyOrdered - (COALESCE((SELECT SUM(invl.QTYINVOICED)FROM C_Invoiceline invl INNER JOIN C_Invoice cinv ON (cinv.C_Invoice_ID = invl.C_Invoice_ID) WHERE cinv.DocStatus not in ('VO') AND invl.C_OrderLine_ID = l.C_OrderLine_ID ),0)) as qty,");
            } else {
                sql.append("l.QtyOrdered-SUM(COALESCE(inout.QTYENTERED,0)),");
            }
            sql.append("CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name), COALESCE(l.M_Product_ID,0),");
            if (OFBForward.UseInfoProductTCInvoice()) {
                sql.append("(COALESCE(p.Name,c.Name)||'-'||(select  bploc.name||'-'||mp.name||'-'|| col.line  from c_orderline col   inner join c_order co on (co.c_order_id = col.c_order_id) inner join m_product mp on (mp.m_product_id = col.m_product_id) inner join c_bpartner_location bploc on (bploc.c_bpartner_location_id = col.c_bpartner_location3_id) where col.c_orderline_id = l.C_OrderLine_ID)) as name2,");
            } else {
                sql.append(" COALESCE(p.Name,c.Name),");
            }
            sql.append(" po.VendorProductNo, l.C_OrderLine_ID,l.Line ,l.datepromised,w.name,l.dateinvoiced,l.dateordered FROM C_OrderLine l LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND l.C_BPartner_ID = po.C_BPartner_ID) ");
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge c ON (l.C_Charge_ID=c.C_Charge_ID)");
            if (Env.isBaseLanguage(Env.getCtx(), "C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language(Env.getCtx())).append("')");
            }
            if (forInvoice) {
                sql.append(" LEFT OUTER JOIN C_InvoiceLine invl ON (l.C_OrderLine_ID=invl.C_OrderLine_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN M_InOutLine inout ON (l.C_OrderLine_ID=inout.C_OrderLine_ID)");
            }
            sql.append(" LEFT OUTER JOIN M_Warehouse w on (l.M_Warehouse_ID=w.M_Warehouse_ID) ");
            sql.append(" WHERE l.C_Order_ID=? GROUP BY l.QtyOrdered,CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END, l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name),po.VendorProductNo, l.M_Product_ID,");
            if (OFBForward.UseInfoProductTCInvoice()) {
                sql.append("name2, ");
            } else {
                sql.append("COALESCE(p.Name,c.Name),");
            }
            sql.append(" l.Line,l.C_OrderLine_ID,l.datepromised, w.name,l.dateinvoiced, l.dateordered ORDER BY l.Line");
            this.log.finer(sql.toString());
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(new Boolean(false));
                        BigDecimal qtyOrdered = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyOrdered.multiply(multiplier);
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                        line.add(pp);
                        line.add(rs.getString(7));
                        pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                        line.add(pp);
                        line.add(null);
                        line.add(null);
                        if (!forInvoice) {
                            line.add(rs.getTimestamp(10));
                        }
                        if (!forInvoice) {
                            line.add(rs.getString(11));
                        }
                        line.add(rs.getTimestamp(12));
                        line.add(rs.getTimestamp(13));
                        data.add(line);
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    @Override
    public void showWindow() {
    }

    @Override
    public void closeWindow() {
    }

    public GridTab getGridTab() {
        return this.gridTab;
    }

    public int getM_Warehouse_ID() {
        return Env.getContextAsInt(Env.getCtx(), this.gridTab.getWindowNo(), "M_Warehouse_ID");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected boolean isRangeActive() {
        MClient client = MClient.get(Env.getCtx());
        return client.get_ValueAsInt("RangeReceiptLow") > 0 && client.get_ValueAsInt("RangeReceiptHi") > 0;
    }

    public int getAD_Org_ID() {
        return Env.getContextAsInt(Env.getCtx(), this.gridTab.getWindowNo(), "AD_Org_ID");
    }
}

