/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.VSchedule;
import org.compiere.grid.ed.VDate;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class InfoSchedule
extends CDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 7364837484557281167L;
    private MResourceAssignment m_mAssignment;
    private Timestamp m_dateFrom = null;
    private boolean m_loading = false;
    private boolean m_createNew;
    private static CLogger log = CLogger.getCLogger(InfoSchedule.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel labelResourceType = new JLabel();
    private JComboBox fieldResourceType = new JComboBox();
    private JLabel labelResource = new JLabel();
    private JComboBox fieldResource = new JComboBox();
    private JButton bPrevious = new JButton();
    private JLabel labelDate = new JLabel();
    private VDate fieldDate = new VDate();
    private JButton bNext = new JButton();
    private JTabbedPane timePane = new JTabbedPane();
    private VSchedule daySchedule = new VSchedule(this, 5);
    private VSchedule weekSchedule = new VSchedule(this, 3);
    private VSchedule monthSchedule = new VSchedule(this, 2);
    private StatusBar statusBar = new StatusBar();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    public InfoSchedule(Frame frame, MResourceAssignment mAssignment, boolean createNew) {
        super(frame, Msg.getMsg(Env.getCtx(), "InfoSchedule"), frame != null);
        this.m_mAssignment = mAssignment == null ? new MResourceAssignment(Env.getCtx(), 0, null) : mAssignment;
        if (mAssignment != null) {
            log.info(mAssignment.toString());
        }
        this.m_dateFrom = this.m_mAssignment.getAssignDateFrom();
        if (this.m_dateFrom == null) {
            this.m_dateFrom = new Timestamp(System.currentTimeMillis());
        }
        this.m_createNew = true;
        try {
            this.jbInit();
            this.dynInit(true);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "InfoSchedule", ex);
        }
        AEnv.showCenterWindow(frame, this);
    }

    public InfoSchedule() {
        this((Frame)null, (MResourceAssignment)null, false);
    }

    private void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.labelResourceType.setHorizontalTextPosition(10);
        this.labelResourceType.setText(Msg.translate(Env.getCtx(), "S_ResourceType_ID"));
        this.labelResource.setHorizontalTextPosition(10);
        this.labelResource.setText(Msg.translate(Env.getCtx(), "S_Resource_ID"));
        this.bPrevious.setMargin(new Insets(0, 0, 0, 0));
        this.bPrevious.setText("<");
        this.labelDate.setText(Msg.translate(Env.getCtx(), "Date"));
        this.bNext.setMargin(new Insets(0, 0, 0, 0));
        this.bNext.setText(">");
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.labelResourceType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 8, 0, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldResourceType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 8, 4), 0, 0));
        this.parameterPanel.add((Component)this.labelResource, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 4, 0, 4), 0, 0));
        this.parameterPanel.add((Component)this.fieldResource, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 0, 8, 4), 0, 0));
        this.parameterPanel.add((Component)this.bPrevious, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 8, 8, 0), 0, 0));
        this.parameterPanel.add((Component)this.labelDate, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.parameterPanel.add((Component)this.fieldDate, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 8, 0), 0, 0));
        this.parameterPanel.add((Component)this.bNext, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.mainPanel.add((Component)new JScrollPane(this.timePane), "Center");
        this.timePane.add((Component)this.daySchedule, Msg.getMsg(Env.getCtx(), "Day"));
        this.timePane.add((Component)this.weekSchedule, Msg.getMsg(Env.getCtx(), "Week"));
        this.timePane.add((Component)this.monthSchedule, Msg.getMsg(Env.getCtx(), "Month"));
        this.timePane.addChangeListener(this);
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.mainPanel.setPreferredSize(new Dimension(1024, 800));
        this.getContentPane().add((Component)this.statusBar, "South");
    }

    private void dynInit(boolean createNew) {
        this.fillResourceType();
        this.fillResource();
        this.fieldResourceType.addActionListener(this);
        this.fieldResource.addActionListener(this);
        this.fieldDate.setValue(this.m_dateFrom);
        this.fieldDate.addActionListener(this);
        this.bPrevious.addActionListener(this);
        this.bNext.addActionListener(this);
        this.daySchedule.setCreateNew(createNew);
        this.weekSchedule.setCreateNew(createNew);
        this.monthSchedule.setCreateNew(createNew);
        this.confirmPanel.addActionListener(this);
        this.displayCalendar();
    }

    private void fillResourceType() {
        KeyNamePair defaultValue;
        block9: {
            String sql;
            int S_ResourceType_ID = 0;
            if (this.m_mAssignment.getS_Resource_ID() != 0) {
                sql = "SELECT S_ResourceType_ID FROM S_Resource WHERE S_Resource_ID=?";
                S_ResourceType_ID = DB.getSQLValue(null, sql, this.m_mAssignment.getS_Resource_ID());
            }
            sql = MRole.getDefault().addAccessSQL("SELECT S_ResourceType_ID, Name FROM S_ResourceType WHERE IsActive='Y' ORDER BY 2", "S_ResourceType", false, false);
            defaultValue = null;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        if (S_ResourceType_ID == pp.getKey()) {
                            defaultValue = pp;
                        }
                        this.fieldResourceType.addItem(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (defaultValue != null) {
            this.fieldResourceType.setSelectedItem(defaultValue);
        }
    }

    private void fillResource() {
        KeyNamePair defaultValue;
        block9: {
            KeyNamePair pp = (KeyNamePair)this.fieldResourceType.getSelectedItem();
            if (pp == null) {
                return;
            }
            int S_ResourceType_ID = pp.getKey();
            defaultValue = null;
            this.m_loading = true;
            this.fieldResource.removeAllItems();
            String sql = "SELECT S_Resource_ID, Name FROM S_Resource WHERE IsActive='Y' AND S_ResourceType_ID=? ORDER BY 2";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, S_ResourceType_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        if (this.m_mAssignment.getS_Resource_ID() == pp.getKey()) {
                            defaultValue = pp;
                        }
                        this.fieldResource.addItem(pp);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (defaultValue != null) {
            this.fieldResource.setSelectedItem(defaultValue);
        }
        this.m_loading = false;
    }

    private void displayCalendar() {
        KeyNamePair pp = (KeyNamePair)this.fieldResource.getSelectedItem();
        if (pp == null) {
            return;
        }
        int S_Resource_ID = pp.getKey();
        if (this.m_mAssignment != null) {
            this.m_mAssignment.setS_Resource_ID(S_Resource_ID);
        }
        Timestamp date = this.fieldDate.getTimestamp();
        int index = this.timePane.getSelectedIndex();
        log.config("Index=" + index + ", ID=" + S_Resource_ID + " - " + date);
        this.m_loading = true;
        if (index == 0) {
            this.daySchedule.recreate(S_Resource_ID, date);
        } else if (index == 1) {
            this.weekSchedule.recreate(S_Resource_ID, date);
        } else {
            this.monthSchedule.recreate(S_Resource_ID, date);
        }
        this.m_loading = false;
        this.repaint();
    }

    @Override
    public void dispose() {
        this.daySchedule.dispose();
        this.weekSchedule.dispose();
        this.monthSchedule.dispose();
        this.removeAll();
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.m_loading) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (e.getActionCommand().equals("Ok")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getSource() == this.fieldResourceType) {
            this.fillResource();
            this.displayCalendar();
        } else if (e.getSource() == this.fieldResource || e.getSource() == this.fieldDate) {
            this.displayCalendar();
        } else if (e.getSource() == this.bPrevious) {
            this.adjustDate(-1);
        } else if (e.getSource() == this.bNext) {
            this.adjustDate(1);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.displayCalendar();
    }

    private void adjustDate(int diff) {
        Timestamp date = this.fieldDate.getTimestamp();
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (this.timePane.getSelectedIndex() == 0) {
            cal.add(6, diff);
        } else if (this.timePane.getSelectedIndex() == 1) {
            cal.add(3, diff);
        } else {
            cal.add(2, diff);
        }
        this.fieldDate.setValue(new Timestamp(cal.getTimeInMillis()));
        this.displayCalendar();
    }

    public void mAssignmentCallback(MResourceAssignment assignment) {
        this.m_mAssignment = assignment;
        this.displayCalendar();
    }

    public MResourceAssignment getMResourceAssignment() {
        return this.m_mAssignment;
    }
}

