/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.apps.search.InvoiceHistory;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class InfoBPartner
extends Info {
    private static final long serialVersionUID = 5550733934685665946L;
    private boolean m_isSOTrx = false;
    private int m_AD_User_ID_index = -1;
    private int m_C_BPartner_Location_ID_index = -1;
    private static String s_partnerFROM = "C_BPartner LEFT OUTER JOIN C_BPartner_Location l ON (C_BPartner.C_BPartner_ID=l.C_BPartner_ID AND l.IsActive='Y') LEFT OUTER JOIN AD_User c ON (C_BPartner.C_BPartner_ID=c.C_BPartner_ID AND (c.C_BPartner_Location_ID IS NULL OR c.C_BPartner_Location_ID=l.C_BPartner_Location_ID) AND c.IsActive='Y') LEFT OUTER JOIN C_Location a ON (l.C_Location_ID=a.C_Location_ID)";
    private static Info_Column[] s_partnerLayout = new Info_Column[]{new Info_Column(" ", "C_BPartner.C_BPartner_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "Value"), "C_BPartner.Value", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Name"), "C_BPartner.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Contact"), "c.Name AS Contact", KeyNamePair.class, "c.AD_User_ID"), new Info_Column(Msg.translate(Env.getCtx(), "SO_CreditAvailable"), "C_BPartner.SO_CreditLimit-C_BPartner.SO_CreditUsed AS SO_CreditAvailable", BigDecimal.class, true, true, null), new Info_Column(Msg.translate(Env.getCtx(), "SO_CreditUsed"), "C_BPartner.SO_CreditUsed", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "Phone"), "c.Phone", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Postal"), "a.Postal", KeyNamePair.class, "l.C_BPartner_Location_ID"), new Info_Column(Msg.translate(Env.getCtx(), "City"), "a.City", String.class), new Info_Column(Msg.translate(Env.getCtx(), "TotalOpenBalance"), "C_BPartner.TotalOpenBalance", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "Revenue"), "C_BPartner.ActualLifetimeValue", BigDecimal.class), new Info_Column(Msg.translate(Env.getCtx(), "Address1"), "l.name as Address", String.class), new Info_Column(Msg.translate(Env.getCtx(), "IsShipTo"), "l.IsShipTo", Boolean.class), new Info_Column(Msg.translate(Env.getCtx(), "IsBillTo"), "l.IsBillTo", Boolean.class)};
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel labelContact = new CLabel();
    private CTextField fieldContact = new CTextField(10);
    private CLabel labelEMail = new CLabel();
    private CTextField fieldEMail = new CTextField(10);
    private CLabel labelPostal = new CLabel();
    private CTextField fieldPostal = new CTextField(10);
    private CLabel labelPhone = new CLabel();
    private CTextField fieldPhone = new CTextField(10);
    private VCheckBox checkAND = new VCheckBox();
    private VCheckBox checkCustomer = new VCheckBox();

    public InfoBPartner(Frame frame, boolean modal, int WindowNo, String value, boolean isSOTrx, boolean multiSelection, String whereClause) {
        super(frame, modal, WindowNo, "C_BPartner", "C_BPartner_ID", multiSelection, whereClause);
        this.log.info(value);
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoBPartner"));
        this.m_isSOTrx = isSOTrx;
        this.statInit();
        this.initInfo(value, whereClause);
        int no = this.p_table.getRowCount();
        this.setStatusLine(String.valueOf(Integer.toString(no)) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (value != null && value.length() > 0) {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        this.fieldValue.requestFocus();
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg(Env.getCtx(), "Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText(Msg.getMsg(Env.getCtx(), "Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.labelContact.setText(Msg.getMsg(Env.getCtx(), "Contact"));
        this.fieldContact.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldContact.addActionListener(this);
        this.labelEMail.setText(Msg.getMsg(Env.getCtx(), "EMail"));
        this.fieldEMail.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldEMail.addActionListener(this);
        this.labelPostal.setText(Msg.getMsg(Env.getCtx(), "Postal"));
        this.fieldPostal.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldPostal.addActionListener(this);
        this.labelPhone.setText(Msg.translate(Env.getCtx(), "Phone"));
        this.fieldPhone.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldPhone.addActionListener(this);
        this.checkAND.setText(Msg.getMsg(Env.getCtx(), "SearchAND"));
        this.checkAND.setToolTipText(Msg.getMsg(Env.getCtx(), "SearchANDInfo"));
        this.checkAND.setSelected(true);
        this.checkAND.addActionListener(this);
        if (this.m_isSOTrx) {
            this.checkCustomer.setText(Msg.getMsg(Env.getCtx(), "OnlyCustomers"));
        } else {
            this.checkCustomer.setText(Msg.getMsg(Env.getCtx(), "OnlyVendors"));
        }
        this.checkCustomer.setSelected(true);
        this.checkCustomer.setFocusable(false);
        this.checkCustomer.setRequestFocusEnabled(false);
        this.checkCustomer.addActionListener(this);
        this.parameterPanel.setLayout(new ALayout());
        this.parameterPanel.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.parameterPanel.add((Component)this.fieldValue, null);
        this.parameterPanel.add((Component)this.labelContact, null);
        this.parameterPanel.add((Component)this.fieldContact, null);
        this.parameterPanel.add((Component)this.labelPhone, null);
        this.parameterPanel.add((Component)this.fieldPhone, null);
        this.parameterPanel.add((Component)this.checkCustomer, null);
        this.parameterPanel.add((Component)this.labelName, new ALayoutConstraint(1, 0));
        this.parameterPanel.add((Component)this.fieldName, null);
        this.parameterPanel.add((Component)this.labelEMail, null);
        this.parameterPanel.add((Component)this.fieldEMail, null);
        this.parameterPanel.add((Component)this.labelPostal, null);
        this.parameterPanel.add((Component)this.fieldPostal, null);
        this.parameterPanel.add((Component)this.checkAND, null);
    }

    private void initInfo(String value, String whereClause) {
        StringBuffer where = new StringBuffer();
        where.append("C_BPartner.IsSummary='N' AND C_BPartner.IsActive='Y'");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.prepareTable(s_partnerLayout, s_partnerFROM, where.toString(), "C_BPartner.Value");
        int i = 0;
        while (i < this.p_layout.length) {
            if (this.p_layout[i].getIDcolSQL().indexOf("AD_User_ID") != -1) {
                this.m_AD_User_ID_index = i;
            }
            if (this.p_layout[i].getIDcolSQL().indexOf("C_BPartner_Location_ID") != -1) {
                this.m_C_BPartner_Location_ID_index = i;
            }
            ++i;
        }
        if (value == null) {
            this.fieldValue.setText("%");
            this.fieldName.setText("%");
        }
        if (!value.endsWith("%")) {
            value = String.valueOf(value) + "%";
        }
        if (value.equals("%")) {
            this.fieldName.setText(value);
        } else if (value.indexOf(48) + value.indexOf(49) + value.indexOf(50) + value.indexOf(51) + value.indexOf(52) + value.indexOf(53) + value.indexOf(54) + value.indexOf(55) + value.indexOf(56) + value.indexOf(57) == -10) {
            if (value.startsWith("%")) {
                this.fieldName.setText(value);
            } else {
                this.fieldName.setText("%" + value);
            }
            this.fieldValue.setText("%");
        } else {
            this.fieldValue.setText(value);
            this.fieldName.setText("%");
        }
    }

    @Override
    protected String getSQLWhere() {
        String postal;
        String phone;
        String email;
        String contact;
        String name;
        ArrayList<String> list = new ArrayList<String>();
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            list.add("UPPER(C_BPartner.Value) LIKE ?");
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            if (!this.alias()) {
                list.add("UPPER(C_BPartner.Name) LIKE ?");
            } else {
                list.add("(UPPER(C_BPartner.Name) LIKE ? or UPPER(C_BPartner.Alias) LIKE '%" + name + "%' )");
            }
        }
        if (!(contact = this.fieldContact.getText().toUpperCase()).equals("") && !contact.equals("%")) {
            list.add("UPPER(c.Name) LIKE ?");
        }
        if (!(email = this.fieldEMail.getText().toUpperCase()).equals("") && !email.equals("%")) {
            list.add("UPPER(c.EMail) LIKE ?");
        }
        if (!(phone = this.fieldPhone.getText().toUpperCase()).equals("") && !phone.equals("%")) {
            list.add("UPPER(c.Phone) LIKE ?");
        }
        if (!(postal = this.fieldPostal.getText().toUpperCase()).equals("") && !postal.equals("%")) {
            list.add("UPPER(a.Postal) LIKE ?");
        }
        StringBuffer sql = new StringBuffer();
        int size = list.size();
        if (size == 1) {
            sql.append(" AND ").append((String)list.get(0));
        } else if (size > 1) {
            boolean AND = this.checkAND.isSelected();
            sql.append(" AND ");
            if (!AND) {
                sql.append("(");
            }
            int i = 0;
            while (i < size) {
                if (i > 0) {
                    sql.append(AND ? " AND " : " OR ");
                }
                sql.append((String)list.get(i));
                ++i;
            }
            if (!AND) {
                sql.append(")");
            }
        }
        if (this.checkCustomer.isSelected()) {
            sql.append(" AND ");
            if (this.m_isSOTrx) {
                sql.append("C_BPartner.IsCustomer='Y'");
            } else {
                sql.append("C_BPartner.IsVendor='Y'");
            }
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        String postal;
        String phone;
        String email;
        String contact;
        String name;
        int index = 1;
        String value = this.fieldValue.getText().toUpperCase();
        if (!value.equals("") && !value.equals("%")) {
            if (!value.endsWith("%")) {
                value = String.valueOf(value) + "%";
            }
            pstmt.setString(index++, value);
            this.log.fine("Value: " + value);
        }
        if (!(name = this.fieldName.getText().toUpperCase()).equals("") && !name.equals("%")) {
            if (!name.endsWith("%")) {
                name = String.valueOf(name) + "%";
            }
            pstmt.setString(index++, name);
            this.log.fine("Name: " + name);
        }
        if (!(contact = this.fieldContact.getText().toUpperCase()).equals("") && !contact.equals("%")) {
            if (!contact.endsWith("%")) {
                contact = String.valueOf(contact) + "%";
            }
            pstmt.setString(index++, contact);
            this.log.fine("Contact: " + contact);
        }
        if (!(email = this.fieldEMail.getText().toUpperCase()).equals("") && !email.equals("%")) {
            if (!email.endsWith("%")) {
                email = String.valueOf(email) + "%";
            }
            pstmt.setString(index++, email);
            this.log.fine("EMail: " + email);
        }
        if (!(phone = this.fieldPhone.getText().toUpperCase()).equals("") && !phone.equals("%")) {
            if (!phone.endsWith("%")) {
                phone = String.valueOf(phone) + "%";
            }
            pstmt.setString(index++, phone);
            this.log.fine("Phone: " + phone);
        }
        if (!(postal = this.fieldPostal.getText().toUpperCase()).equals("") && !postal.equals("%")) {
            if (!postal.endsWith("%")) {
                postal = String.valueOf(postal) + "%";
            }
            pstmt.setString(index++, postal);
            this.log.fine("Postal: " + postal);
        }
    }

    @Override
    public void saveSelectionDetail() {
        Object data;
        int row = this.p_table.getSelectedRow();
        if (row == -1) {
            return;
        }
        int AD_User_ID = 0;
        int C_BPartner_Location_ID = 0;
        if (this.m_AD_User_ID_index != -1 && (data = this.p_table.getModel().getValueAt(row, this.m_AD_User_ID_index)) instanceof KeyNamePair) {
            AD_User_ID = ((KeyNamePair)data).getKey();
        }
        if (this.m_C_BPartner_Location_ID_index != -1 && (data = this.p_table.getModel().getValueAt(row, this.m_C_BPartner_Location_ID_index)) instanceof KeyNamePair) {
            C_BPartner_Location_ID = ((KeyNamePair)data).getKey();
        }
        Integer ID = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "C_BPartner_ID", ID == null ? "0" : ID.toString());
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "AD_User_ID", String.valueOf(AD_User_ID));
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "C_BPartner_Location_ID", String.valueOf(C_BPartner_Location_ID));
    }

    @Override
    protected void showHistory() {
        this.log.info("");
        Integer C_BPartner_ID = this.getSelectedRowKey();
        if (C_BPartner_ID == null) {
            return;
        }
        InvoiceHistory ih = new InvoiceHistory(this, C_BPartner_ID, 0, 0, 0);
        ih.setVisible(true);
        ih = null;
    }

    @Override
    protected boolean hasHistory() {
        return true;
    }

    @Override
    protected void zoom() {
        this.log.info("InfoBPartner.zoom");
        Integer C_BPartner_ID = this.getSelectedRowKey();
        if (C_BPartner_ID == null) {
            return;
        }
        MQuery query = new MQuery("C_BPartner");
        query.addRestriction("C_BPartner_ID", "=", C_BPartner_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("C_BPartner", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected void customize() {
        this.log.info("InfoBPartner.customize");
    }

    @Override
    protected boolean hasCustomize() {
        return false;
    }

    private boolean alias() {
        boolean retValue;
        block6: {
            retValue = true;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement("select alias from C_Bpartner", null);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        retValue = true;
                    }
                }
                catch (Exception e) {
                    retValue = false;
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return retValue;
    }
}

