/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.Allocation;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MColumn;
import org.compiere.model.MFactAcct;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPayment;
import org.compiere.model.X_C_BankMatch;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class VBankImport
implements FormPanel,
ActionListener,
TableModelListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    public static CLogger log = CLogger.getCLogger(Allocation.class);
    public MBankAccount bankAccount;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private MiniTable paymentOKTable = new MiniTable();
    private CPanel paymentOKPanel = new CPanel();
    private JLabel paymentOKLabel = new JLabel();
    private BorderLayout paymentOKLayout = new BorderLayout();
    private JScrollPane paymentOKScrollPane = new JScrollPane();
    private MiniTable paymentNoTable = new MiniTable();
    private CPanel paymentNoPanel = new CPanel();
    private JLabel paymentNoLabel = new JLabel();
    private BorderLayout paymentNoLayout = new BorderLayout();
    private JScrollPane paymentNoScrollPane = new JScrollPane();
    private MiniTable paymentFreeTable = new MiniTable();
    private CPanel paymentFreePanel = new CPanel();
    private JLabel paymentFreeLabel = new JLabel();
    private BorderLayout paymentFreeLayout = new BorderLayout();
    private JScrollPane paymentFreeScrollPane = new JScrollPane();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private JSplitPane infoPanel = new JSplitPane(1);
    private StatusBar statusBar = new StatusBar();
    private GridBagLayout allocationLayout = new GridBagLayout();
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CPanel allocationPanel = new CPanel();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private JLabel documentTypeLabel = new JLabel();
    protected VLookup documentTypeField;
    private JLabel bankAccountLabel = new JLabel();
    protected VLookup bankAccountField;
    private CLabel amtFromLabel = new CLabel(Msg.translate(Env.getCtx(), "PayAmt"));
    protected VNumber amtFromField = new VNumber("AmtFrom", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtFrom"));
    private CLabel amtToLabel = new CLabel("-");
    protected VNumber amtToField = new VNumber("AmtTo", false, false, true, 12, Msg.translate(Env.getCtx(), "AmtTo"));
    protected CLabel BPartner_idLabel = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    protected VLookup bPartnerLookup;
    private CLabel dateFromLabel = new CLabel(Msg.translate(Env.getCtx(), "DateTrx"));
    protected VDate dateFromField = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel dateToLabel = new CLabel("-");
    protected VDate dateToField = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private JButton actionButton = new JButton();
    private JButton matchButton = new JButton();
    private JButton tempMatchButton = new JButton();
    private JButton delMatchButton = new JButton();
    private JButton searchButton = new JButton();
    private boolean validMatch = false;
    private JCheckBox onlyTemp = new JCheckBox();
    private Trx trx = null;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "Y");
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
            this.trx = Trx.get(Trx.createTrxName("AL"), true);
            this.loadBankAccountOK();
            this.loadBankAccountNO();
            this.loadBankAccountFree();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.mainPanel.setLayout(this.mainLayout);
        this.centerPanel.setLayout(this.centerLayout);
        this.bankAccountLabel.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.paymentNoLabel.setText("Movimiento Importado");
        this.paymentFreeLabel.setText("Documento de Sistema");
        this.paymentOKLabel.setText("Documentos Cotejados");
        this.onlyTemp.setSelected(false);
        this.onlyTemp.setText("Reasignar Temporales");
        this.dateFromLabel.setLabelFor(this.dateFromField);
        this.dateFromField.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.dateToLabel.setLabelFor(this.dateToField);
        this.dateToField.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.amtFromLabel.setLabelFor(this.amtFromField);
        this.amtFromField.setToolTipText(Msg.translate(Env.getCtx(), "AmtFrom"));
        this.amtToLabel.setLabelFor(this.amtToField);
        this.amtToField.setToolTipText(Msg.translate(Env.getCtx(), "AmtTo"));
        this.documentTypeLabel.setText(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.actionButton.setText("Confirmar/Procesar");
        this.matchButton.setText("Cojetar");
        this.tempMatchButton.setText("Cojetar Temporal");
        this.searchButton.setText("Buscar");
        this.delMatchButton.setText("DesCotejar");
        this.matchButton.addActionListener(this);
        this.tempMatchButton.addActionListener(this);
        this.actionButton.addActionListener(this);
        this.searchButton.addActionListener(this);
        this.delMatchButton.addActionListener(this);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.paymentNoPanel.setLayout(this.paymentNoLayout);
        this.paymentFreePanel.setLayout(this.paymentFreeLayout);
        this.paymentOKPanel.setLayout(this.paymentOKLayout);
        this.allocationPanel.setLayout(this.allocationLayout);
        this.paymentNoPanel.setPreferredSize(new Dimension(300, 600));
        this.paymentFreePanel.setPreferredSize(new Dimension(300, 600));
        this.paymentOKPanel.setPreferredSize(new Dimension(400, 300));
        this.bankAccountField.setSize(this.bankAccountField.getWidth() + 10, this.bankAccountField.getHeight() + 10);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.bankAccountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bankAccountField != null) {
            this.parameterPanel.add((Component)this.bankAccountField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        this.parameterPanel.add((Component)this.BPartner_idLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bPartnerLookup, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.documentTypeLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.documentTypeField != null) {
            this.parameterPanel.add((Component)this.documentTypeField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
        this.parameterPanel.add((Component)this.amtFromLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.amtFromField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.amtToLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.amtToField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFromLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateFromField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateToLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.dateToField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.searchButton, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.onlyTemp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.matchButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.tempMatchButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.allocationPanel, "South");
        this.allocationPanel.add((Component)this.delMatchButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.allocationPanel.add((Component)this.actionButton, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.paymentNoPanel.add((Component)this.paymentNoLabel, "North");
        this.paymentNoPanel.add((Component)this.paymentNoScrollPane, "Center");
        this.paymentNoScrollPane.getViewport().add((Component)this.paymentNoTable, null);
        this.paymentFreePanel.add((Component)this.paymentFreeLabel, "North");
        this.paymentFreePanel.add((Component)this.paymentFreeScrollPane, "Center");
        this.paymentFreeScrollPane.getViewport().add((Component)this.paymentFreeTable, null);
        this.paymentOKPanel.add((Component)this.paymentOKLabel, "North");
        this.paymentOKPanel.add((Component)this.paymentOKScrollPane, "Center");
        this.paymentOKScrollPane.getViewport().add((Component)this.paymentOKTable, null);
        this.infoPanel.setLeftComponent(this.paymentNoPanel);
        this.infoPanel.setRightComponent(this.paymentFreePanel);
        this.infoPanel.add((Component)this.paymentNoPanel, "left");
        this.infoPanel.add((Component)this.paymentFreePanel, "right");
        this.infoPanel.setBorder(BorderFactory.createEtchedBorder());
        this.infoPanel.setContinuousLayout(true);
        this.infoPanel.setPreferredSize(new Dimension(800, 600));
        this.centerPanel.add((Component)this.infoPanel, "Center");
        this.centerPanel.add((Component)this.paymentOKPanel, "South");
        this.mainPanel.add((Component)this.centerPanel, "Center");
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    public void dynInit() throws Exception {
        int AD_Column_ID = 4917;
        MLookup lookup = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, AD_Column_ID, 30);
        this.bankAccountField = new VLookup("C_BankAccount_ID", false, false, true, lookup);
        this.bankAccountField.setSize(this.bankAccountField.getWidth() + 10, this.bankAccountField.getHeight() + 10);
        this.bPartnerLookup = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, 3499, 30));
        this.BPartner_idLabel.setLabelFor(this.bPartnerLookup);
        MLookup lookupDocument = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, MColumn.getColumn_ID("C_Payment", "C_DocType_ID"), 19);
        this.documentTypeField = new VLookup("C_DocType_ID", false, false, true, lookupDocument);
        this.onlyTemp.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.config("");
        if (e.getSource().equals(this.actionButton)) {
            log.config("action button");
            this.saveData();
            if (this.onlyTemp.isSelected()) {
                this.loadBankAccountFree();
                this.loadBankAccountTemp();
                Vector data = new Vector();
                this.loadTableNOOIS(data);
            } else {
                this.loadBankAccountOK();
                this.loadBankAccountNO();
            }
        } else if (e.getSource().equals(this.matchButton)) {
            log.config("matching");
            if (this.matching()) {
                if (this.onlyTemp.isSelected()) {
                    this.loadBankAccountFree();
                    this.loadBankAccountTemp();
                    Vector data = new Vector();
                    this.loadTableNOOIS(data);
                } else {
                    this.loadBankAccountOK();
                    this.loadBankAccountNO();
                    this.loadBankAccountFree();
                }
            }
        } else if (e.getSource().equals(this.tempMatchButton)) {
            log.config("temp matching");
            if (this.tempMatching()) {
                this.loadBankAccountOK();
                this.loadBankAccountNO();
                this.loadBankAccountFree();
            }
        } else if (e.getSource().equals(this.searchButton)) {
            log.config("search");
            this.loadBankAccountOK();
            this.loadBankAccountNO();
            this.loadBankAccountFree();
        } else if (e.getSource().equals(this.delMatchButton)) {
            log.config("delmatch");
            if (this.delMatching()) {
                if (this.onlyTemp.isSelected()) {
                    this.loadBankAccountFree();
                    this.loadBankAccountTemp();
                    Vector data = new Vector();
                    this.loadTableNOOIS(data);
                } else {
                    this.loadBankAccountFree();
                    this.loadBankAccountNO();
                    this.loadBankAccountOK();
                }
            }
        } else if (e.getSource().equals(this.onlyTemp)) {
            if (this.onlyTemp.isSelected()) {
                this.loadBankAccountFree();
                this.loadBankAccountTemp();
                Vector data = new Vector();
                this.loadTableNOOIS(data);
                this.tempMatchButton.setEnabled(false);
            } else {
                this.loadBankAccountFree();
                this.loadBankAccountNO();
                this.loadBankAccountOK();
                this.tempMatchButton.setEnabled(true);
            }
        }
    }

    protected void loadBankAccountOK() {
        this.loadTableOKOIS(this.getBankData(true));
    }

    protected void loadBankAccountTemp() {
        this.loadTableOKOIS(this.getBankDataTemp(true));
    }

    protected void loadBankAccountNO() {
        this.loadTableNOOIS(this.getBankData(false));
    }

    protected void loadBankAccountFree() {
        this.loadTableFreeOIS(this.getPaymentData(this.bPartnerLookup.getValue(), this.dateFromField.getValue(), this.dateToField.getValue(), this.amtFromField.getValue(), this.amtToField.getValue(), this.documentTypeField.getValue()));
    }

    protected void loadTableFreeOIS(Vector<?> data) {
        this.paymentFreeTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames2());
        model.addTableModelListener(this);
        this.paymentFreeTable.setModel(model);
        this.configureMiniTable2(this.paymentFreeTable);
    }

    protected void loadTableNOOIS(Vector<?> data) {
        this.paymentNoTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this);
        this.paymentNoTable.setModel(model);
        this.configureMiniTable(this.paymentNoTable);
    }

    protected void loadTableOKOIS(Vector<?> data) {
        this.paymentOKTable.getModel().removeTableModelListener(this);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this);
        this.paymentOKTable.setModel(model);
        this.configureMiniTable(this.paymentOKTable);
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(6);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.translate(Env.getCtx(), "Description"));
        columnNames.add("Folio");
        columnNames.add("Numero");
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add("Movimiento");
        columnNames.add("CodTransaccion");
        columnNames.add(Msg.translate(Env.getCtx(), "C_Payment_ID"));
        columnNames.add(Msg.getElement(Env.getCtx(), "C_BankAccount_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "ID"));
        return columnNames;
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, BigDecimal.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.setColumnClass(8, String.class, true);
        miniTable.setColumnClass(9, String.class, true);
        miniTable.setColumnClass(10, Integer.class, true);
        miniTable.autoSize();
    }

    protected Vector<Vector<Object>> getBankData(boolean isMatched) {
        Vector<Vector<Object>> data;
        block9: {
            data = new Vector<Vector<Object>>();
            if (this.bankAccountField.getValue() == null) {
                return data;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT b.C_BankAccount_id,b.bankaccountno,b.description,b.documentdate,b.folio ");
            sql.append(",b.signo,b.amt,b.c_payment_id,p.documentno,b.C_BankMatch_ID, b.serialno,b.CodTransaction ");
            sql.append("FROM C_BankMatch b");
            sql.append(" Inner JOIN C_BankAccount a ON (b.C_BankAccount_id=a.C_BankAccount_id) ");
            sql.append(" LEFT OUTER JOIN C_Payment p ON (b.C_Payment_ID=p.C_Payment_ID) ");
            sql.append(this.getSQLWhere(isMatched));
            if (isMatched) {
                sql.append(" ORDER BY b.c_payment_id");
            } else {
                sql.append(" ORDER BY b.amt");
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.trx.getTrxName());
                    this.setParameters(pstmt, isMatched);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(6);
                        line.add(new Boolean(false));
                        line.add(rs.getTimestamp(4));
                        line.add(rs.getString(3));
                        line.add(rs.getString(5));
                        line.add(rs.getInt(11));
                        line.add(rs.getBigDecimal(7));
                        line.add(rs.getString(6).trim());
                        line.add(rs.getString(12));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(pp);
                        line.add(rs.getInt(10));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<Vector<Object>> getBankDataTemp(boolean isMatched) {
        Vector<Vector<Object>> data;
        block8: {
            data = new Vector<Vector<Object>>();
            if (this.bankAccountField.getValue() == null) {
                return data;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT b.C_BankAccount_id,b.bankaccountno,b.description,b.documentdate,b.folio ");
            sql.append(",b.signo,b.amt,b.c_payment_id,p.documentno,b.C_BankMatch_ID, b.serialno,b.CodTransaction ");
            sql.append("FROM C_BankMatch b");
            sql.append(" Inner JOIN C_BankAccount a ON (b.C_BankAccount_id=a.C_BankAccount_id) ");
            sql.append(" LEFT OUTER JOIN C_Payment p ON (b.C_Payment_ID=p.C_Payment_ID) ");
            sql.append("WHERE b.Processed='Y' and b.C_Charge_ID is not null");
            if (this.bankAccountField.getValue() != null) {
                sql.append(" AND b.C_BankAccount_ID = ?");
            }
            sql.append(" AND b.IsMatched=? ");
            sql.append(" ORDER BY b.amt");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.trx.getTrxName());
                    this.setParameters(pstmt, isMatched);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(6);
                        line.add(new Boolean(false));
                        line.add(rs.getTimestamp(4));
                        line.add(rs.getString(3));
                        line.add(rs.getString(5));
                        line.add(rs.getInt(11));
                        line.add(rs.getBigDecimal(7));
                        line.add(rs.getString(6).trim());
                        line.add(rs.getString(12));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(pp);
                        line.add(rs.getInt(10));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<String> getOISColumnNames2() {
        Vector<String> columnNames = new Vector<String>(6);
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add("Movimiento");
        columnNames.add(Msg.translate(Env.getCtx(), "C_Payment_ID"));
        columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        columnNames.add(Msg.translate(Env.getCtx(), "Description"));
        columnNames.add("Tipo");
        columnNames.add("Banco");
        return columnNames;
    }

    protected void configureMiniTable2(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, Timestamp.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, BigDecimal.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.autoSize();
    }

    protected Vector<Vector<Object>> getPaymentData(Object BPartner, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType) {
        Vector<Vector<Object>> data;
        block7: {
            data = new Vector<Vector<Object>>();
            if (this.bankAccountField.getValue() == null) {
                return data;
            }
            String sql = "SELECT p.datetrx,p.c_payment_id,p.documentno,p.C_BankAccount_id,a.accountno,p.payamt,l2.name,p.isreceipt, bp.value ||'-'||bp.digito || '/'||bp.name  FROM  C_Payment p  Inner JOIN C_BankAccount a ON (p.C_BankAccount_id=a.C_BankAccount_id)  Inner JOIN C_Bpartner bp  ON (p.C_Bpartner_ID=bp.C_Bpartner_ID)  LEFT OUTER JOIN AD_Ref_List l2 ON (p.TenderType=l2.value and l2.AD_Reference_ID=214) ";
            sql = String.valueOf(sql) + this.getSQLWhere(BPartner, DateFrom, DateTo, AmtFrom, AmtTo, DocType) + " ORDER BY p.payamt";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.trx.getTrxName());
                    this.setParameters(pstmt, false, BPartner, DateFrom, DateTo, AmtFrom, AmtTo, DocType);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(6);
                        line.add(new Boolean(false));
                        line.add(rs.getTimestamp(1));
                        line.add(rs.getString(8).equals("Y") ? "A" : "C");
                        KeyNamePair pp = new KeyNamePair(rs.getInt(2), rs.getString(3));
                        line.add(pp);
                        line.add(rs.getBigDecimal(6));
                        line.add(rs.getString(9));
                        line.add(rs.getString(7));
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(pp);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    void setParameters(PreparedStatement pstmt, boolean forCount, Object BPartner, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType) throws SQLException {
        Comparable<Date> to;
        Comparable<Date> from;
        int index = 1;
        if (this.bankAccountField.getValue() != null) {
            pstmt.setInt(index++, (Integer)this.bankAccountField.getValue());
        }
        if (BPartner != null) {
            Integer bp = (Integer)BPartner;
            pstmt.setInt(index++, bp);
            log.fine("BPartner=" + bp);
        }
        if (DateFrom != null || DateTo != null) {
            from = (Timestamp)DateFrom;
            to = (Timestamp)DateTo;
            log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, (Timestamp)from);
                pstmt.setTimestamp(index++, (Timestamp)to);
            }
        }
        if (AmtFrom != null || AmtTo != null) {
            from = (BigDecimal)AmtFrom;
            to = (BigDecimal)AmtTo;
            log.fine("Amt From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            } else if (from != null && to == null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
            } else if (from != null && to != null) {
                pstmt.setBigDecimal(index++, (BigDecimal)from);
                pstmt.setBigDecimal(index++, (BigDecimal)to);
            }
        }
        if (DocType != null) {
            pstmt.setInt(index++, (Integer)DocType);
        }
    }

    void setParameters(PreparedStatement pstmt, boolean isMatched) throws SQLException {
        int index = 1;
        if (this.bankAccountField.getValue() != null) {
            pstmt.setInt(index++, (Integer)this.bankAccountField.getValue());
        }
        pstmt.setString(index++, isMatched ? "Y" : "N");
    }

    private String getSQLText(String text) {
        String s = text.toUpperCase();
        if (!s.endsWith("%")) {
            s = String.valueOf(s) + "%";
        }
        log.fine("String=" + s);
        return s;
    }

    public String getSQLWhere(boolean isMatched) {
        StringBuffer sql = new StringBuffer("WHERE b.Processed='N' ");
        if (this.bankAccountField.getValue() != null) {
            sql.append(" AND b.C_BankAccount_ID = ?");
        }
        sql.append(" AND b.IsMatched=?");
        log.fine(sql.toString());
        return sql.toString();
    }

    public String getSQLWhere(Object BPartner, Object DateFrom, Object DateTo, Object AmtFrom, Object AmtTo, Object DocType) {
        Comparable<Date> to;
        Comparable<Date> from;
        StringBuffer sql = new StringBuffer("WHERE p.Processed='Y' AND p.IsReconciled='N'  AND p.DocStatus IN ('CO','CL','RE') AND p.PayAmt<>0");
        if (this.bankAccountField.getValue() != null) {
            sql.append(" AND p.C_BankAccount_ID = ?");
        }
        if (BPartner != null) {
            sql.append(" AND p.C_BPartner_ID=?");
        }
        if (DateFrom != null || DateTo != null) {
            from = (Timestamp)DateFrom;
            to = (Timestamp)DateTo;
            if (from == null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(p.DateTrx) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(p.DateTrx) BETWEEN ? AND ?");
            }
        }
        if (AmtFrom != null || AmtTo != null) {
            from = (BigDecimal)AmtFrom;
            to = (BigDecimal)AmtTo;
            if (from == null && to != null) {
                sql.append(" AND p.PayAmt <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND p.PayAmt >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND p.PayAmt BETWEEN ? AND ?");
            }
        }
        if (DocType != null) {
            sql.append(" AND p.C_DocType_ID=?");
        }
        sql.append(" AND Not Exists (select * from C_BankMatch b where b.C_Payment_ID=p.C_Payment_ID)");
        log.fine(sql.toString());
        return sql.toString();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            return;
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        log.config(String.valueOf(name) + "=" + value);
        if (value == null) {
            return;
        }
    }

    public boolean validate() {
        int pRows = this.paymentFreeTable.getRowCount();
        TableModel paymentFree = this.paymentFreeTable.getModel();
        MPayment pay = null;
        int found = 0;
        BigDecimal totalAmtP = new BigDecimal("0.0");
        int i = 0;
        while (i < pRows) {
            if (((Boolean)paymentFree.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)paymentFree.getValueAt(i, 3);
                int C_Payment_ID = pp.getKey();
                pay = new MPayment(Env.getCtx(), C_Payment_ID, null);
                totalAmtP = totalAmtP.add(pay.getPayAmt());
                ++found;
            }
            ++i;
        }
        pRows = this.paymentNoTable.getRowCount();
        TableModel paymentNo = this.paymentNoTable.getModel();
        BigDecimal totalAmt = new BigDecimal("0.0");
        X_C_BankMatch cbank = null;
        int found2 = 0;
        int i2 = 0;
        while (i2 < pRows) {
            if (((Boolean)paymentNo.getValueAt(i2, 0)).booleanValue()) {
                int cbank_ID = (Integer)paymentNo.getValueAt(i2, 10);
                cbank = new X_C_BankMatch(Env.getCtx(), cbank_ID, null);
                totalAmt = totalAmt.add(cbank.getAmt());
                ++found2;
            }
            ++i2;
        }
        if (found > 1 || found2 == 0) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "Debe Seleccionar 1 movimiento");
            return false;
        }
        if (totalAmt.longValue() != totalAmtP.longValue()) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "La comparacion de Montos no Cuadra");
            return false;
        }
        if (pay.isReceipt() && cbank.getSigno().equals("C") || !pay.isReceipt() && cbank.getSigno().equals("A")) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "Los Signos no  Cuadran");
            return false;
        }
        return true;
    }

    public boolean validateTemp() {
        int pRows = this.paymentFreeTable.getRowCount();
        TableModel paymentFree = this.paymentFreeTable.getModel();
        MPayment pay = null;
        int found = 0;
        BigDecimal totalAmtP = new BigDecimal("0.0");
        int i = 0;
        while (i < pRows) {
            if (((Boolean)paymentFree.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp = (KeyNamePair)paymentFree.getValueAt(i, 3);
                int C_Payment_ID = pp.getKey();
                pay = new MPayment(Env.getCtx(), C_Payment_ID, null);
                totalAmtP = totalAmtP.add(pay.getPayAmt());
                ++found;
            }
            ++i;
        }
        pRows = this.paymentOKTable.getRowCount();
        TableModel paymentNo = this.paymentOKTable.getModel();
        BigDecimal totalAmt = new BigDecimal("0.0");
        X_C_BankMatch cbank = null;
        int found2 = 0;
        int i2 = 0;
        while (i2 < pRows) {
            if (((Boolean)paymentNo.getValueAt(i2, 0)).booleanValue()) {
                int cbank_ID = (Integer)paymentNo.getValueAt(i2, 10);
                cbank = new X_C_BankMatch(Env.getCtx(), cbank_ID, null);
                totalAmt = totalAmt.add(cbank.getAmt());
                ++found2;
            }
            ++i2;
        }
        if (found > 1 || found2 == 0) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "Debe Seleccionar 1 movimiento");
            return false;
        }
        if (totalAmt.longValue() != totalAmtP.longValue()) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "La comparacion de Montos no Cuadra");
            return false;
        }
        if (pay.isReceipt() && cbank.getSigno().equals("C") || !pay.isReceipt() && cbank.getSigno().equals("A")) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "Los Signos no  Cuadran");
            return false;
        }
        return true;
    }

    public boolean delMatching() {
        boolean value = false;
        int pRows = this.paymentOKTable.getRowCount();
        TableModel payment = this.paymentOKTable.getModel();
        int charge_ID = DB.getSQLValue(null, "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC12'  and isactive='Y' and AD_client_ID=" + Env.getAD_Client_ID(Env.getCtx()));
        int i = 0;
        while (i < pRows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                int cbank_ID = (Integer)this.paymentOKTable.getValueAt(i, 10);
                X_C_BankMatch cbank = new X_C_BankMatch(Env.getCtx(), cbank_ID, this.trx.getTrxName());
                cbank.setC_Payment_ID(0);
                cbank.set_CustomColumn("C_Charge_ID", null);
                cbank.setIsMatched(false);
                if (this.onlyTemp.isSelected()) {
                    cbank.set_CustomColumn("C_Charge_ID", charge_ID);
                    cbank.setIsMatched(true);
                }
                cbank.save();
                value = true;
            }
            ++i;
        }
        this.trx.commit();
        return value;
    }

    public boolean matching() {
        if (!this.onlyTemp.isSelected()) {
            if (!this.validate()) {
                return false;
            }
            int pRows = this.paymentFreeTable.getRowCount();
            TableModel paymentFree = this.paymentFreeTable.getModel();
            MPayment pay = null;
            int i = 0;
            while (i < pRows) {
                if (((Boolean)paymentFree.getValueAt(i, 0)).booleanValue()) {
                    KeyNamePair pp = (KeyNamePair)paymentFree.getValueAt(i, 3);
                    int C_Payment_ID = pp.getKey();
                    pay = new MPayment(Env.getCtx(), C_Payment_ID, this.trx.getTrxName());
                    break;
                }
                ++i;
            }
            pRows = this.paymentNoTable.getRowCount();
            TableModel paymentNo = this.paymentNoTable.getModel();
            int i2 = 0;
            while (i2 < pRows) {
                if (((Boolean)paymentNo.getValueAt(i2, 0)).booleanValue()) {
                    int cbank_ID = (Integer)paymentNo.getValueAt(i2, 10);
                    X_C_BankMatch cbank = new X_C_BankMatch(Env.getCtx(), cbank_ID, this.trx.getTrxName());
                    cbank.setC_Payment_ID(pay.getC_Payment_ID());
                    cbank.setIsMatched(true);
                    cbank.save();
                }
                ++i2;
            }
        } else {
            if (!this.validateTemp()) {
                return false;
            }
            int pRows = this.paymentFreeTable.getRowCount();
            TableModel paymentFree = this.paymentFreeTable.getModel();
            MPayment pay = null;
            int i = 0;
            while (i < pRows) {
                if (((Boolean)paymentFree.getValueAt(i, 0)).booleanValue()) {
                    KeyNamePair pp = (KeyNamePair)paymentFree.getValueAt(i, 3);
                    int C_Payment_ID = pp.getKey();
                    pay = new MPayment(Env.getCtx(), C_Payment_ID, this.trx.getTrxName());
                    break;
                }
                ++i;
            }
            pRows = this.paymentOKTable.getRowCount();
            TableModel paymentNo = this.paymentOKTable.getModel();
            int i3 = 0;
            while (i3 < pRows) {
                if (((Boolean)paymentNo.getValueAt(i3, 0)).booleanValue()) {
                    int cbank_ID = (Integer)paymentNo.getValueAt(i3, 10);
                    X_C_BankMatch cbank = new X_C_BankMatch(Env.getCtx(), cbank_ID, this.trx.getTrxName());
                    cbank.setC_Payment_ID(pay.getC_Payment_ID());
                    cbank.setIsMatched(true);
                    cbank.save();
                }
                ++i3;
            }
        }
        this.trx.commit();
        return true;
    }

    public boolean tempMatching() {
        int pRows = this.paymentFreeTable.getRowCount();
        TableModel paymentFree = this.paymentFreeTable.getModel();
        int count = 0;
        int i = 0;
        while (i < pRows) {
            if (((Boolean)paymentFree.getValueAt(i, 0)).booleanValue()) {
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "Para Asinacion Temporal solo debe seleccionar movimientos Importados");
            return false;
        }
        pRows = this.paymentNoTable.getRowCount();
        TableModel paymentNo = this.paymentNoTable.getModel();
        int charge_ID = DB.getSQLValue(null, "SELECT C_Charge_ID FROM C_Charge WHERE upper(TipoCargo)='TC12'  and isactive='Y' and AD_client_ID=" + Env.getAD_Client_ID(Env.getCtx()));
        if (charge_ID <= 0) {
            ADialog.error(this.m_WindowNo, this.panel, "Error", "Debe configurar un cargo para las asignaciones temporales");
            return false;
        }
        int i2 = 0;
        while (i2 < pRows) {
            if (((Boolean)paymentNo.getValueAt(i2, 0)).booleanValue()) {
                int cbank_ID = (Integer)paymentNo.getValueAt(i2, 10);
                X_C_BankMatch cbank = new X_C_BankMatch(Env.getCtx(), cbank_ID, this.trx.getTrxName());
                cbank.set_CustomColumn("C_Charge_ID", charge_ID);
                cbank.setIsMatched(true);
                cbank.save();
            }
            ++i2;
        }
        this.trx.commit();
        return true;
    }

    public void saveData() {
        int pRows = this.paymentOKTable.getRowCount();
        TableModel paymentOK = this.paymentOKTable.getModel();
        MBankStatement bank = null;
        int lastPayment_ID = 0;
        int lastBankStatementLine_ID = 0;
        int i = 0;
        while (i < pRows) {
            int cbank_ID = (Integer)paymentOK.getValueAt(i, 10);
            X_C_BankMatch cbank = new X_C_BankMatch(Env.getCtx(), cbank_ID, this.trx.getTrxName());
            if (!this.onlyTemp.isSelected()) {
                MBankStatementLine line;
                if (bank == null) {
                    bank = new MBankStatement(Env.getCtx(), 0, this.trx.getTrxName());
                    bank.setC_BankAccount_ID(cbank.getC_BankAccount_ID());
                    bank.setAD_Org_ID(MBankAccount.get(Env.getCtx(), cbank.getC_BankAccount_ID()).getAD_Org_ID());
                    bank.setName("Generado Automaticamente");
                    bank.setStatementDate(Env.getContextAsDate(Env.getCtx(), "#Date"));
                    try {
                        bank.saveEx();
                    }
                    catch (AdempiereException e) {
                        ADialog.error(this.m_WindowNo, this.panel, "Error", e.getMessage());
                        return;
                    }
                }
                if (cbank.getC_Payment_ID() > 0) {
                    if (lastPayment_ID != cbank.getC_Payment_ID()) {
                        lastPayment_ID = cbank.getC_Payment_ID();
                        line = new MBankStatementLine(bank);
                        if (cbank.getC_Payment_ID() > 0) {
                            line.setPayment(new MPayment(Env.getCtx(), cbank.getC_Payment_ID(), this.trx.getTrxName()));
                        }
                        line.saveEx();
                        lastBankStatementLine_ID = line.getC_BankStatementLine_ID();
                    }
                    cbank.set_CustomColumn("C_BankStatementLine_ID", lastBankStatementLine_ID);
                    cbank.setC_BankStatement_ID(bank.getC_BankStatement_ID());
                    cbank.setProcessed(true);
                    cbank.saveEx();
                } else if (cbank.get_ValueAsInt("C_Charge_ID") > 0) {
                    line = new MBankStatementLine(bank);
                    line.setC_Charge_ID(cbank.get_ValueAsInt("C_Charge_ID"));
                    line.setStatementLineDate(cbank.getStatementDate());
                    if (cbank.getSigno().trim().toUpperCase().equals("A")) {
                        line.setStmtAmt(cbank.getAmt());
                        line.setChargeAmt(cbank.getAmt());
                        line.setTrxAmt(cbank.getAmt());
                    } else {
                        line.setStmtAmt(cbank.getAmt().negate());
                        line.setChargeAmt(cbank.getAmt().negate());
                        line.setTrxAmt(cbank.getAmt().negate());
                    }
                    line.setC_Currency_ID(bank.getC_BankAccount().getC_Currency_ID());
                    line.saveEx();
                    lastBankStatementLine_ID = line.getC_BankStatementLine_ID();
                    cbank.set_CustomColumn("C_BankStatementLine_ID", lastBankStatementLine_ID);
                    cbank.setC_BankStatement_ID(bank.getC_BankStatement_ID());
                    cbank.setProcessed(true);
                    cbank.saveEx();
                }
            } else if (cbank.getC_Payment_ID() > 0) {
                DB.executeUpdate("Update C_BankStatementLine set C_Charge_ID=null, ChargeAmt=0, C_Payment_ID=" + cbank.getC_Payment_ID() + " where C_BankStatementLine_ID=" + cbank.get_ValueAsInt("C_BankStatementLine_ID"), this.trx.getTrxName());
                cbank.set_CustomColumn("C_Charge_ID", null);
                cbank.saveEx();
                MFactAcct.deleteEx(MBankStatement.Table_ID, new MBankStatementLine(Env.getCtx(), cbank.get_ValueAsInt("C_BankStatementLine_ID"), this.trx.getTrxName()).getC_BankStatement_ID(), this.trx.getTrxName());
                this.trx.commit();
            }
            ++i;
        }
        if (bank != null) {
            bank.processIt("CO");
            bank.saveEx();
            this.trx.commit();
        }
    }
}

