/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MProjectLine;
import org.compiere.model.MRole;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class VBOMDrop
extends CPanel
implements FormPanel,
ActionListener {
    private static final long serialVersionUID = 3135475369002895149L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private MProduct m_product;
    private BigDecimal m_qty = Env.ONE;
    private int m_bomLine = 0;
    private static CLogger log = CLogger.getCLogger(VBOMDrop.class);
    private ArrayList<JToggleButton> m_selectionList = new ArrayList();
    private ArrayList<VNumber> m_qtyList = new ArrayList();
    private ArrayList<Integer> m_productList = new ArrayList();
    private HashMap<String, ButtonGroup> m_buttonGroups = new HashMap();
    private static final int WINDOW_WIDTH = 600;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel selectionPanel = new CPanel(new ALayout());
    private CComboBox productField;
    private VNumber productQty = new VNumber("Qty", true, false, true, 29, Msg.translate(Env.getCtx(), "Qty"));
    private CComboBox orderField;
    private CComboBox invoiceField;
    private CComboBox projectField;

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.createSelectionPanel(true, true, true);
            this.m_frame.getContentPane().add((Component)this.selectionPanel, "North");
            this.createMainPanel();
            CScrollPane scroll = new CScrollPane(this);
            this.m_frame.getContentPane().add((Component)scroll, "Center");
            this.confirmPanel.addActionListener(this);
            this.m_frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        this.sizeIt();
    }

    private void sizeIt() {
        this.m_frame.pack();
        Dimension size = this.m_frame.getPreferredSize();
        size.width = 600;
        this.m_frame.setSize(size);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
        this.removeAll();
        if (this.selectionPanel != null) {
            this.selectionPanel.removeAll();
        }
        this.selectionPanel = null;
        if (this.m_selectionList != null) {
            this.m_selectionList.clear();
        }
        this.m_selectionList = null;
        if (this.m_productList != null) {
            this.m_productList.clear();
        }
        this.m_productList = null;
        if (this.m_qtyList != null) {
            this.m_qtyList.clear();
        }
        this.m_qtyList = null;
        if (this.m_buttonGroups != null) {
            this.m_buttonGroups.clear();
        }
        this.m_buttonGroups = null;
    }

    private void createSelectionPanel(boolean order, boolean invoice, boolean project) {
        int row = 0;
        this.selectionPanel.setBorder(new TitledBorder(Msg.translate(Env.getCtx(), "Selection")));
        this.productField = new CComboBox(this.getProducts());
        CLabel label = new CLabel(Msg.translate(Env.getCtx(), "M_Product_ID"));
        label.setLabelFor(this.productField);
        this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
        this.selectionPanel.add(this.productField);
        this.productField.addActionListener(this);
        label = new CLabel(this.productQty.getTitle());
        label.setLabelFor(this.productQty);
        this.selectionPanel.add(label);
        this.selectionPanel.add(this.productQty);
        this.productQty.setValue(Env.ONE);
        this.productQty.addActionListener(this);
        if (order) {
            this.orderField = new CComboBox(this.getOrders());
            label = new CLabel(Msg.translate(Env.getCtx(), "C_Order_ID"));
            label.setLabelFor(this.orderField);
            this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
            this.selectionPanel.add(this.orderField);
            this.orderField.addActionListener(this);
        }
        if (invoice) {
            this.invoiceField = new CComboBox(this.getInvoices());
            label = new CLabel(Msg.translate(Env.getCtx(), "C_Invoice_ID"));
            label.setLabelFor(this.invoiceField);
            this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
            this.selectionPanel.add(this.invoiceField);
            this.invoiceField.addActionListener(this);
        }
        if (project) {
            this.projectField = new CComboBox(this.getProjects());
            label = new CLabel(Msg.translate(Env.getCtx(), "C_Project_ID"));
            label.setLabelFor(this.projectField);
            this.selectionPanel.add((Component)label, new ALayoutConstraint(row++, 0));
            this.selectionPanel.add(this.projectField);
            this.projectField.addActionListener(this);
        }
        this.confirmPanel.getOKButton().setEnabled(false);
        Dimension size = this.selectionPanel.getPreferredSize();
        size.width = 600;
        this.selectionPanel.setPreferredSize(size);
    }

    private KeyNamePair[] getProducts() {
        String sql = "SELECT M_Product_ID, Name FROM M_Product WHERE IsBOM='Y' AND IsVerified='Y' AND IsActive='Y' ORDER BY Name";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "M_Product", false, false), true);
    }

    private KeyNamePair[] getOrders() {
        String sql = "SELECT C_Order_ID, DocumentNo || '_' || GrandTotal FROM C_Order WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "C_Order", false, false), true);
    }

    private KeyNamePair[] getProjects() {
        String sql = "SELECT C_Project_ID, Name FROM C_Project WHERE Processed='N' AND IsSummary='N' AND IsActive='Y' AND ProjectCategory<>'S' ORDER BY Name";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "C_Project", false, false), true);
    }

    private KeyNamePair[] getInvoices() {
        String sql = "SELECT C_Invoice_ID, DocumentNo || '_' || GrandTotal FROM C_Invoice WHERE Processed='N' AND DocStatus='DR' ORDER BY DocumentNo";
        return DB.getKeyNamePairs(MRole.getDefault().addAccessSQL(sql, "C_Invoice", false, false), true);
    }

    private void createMainPanel() {
        log.config(": " + this.m_product);
        this.removeAll();
        this.setPreferredSize(null);
        this.invalidate();
        this.setBorder(null);
        this.m_selectionList.clear();
        this.m_productList.clear();
        this.m_qtyList.clear();
        this.m_buttonGroups.clear();
        this.setLayout(new ALayout());
        String title = Msg.getMsg(Env.getCtx(), "SelectProduct");
        if (this.m_product != null && this.m_product.get_ID() > 0) {
            title = this.m_product.getName();
            if (this.m_product.getDescription() != null && this.m_product.getDescription().length() > 0) {
                this.setToolTipText(this.m_product.getDescription());
            }
            this.m_bomLine = 0;
            this.addBOMLines(this.m_product, this.m_qty);
        }
        this.setBorder(new TitledBorder(title));
    }

    private void addBOMLines(MProduct product, BigDecimal qty) {
        MPPProductBOM bom = MPPProductBOM.getDefault(product, null);
        MPPProductBOMLine[] bomLines = bom.getLines(true);
        for (int i = 0; i < bomLines.length; ++i) {
            this.addBOMLine(bomLines[i], qty);
        }
        log.fine("#" + bomLines.length);
    }

    private void addBOMLine(MPPProductBOMLine line, BigDecimal qty) {
        log.fine(line.toString());
        String bomType = line.getComponentType();
        if (bomType == null) {
            bomType = "CO";
        }
        BigDecimal lineQty = line.getQty();
        MProduct product = line.getProduct();
        if (product == null) {
            return;
        }
        if (product.isBOM() && product.isVerified()) {
            this.addBOMLines(product, lineQty);
        } else {
            this.addDisplay(line.getM_Product_ID(), product.getM_Product_ID(), bomType, product.getName(), line.getFeature(), lineQty);
        }
    }

    private void addDisplay(int parentM_Product_ID, int M_Product_ID, String bomType, String name, String feature, BigDecimal lineQty) {
        log.fine("M_Product_ID=" + M_Product_ID + ",Type=" + bomType + ",Name=" + name + ",feature=" + feature + ",Qty=" + lineQty);
        boolean selected = true;
        if ("CO".equals(bomType)) {
            String title = "";
            JCheckBox cb = new JCheckBox(title);
            cb.setSelected(true);
            cb.setEnabled(false);
            this.m_selectionList.add(cb);
            this.add((Component)cb, new ALayoutConstraint(this.m_bomLine++, 0));
        } else if ("OP".equals(bomType)) {
            JCheckBox cb = new JCheckBox(feature);
            cb.setSelected(false);
            selected = false;
            cb.addActionListener(this);
            this.m_selectionList.add(cb);
            this.add((Component)cb, new ALayoutConstraint(this.m_bomLine++, 0));
        } else if ("VA".equals(bomType)) {
            JRadioButton b = new JRadioButton(feature);
            String groupName = feature + "_" + String.valueOf(parentM_Product_ID) + "_" + bomType;
            ButtonGroup group = this.m_buttonGroups.get(groupName);
            if (group == null) {
                log.fine("ButtonGroup=" + groupName);
                group = new ButtonGroup();
                this.m_buttonGroups.put(groupName, group);
                group.add(b);
                b.setSelected(true);
            } else {
                group.add(b);
                b.setSelected(false);
                selected = false;
            }
            b.addActionListener(this);
            this.m_selectionList.add(b);
            this.add((Component)b, new ALayoutConstraint(this.m_bomLine++, 0));
        }
        this.m_productList.add(new Integer(M_Product_ID));
        VNumber qty = new VNumber("Qty", true, false, true, 29, name);
        qty.setValue(lineQty);
        qty.setReadWrite(selected);
        this.m_qtyList.add(qty);
        CLabel label = new CLabel(name);
        label.setLabelFor(qty);
        this.add(label);
        this.add(qty);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (size.width > 600) {
            size.width = 570;
        }
        return size;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean OK;
        KeyNamePair pp;
        log.config(e.getActionCommand());
        Object source = e.getSource();
        if (source instanceof JCheckBox || source instanceof JRadioButton) {
            this.cmd_selection(source);
            if (source instanceof JRadioButton) {
                for (ButtonGroup group : this.m_buttonGroups.values()) {
                    Enumeration<AbstractButton> en = group.getElements();
                    while (en.hasMoreElements()) {
                        if (source != en.nextElement()) continue;
                        Enumeration<AbstractButton> info = group.getElements();
                        while (info.hasMoreElements()) {
                            AbstractButton infoObj = info.nextElement();
                            if (source == infoObj) continue;
                            this.cmd_selection(infoObj);
                        }
                    }
                }
            }
        } else if (source == this.productField || source == this.productQty) {
            this.m_qty = (BigDecimal)this.productQty.getValue();
            pp = (KeyNamePair)this.productField.getSelectedItem();
            this.m_product = MProduct.get(Env.getCtx(), pp.getKey());
            this.createMainPanel();
            this.sizeIt();
        } else if (source == this.orderField) {
            boolean valid;
            pp = (KeyNamePair)this.orderField.getSelectedItem();
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.invoiceField != null) {
                this.invoiceField.setReadWrite(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setReadWrite(!valid);
            }
        } else if (source == this.invoiceField) {
            boolean valid;
            pp = (KeyNamePair)this.invoiceField.getSelectedItem();
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setReadWrite(!valid);
            }
            if (this.projectField != null) {
                this.projectField.setReadWrite(!valid);
            }
        } else if (source == this.projectField) {
            boolean valid;
            pp = (KeyNamePair)this.projectField.getSelectedItem();
            boolean bl = valid = pp != null && pp.getKey() > 0;
            if (this.orderField != null) {
                this.orderField.setReadWrite(!valid);
            }
            if (this.invoiceField != null) {
                this.invoiceField.setReadWrite(!valid);
            }
        } else if (e.getActionCommand().equals("Ok")) {
            if (this.cmd_save()) {
                this.dispose();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        boolean bl = OK = this.m_product != null;
        if (OK) {
            KeyNamePair pp2 = null;
            if (this.orderField != null) {
                pp2 = (KeyNamePair)this.orderField.getSelectedItem();
            }
            if ((pp2 == null || pp2.getKey() <= 0) && this.invoiceField != null) {
                pp2 = (KeyNamePair)this.invoiceField.getSelectedItem();
            }
            if ((pp2 == null || pp2.getKey() <= 0) && this.projectField != null) {
                pp2 = (KeyNamePair)this.projectField.getSelectedItem();
            }
            OK = pp2 != null && pp2.getKey() > 0;
        }
        this.confirmPanel.getOKButton().setEnabled(OK);
    }

    private void cmd_selection(Object source) {
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (source != this.m_selectionList.get(i)) continue;
            boolean selected = this.isSelectionSelected(source);
            VNumber qty = this.m_qtyList.get(i);
            qty.setReadWrite(selected);
            return;
        }
        log.log(Level.SEVERE, "not found - " + source);
    }

    private boolean isSelectionSelected(Object source) {
        boolean retValue = false;
        if (source instanceof JCheckBox) {
            retValue = ((JCheckBox)source).isSelected();
        } else if (source instanceof JRadioButton) {
            retValue = ((JRadioButton)source).isSelected();
        } else {
            log.log(Level.SEVERE, "Not valid - " + source);
        }
        return retValue;
    }

    private boolean cmd_save() {
        KeyNamePair pp = (KeyNamePair)this.orderField.getSelectedItem();
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveOrder(pp.getKey());
        }
        pp = (KeyNamePair)this.invoiceField.getSelectedItem();
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveInvoice(pp.getKey());
        }
        pp = (KeyNamePair)this.projectField.getSelectedItem();
        if (pp != null && pp.getKey() > 0) {
            return this.cmd_saveProject(pp.getKey());
        }
        log.log(Level.SEVERE, "Nothing selected");
        return false;
    }

    private boolean cmd_saveOrder(int C_Order_ID) {
        log.config("C_Order_ID=" + C_Order_ID);
        MOrder order = new MOrder(Env.getCtx(), C_Order_ID, null);
        if (order.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Order_ID=" + C_Order_ID);
            return false;
        }
        int lineCount = 0;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            BigDecimal qty = (BigDecimal)this.m_qtyList.get(i).getValue();
            int M_Product_ID = this.m_productList.get(i);
            MOrderLine ol = new MOrderLine(order);
            ol.setM_Product_ID(M_Product_ID, true);
            ol.setQty(qty);
            ol.setPrice();
            ol.setTax();
            if (ol.save()) {
                ++lineCount;
                continue;
            }
            log.log(Level.SEVERE, "Line not saved");
        }
        log.config("#" + lineCount);
        return true;
    }

    private boolean cmd_saveInvoice(int C_Invoice_ID) {
        log.config("C_Invoice_ID=" + C_Invoice_ID);
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, null);
        if (invoice.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Invoice_ID=" + C_Invoice_ID);
            return false;
        }
        int lineCount = 0;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            BigDecimal qty = (BigDecimal)this.m_qtyList.get(i).getValue();
            int M_Product_ID = this.m_productList.get(i);
            MInvoiceLine il = new MInvoiceLine(invoice);
            il.setM_Product_ID(M_Product_ID, true);
            il.setQty(qty);
            il.setPrice();
            il.setTax();
            if (il.save()) {
                ++lineCount;
                continue;
            }
            log.log(Level.SEVERE, "Line not saved");
        }
        log.config("#" + lineCount);
        return true;
    }

    private boolean cmd_saveProject(int C_Project_ID) {
        log.config("C_Project_ID=" + C_Project_ID);
        MProject project = new MProject(Env.getCtx(), C_Project_ID, null);
        if (project.get_ID() == 0) {
            log.log(Level.SEVERE, "Not found - C_Project_ID=" + C_Project_ID);
            return false;
        }
        int lineCount = 0;
        for (int i = 0; i < this.m_selectionList.size(); ++i) {
            if (!this.isSelectionSelected(this.m_selectionList.get(i))) continue;
            BigDecimal qty = (BigDecimal)this.m_qtyList.get(i).getValue();
            int M_Product_ID = this.m_productList.get(i);
            MProjectLine pl = new MProjectLine(project);
            pl.setM_Product_ID(M_Product_ID);
            pl.setPlannedQty(qty);
            if (pl.save()) {
                ++lineCount;
                continue;
            }
            log.log(Level.SEVERE, "Line not saved");
        }
        log.config("#" + lineCount);
        return true;
    }
}

