/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.GenForm;
import org.compiere.grid.ed.VLocationDialog;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MOrder;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MPrivateAccess;
import org.compiere.model.MRMA;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.ofb.model.OFBForward;

public class InvoiceGen
extends GenForm {
    private static CLogger log = CLogger.getCLogger(InvoiceGen.class);
    public Object m_AD_Org_ID = null;
    public Object m_C_BPartner_ID = null;
    public Object m_DateFrom = null;
    public Object m_DateTo = null;
    public Object m_User_ID = null;
    public Object m_POReference = null;
    public Object m_BPLocation_ID = null;

    @Override
    public void dynInit() throws Exception {
        this.setTitle("InvGenerateInfo");
        this.setReportEngineType(2);
        this.setAskPrintMsg("PrintInvoices");
    }

    @Override
    public void configureMiniTable(IMiniTable miniTable) {
        miniTable.addColumn("C_Order_ID");
        miniTable.addColumn("AD_Org_ID");
        if (VLocationDialog.getZones(Env.getCtx()).length > 0) {
            miniTable.addColumn("C_Zone_ID");
        }
        miniTable.addColumn("C_DocType_ID");
        miniTable.addColumn("DocumentNo");
        miniTable.addColumn("Description");
        miniTable.addColumn("C_BPartner_ID");
        miniTable.addColumn("DateOrdered");
        miniTable.addColumn("TotalLines");
        miniTable.setMultiSelection(true);
        miniTable.setColumnClass(0, IDColumn.class, false, " ");
        miniTable.setColumnClass(1, String.class, true, Msg.translate(Env.getCtx(), "AD_Org_ID"));
        if (VLocationDialog.getZones(Env.getCtx()).length > 0) {
            miniTable.setColumnClass(2, String.class, true, "Zona");
            miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "C_DocType_ID"));
            miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
            miniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "Description"));
            miniTable.setColumnClass(6, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
            miniTable.setColumnClass(7, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateOrdered"));
            miniTable.setColumnClass(8, String.class, true, Msg.translate(Env.getCtx(), "Location"));
            miniTable.setColumnClass(9, BigDecimal.class, true, Msg.translate(Env.getCtx(), "TotalLines"));
        } else {
            miniTable.setColumnClass(2, String.class, true, Msg.translate(Env.getCtx(), "C_DocType_ID"));
            miniTable.setColumnClass(3, String.class, true, Msg.translate(Env.getCtx(), "DocumentNo"));
            miniTable.setColumnClass(4, String.class, true, Msg.translate(Env.getCtx(), "Description"));
            miniTable.setColumnClass(5, String.class, true, Msg.translate(Env.getCtx(), "C_BPartner_ID"));
            miniTable.setColumnClass(6, Timestamp.class, true, Msg.translate(Env.getCtx(), "DateOrdered"));
            miniTable.setColumnClass(7, BigDecimal.class, true, Msg.translate(Env.getCtx(), "TotalLines"));
        }
        miniTable.autoSize();
    }

    private String getOrderSQL() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer("SELECT ic.C_Order_ID, o.Name, dt.Name, ic.DocumentNo, bp.Name, ic.DateOrdered, ic.TotalLines FROM C_Invoice_Candidate_v ic, AD_Org o, C_BPartner bp, C_DocType dt WHERE ic.AD_Org_ID=o.AD_Org_ID AND ic.C_BPartner_ID=bp.C_BPartner_ID AND ic.C_DocType_ID=dt.C_DocType_ID AND ic.AD_Client_ID=?");
        if (this.m_AD_Org_ID != null) {
            sql.append(" AND ic.AD_Org_ID=").append(this.m_AD_Org_ID);
        } else {
            MRole role = new MRole(Env.getCtx(), Env.getAD_Role_ID(Env.getCtx()), null);
            if (!role.isAccessAllOrgs()) {
                String sqlValidOrg = "";
                sqlValidOrg = role.isUseUserOrgAccess() ? "SELECT AD_Org_ID FROM AD_User_OrgAccess WHERE IsActive = 'Y' AND AD_User_ID = " + Env.getAD_User_ID(Env.getCtx()) : "SELECT AD_Org_ID FROM AD_Role_OrgAccess WHERE IsActive = 'Y' AND AD_Role_ID = " + role.get_ID();
                sql.append(" AND ic.AD_Org_ID IN (" + sqlValidOrg + ")");
            }
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND ic.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if (this.m_DateFrom != null || this.m_DateTo != null) {
            Timestamp from = (Timestamp)this.m_DateFrom;
            Timestamp to = (Timestamp)this.m_DateTo;
            if (from == null && to != null) {
                sql.append(" AND TRUNC(ic.DateOrdered) <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(ic.DateOrdered) >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(ic.DateOrdered) BETWEEN ? AND ?");
            }
        }
        if (this.m_User_ID != null) {
            sql.append(" AND ic.AD_User_ID=?");
        }
        if (this.m_BPLocation_ID != null) {
            sql.append(" AND ic.C_BPartner_Location_ID=?");
        }
        if (this.m_POReference != null && ((String)this.m_POReference).length() > 0) {
            sql.append(" AND ic.POReference=?");
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere(MOrder.Table_ID, AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            if (sql.length() > 0) {
                sql.append(" AND ");
            }
            sql.append("ic.C_Order_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY o.Name,bp.Name,ic.DateOrdered");
        return sql.toString();
    }

    private String getRMASql() {
        int AD_User_ID;
        String lockedIDs;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT rma.M_RMA_ID, org.Name, dt.Name, rma.DocumentNo, bp.Name, rma.Created, rma.Amt ");
        sql.append("FROM M_RMA rma INNER JOIN AD_Org org ON rma.AD_Org_ID=org.AD_Org_ID ");
        sql.append("INNER JOIN C_DocType dt ON rma.C_DocType_ID=dt.C_DocType_ID ");
        sql.append("INNER JOIN C_BPartner bp ON rma.C_BPartner_ID=bp.C_BPartner_ID ");
        sql.append("INNER JOIN M_InOut io ON rma.InOut_ID=io.M_InOut_ID ");
        sql.append("WHERE rma.DocStatus='CO' ");
        sql.append("AND dt.DocBaseType = 'SOO' ");
        sql.append("AND rma.AD_Client_ID=?");
        if (this.m_AD_Org_ID != null) {
            sql.append(" AND rma.AD_Org_ID=").append(this.m_AD_Org_ID);
        }
        if (this.m_C_BPartner_ID != null) {
            sql.append(" AND bp.C_BPartner_ID=").append(this.m_C_BPartner_ID);
        }
        if ((lockedIDs = MPrivateAccess.getLockedRecordWhere(MRMA.Table_ID, AD_User_ID = Env.getContextAsInt(Env.getCtx(), "#AD_User_ID"))) != null) {
            sql.append(" AND rma.M_RMA_ID").append(lockedIDs);
        }
        sql.append(" ORDER BY org.Name, bp.Name, rma.Created ");
        return sql.toString();
    }

    public void executeQuery(KeyNamePair docTypeKNPair, IMiniTable miniTable) {
        log.info("");
        int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        String sql = "";
        sql = docTypeKNPair.getKey() == MOrder.Table_ID ? this.getOrderSQL() : this.getRMASql();
        int row = 0;
        miniTable.setRowCount(row);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, AD_Client_ID);
            int i = 2;
            if (this.m_DateFrom != null || this.m_DateTo != null) {
                Timestamp from = (Timestamp)this.m_DateFrom;
                Timestamp to = (Timestamp)this.m_DateTo;
                log.fine("Date From=" + from + ", To=" + to);
                if (from == null && to != null) {
                    pstmt.setTimestamp(i++, to);
                } else if (from != null && to == null) {
                    pstmt.setTimestamp(i++, from);
                } else if (from != null && to != null) {
                    pstmt.setTimestamp(i++, from);
                    pstmt.setTimestamp(i++, to);
                }
            }
            if (this.m_User_ID != null) {
                pstmt.setInt(i++, (Integer)this.m_User_ID);
            }
            if (this.m_BPLocation_ID != null) {
                pstmt.setInt(i++, (Integer)this.m_BPLocation_ID);
            }
            if (this.m_POReference != null && ((String)this.m_POReference).length() > 0) {
                pstmt.setString(i++, (String)this.m_POReference);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                miniTable.setRowCount(row + 1);
                miniTable.setValueAt(new IDColumn(rs.getInt(1)), row, 0);
                miniTable.setValueAt(rs.getString(2), row, 1);
                miniTable.setValueAt(rs.getString(3), row, 2);
                miniTable.setValueAt(rs.getString(4), row, 3);
                if (OFBForward.NewDescriptionInvoiceGenPA()) {
                    String newDescription = DB.getSQLValueString(null, "SELECT string_agg(documentno, ', ' order by documentno) FROM M_InOut WHERE C_Order_ID = " + rs.getInt(1), new Object[0]);
                    newDescription = String.valueOf(newDescription) + "-" + new MOrder(Env.getCtx(), rs.getInt(1), null).getSalesRep().getName();
                    miniTable.setValueAt(newDescription, row, 4);
                } else {
                    miniTable.setValueAt(new MOrder(Env.getCtx(), rs.getInt(1), null).getDescription(), row, 4);
                }
                miniTable.setValueAt(rs.getString(5), row, 5);
                miniTable.setValueAt(rs.getTimestamp(6), row, 6);
                miniTable.setValueAt(rs.getBigDecimal(7), row, 7);
                ++row;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        miniTable.autoSize();
    }

    @Override
    public void saveSelection(IMiniTable miniTable) {
        log.info("");
        ArrayList<Integer> results = new ArrayList<Integer>();
        this.setSelection(null);
        int rows = miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)miniTable.getValueAt(i, 0);
            if (id != null && id.isSelected()) {
                results.add(id.getRecord_ID());
            }
            ++i;
        }
        if (results.size() == 0) {
            return;
        }
        log.config("Selected #" + results.size());
        this.setSelection(results);
    }

    public String generate(IStatusBar statusBar, KeyNamePair docTypeKNPair, String docActionSelected) {
        String info = "";
        String trxName = Trx.createTrxName("IVG");
        Trx trx = Trx.get(trxName, true);
        this.setSelectionActive(false);
        statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "InvGenerateGen"));
        statusBar.setStatusDB(String.valueOf(this.getSelection().size()));
        int AD_Process_ID = 0;
        AD_Process_ID = docTypeKNPair.getKey() == MRMA.Table_ID ? 52002 : 134;
        MPInstance instance = new MPInstance(Env.getCtx(), AD_Process_ID, 0);
        if (!instance.save()) {
            info = Msg.getMsg(Env.getCtx(), "ProcessNoInstance");
            return info;
        }
        StringBuffer insert = new StringBuffer();
        insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
        int counter = 0;
        for (Integer selectedId : this.getSelection()) {
            if (++counter > 1) {
                insert.append(" UNION ");
            }
            insert.append("SELECT ");
            insert.append(instance.getAD_PInstance_ID());
            insert.append(", ");
            insert.append(selectedId);
            insert.append(" FROM DUAL ");
            if (counter != 1000) continue;
            if (DB.executeUpdate(insert.toString(), trxName) < 0) {
                String msg;
                info = msg = "No Invoices";
                log.config(msg);
                trx.rollback();
                return info;
            }
            insert = new StringBuffer();
            insert.append("INSERT INTO T_SELECTION(AD_PINSTANCE_ID, T_SELECTION_ID) ");
            counter = 0;
        }
        if (counter > 0 && DB.executeUpdate(insert.toString(), trxName) < 0) {
            String msg;
            info = msg = "No Invoices";
            log.config(msg);
            trx.rollback();
            return info;
        }
        ProcessInfo pi = new ProcessInfo("", AD_Process_ID);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        MPInstancePara para = new MPInstancePara(instance, 10);
        para.setParameter("Selection", "Y");
        if (!para.save()) {
            String msg;
            info = msg = "No Selection Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        para = new MPInstancePara(instance, 20);
        para.setParameter("DocAction", docActionSelected);
        if (!para.save()) {
            String msg;
            info = msg = "No DocAction Parameter added";
            log.log(Level.SEVERE, msg);
            return info;
        }
        this.setTrx(trx);
        this.setProcessInfo(pi);
        return info;
    }
}

