/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import org.compiere.apps.AppsAction;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class ConfirmPanel
extends CPanel {
    private static final long serialVersionUID = 6041019802043360966L;
    public static final String A_OK = "Ok";
    public static final String A_CANCEL = "Cancel";
    public static final String A_REFRESH = "Refresh";
    public static final String A_RESET = "Reset";
    public static final String A_CUSTOMIZE = "Customize";
    public static final String A_HISTORY = "History";
    public static final String A_ZOOM = "Zoom";
    public static final String A_PROCESS = "Process";
    public static final String A_PRINT = "Print";
    public static final String A_EXPORT = "Export";
    public static final String A_HELP = "Help";
    public static final String A_DELETE = "Delete";
    public static final String A_PATTRIBUTE = "PAttribute";
    public static final String A_NEW = "New";
    public static Insets s_insets = new Insets(0, 10, 0, 10);
    private CPanel m_addlButtons = null;
    private CButton bOK;
    private CButton bCancel;
    private CButton bRefresh;
    private CButton bReset;
    private CButton bCustomize;
    private CButton bHistory;
    private CButton bZoom;

    public static final CButton createOKButton(String text) {
        AppsAction aa = new AppsAction(A_OK, KeyStroke.getKeyStroke(115, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        button.setDefaultCapable(true);
        return button;
    }

    public static final CButton createOKButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createOKButton(Msg.getMsg(Env.getCtx(), A_OK));
        }
        return ConfirmPanel.createOKButton("");
    }

    public static final CButton createCancelButton(String text) {
        AppsAction aa = new AppsAction(A_CANCEL, KeyStroke.getKeyStroke(27, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createCancelButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createCancelButton(Msg.getMsg(Env.getCtx(), A_CANCEL));
        }
        return ConfirmPanel.createCancelButton("");
    }

    public static final CButton createRefreshButton(String text) {
        AppsAction aa = new AppsAction(A_REFRESH, KeyStroke.getKeyStroke(116, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createRefreshButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createRefreshButton(Msg.getMsg(Env.getCtx(), A_REFRESH));
        }
        return ConfirmPanel.createRefreshButton("");
    }

    public static final CButton createResetButton(String text) {
        AppsAction aa = new AppsAction(A_RESET, null, text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createResetButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createResetButton(Msg.getMsg(Env.getCtx(), A_RESET));
        }
        return ConfirmPanel.createResetButton(null);
    }

    public static final CButton createCustomizeButton(String text) {
        AppsAction aa = new AppsAction(A_CUSTOMIZE, null, text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createCustomizeButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createCustomizeButton(Msg.getMsg(Env.getCtx(), A_CUSTOMIZE));
        }
        return ConfirmPanel.createCustomizeButton(null);
    }

    public static final CButton createHistoryButton(String text) {
        AppsAction aa = new AppsAction(A_HISTORY, KeyStroke.getKeyStroke(120, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createHistoryButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createHistoryButton(Msg.getMsg(Env.getCtx(), A_HISTORY));
        }
        return ConfirmPanel.createHistoryButton(null);
    }

    public static final CButton createZoomButton(String text) {
        AppsAction aa = new AppsAction(A_ZOOM, null, text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createZoomButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createZoomButton(Msg.getMsg(Env.getCtx(), A_ZOOM));
        }
        return ConfirmPanel.createZoomButton(null);
    }

    public static final CButton createProcessButton(String text) {
        AppsAction aa = new AppsAction(A_PROCESS, KeyStroke.getKeyStroke(115, 1), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createProcessButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createProcessButton(Msg.getMsg(Env.getCtx(), A_PROCESS));
        }
        return ConfirmPanel.createProcessButton(null);
    }

    public static final CButton createPrintButton(String text) {
        AppsAction aa = new AppsAction(A_PRINT, KeyStroke.getKeyStroke(123, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createPrintButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createPrintButton(Msg.getMsg(Env.getCtx(), A_PRINT));
        }
        return ConfirmPanel.createPrintButton(null);
    }

    public static final CButton createHelpButton(String text) {
        AppsAction aa = new AppsAction(A_HELP, KeyStroke.getKeyStroke(112, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createHelpButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createHelpButton(Msg.getMsg(Env.getCtx(), A_HELP));
        }
        return ConfirmPanel.createHelpButton(null);
    }

    public static final CButton createExportButton(String text) {
        AppsAction aa = new AppsAction(A_EXPORT, null, text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createExportButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createExportButton(Msg.getMsg(Env.getCtx(), A_EXPORT));
        }
        return ConfirmPanel.createExportButton(null);
    }

    public static final CButton createDeleteButton(String text) {
        AppsAction aa = new AppsAction(A_DELETE, KeyStroke.getKeyStroke(114, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createDeleteButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createDeleteButton(Msg.getMsg(Env.getCtx(), A_DELETE));
        }
        return ConfirmPanel.createDeleteButton(null);
    }

    public static final CButton createPAttributeButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createPAttributeButton(Msg.getMsg(Env.getCtx(), A_PATTRIBUTE));
        }
        return ConfirmPanel.createPAttributeButton(null);
    }

    public static final CButton createPAttributeButton(String text) {
        AppsAction aa = new AppsAction(A_PATTRIBUTE, null, text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public static final CButton createNewButton(boolean withText) {
        if (withText) {
            return ConfirmPanel.createNewButton(Msg.getMsg(Env.getCtx(), A_NEW));
        }
        return ConfirmPanel.createNewButton(null);
    }

    public static final CButton createNewButton(String text) {
        AppsAction aa = new AppsAction(A_NEW, KeyStroke.getKeyStroke(113, 0), text);
        CButton button = (CButton)aa.getButton();
        button.setMargin(s_insets);
        return button;
    }

    public ConfirmPanel() {
        this(false, false, false, false, false, false, true);
    }

    public ConfirmPanel(boolean withCancelButton) {
        this(withCancelButton, false, false, false, false, false, true);
    }

    public ConfirmPanel(boolean withCancelButton, boolean withRefreshButton, boolean withResetButton, boolean withCustomizeButton, boolean withHistoryButton, boolean withZoomButton, boolean withText) {
        BorderLayout mainLayout = new BorderLayout();
        this.setLayout(mainLayout);
        this.setName("confirmPanel");
        CPanel okCancel = new CPanel(new FlowLayout(2));
        okCancel.setOpaque(false);
        this.bCancel = ConfirmPanel.createCancelButton(withText);
        okCancel.add(this.bCancel);
        this.bOK = ConfirmPanel.createOKButton(withText);
        okCancel.add(this.bOK);
        this.setCancelVisible(withCancelButton);
        this.add((Component)okCancel, "East");
        if (withRefreshButton) {
            this.bRefresh = ConfirmPanel.createRefreshButton(withText);
            this.addComponent(this.bRefresh);
        }
        if (withResetButton) {
            this.bReset = ConfirmPanel.createResetButton(withText);
            this.addComponent(this.bReset);
        }
        if (withCustomizeButton) {
            this.bCustomize = ConfirmPanel.createCustomizeButton(withText);
            this.addComponent(this.bCustomize);
        }
        if (withHistoryButton) {
            this.bHistory = ConfirmPanel.createHistoryButton(withText);
            this.addComponent(this.bHistory);
        }
        if (withZoomButton) {
            this.bZoom = ConfirmPanel.createZoomButton(withText);
            this.addComponent(this.bZoom);
        }
    }

    public void addComponent(Component button) {
        if (this.m_addlButtons == null) {
            this.m_addlButtons = new CPanel(new FlowLayout(0));
            this.add((Component)this.m_addlButtons, "West");
        }
        this.m_addlButtons.add(button);
    }

    public CButton addButton(String action, String toolTipText, Icon icon) {
        AppsAction aa = new AppsAction(action, null, toolTipText);
        CButton b = (CButton)aa.getButton();
        this.addComponent(b);
        return b;
    }

    public JButton addButton(JButton button) {
        this.addComponent(button);
        return button;
    }

    public CButton getOKButton() {
        return this.bOK;
    }

    public CButton getCancelButton() {
        return this.bCancel;
    }

    public void setOKVisible(boolean value) {
        this.bOK.setVisible(value);
        this.bOK.setEnabled(value);
    }

    public boolean isOKVisible() {
        return this.bOK.isVisible();
    }

    public void setCancelVisible(boolean value) {
        this.bCancel.setVisible(value);
        this.bCancel.setEnabled(value);
    }

    public boolean isCancelVisible() {
        return this.bCancel.isVisible();
    }

    public CButton getResetButton() {
        return this.bReset;
    }

    public CButton getCustomizeButton() {
        return this.bCustomize;
    }

    public CButton getHistoryButton() {
        return this.bHistory;
    }

    public CButton getZoomButton() {
        return this.bZoom;
    }

    public CButton getRefreshButton() {
        return this.bRefresh;
    }

    public void addActionListener(ActionListener al) {
        ((AppsAction)this.bOK.getAction()).setDelegate(al);
        ((AppsAction)this.bCancel.getAction()).setDelegate(al);
        if (this.bRefresh != null) {
            ((AppsAction)this.bRefresh.getAction()).setDelegate(al);
        }
        if (this.bReset != null) {
            ((AppsAction)this.bReset.getAction()).setDelegate(al);
        }
        if (this.bCustomize != null) {
            ((AppsAction)this.bCustomize.getAction()).setDelegate(al);
        }
        if (this.bHistory != null) {
            ((AppsAction)this.bHistory.getAction()).setDelegate(al);
        }
        if (this.bZoom != null) {
            ((AppsAction)this.bZoom.getAction()).setDelegate(al);
        }
        JRootPane rootpane = null;
        if (al instanceof JDialog) {
            rootpane = ((JDialog)((Object)al)).getRootPane();
        } else if (al instanceof JFrame) {
            rootpane = ((JFrame)((Object)al)).getRootPane();
        }
        if (rootpane != null) {
            rootpane.setDefaultButton(this.bOK);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.bOK.setEnabled(enabled);
        this.bCancel.setEnabled(enabled);
        if (this.bRefresh != null) {
            this.bRefresh.setEnabled(enabled);
        }
        if (this.bCustomize != null) {
            this.bCustomize.setEnabled(enabled);
        }
        if (this.bHistory != null) {
            this.bHistory.setEnabled(enabled);
        }
        if (this.bZoom != null) {
            this.bZoom.setEnabled(enabled);
        }
    }
}

