/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AMenu;
import org.compiere.apps.ATask;
import org.compiere.apps.AWindow;
import org.compiere.apps.ProcessDialog;
import org.compiere.apps.form.FormFrame;
import org.compiere.model.MTask;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class AMenuStartItem
extends Thread
implements ActionListener {
    private int m_ID = 0;
    private boolean m_isMenu = false;
    private String m_name;
    private AMenu m_menu;
    private static CLogger log = CLogger.getCLogger(AMenuStartItem.class);
    private Runnable m_resetPB = new Runnable(){

        @Override
        public void run() {
            AMenuStartItem.this.m_value = 0;
            if (AMenuStartItem.this.m_menu != null) {
                ((AMenuStartItem)AMenuStartItem.this).m_menu.progressBar.setValue(0);
            }
        }
    };
    private Runnable m_tickPB = new Runnable(){

        @Override
        public void run() {
            if (AMenuStartItem.this.m_menu == null) {
                return;
            }
            int tick = 5;
            if (((AMenuStartItem)AMenuStartItem.this).m_menu.progressBar.getValue() < ((AMenuStartItem)AMenuStartItem.this).m_menu.progressBar.getMaximum() - 5) {
                ((AMenuStartItem)AMenuStartItem.this).m_menu.progressBar.setValue(((AMenuStartItem)AMenuStartItem.this).m_menu.progressBar.getValue() + 5);
            }
        }
    };
    private Runnable m_updatePB = new Runnable(){

        @Override
        public void run() {
            if (AMenuStartItem.this.m_menu == null) {
                return;
            }
            AMenuStartItem.this.m_value += AMenuStartItem.this.m_increment;
            if (((AMenuStartItem)AMenuStartItem.this).m_menu.progressBar.getValue() > AMenuStartItem.this.m_value) {
                ((AMenuStartItem)AMenuStartItem.this).m_menu.progressBar.setValue(AMenuStartItem.this.m_value);
            }
        }
    };
    int m_value = 0;
    int m_increment = 20;
    private Timer m_timer = new Timer(500, this);

    public AMenuStartItem(int ID, boolean isMenu, String name, AMenu menu) {
        this.m_ID = ID;
        this.m_isMenu = isMenu;
        this.m_name = name;
        this.m_menu = menu;
        if (menu != null) {
            this.m_increment = (menu.progressBar.getMaximum() - menu.progressBar.getMinimum()) / 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.m_menu != null) {
            this.m_menu.setBusy(true);
        }
        SwingUtilities.invokeLater(this.m_resetPB);
        this.m_timer.start();
        SwingUtilities.invokeLater(this.m_updatePB);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String errmsg = null;
        try {
            String sql = "SELECT * FROM AD_Menu WHERE AD_Menu_ID=?";
            if (!this.m_isMenu) {
                sql = "SELECT * FROM AD_WF_Node WHERE AD_WF_Node_ID=?";
            }
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_ID);
            rs = pstmt.executeQuery();
            SwingUtilities.invokeLater(this.m_updatePB);
            if (rs.next()) {
                String Action2 = rs.getString("Action");
                String IsSOTrx = "Y";
                if (this.m_isMenu) {
                    IsSOTrx = rs.getString("IsSOTrx");
                }
                if (Action2.equals("W")) {
                    int cmd = rs.getInt("AD_Window_ID");
                    this.startWindow(0, cmd);
                } else if (Action2.equals("P") || Action2.equals("R")) {
                    int cmd = rs.getInt("AD_Process_ID");
                    this.startProcess(cmd, IsSOTrx);
                } else if (Action2.equals("B")) {
                    int cmd = rs.getInt("AD_Workbench_ID");
                    this.startWindow(cmd, 0);
                } else if (Action2.equals("F")) {
                    int cmd = this.m_isMenu ? rs.getInt("AD_Workflow_ID") : rs.getInt("Workflow_ID");
                    if (this.m_menu != null) {
                        this.m_menu.startWorkFlow(cmd);
                    }
                } else if (Action2.equals("T")) {
                    int cmd = rs.getInt("AD_Task_ID");
                    this.startTask(cmd);
                } else if (Action2.equals("X")) {
                    int cmd = rs.getInt("AD_Form_ID");
                    this.startForm(cmd);
                } else {
                    log.log(Level.SEVERE, "No valid Action in ID=" + this.m_ID);
                }
            }
            SwingUtilities.invokeLater(this.m_updatePB);
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, "ID=" + this.m_ID, e);
                errmsg = Msg.parseTranslation(Env.getCtx(), e.getMessage());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (errmsg != null) {
            ADialog.error(0, null, "Error", errmsg);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        this.m_timer.stop();
        SwingUtilities.invokeLater(this.m_resetPB);
        if (this.m_menu != null) {
            this.m_menu.setBusy(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(this.m_tickPB);
    }

    private void startWindow(int AD_Workbench_ID, int AD_Window_ID) {
        AWindow frame = (AWindow)Env.showWindow(AD_Window_ID);
        if (frame != null) {
            this.m_menu.getWindowManager().add(frame);
            return;
        }
        if (Ini.isPropertyBool("SingleInstancePerWindow") && (frame = this.m_menu.getWindowManager().find(AD_Window_ID)) != null) {
            frame.toFront();
            return;
        }
        SwingUtilities.invokeLater(this.m_updatePB);
        frame = new AWindow(this.m_menu.getGraphicsConfiguration());
        boolean OK = false;
        OK = AD_Workbench_ID != 0 ? frame.initWorkbench(AD_Workbench_ID) : frame.initWindow(AD_Window_ID, null);
        if (!OK) {
            return;
        }
        SwingUtilities.invokeLater(this.m_updatePB);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        }
        SwingUtilities.invokeLater(this.m_updatePB);
        if (!Ini.isPropertyBool("OpenWindowMaximized")) {
            frame.validate();
            AEnv.showCenterScreen(frame);
        }
        this.m_menu.getWindowManager().add(frame);
        frame = null;
    }

    private void startProcess(int AD_Process_ID, String IsSOTrx) {
        SwingUtilities.invokeLater(this.m_updatePB);
        boolean isSO = false;
        if (IsSOTrx != null && IsSOTrx.equals("Y")) {
            isSO = true;
        }
        this.m_timer.stop();
        ProcessDialog pd = new ProcessDialog(this.m_menu.getGraphicsConfiguration(), AD_Process_ID, isSO);
        if (!pd.init()) {
            return;
        }
        this.m_timer.start();
        this.m_menu.getWindowManager().add(pd);
        SwingUtilities.invokeLater(this.m_updatePB);
        pd.getContentPane().invalidate();
        pd.getContentPane().validate();
        pd.pack();
        SwingUtilities.invokeLater(this.m_updatePB);
        AEnv.showCenterScreen(pd);
    }

    private void startTask(int AD_Task_ID) {
        SwingUtilities.invokeLater(this.m_updatePB);
        PO task = null;
        if (AD_Task_ID > 0) {
            task = new MTask(Env.getCtx(), AD_Task_ID, null);
        }
        if (task.get_ID() != AD_Task_ID) {
            task = null;
        }
        if (task == null) {
            return;
        }
        SwingUtilities.invokeLater(this.m_updatePB);
        this.m_menu.getWindowManager().add(new ATask(this.m_name, (MTask)task));
    }

    private void startForm(int AD_Form_ID) {
        FormFrame ff = null;
        if (Ini.isPropertyBool("SingleInstancePerWindow") && (ff = this.m_menu.getWindowManager().findForm(AD_Form_ID)) != null) {
            ff.toFront();
            return;
        }
        ff = new FormFrame(this.m_menu.getGraphicsConfiguration());
        SwingUtilities.invokeLater(this.m_updatePB);
        boolean ok = ff.openForm(AD_Form_ID);
        if (!ok) {
            ff.dispose();
            return;
        }
        this.m_menu.getWindowManager().add(ff);
        SwingUtilities.invokeLater(this.m_updatePB);
        SwingUtilities.invokeLater(this.m_updatePB);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(ff);
        } else {
            AEnv.showCenterScreen(ff);
        }
    }
}

