/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Payroll;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.eevolution.model.MHRMovement;
import org.eevolution.model.MHRProcess;

public class Doc_HRProcess
extends Doc {
    public MHRProcess process = null;
    public static final String DOCTYPE_Payroll = "HRP";

    public Doc_HRProcess(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MHRProcess.class, rs, DOCTYPE_Payroll, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.process = (MHRProcess)this.getPO();
        this.setDateDoc(this.getDateAcct());
        this.p_lines = this.loadLines(this.process);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MHRProcess process) {
        ArrayList<DocLine_Payroll> list = new ArrayList<DocLine_Payroll>();
        MHRMovement[] lines = process.getLines(true);
        int i = 0;
        while (i < lines.length) {
            MHRMovement line = lines[i];
            DocLine_Payroll docLine = new DocLine_Payroll(line, this);
            this.log.fine(docLine.toString());
            list.add(docLine);
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        String sql = "SELECT m.HR_Concept_id, MAX(c.Name), SUM(m.Amount), MAX(c.AccountSign), MAX(CA.IsBalancing), e.AD_Org_ID, d.C_Activity_ID FROM HR_Movement m INNER JOIN HR_Concept_Acct ca ON (ca.HR_Concept_ID=m.HR_Concept_ID AND ca.IsActive = 'Y') INNER JOIN HR_Concept      c  ON (c.HR_Concept_ID=m.HR_Concept_ID AND c.IsActive = 'Y') INNER JOIN C_BPartner      bp ON (bp.C_BPartner_ID = m.C_BPartner_ID) INNER JOIN HR_Employee\t e  ON (bp.C_BPartner_ID=e.C_BPartner_ID) INNER JOIN HR_Department   d  ON (d.HR_Department_ID=e.HR_Department_ID) WHERE m.HR_Process_ID=? AND (m.Qty <> 0 OR m.Amount <> 0) AND c.AccountSign != 'N' AND ca.IsBalancing != 'Y' GROUP BY m.HR_Concept_ID,e.AD_Org_ID,d.C_Activity_ID ORDER BY e.AD_Org_ID,d.C_Activity_ID";
        ResultSet rs = null;
        CPreparedStatement pstmt = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, this.process.get_TrxName());
                pstmt.setInt(1, this.process.getHR_Process_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int HR_Concept_ID = rs.getInt(1);
                    BigDecimal sumAmount = rs.getBigDecimal(3);
                    sumAmount = sumAmount.setScale(as.getStdPrecision(), 4);
                    String AccountSign = rs.getString(4);
                    int AD_OrgTrx_ID = rs.getInt(6);
                    int C_Activity_ID = rs.getInt(7);
                    if (AccountSign == null || AccountSign.length() <= 0 || !AccountSign.equals("D") && !AccountSign.equals("C")) continue;
                    MAccount accountBPD = MAccount.get(this.getCtx(), this.getAccountBalancing(as.getC_AcctSchema_ID(), HR_Concept_ID, "D"));
                    FactLine debit = fact.createLine(null, accountBPD, as.getC_Currency_ID(), sumAmount, null);
                    debit.setAD_OrgTrx_ID(AD_OrgTrx_ID);
                    debit.setC_Activity_ID(C_Activity_ID);
                    debit.saveEx();
                    MAccount accountBPC = MAccount.get(this.getCtx(), this.getAccountBalancing(as.getC_AcctSchema_ID(), HR_Concept_ID, "C"));
                    FactLine credit = fact.createLine(null, accountBPC, as.getC_Currency_ID(), null, sumAmount);
                    credit.setAD_OrgTrx_ID(AD_OrgTrx_ID);
                    credit.setC_Activity_ID(C_Activity_ID);
                    credit.saveEx();
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, sql, e);
                this.p_Error = e.getLocalizedMessage();
                DB.close(rs, pstmt);
                pstmt = null;
                rs = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            pstmt = null;
            rs = null;
            throw throwable;
        }
        DB.close(rs, pstmt);
        pstmt = null;
        rs = null;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private int getAccountBalancing(int AcctSchema_ID, int HR_Concept_ID, String AccountSign) {
        String field;
        if ("D".equals(AccountSign)) {
            field = "HR_Expense_Acct";
        } else if ("C".equals(AccountSign)) {
            field = "HR_Revenue_Acct";
        } else {
            throw new IllegalArgumentException("Invalid value for AccountSign=" + AccountSign);
        }
        String sqlAccount = "SELECT " + field + " FROM HR_Concept_Acct" + " WHERE HR_Concept_ID=? AND C_AcctSchema_ID=?";
        int Account_ID = DB.getSQLValueEx(this.getTrxName(), sqlAccount, HR_Concept_ID, AcctSchema_ID);
        return Account_ID;
    }
}

