/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.X_DM_PerformanceBond;
import org.compiere.model.X_DM_PerformanceBondDet_Proc;
import org.compiere.model.X_DM_PerformanceBond_Proc;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_DMPerformanceBondProc
extends Doc {
    private int m_precision = -1;

    public Doc_DMPerformanceBondProc(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, X_DM_PerformanceBond_Proc.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        X_DM_PerformanceBond_Proc proc = new X_DM_PerformanceBond_Proc(this.getCtx(), this.getPO().get_ID(), null);
        this.setDateDoc(proc.getDateAcct());
        this.setDateAcct(proc.getDateAcct());
        this.setAmount(0, new BigDecimal("0.0"));
        this.setAmount(1, new BigDecimal("0.0"));
        return null;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue);
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact;
        ArrayList<Fact> facts;
        block18: {
            facts = new ArrayList<Fact>();
            X_DM_PerformanceBond_Proc procDoc = new X_DM_PerformanceBond_Proc(this.getCtx(), this.p_po.get_ID(), this.getTrxName());
            MDocType type = MDocType.get(this.getCtx(), procDoc.getC_DocType_ID());
            if (!type.get_ValueAsBoolean("Posted")) {
                return facts;
            }
            fact = new Fact(this, as, "A");
            if (!as.isAccrual()) {
                return facts;
            }
            if (this.getDocumentType().equals("PBA")) {
                FactLine fl = null;
                FactLine fl2 = null;
                BigDecimal amtConvert = null;
                this.log.config("variables para la conversion:" + procDoc.getAmt() + " , " + procDoc.getC_Currency_ID() + " , " + as.getC_Currency_ID() + " , " + this.getDateAcct() + " , " + 114 + " , " + this.getAD_Client_ID() + " , " + this.getAD_Org_ID());
                if (procDoc.getC_Currency_ID() != as.getC_Currency_ID()) {
                    amtConvert = MConversionRate.convert(this.getCtx(), procDoc.getAmt(), procDoc.getC_Currency_ID(), as.getC_Currency_ID(), this.getDateAcct(), 114, this.getAD_Client_ID(), this.getAD_Org_ID());
                    this.log.config("monto dentro de if: " + amtConvert);
                } else {
                    amtConvert = procDoc.getAmt();
                }
                fl = fact.createLine(null, this.getAccount(209, as), as.getC_Currency_ID(), amtConvert, null);
                fl.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl.save();
                fl2 = fact.createLine(null, this.getAccount(210, as), as.getC_Currency_ID(), amtConvert.negate(), null);
                fl2.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl2.save();
            } else if (this.getDocumentType().equals("PBB")) {
                FactLine fl = null;
                FactLine fl2 = null;
                X_DM_PerformanceBond boleta = new X_DM_PerformanceBond(this.getCtx(), procDoc.getDM_PerformanceBond_ID(), this.getTrxName());
                BigDecimal amtConvert = new BigDecimal("0.0");
                Timestamp dateDoc = (Timestamp)boleta.get_Value("DateDoc");
                amtConvert = procDoc.getC_Currency_ID() != as.getC_Currency_ID() ? MConversionRate.convert(this.getCtx(), boleta.getAmt(), procDoc.getC_Currency_ID(), as.getC_Currency_ID(), dateDoc, 114, this.getAD_Client_ID(), this.getAD_Org_ID()) : boleta.getAmt();
                fl = fact.createLine(null, this.getAccount(215, as), as.getC_Currency_ID(), amtConvert, null);
                fl.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl.save();
                fl2 = fact.createLine(null, this.getAccount(216, as), as.getC_Currency_ID(), amtConvert.negate(), null);
                fl2.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl2.save();
            } else if (this.getDocumentType().equals("PBC")) {
                FactLine fl = null;
                FactLine fl2 = null;
                FactLine fl3 = null;
                FactLine fl4 = null;
                X_DM_PerformanceBond boleta = new X_DM_PerformanceBond(this.getCtx(), procDoc.getDM_PerformanceBond_ID(), this.getTrxName());
                BigDecimal amtConvert = new BigDecimal("0.0");
                Timestamp dateDoc = (Timestamp)boleta.get_Value("DateDoc");
                amtConvert = procDoc.getC_Currency_ID() != as.getC_Currency_ID() ? MConversionRate.convert(this.getCtx(), boleta.getAmt(), procDoc.getC_Currency_ID(), as.getC_Currency_ID(), dateDoc, 114, this.getAD_Client_ID(), this.getAD_Org_ID()) : boleta.getAmt();
                int C_VCombinationTemp_ID = DB.getSQLValue(this.getTrxName(), "SELECT DM_Cobro_Acct  FROM C_Bank WHERE C_Bank_ID = " + boleta.getC_Bank_ID());
                MAccount acct = MAccount.get(as.getCtx(), C_VCombinationTemp_ID);
                fl = fact.createLine(null, acct, as.getC_Currency_ID(), amtConvert, null);
                fl.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl.save();
                fl2 = fact.createLine(null, this.getAccount(214, as), as.getC_Currency_ID(), amtConvert.negate(), null);
                fl2.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl2.save();
                fl3 = fact.createLine(null, this.getAccount(215, as), as.getC_Currency_ID(), amtConvert, null);
                fl3.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl3.save();
                fl4 = fact.createLine(null, this.getAccount(216, as), as.getC_Currency_ID(), amtConvert.negate(), null);
                fl4.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                fl4.save();
            } else if (this.getDocumentType().equals("PBV")) {
                String sqlDetail = "SELECT DM_PerformanceBondDet_Proc_ID FROM DM_PerformanceBondDet_Proc WHERE DM_PerformanceBond_Proc_ID = ? ";
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sqlDetail, this.getTrxName());
                        pstmt.setInt(1, this.p_po.get_ID());
                        rs = pstmt.executeQuery();
                        while (rs.next()) {
                            FactLine fl = null;
                            FactLine fl2 = null;
                            X_DM_PerformanceBondDet_Proc detail = new X_DM_PerformanceBondDet_Proc(this.getCtx(), rs.getInt(1), this.getTrxName());
                            X_DM_PerformanceBond boletaDetail = new X_DM_PerformanceBond(this.getCtx(), detail.getDM_PerformanceBond_ID(), this.getTrxName());
                            BigDecimal amtConvert = new BigDecimal("0.0");
                            Timestamp dateDoc = (Timestamp)boletaDetail.get_Value("DateDoc");
                            amtConvert = procDoc.getC_Currency_ID() != as.getC_Currency_ID() ? MConversionRate.convert(this.getCtx(), boletaDetail.getAmt(), procDoc.getC_Currency_ID(), as.getC_Currency_ID(), dateDoc, 114, this.getAD_Client_ID(), this.getAD_Org_ID()) : boletaDetail.getAmt();
                            fl = fact.createLine(null, this.getAccount(215, as), as.getC_Currency_ID(), amtConvert, null);
                            fl.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                            fl.save();
                            fl2 = fact.createLine(null, this.getAccount(216, as), as.getC_Currency_ID(), amtConvert.negate(), null);
                            fl2.setC_BPartner_ID(procDoc.getC_BPartner_ID());
                            fl2.save();
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, sqlDetail, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            } else {
                this.p_Error = "DocumentType unknown: " + this.getDocumentType();
                this.log.log(Level.SEVERE, this.p_Error);
                fact = null;
            }
        }
        facts.add(fact);
        return facts;
    }
}

