/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocLine_Bank;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MPeriod;
import org.compiere.util.Env;

public class Doc_BankStatement
extends Doc {
    private int m_C_BankAccount_ID = 0;

    public Doc_BankStatement(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MBankStatement.class, rs, "CMB", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MBankStatement bs = (MBankStatement)this.getPO();
        this.setDateDoc(bs.getStatementDate());
        this.setDateAcct(bs.getStatementDate());
        this.m_C_BankAccount_ID = bs.getC_BankAccount_ID();
        this.setAmount(0, bs.getStatementDifference());
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.m_C_BankAccount_ID);
        this.setC_Currency_ID(ba.getC_Currency_ID());
        this.p_lines = this.loadLines(bs);
        this.log.fine("Lines=" + this.p_lines.length);
        return null;
    }

    private DocLine[] loadLines(MBankStatement bs) {
        ArrayList<DocLine_Bank> list = new ArrayList<DocLine_Bank>();
        MBankStatementLine[] lines = bs.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            DocLine_Bank docLine = new DocLine_Bank(line, this);
            if (i == 0) {
                this.setDateAcct(bs.getStatementDate());
            }
            docLine.setDateAcct(bs.getStatementDate());
            MPeriod period = MPeriod.get(this.getCtx(), docLine.getDateAcct(), line.getAD_Org_ID());
            if (period != null && period.isOpen("CMB", line.getDateAcct())) {
                docLine.setC_Period_ID(period.getC_Period_ID());
            }
            list.add(docLine);
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        int i = 0;
        while (i < this.p_lines.length) {
            BigDecimal lineBalance = ((DocLine_Bank)this.p_lines[i]).getStmtAmt();
            retValue = retValue.subtract(lineBalance);
            sb.append("-").append(lineBalance);
            ++i;
        }
        sb.append("]");
        this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue + sb.toString());
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        FactLine fl = null;
        int AD_Org_ID = this.getBank_Org_ID();
        ArrayList<Fact> facts = new ArrayList<Fact>();
        MBankStatement bs = (MBankStatement)this.getPO();
        if (bs.getDocStatus().equals("VO")) {
            return facts;
        }
        int i = 0;
        while (i < this.p_lines.length) {
            DocLine_Bank line = (DocLine_Bank)this.p_lines[i];
            int C_BPartner_ID = line.getC_BPartner_ID();
            AD_Org_ID = line.getAD_Org_ID();
            MAccount acct_bank_asset = this.getAccount(40, as);
            MAccount acct_bank_in_transit = this.getAccount(11, as);
            if (!as.isPostIfClearingEqual() && acct_bank_asset.equals(acct_bank_in_transit)) {
                BigDecimal amt_stmt_minus_trx = line.getStmtAmt().subtract(line.getTrxAmt());
                if (amt_stmt_minus_trx.compareTo(Env.ZERO) != 0) {
                    fl = fact.createLine(line, this.getAccount(40, as), line.getC_Currency_ID(), amt_stmt_minus_trx);
                    if (fl != null && AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    }
                    if (fl != null && C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                }
            } else {
                fl = fact.createLine(line, this.getAccount(40, as), line.getC_Currency_ID(), line.getStmtAmt());
                if (fl != null && AD_Org_ID != 0) {
                    fl.setAD_Org_ID(AD_Org_ID);
                }
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                if ((fl = "K".equals(line.getm_TenderType()) && "Y".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(15, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : ("L".equals(line.getm_TenderType()) && "Y".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(16, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : ("K".equals(line.getm_TenderType()) && "N".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(17, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : ("L".equals(line.getm_TenderType()) && "N".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(18, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : ("V".equals(line.getm_TenderType()) && "Y".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(19, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : ("P".equals(line.getm_TenderType()) && "Y".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(201, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : ("V".equals(line.getm_TenderType()) && "N".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(200, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : ("P".equals(line.getm_TenderType()) && "N".equals(line.getm_isReceipt()) ? fact.createLine(line, this.getAccount(202, as), line.getC_Currency_ID(), line.getTrxAmt().negate()) : fact.createLine(line, this.getAccount(11, as), line.getC_Currency_ID(), line.getTrxAmt().negate()))))))))) != null) {
                    if (C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                    if (AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    } else {
                        fl.setAD_Org_ID(line.getAD_Org_ID(true));
                    }
                }
            }
            if ((fl = line.getChargeAmt().compareTo(Env.ZERO) > 0 ? fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), null, line.getChargeAmt()) : fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getChargeAmt().negate(), null)) != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            if ((fl = line.getInterestAmt().signum() < 0 ? fact.createLine((DocLine)line, this.getAccount(42, as), this.getAccount(42, as), line.getC_Currency_ID(), line.getInterestAmt().negate()) : fact.createLine((DocLine)line, this.getAccount(41, as), this.getAccount(41, as), line.getC_Currency_ID(), line.getInterestAmt().negate())) != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            ++i;
        }
        facts.add(fact);
        return facts;
    }

    private int getBank_Org_ID() {
        if (this.m_C_BankAccount_ID == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.m_C_BankAccount_ID);
        return ba.getAD_Org_ID();
    }
}

