/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.model;

import java.math.BigDecimal;
import org.adempiere.exceptions.AdempiereException;
import org.blumos.model.BlumosUtilities;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_T_BL_VAC_SOLICITUD;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.ofb.utils.DateUtils;

public class ModBlumosVacaciones
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBlumosVacaciones.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("T_BL_VAC_SOLICITUD", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 2 || type == 1) && po.get_Table_ID() == X_T_BL_VAC_SOLICITUD.Table_ID) {
            BigDecimal v_pp;
            BigDecimal v_progresivo;
            X_T_BL_VAC_SOLICITUD solVac = (X_T_BL_VAC_SOLICITUD)po;
            if (solVac.getDESDE() == null) {
                throw new AdempiereException("DEBE ESPECIFICAR FECHA DE INICIO DE FERIADO. PUSO: " + solVac.getDESDE());
            }
            if (solVac.getHASTA() == null) {
                throw new AdempiereException("DEBE ESPECIFICAR FECHA DE FIN DE FERIADO. PUSO: " + solVac.getHASTA());
            }
            if (solVac.getHASTA().compareTo(solVac.getDESDE()) < 0) {
                throw new AdempiereException("FECHA DE FIN NO PUEDE SER ANTERIOR A FECHA DE INICIO. PUSO DESDE: " + solVac.getDESDE() + " HASTA: " + solVac.getHASTA());
            }
            BigDecimal v_normal = DB.getSQLValueBD(po.get_TrxName(), "Select Sum(Dias) From T_Bl_Vac_Movimientos Where Fecha_Movimiento<=now() And C_Bpartner_Id=" + solVac.getC_BPartner_ID() + " And Progresivo='N'", new Object[0]);
            if (v_normal == null) {
                v_normal = Env.ZERO;
            }
            if ((v_progresivo = DB.getSQLValueBD(po.get_TrxName(), "SELECT coalesce((select sum(dias) from t_bl_vac_movimientos where fecha_movimiento<=sysdate and c_bpartner_id=" + solVac.getC_BPartner_ID() + " and progresivo='Y'),0) from dual", new Object[0])) == null) {
                v_progresivo = Env.ZERO;
            }
            if ((v_pp = DB.getSQLValueBD(po.get_TrxName(), "SELECT ((Trunc(Mod(Months_Between(?,Fecha_Ingreso),12)))*1.25) from t_bl_vac_maestro where c_bpartner_id=" + solVac.getC_BPartner_ID(), DateUtils.today())) == null) {
                v_pp = Env.ZERO;
            }
            BigDecimal v_total = v_normal.add(v_pp).add(v_progresivo);
            solVac.setSALDO_NORMAL(v_normal);
            solVac.setSALDO_PP(v_pp);
            solVac.setSALDO_PROGRESIVO(v_progresivo);
            solVac.setSALDO_TOTAL(v_total);
            int v_diasInt = BlumosUtilities.DameDiasHabiles(solVac.getDESDE(), solVac.getHASTA(), po.getCtx(), po.get_TrxName());
            BigDecimal v_dias = BigDecimal.valueOf(v_diasInt);
            if (solVac.isMEDIO_DIA()) {
                v_dias = new BigDecimal("0.5");
            }
            solVac.setDIAS(v_dias);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }
}

