/*
 * Decompiled with CFR 0.152.
 */
package org.blumos.model;

import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;

public class ModBlumosFechaOtif
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModBlumosFechaOtif.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID) {
            MOrder order = (MOrder)po;
            MOrderLine[] lines = order.getLines(true, null);
            int i = 0;
            while (i < lines.length) {
                MOrderLine line = lines[i];
                Timestamp date = (Timestamp)line.get_Value("rrstartdate");
                if (date == null) {
                    line.set_CustomColumn("rrstartdate", line.getDatePromised());
                    line.set_CustomColumn("Qty_Original", line.getQtyOrdered());
                    line.save(po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }
}

