/*
 * Decompiled with CFR 0.152.
 */
package org.andes.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.X_CD_Header;
import org.compiere.model.X_CD_Line;
import org.compiere.model.X_C_OtherExpenses;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProcessOtherExpenses
extends SvrProcess {
    private String P_DocAction;
    private int Record_ID;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.P_DocAction = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        X_C_OtherExpenses other = new X_C_OtherExpenses(this.getCtx(), this.Record_ID, this.get_TrxName());
        if (this.P_DocAction.compareToIgnoreCase("CO") == 0) {
            if (other.get_ValueAsBoolean("override")) {
                other.setDocStatus("CO");
                other.set_CustomColumn("Processed", true);
            } else {
                Calendar cal = Calendar.getInstance();
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                Timestamp dateNow = new Timestamp(cal.getTimeInMillis());
                if (other.getDocStatus().compareToIgnoreCase("DR") == 0) {
                    if (other.getExpense().compareToIgnoreCase("RE") == 0) {
                        String sql = "SELECT currency_20000+currency_10000+currency_5000+currency_2000+currency_1000+ currency_500+currency_100+currency_50+currency_10+currency_5+currency_1  FROM C_OtherExpenses WHERE C_OtherExpenses_ID = ?";
                        BigDecimal totallines = DB.getSQLValueBD(this.get_TrxName(), sql, this.Record_ID);
                        if (totallines == null) {
                            totallines = Env.ZERO;
                        }
                        if (totallines.compareTo(other.getGrandTotal()) != 0) {
                            throw new AdempiereException("Error: Total Solicitado no cuadra con total detalle");
                        }
                        other.setDocStatus("L1");
                    } else {
                        other.setDocStatus("L1");
                    }
                } else if (other.getDocStatus().compareToIgnoreCase("L1") == 0) {
                    other.setDocStatus("L2");
                } else if (other.getDocStatus().compareToIgnoreCase("L2") == 0) {
                    MBankAccount bAccountTo = new MBankAccount(this.getCtx(), other.getC_BankAccount_ID(), this.get_TrxName());
                    int ID_DisponTo = 0;
                    ID_DisponTo = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(CD_Header_ID) FROM CD_Header  WHERE C_BankAccount_ID = " + bAccountTo.get_ID() + " AND DateTrx = ? ", dateNow);
                    if (ID_DisponTo <= 0) {
                        throw new AdempiereException("Error: No existe disponibilidad para cuenta bancaria");
                    }
                    other.setDocStatus("CO");
                    other.set_CustomColumn("Processed", true);
                    if (ID_DisponTo > 0) {
                        X_CD_Header dispon = new X_CD_Header(this.getCtx(), ID_DisponTo, this.get_TrxName());
                        X_CD_Line newLine = new X_CD_Line(this.getCtx(), 0, this.get_TrxName());
                        newLine.setCD_Header_ID(dispon.get_ID());
                        newLine.setAD_Org_ID(dispon.getAD_Org_ID());
                        newLine.setAmt(other.getGrandTotal());
                        newLine.setDescription("Generado desde Otro Gasto " + other.getDocumentNo());
                        newLine.setC_BankAccount_ID(other.getC_BankAccount_ID());
                        newLine.setType("EG");
                        newLine.set_CustomColumn("C_OtherExpenses_ID", other.get_ID());
                        int id_charge = DB.getSQLValue(this.get_TrxName(), "SELECT MAX(C_Charge_ID)  FROM C_Charge cc  INNER JOIN C_ChargeType ct ON (cc.C_ChargeType_ID = ct.C_ChargeType_ID)  WHERE cc.IsActive = 'Y' AND ct.value = 'TCRA'");
                        if (id_charge > 0) {
                            newLine.set_CustomColumn("C_Charge_ID", id_charge);
                        }
                        newLine.save();
                    }
                }
            }
        }
        if (this.P_DocAction.compareToIgnoreCase("VO") == 0) {
            if (other.getDocStatus().compareToIgnoreCase("L2") == 0) {
                other.setDocStatus("L1");
            } else if (other.getDocStatus().compareToIgnoreCase("L1") == 0) {
                other.setDocStatus("DR");
            }
        }
        other.save();
        return "Procesado";
    }
}

