/*
 * Decompiled with CFR 0.152.
 */
package org.andes.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.X_CD_Header;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GenerateCD3
extends SvrProcess {
    private Timestamp p_dateTrx;
    private int created = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("DateTrx")) {
                this.p_dateTrx = (Timestamp)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
    }

    @Override
    protected String doIt() throws Exception {
        block6: {
            StringBuffer sql = new StringBuffer("SELECT AD_Org_ID,C_Bank_ID,C_BankAccount_ID FROM C_BankAccount WHERE IsActive = 'Y' AND AD_Client_ID = " + Env.getAD_Client_ID(this.getCtx()) + " AND C_BankAccount_ID NOT IN (SELECT C_BankAccount_ID FROM CD_Header WHERE IsActive = 'Y' AND DateTrx = ?)");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                    pstmt.setTimestamp(1, this.p_dateTrx);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        X_CD_Header head = new X_CD_Header(this.getCtx(), 0, this.get_TrxName());
                        head.setAD_Org_ID(rs.getInt("AD_Org_ID"));
                        head.setC_Bank_ID(rs.getInt("C_Bank_ID"));
                        head.setC_BankAccount_ID(rs.getInt("C_BankAccount_ID"));
                        head.setDateTrx(this.p_dateTrx);
                        head.save();
                        ++this.created;
                    }
                }
                catch (Exception e) {
                    this.log.severe(e.getMessage());
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "Generadas " + this.created;
    }
}

