/*
 * Decompiled with CFR 0.152.
 */
package org.aguas.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import org.compiere.model.MClient;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_DM_PerformanceBond_Proc;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModelOFBAguasBoletaDeGarantia
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModelOFBAguasBoletaDeGarantia.class);
    private int m_AD_Client_ID = -1;

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addModelChange("DM_PerformanceBond_Proc", this);
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        X_DM_PerformanceBond_Proc proc;
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        if ((type == 1 || type == 2) && po.get_Table_ID() == X_DM_PerformanceBond_Proc.Table_ID) {
            BigDecimal d;
            BigDecimal result;
            proc = (X_DM_PerformanceBond_Proc)po;
            Timestamp dateStat = (Timestamp)proc.get_Value("DateTrxRef");
            Timestamp dateEnd = (Timestamp)proc.get_Value("DateAcctRef");
            Timestamp dateReceipt = (Timestamp)proc.get_Value("DateReception");
            if (dateStat != null && dateEnd != null && dateStat.compareTo(dateEnd) >= 0) {
                return "Error: Fecha Emision Debe Ser menor a Fecha de Vencimiento";
            }
            if (dateReceipt != null && dateEnd != null && dateReceipt.compareTo(dateEnd) >= 0) {
                return "Error: Fecha de recepci\u00f3n no puede ser posterior al vencimiento";
            }
            if (proc.getC_DocType().getDocBaseType().equals("PBA") && (result = (d = proc.getAmt()).subtract(d.setScale(0, RoundingMode.FLOOR)).movePointRight(d.scale())).compareTo(Env.ZERO) > 0 && proc.getC_Currency_ID() == 228) {
                return "Error: Moneda no soporta numero con decimales";
            }
            if (proc.getC_DocType().getDocBaseType().equals("PBA")) {
                int actualrol;
                String documentNo = (String)proc.get_Value("DocumentRefNo");
                if (!ModelOFBAguasBoletaDeGarantia.isNumeric(documentNo)) {
                    return "Error: Numero de Boleta No V\u00e1lido";
                }
                String sqlCant = "SELECT COUNT(1) FROM DM_PerformanceBond_Proc WHERE DocumentRefNo = '" + proc.get_ValueAsString("DocumentRefNo") + "' AND C_Bank_ID = " + proc.get_ValueAsInt("C_Bank_ID") + " AND DM_PerformanceBond_Proc_ID <> " + proc.get_ID();
                int cantValid = DB.getSQLValue(po.get_TrxName(), sqlCant);
                if (cantValid > 0) {
                    return "Error: Numero de Boleta ya Usado";
                }
                if (proc.getAmt().compareTo(Env.ZERO) <= 0) {
                    return "Error:  Monto No Puede ser 0";
                }
                Timestamp emision = proc.getDateTrxRef();
                Timestamp recepcion = (Timestamp)proc.get_Value("DateReception");
                if (emision != null && recepcion != null && recepcion.compareTo(emision) < 0) {
                    return "Error: Fecha de Recepcion NO Valida";
                }
                if (type == 1 && (actualrol = Env.getContextAsInt(Env.getCtx(), "#AD_Role_ID")) != 1000048 && actualrol != 1000000) {
                    return "S\u00f3lo el rol de tesorer\u00eda puede dar de alta una boleta.";
                }
            }
            if (proc.getC_DocType().getDocBaseType().equals("PBD")) {
                Timestamp Nvencimiento = (Timestamp)proc.get_Value("DateNew");
                Timestamp Vencimiento = (Timestamp)proc.get_Value("DateAcctRef2");
                if (Nvencimiento != null && Vencimiento != null && Nvencimiento.compareTo(Vencimiento) <= 0) {
                    return "Error: Nueva Fecha de Vencimiento Invalida";
                }
            }
        }
        if (type == 1 && po.get_Table_ID() == X_DM_PerformanceBond_Proc.Table_ID && (proc = (X_DM_PerformanceBond_Proc)po).getC_DocType().getDocBaseType().equals("PBA")) {
            int correlative = 0;
            correlative = DB.getSQLValue(po.get_TrxName(), "SELECT COALESCE(MAX(Correlative),0) FROM DM_PerformanceBond_Proc ");
            if (correlative < 1) {
                correlative = 1;
            }
            proc.set_CustomColumn("Correlative", correlative + 1);
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int timing) {
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        return null;
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    public static boolean isNumeric(String cadena) {
        try {
            Integer.parseInt(cadena);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

