/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class ClientAcctProcessor
extends SvrProcess {
    private int p_C_AcctSchema_ID;
    private int p_AD_Table_ID;
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;
    private MAcctSchema[] m_ass = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Table_ID")) {
                this.p_AD_Table_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("C_AcctSchema_ID=" + this.p_C_AcctSchema_ID + ", AD_Table_ID=" + this.p_AD_Table_ID);
        if (!MClient.isClientAccounting()) {
            throw new AdempiereUserError(Msg.getMsg(this.getCtx(), "ClientAccountingNotEnabled"));
        }
        this.m_client = MClient.get(this.getCtx(), this.getAD_Client_ID());
        this.m_ass = this.p_C_AcctSchema_ID == 0 ? MAcctSchema.getClientAcctSchema(this.getCtx(), this.getAD_Client_ID()) : new MAcctSchema[]{new MAcctSchema(this.getCtx(), this.p_C_AcctSchema_ID, this.get_TrxName())};
        this.postSession();
        MCost.create(this.m_client);
        this.addLog(this.m_summary.toString());
        return "@OK@";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postSession() {
        ArrayList<BigDecimal> listProcessedOn = new ArrayList<BigDecimal>();
        listProcessedOn.add(Env.ZERO);
        Timestamp ts = DB.getSQLValueTS(this.get_TrxName(), "SELECT CURRENT_TIMESTAMP FROM DUAL", new Object[0]);
        long ms = ts.getTime() - 2000L;
        ts = new Timestamp(ms);
        long mili = ts.getTime();
        BigDecimal value = new BigDecimal(Long.toString(mili));
        int[] documentsTableID = Doc.getDocumentsTableID();
        String[] documentsTableName = Doc.getDocumentsTableName();
        for (int i = 0; i < documentsTableID.length; ++i) {
            int AD_Table_ID = documentsTableID[i];
            String TableName = documentsTableName[i];
            if (this.p_AD_Table_ID != 0 && this.p_AD_Table_ID != AD_Table_ID) continue;
            StringBuffer sql = new StringBuffer("SELECT DISTINCT ProcessedOn FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND ProcessedOn<?").append(" AND Processed='Y' AND Posted='N' AND IsActive='Y'");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                pstmt.setInt(1, this.getAD_Client_ID());
                pstmt.setBigDecimal(2, value);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    BigDecimal processedOn = rs.getBigDecimal(1);
                    if (listProcessedOn.contains(processedOn)) continue;
                    listProcessedOn.add(processedOn);
                }
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql.toString(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    throw throwable;
                }
                DB.close(rs, pstmt);
                continue;
            }
            DB.close(rs, pstmt);
            continue;
        }
        int[] count = new int[documentsTableID.length];
        int[] countError = new int[documentsTableID.length];
        for (int i = 0; i < count.length; ++i) {
            count[i] = 0;
            countError[i] = 0;
        }
        Collections.sort(listProcessedOn);
        for (BigDecimal processedOn : listProcessedOn) {
            for (int i = 0; i < documentsTableID.length; ++i) {
                int AD_Table_ID = documentsTableID[i];
                String TableName = documentsTableName[i];
                if (this.p_AD_Table_ID != 0 && this.p_AD_Table_ID != AD_Table_ID) continue;
                StringBuffer sql = new StringBuffer("SELECT * FROM ").append(TableName).append(" WHERE AD_Client_ID=? AND (ProcessedOn");
                if (processedOn.compareTo(Env.ZERO) != 0) {
                    sql.append("=?");
                } else {
                    sql.append(" IS NULL OR ProcessedOn=0");
                }
                sql.append(") AND Processed='Y' AND Posted='N' AND IsActive='Y'").append(" ORDER BY Created");
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    pstmt = DB.prepareStatement(sql.toString(), this.get_TrxName());
                    pstmt.setInt(1, this.getAD_Client_ID());
                    if (processedOn.compareTo(Env.ZERO) != 0) {
                        pstmt.setBigDecimal(2, processedOn);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int n = i;
                        count[n] = count[n] + 1;
                        boolean ok = true;
                        String innerTrxName = Trx.createTrxName("CAP");
                        Trx innerTrx = Trx.get(innerTrxName, true);
                        String postStatus = "N";
                        Doc doc = Doc.get(this.m_ass, AD_Table_ID, rs, innerTrxName);
                        try {
                            if (doc == null) {
                                this.log.severe(this.getName() + ": No Doc for " + TableName);
                                ok = false;
                            } else {
                                String error = doc.post(false, false);
                                ok = error == null;
                                postStatus = doc.getPostStatus();
                            }
                        }
                        catch (Exception e) {
                            this.log.log(Level.SEVERE, this.getName() + ": " + TableName, e);
                            ok = false;
                        }
                        finally {
                            if (ok) {
                                innerTrx.commit();
                            } else {
                                innerTrx.rollback();
                                StringBuffer sqlupd = new StringBuffer("UPDATE ").append(doc.get_TableName()).append(" SET Posted='").append(postStatus).append("',Processing='N' ").append("WHERE ").append(doc.get_TableName()).append("_ID=").append(doc.get_ID());
                                DB.executeUpdateEx(sqlupd.toString(), null);
                            }
                            innerTrx.close();
                            innerTrx = null;
                        }
                        if (ok) continue;
                        int n2 = i;
                        countError[n2] = countError[n2] + 1;
                    }
                }
                catch (Exception e) {
                    try {
                        this.log.log(Level.SEVERE, sql.toString(), e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, pstmt);
                        throw throwable;
                    }
                    DB.close(rs, pstmt);
                    continue;
                }
                DB.close(rs, pstmt);
                continue;
            }
        }
        for (int i = 0; i < documentsTableID.length; ++i) {
            String TableName = documentsTableName[i];
            if (count[i] > 0) {
                this.m_summary.append(TableName).append("=").append(count[i]);
                if (countError[i] > 0) {
                    this.m_summary.append("(Errors=").append(countError[i]).append(")");
                }
                this.m_summary.append(" - ");
                this.log.finer(this.getName() + ": " + this.m_summary.toString());
                continue;
            }
            this.log.finer(this.getName() + ": " + TableName + " - no work");
        }
    }
}

