/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MMessage;
import org.compiere.model.Query;
import org.compiere.model.X_AD_Message;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MessageElementHandler
extends AbstractElementHandler {
    private List<Integer> messages = new ArrayList<Integer>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("Value"));
        String entitytype = atts.getValue("EntityType");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        String value = atts.getValue("Value");
        int id = this.get_IDWithColumn(ctx, "AD_Message", "value", value);
        MMessage m_Message = new MMessage(ctx, id, this.getTrxName(ctx));
        int AD_Backup_ID = -1;
        String Object_Status = null;
        if (id <= 0 && atts.getValue("AD_Message_ID") != null && Integer.parseInt(atts.getValue("AD_Message_ID")) <= 999999) {
            m_Message.setAD_Message_ID(Integer.parseInt(atts.getValue("AD_Message_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Message", m_Message);
            Object_Status = "Update";
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        m_Message.setMsgText(this.getStringValue(atts, "MsgText"));
        m_Message.setMsgTip(this.getStringValue(atts, "MsgTip"));
        m_Message.setEntityType(atts.getValue("EntityType"));
        m_Message.setIsActive(atts.getValue("isActive") != null ? Boolean.valueOf(atts.getValue("isActive")) : true);
        m_Message.setValue(value);
        m_Message.setMsgType(atts.getValue("MsgType"));
        if (m_Message.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_Message.getValue(), "Message", m_Message.get_ID(), AD_Backup_ID, Object_Status, "AD_Message", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Message"));
            return;
        }
        this.record_log(ctx, 0, m_Message.getValue(), "Message", m_Message.get_ID(), AD_Backup_ID, Object_Status, "AD_Message", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Message"));
        throw new POSaveFailedException("Failed to save message.");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        for (X_AD_Message message : this.getMessages(ctx)) {
            if (this.messages.contains(message.getAD_Message_ID())) continue;
            this.messages.add(message.getAD_Message_ID());
            AttributesImpl atts = new AttributesImpl();
            this.createMessageBinding(atts, message);
            document.startElement("", "", "message", atts);
            document.endElement("", "", "message");
        }
    }

    private List<X_AD_Message> getMessages(Properties ctx) {
        Object[] params;
        String whereClause;
        int AD_Message_ID = Env.getContextAsInt(ctx, "AD_Message_ID");
        int AD_EntityType_ID = Env.getContextAsInt(ctx, "AD_EntityType_ID");
        if (AD_Message_ID > 0) {
            whereClause = "AD_Message_ID=?";
            params = new Object[]{AD_Message_ID};
        } else if (AD_EntityType_ID > 0) {
            whereClause = " EXISTS (SELECT 1 FROM AD_EntityType et WHERE et.AD_EntityType_ID=? AND et.EntityType=AD_Message.EntityType)";
            params = new Object[]{AD_EntityType_ID};
        } else {
            throw new IllegalArgumentException("AD_Message_ID and AD_EntityType_ID not found");
        }
        List<X_AD_Message> list = new Query(ctx, "AD_Message", whereClause, null).setParameters(params).setOrderBy("AD_Message_ID").list();
        return list;
    }

    private AttributesImpl createMessageBinding(AttributesImpl atts, X_AD_Message m_Message) {
        atts.clear();
        if (m_Message.getAD_Message_ID() <= 999999) {
            atts.addAttribute("", "", "AD_Message_ID", "CDATA", Integer.toString(m_Message.getAD_Message_ID()));
        }
        atts.addAttribute("", "", "MsgText", "CDATA", m_Message.getMsgText() != null ? m_Message.getMsgText() : "");
        atts.addAttribute("", "", "MsgType", "CDATA", m_Message.getMsgType() != null ? m_Message.getMsgType() : "");
        atts.addAttribute("", "", "MsgTip", "CDATA", m_Message.getMsgTip() != null ? m_Message.getMsgTip() : "");
        atts.addAttribute("", "", "Value", "CDATA", m_Message.getValue() != null ? m_Message.getValue() : "");
        atts.addAttribute("", "", "EntityType", "CDATA", m_Message.getEntityType() != null ? m_Message.getEntityType() : "");
        atts.addAttribute("", "", "isActive", "CDATA", m_Message.isActive() ? "true" : "false");
        return atts;
    }
}

