/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.PoFiller;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.X_AD_Element;
import org.compiere.util.Env;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class AdElementHandler
extends AbstractElementHandler {
    private List<Integer> processedElements = new ArrayList<Integer>();
    private final String AD_ELEMENT = "AD_Element";

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String elementValue = element.getElementValue();
        int AD_Backup_ID = -1;
        String Object_Status = null;
        Attributes atts = element.attributes;
        this.log.info(elementValue + " " + atts.getValue("ColumnName"));
        String entitytype = atts.getValue("EntityType");
        String ColumnName = atts.getValue("ColumnName");
        if (!this.isProcessElement(ctx, entitytype)) {
            element.skip = true;
            return;
        }
        int id = this.get_IDWithColumn(ctx, "AD_Element", "ColumnName", ColumnName);
        X_AD_Element m_AdElement = new X_AD_Element(ctx, id, this.getTrxName(ctx));
        if (id <= 0 && atts.getValue("AD_Element_ID") != null && Integer.parseInt(atts.getValue("AD_Element_ID")) <= 999999) {
            m_AdElement.setAD_Element_ID(Integer.parseInt(atts.getValue("AD_Element_ID")));
        }
        if (id > 0) {
            AD_Backup_ID = this.copyRecord(ctx, "AD_Element", m_AdElement);
            Object_Status = "Update";
            if (this.processedElements.contains(id)) {
                element.skip = true;
                return;
            }
        } else {
            Object_Status = "New";
            AD_Backup_ID = 0;
        }
        PoFiller pf = new PoFiller(m_AdElement, atts);
        pf.setBoolean("IsActive");
        pf.setString("ColumnName");
        pf.setString("Description");
        pf.setString("EntityType");
        pf.setString("Help");
        pf.setString("Name");
        pf.setString("PrintName");
        pf.setString("PO_Description");
        pf.setString("PO_Name");
        pf.setString("PO_Help");
        pf.setString("PO_PrintName");
        if (m_AdElement.save(this.getTrxName(ctx))) {
            this.record_log(ctx, 1, m_AdElement.getName(), "Element", m_AdElement.get_ID(), AD_Backup_ID, Object_Status, "AD_Element", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Element"));
            element.recordId = m_AdElement.getAD_Element_ID();
            this.processedElements.add(m_AdElement.getAD_Element_ID());
            return;
        }
        this.record_log(ctx, 0, m_AdElement.getName(), "Element", m_AdElement.get_ID(), AD_Backup_ID, Object_Status, "AD_Element", this.get_IDWithColumn(ctx, "AD_Table", "TableName", "AD_Element"));
        throw new POSaveFailedException("Reference");
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int adElement_id = Env.getContextAsInt(ctx, "AD_Element_ID");
        if (this.processedElements.contains(adElement_id)) {
            return;
        }
        this.processedElements.add(adElement_id);
        X_AD_Element m_AdElement = new X_AD_Element(ctx, adElement_id, null);
        AttributesImpl atts = new AttributesImpl();
        this.createAdElementBinding(atts, m_AdElement);
        document.startElement("", "", "element", atts);
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        packOut.createTranslations("AD_Element", m_AdElement.get_ID(), document);
        document.endElement("", "", "element");
    }

    private AttributesImpl createAdElementBinding(AttributesImpl atts, X_AD_Element m_AdElement) {
        AttributeFiller filler = new AttributeFiller(atts, m_AdElement);
        if (m_AdElement.getAD_Element_ID() <= 999999) {
            filler.add("AD_Element_ID");
        }
        filler.add("IsActive");
        filler.add("ColumnName");
        filler.add("Description");
        filler.add("EntityType");
        filler.add("Help");
        filler.add("Name");
        filler.add("PrintName");
        filler.add("PO_Description");
        filler.add("PO_Name");
        filler.add("PO_Help");
        filler.add("PO_PrintName");
        return atts;
    }
}

