/*
 * Decompiled with CFR 0.152.
 */
package org.windsor.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.MWarehouse;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_M_StorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ModWindsorUpdateReserved
implements ModelValidator {
    private static CLogger log = CLogger.getCLogger(ModWindsorUpdateReserved.class);
    private int m_AD_Client_ID = -1;

    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
            log.info(client.toString());
        } else {
            log.info("Initializing global validator: " + this.toString());
        }
        engine.addDocValidate("C_Order", (ModelValidator)this);
        engine.addDocValidate("M_Requisition", (ModelValidator)this);
    }

    public String modelChange(PO po, int type) throws Exception {
        log.info(String.valueOf(po.get_TableName()) + " Type: " + type);
        return null;
    }

    public static String rtrim(String s, char c) {
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) == c) {
            --i;
        }
        return s.substring(0, i + 1);
    }

    public String docValidate(PO po, int timing) {
        MRequisitionLine rLine;
        MRequisitionLine[] rLines;
        MRequisition req;
        MWarehouse wh;
        MRequisitionLine reqL;
        MOrderLine oLine;
        int i;
        MOrderLine[] oLines;
        MOrder order;
        log.info(String.valueOf(po.get_TableName()) + " Timing: " + timing);
        if (timing == 9 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx()) {
            oLines = order.getLines(false, null);
            i = 0;
            while (i < oLines.length) {
                oLine = oLines[i];
                if (oLine.getM_Product_ID() > 0 && oLine.getM_Product().isStocked() && oLine.getM_Product().getProductType().compareTo("I") == 0 && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                    reqL = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                    wh = MWarehouse.get((Properties)reqL.getCtx(), (int)reqL.getM_Requisition().getM_Warehouse_ID());
                    if (this.existReservationTable(order.get_TrxName())) {
                        this.OFBReservation(wh.get_ID(), oLine.getM_Product_ID(), Env.ZERO, oLine.getQtyOrdered().negate(), po);
                        MStorage.add(wh.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), oLine.getM_AttributeSetInstance_ID(), Env.ZERO, oLine.getQtyOrdered().negate(), Env.ZERO, order.get_TrxName());
                    } else {
                        MStorage.add(wh.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), oLine.getM_AttributeSetInstance_ID(), Env.ZERO, oLine.getQtyOrdered().negate(), Env.ZERO, order.get_TrxName());
                    }
                }
                ++i;
            }
        }
        if (timing == 2 && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx()) {
            oLines = order.getLines(false, null);
            i = 0;
            while (i < oLines.length) {
                oLine = oLines[i];
                if (oLine.getM_Product_ID() > 0 && oLine.getM_Product().isStocked() && oLine.getM_Product().getProductType().compareTo("I") == 0 && oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                    reqL = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                    wh = MWarehouse.get((Properties)reqL.getCtx(), (int)reqL.getM_Requisition().getM_Warehouse_ID());
                    if (this.existReservationTable(order.get_TrxName())) {
                        this.OFBReservation(wh.get_ID(), oLine.getM_Product_ID(), Env.ZERO, oLine.getQtyOrdered(), po);
                        MStorage.add(wh.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), oLine.getM_AttributeSetInstance_ID(), Env.ZERO, oLine.getQtyOrdered(), Env.ZERO, order.get_TrxName());
                    } else {
                        MStorage.add(wh.getCtx(), wh.getM_Warehouse_ID(), wh.getDefaultLocator().getM_Locator_ID(), oLine.getM_Product_ID(), oLine.getM_AttributeSetInstance_ID(), oLine.getM_AttributeSetInstance_ID(), Env.ZERO, oLine.getQtyOrdered(), Env.ZERO, order.get_TrxName());
                    }
                }
                ++i;
            }
        }
        if (timing == 2 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)((Object)po)).isSOTrx()) {
            rLines = req.getLines();
            i = 0;
            while (i < rLines.length) {
                rLine = rLines[i];
                if (rLine.getM_Product_ID() > 0 && rLine.getM_Product().isStocked() && rLine.getM_Product().getProductType().compareTo("I") == 0) {
                    MWarehouse wh2 = MWarehouse.get((Properties)req.getCtx(), (int)req.getM_Warehouse_ID());
                    if (this.existReservationTable(req.get_TrxName())) {
                        this.OFBReservation(wh2.get_ID(), rLine.getM_Product_ID(), Env.ZERO, rLine.getQty().negate(), po);
                        MStorage.add(wh2.getCtx(), wh2.getM_Warehouse_ID(), wh2.getDefaultLocator().getM_Locator_ID(), rLine.getM_Product_ID(), rLine.getM_AttributeSetInstance_ID(), rLine.getM_AttributeSetInstance_ID(), Env.ZERO, rLine.getQty().negate(), Env.ZERO, req.get_TrxName());
                    } else {
                        MStorage.add(wh2.getCtx(), wh2.getM_Warehouse_ID(), wh2.getDefaultLocator().getM_Locator_ID(), rLine.getM_Product_ID(), rLine.getM_AttributeSetInstance_ID(), rLine.getM_AttributeSetInstance_ID(), Env.ZERO, rLine.getQty().negate(), Env.ZERO, req.get_TrxName());
                    }
                }
                ++i;
            }
        }
        if (timing == 9 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)((Object)po)).isSOTrx()) {
            rLines = req.getLines();
            i = 0;
            while (i < rLines.length) {
                rLine = rLines[i];
                rLine.set_CustomColumn("QtyReserved", rLine.getQty());
                rLine.save();
                ++i;
            }
        }
        if (timing == 10 && po.get_Table_ID() == MRequisition.Table_ID && (req = (MRequisition)((Object)po)).isSOTrx()) {
            DB.executeUpdate((String)("UPDATE M_RequisitionLine SET QtyReserved = 0 WHERE M_Requisition_ID = " + req.get_ID()), (String)po.get_TrxName());
        }
        if ((timing == 9 || timing == 10 || timing == 12) && po.get_Table_ID() == MOrder.Table_ID && (order = (MOrder)((Object)po)).isSOTrx()) {
            oLines = order.getLines(false, null);
            i = 0;
            while (i < oLines.length) {
                oLine = oLines[i];
                if (oLine.get_ValueAsInt("M_RequisitionLine_ID") > 0) {
                    MRequisitionLine rLine2 = new MRequisitionLine(po.getCtx(), oLine.get_ValueAsInt("M_RequisitionLine_ID"), po.get_TrxName());
                    BigDecimal qtyUsed = DB.getSQLValueBD((String)po.get_TrxName(), (String)"SELECT SUM(QtyOrdered) FROM C_OrderLine co INNER JOIN C_Order col ON (col.C_Order_ID = co.C_Order_ID) WHERE DocStatus IN ('CO','CL','IP') AND M_RequisitionLine_ID = ?", (int)rLine2.get_ID());
                    if (qtyUsed == null) {
                        qtyUsed = Env.ZERO;
                    }
                    BigDecimal qtyReserved = rLine2.getQty().subtract(qtyUsed);
                    DB.executeUpdate((String)("UPDATE M_RequisitionLine SET QtyReserved = " + qtyReserved + ", qtyUsed = " + qtyUsed + " WHERE M_RequisitionLine_ID = " + rLine2.get_ID()), (String)po.get_TrxName());
                }
                ++i;
            }
        }
        return null;
    }

    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        log.info("AD_User_ID=" + AD_User_ID);
        return null;
    }

    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("QSS_Validator");
        return sb.toString();
    }

    public void OFBReservation(int M_WareHouse_ID, int M_Product_ID, BigDecimal ordered, BigDecimal reserved, PO po) {
        CPreparedStatement pstmt = null;
        String mysql = "SELECT * from M_StorageReservation where M_WareHouse_ID = ? and M_Product_ID = ?";
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)po.get_TrxName());
            pstmt.setInt(1, M_WareHouse_ID);
            pstmt.setInt(2, M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), rs, po.get_TrxName());
                storage.setQtyReserved(storage.getQtyReserved().subtract(reserved));
                storage.save();
            } else {
                X_M_StorageReservation storage = new X_M_StorageReservation(po.getCtx(), 0, po.get_TrxName());
                storage.setQtyReserved(reserved.negate());
                storage.setM_Product_ID(M_Product_ID);
                storage.setM_Warehouse_ID(M_WareHouse_ID);
                storage.save();
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
    }

    public boolean existReservationTable(String Trx2) {
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean val = false;
        String mysql = "SELECT count(1) from M_StorageReservation";
        if (!DB.isOracle()) {
            mysql = "select count(1) from AD_Table where tablename='M_StorageReservation'";
        }
        try {
            pstmt = DB.prepareStatement((String)mysql, (String)Trx2);
            rs = pstmt.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                val = true;
            }
        }
        catch (Exception e) {
            val = false;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        return val;
    }
}

