/*
 * Decompiled with CFR 0.152.
 */
package org.tsm.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MAsset;
import org.compiere.model.MBPartner;
import org.compiere.model.X_HR_Prebitacora;
import org.compiere.model.X_Pre_M_Movement;
import org.compiere.model.X_Pre_M_MovementLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ProcessPreMovement
extends SvrProcess {
    private int p_Order_ID;
    private String p_Action;

    protected void prepare() {
        this.p_Order_ID = this.getRecord_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DocAction")) {
                    this.p_Action = (String)para[i].getParameter();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        X_Pre_M_Movement preMov;
        if (this.p_Action == null) {
            this.p_Action = "CO";
        }
        if ((preMov = new X_Pre_M_Movement(this.getCtx(), this.p_Order_ID, this.get_TrxName())).getDocStatus().compareTo("DR") == 0 && this.p_Action.compareTo("CO") == 0) {
            int cant = 0;
            String sql = " SELECT A_Asset_ID,A_AssetRampla_ID, C_BpartnerRef_ID FROM A_Asset WHERE IsActive = 'Y' AND A_Asset_ID NOT IN (SELECT A_AssetRampla_ID FROM A_Asset WHERE IsActive = 'Y' AND A_AssetRampla_ID IS NOT NULL) AND AD_OrgRef_ID = " + preMov.getAD_Org_ID() + " AND A_Asset_Type_ID IN ('01','02')" + " UNION" + " SELECT null,null,C_Bpartner_ID FROM C_Bpartner" + " WHERE IsActive = 'Y' AND IsUnlinked <> 'Y' AND AD_OrgRef_ID = " + preMov.getAD_Org_ID() + " AND C_Bpartner_ID NOT IN (SELECT C_BpartnerRef_ID FROM A_Asset WHERE IsActive = 'Y' AND C_BpartnerRef_ID IS NOT NULL)";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    X_HR_Prebitacora preBitacora;
                    int ID_Rampla = rs.getInt("A_AssetRampla_ID");
                    X_Pre_M_MovementLine pMovLine = new X_Pre_M_MovementLine(this.getCtx(), 0, this.get_TrxName());
                    pMovLine.setPre_M_Movement_ID(preMov.get_ID());
                    pMovLine.setAD_Org_ID(preMov.getAD_Org_ID());
                    if (rs.getInt("A_Asset_ID") > 0) {
                        pMovLine.setA_Asset_ID(rs.getInt("A_Asset_ID"));
                    }
                    if (rs.getInt("C_BpartnerRef_ID") > 0) {
                        pMovLine.setC_BPartner_ID(rs.getInt("C_BpartnerRef_ID"));
                    }
                    if (ID_Rampla > 0) {
                        pMovLine.setA_AssetRef_ID(ID_Rampla);
                    }
                    int ID_preBitacora = 0;
                    if (rs.getInt("A_Asset_ID") > 0 && (ID_preBitacora = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(HR_Prebitacora_ID) FROM HR_Prebitacora  WHERE A_Asset_ID = " + rs.getInt("A_Asset_ID") + "  AND DateTrx = ?"), (Object[])new Object[]{preMov.getMovementDate()})) > 0) {
                        preBitacora = new X_HR_Prebitacora(this.getCtx(), ID_preBitacora, this.get_TrxName());
                        pMovLine.set_CustomColumn("HR_Prebitacora_ID", ID_preBitacora);
                        pMovLine.set_CustomColumn("HR_Concept_TSM_ID", preBitacora.getHR_Concept_TSM_ID());
                    }
                    if (rs.getInt("C_BpartnerRef_ID") > 0 && (ID_preBitacora = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT MAX(HR_Prebitacora_ID) FROM HR_Prebitacora  WHERE C_BPartner_ID = " + rs.getInt("C_BpartnerRef_ID") + "  AND DateTrx = ?"), (Object[])new Object[]{preMov.getMovementDate()})) > 0) {
                        preBitacora = new X_HR_Prebitacora(this.getCtx(), ID_preBitacora, this.get_TrxName());
                        pMovLine.set_CustomColumn("HR_PrebitacoraRef_ID", ID_preBitacora);
                        pMovLine.set_CustomColumn("HR_Concept_TSMBP_ID", preBitacora.getHR_Concept_TSM_ID());
                    }
                    pMovLine.save();
                    ++cant;
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            }
            if (cant > 0) {
                preMov.setDocStatus("IP");
                preMov.save();
            }
            return "Se han agregado " + cant + " lineas a la disponibilidad";
        }
        if (this.p_Action.compareTo("CO") == 0 && (preMov.getDocStatus().compareTo("IP") == 0 || preMov.getDocStatus().compareTo("WC") == 0)) {
            boolean overWrite = false;
            overWrite = preMov.get_ValueAsBoolean("OverWrite");
            if (!overWrite) {
                int cantBP = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM C_Bpartner  WHERE IsActive = 'Y' AND AD_OrgRef_ID = " + preMov.getAD_Org_ID() + " AND IsUnlinked = 'N' " + " AND C_BPartner_ID NOT IN (SELECT C_BPartner_ID FROM Pre_M_MovementLine WHERE C_BPartner_ID IS NOT NULL " + " AND Pre_M_Movement_ID =" + preMov.get_ID() + ")"));
                if (cantBP > 0) {
                    throw new AdempiereException("ERROR: No estan en la disponibilidad " + cantBP + " conductores");
                }
                int cantAset = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM A_Asset  WHERE IsActive = 'Y' AND A_Asset_Type_ID IN ('01','02') AND AD_OrgRef_ID = " + preMov.getAD_Org_ID() + " AND A_Asset_ID NOT IN (SELECT A_Asset_ID FROM Pre_M_MovementLine WHERE A_Asset_ID IS NOT NULL " + " AND Pre_M_Movement_ID =" + preMov.get_ID() + ") " + " AND A_Asset_ID NOT IN (SELECT A_AssetRef_ID FROM Pre_M_MovementLine WHERE A_Asset_ID IS NOT NULL " + " AND Pre_M_Movement_ID =" + preMov.get_ID() + ")"));
                if (cantAset > 0) {
                    throw new AdempiereException("ERROR: No estan en la disponibilidad " + cantAset + " activos");
                }
                int cantPMov = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM Pre_M_Movement  WHERE Pre_M_Movement_ID <> " + preMov.get_ID() + " AND MovementDate = ? AND AD_Org_ID=" + preMov.getAD_Org_ID() + " AND Workshift='" + preMov.get_ValueAsString("Workshift") + "'"), (Object[])new Object[]{preMov.getMovementDate()});
                if (cantPMov > 0) {
                    throw new AdempiereException("ERROR: Ya existe una disponibilidad para el mismo dia, turno y flota");
                }
                int cantIndBP = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM RVOFB_Pre_M_MovementLine WHERE Pre_M_Movement_ID=" + preMov.get_ID() + " AND (A_Asset_ID > 0 OR C_Bpartner_ID > 0) AND IsActive = 'Y'"));
                if (cantIndBP > 0) {
                    throw new AdempiereException("ERROR: Hay incidencias en la disponibilidad");
                }
                Calendar calCalendarioHead = Calendar.getInstance();
                calCalendarioHead.add(5, 7);
                if (preMov.getMovementDate().compareTo(new Timestamp(calCalendarioHead.getTimeInMillis())) > 0) {
                    throw new AdempiereException("Error: Fecha supera 6 dias");
                }
                String sqlLine = "SELECT Pre_M_MovementLine_ID FROM Pre_M_MovementLine  WHERE Pre_M_Movement_ID = " + preMov.get_ID();
                CPreparedStatement pstmtLine = null;
                pstmtLine = DB.prepareStatement((String)sqlLine, (String)this.get_TrxName());
                ResultSet rsLine = pstmtLine.executeQuery();
                while (rsLine.next()) {
                    X_Pre_M_MovementLine pMovLine = new X_Pre_M_MovementLine(this.getCtx(), rsLine.getInt("Pre_M_MovementLine_ID"), this.get_TrxName());
                    if (pMovLine.isActive()) {
                        int cantPMovLine;
                        if (pMovLine.getA_Asset_ID() > 0 && (cantPMovLine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM Pre_M_Movement mm INNER JOIN Pre_M_MovementLine mml ON (mm.Pre_M_Movement_ID = mml.Pre_M_Movement_ID)  WHERE mm.Pre_M_Movement_ID <> " + preMov.get_ID() + "AND mm.MovementDate = ? " + " AND mm.AD_Org_ID=" + preMov.getAD_Org_ID() + " AND mm.Workshift='" + preMov.get_ValueAsString("Workshift") + "'" + " AND mml.A_Asset_ID = " + pMovLine.getA_Asset_ID()), (Object[])new Object[]{preMov.getMovementDate()})) > 0) {
                            throw new AdempiereException("ERROR: Ya existe una disponibilidad para el mismo activo:" + pMovLine.getA_Asset().getValue());
                        }
                        if (pMovLine.getC_BPartner_ID() > 0 && (cantPMovLine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM Pre_M_Movement mm INNER JOIN Pre_M_MovementLine mml ON (mm.Pre_M_Movement_ID = mml.Pre_M_Movement_ID)  WHERE mm.Pre_M_Movement_ID <> " + preMov.get_ID() + " AND mm.MovementDate = ? " + " AND mm.AD_Org_ID=" + preMov.getAD_Org_ID() + " AND mm.Workshift='" + preMov.get_ValueAsString("Workshift") + "'" + " AND mml.C_Bpartner_ID = " + pMovLine.getC_BPartner_ID()), (Object[])new Object[]{preMov.getMovementDate()})) > 0) {
                            throw new AdempiereException("ERROR: Ya existe una disponibilidad para el mismo conductor:" + pMovLine.getC_BPartner().getValue());
                        }
                        if (pMovLine.getC_BPartner_ID() > 0 && (cantPMovLine = DB.getSQLValue((String)this.get_TrxName(), (String)("SELECT COUNT(1) FROM Pre_M_Movement mm INNER JOIN Pre_M_MovementLine mml ON (mm.Pre_M_Movement_ID = mml.Pre_M_Movement_ID)  WHERE mm.Pre_M_Movement_ID <> " + preMov.get_ID() + " AND mm.MovementDate = ? " + " AND mm.AD_Org_ID <> " + preMov.getAD_Org_ID() + " AND mml.C_Bpartner_ID = " + pMovLine.getC_BPartner_ID()), (Object[])new Object[]{preMov.getMovementDate()})) > 0) {
                            throw new AdempiereException("ERROR: Ya existe una disponibilidad en otra flota para el mismo conductor:" + pMovLine.getC_BPartner().getValue());
                        }
                    }
                    if (pMovLine.getA_Asset_ID() > 0) {
                        MAsset asset = new MAsset(this.getCtx(), pMovLine.getA_Asset_ID(), this.get_TrxName());
                        pMovLine.set_CustomColumn("AD_OrgRefA_ID", asset.get_ValueAsInt("AD_OrgRef_ID"));
                        pMovLine.save(this.get_TrxName());
                    }
                    if (pMovLine.getC_BPartner_ID() <= 0) continue;
                    MBPartner partner = new MBPartner(this.getCtx(), pMovLine.getC_BPartner_ID(), this.get_TrxName());
                    pMovLine.set_CustomColumn("AD_OrgRefB_ID", partner.get_ValueAsInt("AD_OrgRef_ID"));
                    pMovLine.save(this.get_TrxName());
                }
                if (preMov.getDocStatus().compareTo("IP") == 0) {
                    preMov.setDocStatus("WC");
                    preMov.save();
                } else if (preMov.getDocStatus().compareTo("WC") == 0) {
                    preMov.setDocStatus("CO");
                    preMov.setProcessed(true);
                    preMov.save();
                    DB.executeUpdate((String)("UPDATE Pre_M_MovementLine SET Processed = 'Y'  WHERE Pre_M_Movement_ID = " + preMov.get_ID()), (String)this.get_TrxName());
                }
            } else if (preMov.getDocStatus().compareTo("IP") == 0) {
                preMov.setDocStatus("WC");
                preMov.save();
            } else if (preMov.getDocStatus().compareTo("WC") == 0) {
                preMov.setDocStatus("CO");
                preMov.setProcessed(true);
                preMov.save();
                DB.executeUpdate((String)("UPDATE Pre_M_MovementLine SET Processed = 'Y'  WHERE Pre_M_Movement_ID = " + preMov.get_ID()), (String)this.get_TrxName());
            }
            return "Procesado";
        }
        if (this.p_Action.compareTo("VO") == 0) {
            preMov.setDocStatus("VO");
            preMov.setProcessed(true);
            preMov.save();
            return "Anulado";
        }
        return "Procesado";
    }
}

